/**
 * Wizard pages scripts
 *
 * @copyright (c) 2004-2006, SWsoft
 */
function SbTreeOnPanelToggle(changedPanelId, otherPanelId) {
	var changedPanel = document.getElementById(changedPanelId + 'Place');
	var otherPanel = document.getElementById(otherPanelId + 'Place');
	var emptyPanel = document.getElementById('EmptyPanelPlace');
	if (IsSBPanelHidden(changedPanelId)) {
		if (IsSBPanelHidden(otherPanelId)) {
			changedPanel.style.height = '0%';
			otherPanel.style.height = '0%';
			emptyPanel.style.height = '100%';
		} else {
			changedPanel.style.height = '0%';
			emptyPanel.style.height = '0%';
			otherPanel.style.height = '100%';
		}
	} else {
		if (IsSBPanelHidden(otherPanelId)) {
			otherPanel.style.height = '0%';
			emptyPanel.style.height = '0%';
			changedPanel.style.height = '100%';
		} else {
			emptyPanel.style.height = '0%';
			changedPanel.style.height = '50%';
			otherPanel.style.height = '50%';
		}
	}
}

function SbPagesUpdateMainCheckBox(treeId) {
	var checkbox = document.getElementById(treeId + 'SelectAll');
	checkbox.checked = !SbIsSomethingNotChecked(treeId);
}

function SbPagesEnableButton(buttonId) {
	var button = document.getElementById(buttonId);
	
	if (!button) {
		return ;
	}
	
	button.disabled = false;
	if (document.all) {
		button.style.filter = '';
	} else {
		button.style.MozOpacity = '';
		button.style.opacity = '';
	}
	button.style.cursor = 'pointer';
}

function SbUpdatePagesStates(structureId, pagesetId, specialId) {
	var siteTree = window.sbPagesContainer[structureId];
	var nodes = siteTree.getAllNodes();
	var singleModules = new Array();
	var isFound = false;
	var notFoundedSingleModules = new Array();
	singleModules[singleModules.length] = 'FlashIntro';
	singleModules[singleModules.length] = 'PageModule';
	singleModules[singleModules.length] = 'Login';
	for (var k = 0; k < singleModules.length; k++) {
		isFound = false;
		for(var i = 0; i < nodes.length; i++) {
			if (singleModules[k] == nodes[i].type) {
				var pagesTree = window.sbPagesContainer[pagesetId];
				var pages = pagesTree.getAllNodes();
				for(var j = 0; j < pages.length; j++) {
					if (singleModules[k] == pages[j].type) {
						pages[j].disable();
					}
				}
				var pagesTree = window.sbPagesContainer[specialId];
				var pages = pagesTree.getAllNodes();
				for(var j = 0; j < pages.length; j++) {
					if (singleModules[k] == pages[j].type) {
						pages[j].disable();
					}
				}
				isFound = true;
				break;
			}
		}
		if (!isFound) {
			notFoundedSingleModules[notFoundedSingleModules.length] = singleModules[k];
		}
	}
	for (var k = 0; k < notFoundedSingleModules.length; k++) {
		var pagesTree = window.sbPagesContainer[pagesetId];
		var pages = pagesTree.getAllNodes();
		for(var j = 0; j < pages.length; j++) {
			if (notFoundedSingleModules[k] == pages[j].type) {
				pages[j].enable();
			}
		}
		var pagesTree = window.sbPagesContainer[specialId];
		var pages = pagesTree.getAllNodes();
		for(var j = 0; j < pages.length; j++) {
			if (notFoundedSingleModules[k] == pages[j].type) {
				pages[j].enable();
			}
		}
	}
}

function SbPagesDisableButton(buttonId) {
	var button = document.getElementById(buttonId);
	
	if (!button) {
		return ;
	}
	
	button.disabled = true;
	if (document.all) {
		button.style.filter = "alpha(opacity='40')";
	} else {
		button.style.MozOpacity = '0.4';
		button.style.opacity = '0.4';
	}
	button.style.cursor = 'default';
}

function SbPagesIsButtonEnabled(buttonId) {
	var button = document.getElementById(buttonId);
	return !button.disabled;
}

function SbIsSomethingChecked(treeId) {
	var tree = document.getElementById(treeId);
	return tree.isSomethingChecked();
}

function SbIsSomethingNotChecked(treeId) {
	var tree = document.getElementById(treeId);
	return tree.isSomethingNotChecked();
}

function SbUpdateAddButton(pagesetTreeId, specialTreeId) {
	if (SbIsSomethingChecked(pagesetTreeId) || SbIsSomethingChecked(specialTreeId)) {
		SbPagesEnableButton('buttonAdd');
	} else {
		SbPagesDisableButton('buttonAdd');
	}
}

function SbUpdateRemoveButton(siteTreeId) {
	if (SbIsSomethingChecked(siteTreeId) && SbIsSomethingNotChecked(siteTreeId)) {
		SbPagesEnableButton('buttonRemove');
	} else {
		SbPagesDisableButton('buttonRemove');
	}
}

function SbUpdateUpButton(siteTreeId) {
	var result = true;
	var tree = document.getElementById(siteTreeId);
	var checkedList = tree.getCheckedNodes();
	if (checkedList.length > 0) {
		for (var i = 0; i < checkedList.length; i++) {
			var previousNode = tree.getPreviousNode(checkedList[i]);
			if (null == previousNode) {
				result = false;
				break;
			}
			if (('FlashIntro' == previousNode.type) ||
				('PageModule' == previousNode.type)) {
				result = false;
				break;
			}
		}
	} else {
		result = false;
	}
	if (result) {
		SbPagesEnableButton('buttonUp');
	} else {
		SbPagesDisableButton('buttonUp');
	}
}

function SbUpdateDownButton(siteTreeId) {
	var result = true;
	var tree = document.getElementById(siteTreeId);
	var checkedList = tree.getCheckedNodes();
	if (checkedList.length > 0) {
		for (var i = 0; i < checkedList.length; i++) {
			if (('FlashIntro' == checkedList[i].type) ||
				('PageModule' == checkedList[i].type)) {
				result = false;
				break;
			}
			if (null == tree.getNextNode(checkedList[i])) {
				result = false;
				break;
			}
		}
	} else {
		result = false;
	}
	if (result) {
		SbPagesEnableButton('buttonDown');
	} else {
		SbPagesDisableButton('buttonDown');
	}
}

function SbUpdateLeftButton(siteTreeId) {
	var result = true;
	var tree = document.getElementById(siteTreeId);
	var checkedList = tree.getCheckedNodes();
	if (checkedList.length > 0) {
		for (var i = 0; i < checkedList.length; i++) {
			if (1 == tree.getLevel(checkedList[i])) {
				result = false;
				break;
			}
		}
	} else {
		result = false;
	}
	if (result) {
		SbPagesEnableButton('buttonLeft');
	} else {
		SbPagesDisableButton('buttonLeft');
	}
}

function SbUpdateRightButton(siteTreeId) {
	var result = true;
	var tree = document.getElementById(siteTreeId);
	var checkedList = tree.getCheckedNodes();
	if (checkedList.length > 0) {
		for (var i = 0; i < checkedList.length; i++) {
			if (1 != tree.getLevel(checkedList[i])) {
				result = false;
				break;
			}
			switch(checkedList[i].type){
				case 'FlashIntro':
				case 'Eshop':
				case 'PageModule':
				case 'Blogger':
				case 'ImageGallery':
				case 'Forum':
				case 'Login':
					result = false;
					break;
			}
			var previousNode = tree.getPreviousNode(checkedList[i]);
			if (null == previousNode) {
				result = false;
				break;
			} else {
				switch(previousNode.type){
					case 'FlashIntro':
					case 'Eshop':
					case 'PageModule':
					case 'Blogger':
					case 'DownloadableContent':
					case 'ImageGallery':
					case 'Forum':
					case 'Login':
						result = false;
						break;
				}
			}
		}
	} else {
		result = false;
	}
	if (result) {
		SbPagesEnableButton('buttonRight');
	} else {
		SbPagesDisableButton('buttonRight');
	}
}

function SbUpdateRenameButton(siteTreeId) {
	var result = true;
	var tree = document.getElementById(siteTreeId);
	var checkedList = tree.getCheckedNodes();
	if (checkedList.length == 1) {
		SbPagesEnableButton('buttonRename');
	} else {
		SbPagesDisableButton('buttonRename');
	}
}

function SbPagesSiteButtonsUpdate(siteTreeId) {
	SbPagesUpdateMainCheckBox(siteTreeId);
	SbUpdateRemoveButton(siteTreeId);
	SbUpdateUpButton(siteTreeId);
	SbUpdateDownButton(siteTreeId);
	SbUpdateLeftButton(siteTreeId);
	SbUpdateRightButton(siteTreeId);
	SbUpdateRenameButton(siteTreeId);
}

function SbPagesSiteMoveUp(siteTreeId) {
	if (SbPagesIsButtonEnabled('buttonUp')) {
		var tree = document.getElementById(siteTreeId);
		var checkedList = tree.getCheckedNodes();
		if (checkedList.length > 0) {
			for (var i = 0; i < checkedList.length; i++) {
				var previous = tree.getPreviousNode(checkedList[i]);
				if (null != previous) {
					var parent = checkedList[i].parentNode;
					var node = parent.removeChild(checkedList[i]);
					parent.insertBefore(node, previous);
					node.checkbox.checked = true;
				}
			}
			tree.registerChange();
		}
		SbPagesSiteButtonsUpdate(siteTreeId);
	}
}

function SbPagesSiteMoveDown(siteTreeId) {
	if (SbPagesIsButtonEnabled('buttonDown')) {
		var tree = document.getElementById(siteTreeId);
		var checkedList = tree.getCheckedNodes();
		if (checkedList.length > 0) {
			checkedList = checkedList.reverse();
			for (var i = 0; i < checkedList.length; i++) {
				var next = tree.getNextNode(checkedList[i]);
				if (null != next) {
					var parent = checkedList[i].parentNode;
					var node = parent.removeChild(checkedList[i]);
					var afterNext = tree.getNextNode(next);
					if (null == afterNext) {
						parent.appendChild(node);
					} else {
						parent.insertBefore(node, afterNext);
					}
					node.checkbox.checked = true;
				}
			}
			tree.registerChange();
		}
		SbPagesSiteButtonsUpdate(siteTreeId);
	}
}

function SbPagesSiteMoveLeft(siteTreeId) {
	if (SbPagesIsButtonEnabled('buttonLeft')) {
		var tree = document.getElementById(siteTreeId);
		var checkedList = tree.getCheckedNodes();
		if (checkedList.length > 0) {
			for (var i = 0; i < checkedList.length; i++) {
				if (1 != tree.getLevel(checkedList[i])) {
					var parent = checkedList[i].parentNode;
					var node = parent.removeChild(checkedList[i]);
					var afterParent = tree.getNextNode(parent);
					if (null == afterParent) {
						tree.appendChild(node);
					} else {
						tree.insertBefore(node, afterParent);
					}
					node.setVisibleLevel(false);
					node.updateVisibility(false);
					node.checkbox.checked = true;
				}
			}
			tree.refresh();
			tree.registerChange();
		}
		SbPagesSiteButtonsUpdate(siteTreeId);
	}
}

function SbPagesSiteMoveRight(siteTreeId) {
	if (SbPagesIsButtonEnabled('buttonRight')) {
		var tree = document.getElementById(siteTreeId);
		var checkedList = tree.getCheckedNodes();
		if (checkedList.length > 0) {
			for (var i = 0; i < checkedList.length; i++) {
				if (1 == tree.getLevel(checkedList[i])) {
					var target = tree.getPreviousNode(checkedList[i]);
					if (null != target) {
						var node = tree.removeChild(checkedList[i]);
						target.appendChild(node);
						var subChildsList = node.getChildList();
						for (var j = 0; j < subChildsList.length; j++) {
							var child = node.removeChild(subChildsList[j]);
							target.appendChild(child);
						}
						node.setVisibleLevel(true);
						node.updateVisibility(true);
						node.checkbox.checked = true;
					}
				}
			}
			tree.refresh();
			tree.registerChange();
		}
		SbPagesSiteButtonsUpdate(siteTreeId);
	}
}

function SbPagesSiteRename(siteTreeId) {
	if (SbPagesIsButtonEnabled('buttonRename')) {
		var tree = document.getElementById(siteTreeId);
		var checkedList = tree.getCheckedNodes();
		if (checkedList.length > 0) {
			if ((tree.getLevel(checkedList[0]) == 2) && !checkedList[0].parentNode.isExpanded) {
				checkedList[0].parentNode.expand();
			}
			tree.selectNode(checkedList[0]);
			checkedList[0].startEdit();
		}
	}
}

function SbPagesSiteAdd(sourceTreeId, siteTreeId) {
	if (SbPagesIsButtonEnabled('buttonAdd')) {
		var sourceTree = document.getElementById(sourceTreeId);
		var targetTree = document.getElementById(siteTreeId);
		var checkedList = sourceTree.getCheckedNodes();
		var skipCount = 0;
		if (checkedList.length > 0) {
			for (var i = 0; i < checkedList.length; i++) {
				if (skipCount > 0) {
					skipCount--;
				} else {
					var node = checkedList[i].cloneSbTreeNode();
					var subChildsList = node.getChildList();
					
					for (var j = 0; j < subChildsList.length; j++) {
						if (subChildsList[j].isChecked) {
							skipCount++;
						} else {
							node.removeChild(subChildsList[j]);
						}
					}
					
					insertResult = targetTree.insertTreeNode(node, targetTree, null);
					node.unCheck();
					node.addListeners();
					
					if (node.hasChilds()) {
						node.expand();
					}
					
					node.setVisibleLevel(false);
					node.updateVisibility(false);
					subChildsList = node.getChildList();
					
					for (var j = 0; j < subChildsList.length; j++) {
						subChildsList[j].unCheck();
						subChildsList[j].addListeners();
						subChildsList[j].updateVisibility(true);
					}
					
					if (!insertResult) {
						break;
					}
				}
			}
			targetTree.registerChange();
		}
	}
}

function SbPagesSiteRemove(treeId) {
	if (SbPagesIsButtonEnabled('buttonRemove')) {
		var tree = document.getElementById(treeId);
		var checkedList = tree.getCheckedNodes();
		var skipCount = 0;
		if (checkedList.length > 0) {
			for (var i = 0; i < checkedList.length; i++) {
				if (skipCount > 0) {
					skipCount--;
				} else {
					var node = checkedList[i];
					var subChildsList = node.getChildList();
					for (var j = 0; j < subChildsList.length; j++) {
						skipCount++;
						if (subChildsList[j].isChecked) {
							node.removeChild(subChildsList[j]);
							tree.removeTreeNode(subChildsList[j]);
						} else {
							var subChild = node.removeChild(subChildsList[j]);
							var afterParent = tree.getNextNode(node);
							if (null == afterParent) {
								tree.appendChild(subChild);
							} else {
								tree.insertBefore(subChild, afterParent);
							}
							subChild.setVisibleLevel(false);
							subChild.updateVisibility(false);
						}
					}
					node.parentNode.removeChild(node);
					tree.removeTreeNode(node);
				}
			}
			tree.refresh();
			tree.registerChange();
			SbUpdateRemoveButton(treeId);
		}
	}
}

// View namespace
Sb.Views.Wizard.Pages = {};

Sb.Views.Wizard.Pages.updateCounterPanelSize = function() {
	var panelHeight = $('counterTurnOn').checked
		? 100
		: 35;
		
	$('counterControlPanel').setStyle({ height: panelHeight + 'px' });
}
