/**
 * Modal form scripts
 *
 * @copyright (c) 2004-2006, SWsoft
 */

var SbModalFormDragControlObject;

SbModalFormDragControlObject = new SbModalFormDragControl();

function SbModalFormDragControl() {
	this.entity = null;
	this.isDragging = false;
}

SbModalFormDragControl.prototype.startDragging = function(object) {
	this.entity = object;
	this.isDragging = true;
	addEvent(window, 'blur', SbModalFormDragControl_mouseUp);
	addEvent(document, 'mouseup', SbModalFormDragControl_mouseUp);
	addEvent(document, 'mousemove', SbModalFormDragControl_mouseMove);
}

SbModalFormDragControl.prototype.onMouseUp = function(event) {
	if (this.isDragging && (null != this.entity)) {
		if (document.all) {
			event = window.event;
		}
		removeEvent(window, 'blur', SbModalFormDragControl_mouseUp);
		removeEvent(document, 'mouseup', SbModalFormDragControl_mouseUp);
		removeEvent(document, 'mousemove', SbModalFormDragControl_mouseMove);
		this.entity.onMouseUp(event);
		this.isDragging = false;
		this.entity = null;
	}
}

SbModalFormDragControl.prototype.onMouseMove = function(event) {
	if (this.isDragging && (null != this.entity)) {
		if (document.all) {
			event = window.event;
		}
		this.entity.onMouseMove(event);
	}
}

SbModalFormDragControl_mouseUp = function(event) {
	return SbModalFormDragControlObject.onMouseUp(event);
}

SbModalFormDragControl_mouseMove = function(event) {
	return SbModalFormDragControlObject.onMouseMove(event);
}











function SbProduceModalForm(formId, formUrl) {
	if (null == self.sbProducedModalForms) {
		self.sbProducedModalForms = new Array();
	}

	var isProduced = false;
	for (var i = 0; i < self.sbProducedModalForms.length; i++) {
		if (self.sbProducedModalForms[i] == formId) {
			isProduced = true;
			break;
		}
	}
	if (!isProduced) {
		self.sbProducedModalForms.push(formId);
		var container = new Element('div', {style: 'height: 0px;'});
		self.document.body.insertBefore(container, self.document.body.firstChild);
		var request = new SbAjaxRequest.ContainerUpdater(
			formUrl,
			'',
			container,
			{
				asynchronous: false,

				addOverlay: false,

				onCreate: function() {
					self.document.body.style.cursor = 'wait';
				},

				onComplete: function() {
					self.document.body.style.cursor = 'default';
				}
			}
		);
	}
	return $(formId);
}

function SbInitModalForm(formId) {
	var object;

	if (null == window.sbModalFormsContainer) {
		window.sbModalFormsContainer = new Array();
	}
	object = document.getElementById(formId);
	window.sbModalFormsContainer.push(object);
	SbModalForm(object, formId, 200 - 3 * window.sbModalFormsContainer.length);
}





function SbModalForm(formObject, name, defaultZIndex) {
	formObject.identifier = name;
	formObject.initialZIndex = formObject.style.zIndex;
	formObject.horizontalDelta = 0;
	formObject.verticalDelta = 0;
	formObject.positionLeft = 0;
	formObject.positionTop = 0;
	formObject.isMoved = false;
	formObject.disabledItems = new Array();
	formObject.disabledItemsVisibility = new Array();
	formObject.headerObject = document.getElementById(name + 'Header');
	formObject.backgroundObject = document.getElementById(name + 'Background');
	formObject.titleObject = document.getElementById(name + 'Title');

	formObject._prepareSelectboxesBeforeShow = SbModalForm._prepareSelectboxesBeforeShow;
	formObject._prepareSelectboxesBeforeHide = SbModalForm._prepareSelectboxesBeforeHide;
	formObject.setStyles = SbModalForm.setStyles;
	formObject.resetPosition = SbModalForm.resetPosition;
	formObject.hide = SbModalForm.hide;
	formObject.show = SbModalForm.show;
	formObject.changeSize = SbModalForm.changeSize;
	formObject.getMaxDimensions = SbModalForm.getMaxDimensions;
	formObject.onMouseUp = SbModalForm.onMouseUp;
	formObject.onMouseMove = SbModalForm.onMouseMove;
	formObject.setPosition = SbModalForm.setPosition;
	formObject.setTitle = SbModalForm.setTitle;

	formObject.setStyles(defaultZIndex);
	formObject.resetPosition();

	formObject.headerMouseDown = SbModalForm.headerMouseDown;
	formObject.headerObject.onmousedown = function(event) { formObject.headerMouseDown(event); };

	addEvent(window, 'resize', function(event) { formObject.resetPosition(); });
	addEvent(window, 'scroll', function(event) { formObject.resetPosition(); });
}

SbModalForm.setStyles = function(defaultZIndex) {
	this.style.position = 'absolute';
	this.style.overflow = 'hidden';
	if (!this.initialZIndex) {
		this.style.zIndex = defaultZIndex;
		this.backgroundObject.style.zIndex = defaultZIndex - 1;
	} else {
		this.backgroundObject.style.zIndex = this.style.zIndex - 1;
	}
	var modalForm = this;
	if (this.style.display.toLowerCase() == 'none') {
		addEvent(self, 'load', function (event) {modalForm.hide();});
	} else {
		addEvent(self, 'load', function (event) {modalForm.show();});
	}
}

SbModalForm.hide = function() {
	this._prepareSelectboxesBeforeHide();
	this.style.display = 'none';
	this.backgroundObject.style.display = 'none';
}

SbModalForm.show = function() {
	this._prepareSelectboxesBeforeShow(self);
	this.style.display = 'block';
	this.backgroundObject.style.display = 'block';
	this.resetPosition();
}

SbModalForm.changeSize = function(width, height) {
	setObjectSize(this, width, height);
	this.resetPosition();
}

SbModalForm.getMaxDimensions = function() {
	var endOffset = 20; //const

	var winDimensions = Element.getDimensions(self.document.body);
	if (winDimensions.width > 20) {
		winDimensions.width -= endOffset;
	}
	if (winDimensions.height > 20) {
		winDimensions.height -= endOffset;
	}
	return winDimensions;
}

SbModalForm._prepareSelectboxesBeforeShow = function(winObject) {
	//TODO: For IE 7 this code needless, remove later.
	if (document.all) {
		var wholeList = winObject.document.getElementsByTagName('SELECT');
		var ownList = this.getElementsByTagName('SELECT');
		for (var i = 0; i < wholeList.length; i++) {
			var item = wholeList[i];
			var isOwn = false;
			for (var j = 0; j < ownList.length; j++) {
				if (item == ownList[j]) {
					isOwn = true;
					break;
				}
			}
			if (isOwn) {
				continue;
			}
			this.disabledItems.push(item);
			this.disabledItemsVisibility.push(item.disabled);
			item.disabled = true;
		}
		var ownFrames = this.getElementsByTagName('IFRAME');
		for (var i = 0; i < winObject.frames.length; i++) {
			var isOwn = false;
			for (var j = 0; j < ownFrames.length; j++) {
				if (winObject.frames[i] == ownFrames[j].contentWindow) {
					isOwn = true;
					break;
				}
			}
			if (isOwn) {
				continue;
			}
			this._prepareSelectboxesBeforeShow(winObject.frames[i]);
		}
	}
}

SbModalForm._prepareSelectboxesBeforeHide = function() {
	//TODO: For IE 7 this code needless, remove later.
	if (document.all) {
		for (var i = 0; i < this.disabledItems.length; i++) {
			try {
				this.disabledItems[i].disabled = this.disabledItemsVisibility[i];
			} catch (exception) {
				continue;
			}
		}
		this.disabledItems = new Array();
		this.disabledItemsVisibility = new Array();
	}
}

SbModalForm.resetPosition = function() {
	setObjectSize(this.backgroundObject, getScreenWidth(), getScreenHeight());
	var left = getScrollLeft();
	var top = getScrollTop();
	setObjectPosition(this.backgroundObject, left, top);
	if (this.isMoved) {
		left = this.positionLeft;
		top = this.positionTop;
	} else {
		left += Math.ceil(getScreenWidth()/2 - getObjectWidth(this)/2);
		top += Math.ceil(getScreenHeight()/2 - getObjectHeight(this)/2);
	}
	this.setPosition(left, top);
}

SbModalForm.headerMouseDown = function(event) {
	if (document.all) {
		event = window.event;
	}
	this.horizontalDelta = getScreenX(event) - this.positionLeft;
	this.verticalDelta = getScreenY(event) - this.positionTop;
	if (this.horizontalDelta < 0) {
		this.horizontalDelta = 0;
	}
	if (this.verticalDelta < 0) {
		this.verticalDelta = 0;
	}
	SbModalFormDragControlObject.startDragging(this);
	stopEvent(event);
}

SbModalForm.onMouseUp = function(event) {
	this.setPosition(getScreenX(event), getScreenY(event));
	this.horizontalDelta = 0;
	this.verticalDelta = 0;
}

SbModalForm.onMouseMove = function(event) {
	this.setPosition(getScreenX(event), getScreenY(event));
	this.isMoved = true;
}

SbModalForm.setPosition = function(left, top) {
	var endOffset = 20; //const

	left -= this.horizontalDelta;
	top -= this.verticalDelta;
	if ((left + getObjectWidth(this)) > (getScreenWidth() + getScrollLeft() - endOffset)) {
		left = getScreenWidth() + getScrollLeft() - endOffset - getObjectWidth(this);
	}
	if (left < endOffset + getScrollLeft()) {
		left = endOffset + getScrollLeft();
	}
	if ((top + getObjectHeight(this)) > (getScreenHeight() + getScrollTop() - endOffset)) {
		top = getScreenHeight() + getScrollTop() - endOffset - getObjectHeight(this);
	}
	if (top < endOffset + getScrollTop()) {
		top = endOffset + getScrollTop();
	}
	if ((left + getObjectWidth(this)) > (getScreenWidth() + getScrollLeft() - endOffset)) {
		left = Math.ceil(endOffset / 2);
		this.positionLeft = left;
	} else {
		this.positionLeft = left;
	}
	if ((top + getObjectHeight(this)) > (getScreenHeight() + getScrollTop() - endOffset)) {
		top = Math.ceil(endOffset / 2);
		this.positionTop = top;
	} else {
		this.positionTop = top;
	}
	setObjectPosition(this, left, top);
}

SbModalForm.setTitle = function(newTitle) {
	this.titleObject.innerHTML = newTitle;
}
