/**
 * Admin navigation scripts
 *
 * @copyright (c) 2004-2006, SWsoft
 */

function SB_Navigation(formId, viewUrl) {
	this.setFormId(formId);
	this.setViewUrl(viewUrl);
	
	this.postBackUrl = null;
	this.viewParams = null;
	this.onSubmitMethods = new Array();
}

SB_Navigation.prototype.registerOnSubmitFunction = function(method) {
	if ('function' == typeof(method)) {
		this.onSubmitMethods[this.onSubmitMethods.length] = method;
	}
}

SB_Navigation.prototype.onSubmit = function() {
	var result = true;
	
	for(var i = 0; i < this.onSubmitMethods.length; i++) {
		var method = this.onSubmitMethods[i];
		if (false == method()) {
			result = false;
			break;
		}
	}
	return result;
}

SB_Navigation.prototype.setFormId = function(formId) {
	this.formId = formId;
	
	if (('undefined' == typeof(formId)) || ('' == formId)) {
		this.formId = 0;
	}
}

SB_Navigation.prototype.setViewUrl = function(viewUrl) {
	this.viewUrl = viewUrl;
}

SB_Navigation.prototype.setPostBackUrl = function(postBackUrl) {
	alert("Internal error: call 'setPostBackUrl' is deprecated now");
}

SB_Navigation.prototype.isExistsViewParam = function(key) {
	if (null != this.viewParams && 'undefined' != typeof(this.viewParams['__hash__' + key])) {
		return true;
	}
	return false;
}

SB_Navigation.prototype.unsetViewParam = function(key) {
	if (null != this.viewParams && 'undefined' != typeof(this.viewParams['__hash__' + key])) {
		delete this.viewParams['__hash__' + key];
	}
}

SB_Navigation.prototype.setViewParam = function(key, value) {
	if (null == this.viewParams) {
		this.viewParams = new Array();
	}
	this.viewParams['__hash__' + key] = value;
}

SB_Navigation.prototype.getViewUrlWithParams = function(viewUrl) {
	if (null != this.viewParams) {
		viewUrl += (viewUrl.indexOf('?') < 0) ? '?' : '';
		
		// very bad practice cause this construction iteraties throw all properties
		for (var key in this.viewParams) {
			if (!key.match(/^__hash__/)) {
				continue ;
			}
			
			cleanKey = key.replace(/__hash__/, '');
			
			var lastChar = viewUrl.charAt(viewUrl.length - 1);
			viewUrl += (('?' == lastChar) || ('&' == lastChar)) ? '' : '&';
			viewUrl += escape(cleanKey) + '=' + escape(this.viewParams[key]);
		}
	}
	return viewUrl;
}

SB_Navigation.prototype.go = function(viewUrl, win) {
	if ('undefined' == typeof(viewUrl)) {
		viewUrl = this.viewUrl;
	}

	if ('undefined' == typeof(win)) {
		win = window;
	}
	
	viewUrl = this.getViewUrlWithParams(viewUrl);

	if (sbApplyChangesObject.isSavingRequired()) {
		var navigation = this;
		sbApplyChangesObject.show(
			function() {
				if (navigation.onSubmit()) {
					navigation.addHidden('sbNavigationViewUrl', viewUrl, win);
				
					submitter = win.document.forms[navigation.formId].onsubmit;
					
					if ('undefined' == typeof(submitter)) {
						alert("Internal error: onsubmit is undefined for form '" + navigation.formId + "'");
					} else {
						submitter();
					}
				}
			},
			function() {
				win.location.href = viewUrl;
			}
		);
	} else {
		win.location.href = viewUrl;
	}
	
	return false;
}

SB_Navigation.prototype.ajaxRequest = function(viewUrl, win, options) {
	if ('undefined' == typeof(viewUrl)) {
		viewUrl = this.viewUrl;
	}

	if ('undefined' == typeof(win)) {
		win = window;
	}
	
	viewUrl = this.getViewUrlWithParams(viewUrl);

	if (sbApplyChangesObject.isSavingRequired()) {
		var navigation = this;
		sbApplyChangesObject.show(
			function() {
				if (navigation.onSubmit()) {
					navigation.addHidden('sbNavigationViewUrl', viewUrl, win);
					options.method = 'post';
					var formId = navigation.formId;
					$(win.document.forms[navigation.formId]).request(options);
				}
			},
			function() {
				options.method = 'get';
				new Ajax.Request(viewUrl, options);
			}
		);
	} else {
		options.method = 'get';
		new Ajax.Request(viewUrl, options);
	}
	
	return true;
}

SB_Navigation.prototype.addHidden = function(name, value, win) {
	if ('undefined' == typeof(win)) {
		win = window;
	}
	formId = this.formId;
	
	var input = win.document.forms[formId][name];
	if (input) {
		input.value = value;
	} else {
		input = document.createElement('input');
		input.setAttribute('type', 'hidden');
		input.setAttribute('name', name);
		input.value = value;
		win.document.forms[formId].appendChild(input);
	}	
}

SB_Navigation.prototype.getForm = function() {
	return self.document.forms[this.formId];
}