var PagedList = Class.create();

PagedList.prototype = {
	initialize: function(url, useAjax) {
		this._url  = url;
		this._useAjax = useAjax;
	},

	renderWithAjax: function(params) {
		var request = new SbAjaxRequest.ContainerUpdater(
			this._url,
			params,
			$('pagedListContainer'),
			{
				addOverlayText: false,

				replaceContent: true,

				onCreate:  function() {
					self.document.body.style.cursor = 'wait';
				},

				onFailure: function() {
					document.location.href = baseUrl + '/Login';
				},

				onComplete:  function() {
					self.document.body.style.cursor = 'default';
				}
			}
		);
	},

	render: function(params) {
		if (this._useAjax) {
			this.renderWithAjax(params);
		} else {
			document.location.href = this._url + params;
		}
	},

	doSort: function(orderBy, orderType) {
		this.render("?pageNum=1&orderBy=" + escape(orderBy) + "&orderType=" + escape(orderType));
	},

	gotoPage: function(pageNum) {
		this.render("?pageNum=" + pageNum);
	},

	setPageSize: function(pageSize) {
		this.render("?pageNum=1&pageSize=" + pageSize);
	},

	searchShowAll: function() {
		if ($('filterValue')) {
			$('filterValue').enable();
			$('filterValue').selectedIndex = 0;
		}

		$('searchString').value = '';

		this.searchItems();
	},

	searchItems: function() {
		var strFilterValue = '';

		if ($('filterValue')) {
			strFilterValue = '&filterValue=' + $F('filterValue');
		}

		this.render("?pageNum=1&searchString=" + $F('searchString') + strFilterValue);
	}
};

function setCheckboxStatus(status) {
	form = document.forms.listForm;
	for (var n = 0; n < form.elements.length; n++) {
		if (form.elements[n].type == 'checkbox') {
			if (!form.elements[n].disabled) {
				form.elements[n].checked = status;
				setCheckboxClassName(form.elements[n]);
			}
		}
	}
}

function countSelectedCheckBoxes() {
	result = 0;
	form = document.forms.listForm;
	for (var n = 0; n < form.elements.length; n++) {
		if (form.elements[n].type == 'checkbox') {
			if (form.elements[n].checked) {
				++result;
			}
		}
	}
	return result;
}


function setCheckboxClassName(o) {
	o = $(o);
	if (o.checked)
		o.up("tr").addClassName("list-table-row-selected");
	else
		o.up("tr").removeClassName("list-table-row-selected");

	return true;
}
