var isFileNameValidationRequired = true;

function submitForUpload() {
	if (validateField('SB_Validator.notEmpty', 'uploadInput', 'SELECT-FILE')) {
		if (SB_Validator.isEmpty(document.getElementById('file_name').value)) {
			isFileNameValidationRequired = false;
		}
		try {
			sbApplyChangesObject.registerForcedSaving();
			sbNavigationObject.go();
		} catch (e) {
			alert(SbGetLocaleByKey('SELECT-FILE'));
		}
	}
}

function validateEditForm() {
	if (SB_Validator.notEmpty(document.getElementById('uploadInput').value)) {
		document.getElementById('upload_clicked').value = 'true';
		if (SB_Validator.isEmpty(document.getElementById('file_name').value)) {
			isFileNameValidationRequired = false;
		}
	} else {
		if (!$('downloadableContentDownloadLink')) {
			isFileNameValidationRequired = false;
		}
	}
	if ((!isFileNameValidationRequired) || validateField('SB_Validator.notEmpty', 'file_name', 'EMPTY-FILE-NAME')) {
		var fileName = document.getElementById('file_name').value;
		if ('' == fileName) {
			fileName = document.getElementById('uploadInput').value;
		}
		if ('' == fileName) {
			isFileNameValidationRequired = true;
			return true;
		}
		var extensionIndex = fileName.lastIndexOf('.');
		var extension = fileName.substring(extensionIndex + 1, fileName.length);

		if (SB_Validator.notEmpty(document.getElementById('file_name').value) && (!SB_Validator.isRegex(fileName, /^[^\.]+/))) {
			alert(SbGetLocaleByKey('WRONG-FILE-NAME'));
			try {
				document.getElementById(elementId).focus();
			} catch (e) {}
			isFileNameValidationRequired = true;
			return false;
		}
		if (!SB_Validator.isRegex(extension, /^[A-Za-z0-9_]+$/) && extensionIndex > (-1)) {
			var message = SbGetLocaleByKey('WRONG-FILE-EXTENSION');
			message = message.replace(/%s/, extension);
			alert(message);

			try {
				document.getElementById(elementId).focus();
			} catch (e) {}
			isFileNameValidationRequired = true;
			return false;
		}
		isFileNameValidationRequired = true;
		return true;
	} else {
		isFileNameValidationRequired = true;
		return false;
	}
}

function download(source) {
	var w = window.open(source + '?' + Math.random(), 'downlodable_content', 'title=no,menubar=no,toolbar=no,location=no,status=no,scrollbars=yes,resizable=yes');
	w.focus();
}