/**
 * Forum edit
 *
 * @author Evgueni Palchukovsky <epalchukovsky@swsoft.com> 
 * @version $Id: Edit.js 29787 2008-10-10 08:08:45Z adobrenko $
 * @since 2006/07/07
 * @package SB
 * @subpackage Forum
 * @copyright (c) 2004-2006, SWsoft
 */

function Modules_Forum_Edit_Field(controlId, caption, card) {
	this.controlId	= controlId;
	this.caption	= caption;
	this.card		= card;
}

forum = new function Modules_Forum_Edit() {
	this.fields = new Array();
	this.oldSubmit = document.forms.SB_WizardForm.submit;
}

forum.registerInput = function(controlId, caption, card) {
	this.fields.push(new Modules_Forum_Edit_Field(controlId, caption, card));
}

forum.validateSettings = function() {
	return 	validateField('SB_Validator.notEmpty', 'topicsPerPage', 'EMPTY-TOPICS-PER-PAGE')
		&&	validateField('SB_Validator.isInt', 'topicsPerPage', 'NOT-INT-TOPICS-PER-PAGE')
		&&	extendedValidateField("SB_Validator.isGreaterThan(document.getElementById('topicsPerPage').value, 0)", 'topicsPerPage', 'NOT-POSITIVE-TOPICS-PER-PAGE')
		&&	validateField('SB_Validator.notEmpty', 'repliesPerPage', 'EMPTY-REPLIES-PER-PAGE')
		&&	validateField('SB_Validator.isInt', 'repliesPerPage', 'NOT-INT-REPLIES-PER-PAGE')
		&&	extendedValidateField("SB_Validator.isGreaterThan(document.getElementById('repliesPerPage').value, 0)", 'repliesPerPage', 'NOT-POSITIVE-REPLIES-PER-PAGE');
}

forum.validateTopic = function() {
	return validateField('SB_Validator.notEmpty', 'subject', 'EMPTY-TOPIC-SUBJECT');
}

forum.validateMessage = function() {
	var comment = document.getElementsByName('comment');
	comment = comment[0];
	var wysiwyg = FCKeditorAPI.GetInstance(comment.id);
	if (wysiwyg) {
		var doc = wysiwyg.EditorDocument;
		if (	!SB_Validator.notEmpty(doc.body.textContent)
			&&	!doc.getElementsByTagName('IMG').length) {
			alert(SbGetLocaleByKey('MESSAGE-CONTENT-EMPTY'));
			return false;
		}
	} else {
		alert("Internal error. WYSIWYG object not found.");
	}
	return true;
}

forum.validateCategory = function() {
	return validateField('SB_Validator.notEmpty', 'name', 'EMPTY-CATEGORY-NAME');
}

function ForumSubmitSettings() {
	if (forum.validateSettings()) {
		document.forms.SB_WizardForm.submit = forum.oldSubmit;
		document.forms.SB_WizardForm.submit();
	}
}

function ForumSubmitTopic() {
	if (forum.validateTopic()) {
		document.forms.SB_WizardForm.submit = forum.oldSubmit;
		document.forms.SB_WizardForm.submit();
	}
}

function ForumSubmitMessage() {
	if (forum.validateMessage()) {
		document.forms.SB_WizardForm.submit = forum.oldSubmit;
		document.forms.SB_WizardForm.submit();
	}
}

function ForumSubmitCategory() {
	if (forum.validateCategory()) {
		document.forms.SB_WizardForm.submit = forum.oldSubmit;
		document.forms.SB_WizardForm.submit();
	}
}

function setCheckboxStatus(status, prefix) {
	var form = document.forms['SB_WizardForm'];
	for (var i = 0; i < form.elements.length; i++) {
		var e = form.elements[i];
		if (e.type == 'checkbox' && e.name == prefix+'_objectIds[]' && !e.disabled) {
			e.checked = status;
		}
	}
}

function deleteRecords(action, prefix) {
	var count = countSelectedCheckBoxes(prefix);
	if (count > 0) {
		var message = SbGetLocaleByKey('DELETE-RECORDS-CONFIRM');
		message = message.replace('%s', count);
		if (confirm(message)) {
			setWizardFormAction(action);
			self.sbApplyChangesObject.registerForcedSaving(); 
			sbNavigationObject.go();
		}
	} else {
		alert(SbGetLocaleByKey('SELECT-RECORDS-FOR-DELETE'));
	}
}

function countSelectedCheckBoxes(prefix) {
	var result = 0;
	var form = document.forms['SB_WizardForm'];
	for (var i = 0; i < form.elements.length; i++) {
		var e = form.elements[i];
		if (e.type == 'checkbox' && e.name==prefix+'_objectIds[]' && e.checked) {
			++result;
		}
	}
	return result;
}

function forumTopicToogle(object, tabLabel) {
	if (forum.validateTopic()) {
		if (!hasSupport()) return;
		if (eval(object)!='undefined') {
			eval(object+'.tooglePage(tabLabel.id);');
		}
	}
}