var CategoryID = "0";
var CategoryName = "";
var BaseUrl = ""; 
var CancelUpload = false;
var UploadInProgress = false;
var Errors = null;
var Localization = new Array();

function OpenImageWindows(url)
{
    var wPreview = window.open(url, 'preview', "resizable=yes, tolbar=no, status=yes, scrollbars=yes");
    try { wPreview.focus(); } catch(e){}
}


function CountItems(inst)
{
	var i = 0;
	for(var item in inst)
	{
		i++;
	}
	return i;
}

function InstToInst(to, from)
{
	to = new Array();
	for(var item in from)
	{
		to[item] = item;
	}
	return to;
}

function FindeSelectedIndex(item)
{
	var res = -1;
	for(var i = 0; i < JamShellListX.SelCount; i++)
	{
		if (JamShellListX.SelectedFiles(i) == item)
		{
			res = i;
			break;
		}
	}
	return res;
}

function IsCategory()
{
	var combo = document.getElementById(CategoryListId);
	var textBox = document.getElementById(NewCategoryId);
	var res = true;
	if (combo.value == "new" && textBox.value =="")
	{
		res = false;
		textBox.focus();
	}
	return res;
}

function SetSelectedCount()
{
	JamSelectImages.innerHTML = JamShellListX.SelCount;
	var upload = false;
	var deselect = false;
	if (JamShellListX.SelCount > 0)
	{
		upload = true;
		deselect = true;
	}
	ButtonSetEnabled(ButtonUploadId, upload);
	ButtonSetEnabled(ButtonUnSelectId, deselect);
}

function ButtonSetEnabled(buttonId, state) {
	state ? enableButton(document.getElementById(buttonId)) : disableButton(document.getElementById(buttonId));
}

function SetMaxCount(count, progressBarId) {
	
}

function SetWidth(width, progressBarId) {
	
}

function StartUpload()
{
	HideModalBoxControl(MultipleUploadDialogId);
	ShowModalBoxControl(StatusUploadDialogId);
	UpdateStatus(0, ProgressBarId);
	
	SwitchStatusToError(false);
	Errors = null;
	CancelUpload = false;
	UploadInProgress = true;

	var res = GetSelectedResolution();
	var cat = GetCategoryParam();
	FileUploader.MaxWidth = res.Width;
	FileUploader.MaxHeight = res.Height;
	CategoryID = cat.ID;
	CategoryName = cat.Name;

	SetMaxCount(JamShellListX.SelCount, ProgressBarId);
	SetWidth(0, ProgressBarId);
	
	var from = document.getElementById(FromFileCountId);
	from.innerHTML = JamShellListX.SelCount;
	
	setTimeout("UploadFile(0)", 100);
}

function CancelUploadFiles()
{
	CancelUpload = true;
	UploadInProgress = false;
	HideModalBoxControl(StatusUploadDialogId);
	ShowModalBoxControl(MultipleUploadDialogId);
}

function HideModalBoxControl(dialogId) {
	document.getElementById(dialogId).hide();
}

function ShowModalBoxControl(dialogId) {
	document.getElementById(dialogId).show();
}

function UpdateStatus(status, progressBarId) {
	sbProgressBar._setStatus(status);
}

function UploadFile(index)
{
	if (CancelUpload) return;
	var status = FileUploader.RequestCheck();
	
	if (status == 5)
	{
		setTimeout("UploadFile("+index+")",100);
		return;
	}
	
	var uploadet = document.getElementById(UploadetFileCountId);
	var left = document.getElementById(FileLeftCountId);
	var file = document.getElementById(FileNameId);
	
	uploadet.innerHTML = index;
	left.innerHTML = JamShellListX.SelCount - index;
	file.innerHTML = "";
	
	if (status > 0) {
		if (Errors == null) Errors = new Array();
		var er = new Object();
		var fileIndex = index == 0 ? index : index - 1;
		er.FileName = JamShellListX.SelectedFiles(fileIndex);
		er.Status = status;
		Errors.push(er);
	}
	if (CategoryID == "0" && CategoryName != null)
	{
		CategoryID = GetCategoryIdFromResponseText(FileUploader.ResponseText);
	}
	
	UpdateStatus(index/JamShellListX.SelCount, ProgressBarId);
	if (index < JamShellListX.SelCount)
	{
		file.innerHTML = JamShellListX.SelectedFiles(index);
		var foo = BaseUrl + "&categoryId=" + CategoryID;
		if (CategoryName != null) {
			FileUploader.FormFields = "categoryName=" + encodeURI(CategoryName);
		}
		FileUploader.UploadURL = foo;
		FileUploader.FileName = JamShellListX.Path +  JamShellListX.SelectedFiles(index);
		FileUploader.SendRequestAsync();
		index++;
		setTimeout("UploadFile("+index+")",100);
	}
	else
	{
		UploadInProgress = false;
		var count = JamShellListX.SelCount;
		JamShellListX.ClearSelection();
		SetSelectedCount();
		if (Errors == null)
		{
			MakePostBack();
		}
		else
		{
	 		for (var i = 0; i < Errors.length; i++)
	 		{
	   			JamShellListX.SelectedFiles.Add(Errors[i].FileName);
	 		}
	 		SwitchStatusToError(true, count);
	 		SetErrorMessages();
	 		SetSelectedCount();
		}
	}
}

function SetErrorMessages()
{
	var errorLabelId = document.getElementById(ErrorLabelId);
	var status1 = 0;
	var status2 = 0;
	var status3 = 0;
	for (var i = 0; i < Errors.length; i++)
	{
		switch (Errors[i].Status)
		{
			case 1:
				status1++;
				break;
			case 2:
				status2++;
				break;
			case 3:
				status3++;
				break;
		}
	}
	var str = "";
	if (status1 > 0)
	{
		str += Localization["FileNoFound"] + "&nbsp;(" + status1 +")<br/>";
	}
	if (status2 > 0)
	{
		str += Localization["NotResize"] + "&nbsp;(" + status2 +")<br/>";
	}
	if (status3 > 0)
	{
		str += Localization["HttpError"] + "&nbsp;(" + status3 +")<br/>";
	}
	str += Localization["CanNotUpload"];
	errorLabelId.innerHTML = str;
}

function SetCaption(dialogId, caption) {
	var dialog = document.getElementById(dialogId);
	dialog.setTitle(caption);
}

function SwitchStatusToError(error, count)
{
	var bar = document.getElementById(ProgressBarId);
	var upload = document.getElementById(UploadetFileCountId);
	var from = document.getElementById(FromFileCountId);
	var left = document.getElementById(FileLeftCountId);
	var fileName = document.getElementById(FileNameId);
	var errorImage = document.getElementById(ErrorImageId);
	var progressImage = document.getElementById(ProgressImageId);
	var panelErrors = document.getElementById(PanelErrorsId);
	var panelPBId = document.getElementById(PanelPBId);
	var panelFileNameId = document.getElementById(PanelFileNameId);
	var errorLabelId = document.getElementById(ErrorLabelId);
	var panelProgressButtonsId = document.getElementById(PanelProgressButtonsId);
	var panelErrorButonsId = document.getElementById(PanelErrorButonsId);
	if (error == true)
	{
		SetCaption(StatusUploadDialogId, Localization["Alert"]);
		upload.innerHTML = count - JamShellListX.SelCount;
		from.innerHTML = count;
		left.innerHTML = JamShellListX.SelCount;
		errorImage.style.display = "block"; 
		progressImage.style.display = "none";
		
		panelErrors.style.display = "inline";
		panelPBId.style.display = "none";
		
		panelFileNameId.style.display = "none";
		panelProgressButtonsId.style.display = "none";
		panelErrorButonsId.style.display = "inline";
	}
	else
	{
		SetCaption(StatusUploadDialogId, Localization["Progress"]);
		upload.innerHTML = "0";
		from.innerHTML = JamShellListX.SelCount;
		left.innerHTML = JamShellListX.SelCount;
		errorImage.style.display = "none";
		progressImage.style.display = "block";
		
		panelErrors.style.display = "none";
		panelPBId.style.display = "inline";
		
		panelFileNameId.style.display = "inline";
		panelProgressButtonsId.style.display = "inline";
		panelErrorButonsId.style.display = "none";
	}
}

function RetryUpload()
{
	SwitchStatusToError(false);
	StartUpload();
}

function MakePostBack()
{
	eval(PostBackScript);
}

function GetCategoryIdFromResponseText(text)
{
	var res = "0";
	try{
		var temp = text.split("[ID:");
		var temp1 = temp[1].split("]");
		res = temp1[0];
	}
	catch(e){}
	return res;
}

function GetCategoryParam()
{
	var res = new Object();
	try
	{
		var combo = document.getElementById(CategoryListId);
		var value = combo.value;
		res.ID = value;
		res.Name = combo.text;
		//New category
		if (value == "new")
		{
			var el = document.getElementById(NewCategoryId);
			res.ID = "0";
			res.Name = el.value;
		}
		//No category
		if (value == "0") {
			res.Name = null;
		}
	}
	catch(e)
	{
		res.ID = "0";
		res.Name = null;
	}
	return res;
}

function GetSelectedResolution()
{
	var res = new Object();
	try
	{
		var combo = document.getElementById(ResizeResolutionId);
		var value = combo.value;
		var par = new Array();
		par = value.split("|");
		res.Width = par[0];
		res.Height = par[1];
	}
	catch(e)
	{
		res.Width = "100000";
		res.Height = "100000";
	}
	return res;
}

function ControlsInit()
{
	JamShellTreeX.RootedAt = 3;
	JamShellTreeX.BorderStyle = 0;
	JamShellListX.BorderStyle = 0;
	JamShellListX.Thumbnails = true;
	JamShellComboX.ShellLink = JamShellLinkX;
	JamShellTreeX.ShellLink = JamShellLinkX;
	JamShellListX.ShellLink = JamShellLinkX;
	JamShellListX.Filter = '*.jpg;*.jpeg;*.gif;*.png;*.bmp';
	JamShellListX.ShowFolders = false;
	JamShellTreeX.ShowFiles = false;
	JamShellTreeX.ShowRecycleBin = false;
	JamShellTreeX.FileSystemOnly = true;
	JamShellComboX.ShowFiles = false;
	JamShellComboX.ShowRecycleBin = false;
	JamShellComboX.FileSystemOnly = true;

	var combo = document.getElementById(CategoryListId);
	var textBox = document.getElementById(NewCategoryId);
	var disp = true;
	if (combo.value  == "new")
	{
		disp = false;
	}
	textBox.disabled = disp;

	try
	{
		JamShellComboX.focus();
		JamShellTreeX.focus();
		JamShellListX.focus();
	}
	catch(e){}
	SetSelectedCount();
}

function SelectCategory(comboBox, eventArgs)
{
	var category = comboBox.Value;
	var textBox = document.getElementById(NewCategoryId);
	var disp = "none";
	if (category == "new")
	{
		disp = "block";
	}
	if (disp == "block")
	{
		textBox.value = "";
	}
	textBox.style.display = disp;
}

function GetSelectedFiles()
{
	var str = "";
	var array = GetSelectedFilesList();
	for (var i = 0; i < array.length; i++)
	{
		str += array[i].Path + "\n";
	}
	return str;
}

function GetSelectedFilesList()
{
	var res = new Array();
	for (var i = 0; i < JamShellListX.SelCount; i++)
	{
		var obj = new Object();
		obj.Path = JamShellListX.Path + JamShellListX.SelectedFiles(i);
		obj.FileName = JamShellListX.SelectedFiles(i);
		res.push(obj);
	}
	return res;
}

function GetItemIndex(val)
{
	return JamShellListX.FindCaption(val);
}
