<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:strip-space elements="*"/>
	<xsl:output method="html" indent="yes" encoding="utf-8"/>

	<xsl:template match="SITEBUILDER-PAGE">
		<script type="text/javascript" language="javascript" src="/js/navigation.js?{$version}.{$build}"/>
		<script type="text/javascript" language="javascript">
			var baseUrl='<xsl:value-of select="$baseUrl"/>';
			var sbNavigationObject;
			sbNavigationObject = new SB_Navigation('<xsl:value-of select="APPLY-CHANGES/@FORM-ID"/>');
		</script>

		<table cellpadding="0" cellspacing="0" border="0" style="width: 100%; height: 100%">
			<xsl:call-template name="MAIN-PAGE-HEADER"/>
			<xsl:call-template name="MAIN-PAGE-CONTENT"/>
			<xsl:call-template name="MAIN-PAGE-FOOTER"/>
		</table>

		<xsl:if test="NAVIGATION/MENU-PANEL">
			<script type="text/javascript">
				<xsl:comment>
					ShowAdminPanelNavigation();

					<xsl:for-each select="SITEBUILDER-PAGE/NAVIGATION/MENU-PANEL">
						SBPanelToggle('<xsl:value-of select="@ID"/>','<xsl:value-of select="$skinPath"/>/images/show.gif','<xsl:value-of select="$skinPath"/>/images/hide.gif' );
					</xsl:for-each>
				</xsl:comment>
			</script>
		</xsl:if>

	</xsl:template>


	<xsl:template name="MAIN-PAGE-HEADER">
		<tr>
			<!-- :INFO: ayuzhakov 20070209: don't change id and style properties! -->
			<td class="sb-adminpanel-header" id="adminPanelHeader" style="display: none;">
				<xsl:if test="NAVIGATION">
					<xsl:attribute name="colspan">2</xsl:attribute>
				</xsl:if>
				<xsl:call-template name="TOP-HEADER"/>
			</td>
		</tr>
	</xsl:template>


	<xsl:template name="MAIN-PAGE-CONTENT">
		<tr>
			<xsl:if test="NAVIGATION">
				<!-- :INFO: ayuzhakov 20070209: don't change id and style properties! -->
				<td id="adminPanelLeftMenu" style="height: 100%; display: none;" class="sb-leftmenu"><xsl:apply-templates select="NAVIGATION"/></td>
			</xsl:if>

			<td valign="top" width="100%">
				<table cellpadding="0" cellspacing="0" border="0" style="width: 100%; height: 100%;">
					<tr>
						<td>
							<table class="sb-pagetitle" cellpadding="0" cellspacing="0">
								<tr>
									<td colspan="2" class="sb-pagetitle-path sb-pagetitle-link" align="left" >
										<xsl:choose>
											<xsl:when test="VIEW-CONTENT/PATHS/PATH">
												<xsl:for-each select="VIEW-CONTENT/PATHS/PATH">
													<a class="sb-pagetitle-link" href="#">
														<xsl:attribute name="onclick">javascript:sbNavigationObject.go('<xsl:value-of select="@ACTION"/>');</xsl:attribute>
														<xsl:value-of select="@TITLE"/>
													</a>
													<img src="{$skinPath}/images/arrow_next.gif" border="0" alt="" style="margin: 0 5px;"/>
												</xsl:for-each>
											</xsl:when>
											<xsl:otherwise>
											</xsl:otherwise>
										</xsl:choose>
									</td>
								</tr>
								<tr>
									<td align="left" class="sb-pagetitle-title">
										<span class="sb-page-title"><xsl:value-of select="VIEW-CONTENT/@TITLE"/></span>
									</td>
									<td valign="middle" align="right" class="sb-pagetitle-levelup">
										<xsl:if test="VIEW-CONTENT/@LEVEL-UP-ACTION">
										<table cellpadding="3" cellspacing="0" onmouseout="SetContextHelp();" onmouseover="SetContextHelp('LEVEL-UP-CONTEXT-HELP');">
											<tr>
												<td>
													<a>
														<xsl:attribute name="href"><xsl:value-of select="VIEW-CONTENT/@LEVEL-UP-ACTION"/></xsl:attribute>
														<img src="{$skinPath}/images/levelup.gif" border="0" alt=""/>
													</a>
												</td>
												<td>
													<a class="sb-pagetitle-link" href="#">
														<xsl:attribute name="onclick">javascript:sbNavigationObject.go('<xsl:value-of select="VIEW-CONTENT/@LEVEL-UP-ACTION"/>');</xsl:attribute>
														<xsl:value-of select="VIEW-CONTENT/@LEVEL-UP-TITLE"/>
													</a>
												</td>
											</tr>
										</table>
										</xsl:if>
									</td>
								</tr>
							</table>
						</td>
					</tr>
<!--					<tr><td style="padding: 10px;">&#160;</td></tr> -->
					<tr>
						<td align="left" colspan="2" style="height: 100%;">
							<div id="DivAdminPanel" style="overflow: auto; white-space: nowrap; width: 100%; height: 100%;">
								<xsl:apply-templates select="VIEW-CONTENT"/>
							</div>
						</td>
					</tr>
				</table>
			</td>
		</tr>
	</xsl:template>

	<xsl:template name="MAIN-PAGE-FOOTER">
		<!-- Nothing to do in PAGE-FOOTER -->
	</xsl:template>


	<xsl:template match="VIEW-CONTENT">
		<table cellpadding="0" cellspacing="0" border="0" style="width: 100%; height: 100%;">
			<tr>
				<td class="admin-content-area">
					<xsl:apply-templates select="/SITEBUILDER-PAGE/STATUS" mode="admin"/>
					<xsl:apply-templates/>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template match="NAVIGATION">
		<script src='/js/panel_toggle.js?{$version}.{$build}' type='text/javascript'></script>
		<!-- style="width: 210px; height: 100%;"  -->
		<table cellpadding="0" cellspacing="0" border="0" style="width: 210px; height: 100%;">
			<tr>
				<td valign="top" class="sb-leftmenu-table">
					<div id="DivLeftMenu" style="width: 100%; overflow: auto; overflow-x: hidden; text-align: center; vertical-align: top; height: 100%;">
<!--						<table width="100%"><tr><td  class="SB_LeftMenu_Table" cellpadding="0" cellspacing="0"> -->
						<form action="/" method="post" name="adminNavigation" id="adminNavigation">
							<xsl:apply-templates select="MENU-PANEL"/>
						</form>
<!--						</td></tr>
						</table> -->
					</div>
				</td>
			</tr>
			<tr>
				<td  class="sb-leftmenu-copyright" valign="Bottom">
				<xsl:if test="$hideCopyright != 1">
					<table border="0" cellpadding="0" cellspacing="0" width="100%" valign="bottom">
						<tr>
							<td align="left" class="sb-leftmenu-horizontal-separator">
								<img style="border-width: 0px; height: 1px;" src="/images/blank.gif"/>
							</td>
						</tr>
						<tr>
							<td align="left"><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/COPYRIGHT"/><br/><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/ALL-RIGHTS-RESERVED"/></td>
						</tr>
					</table>
				</xsl:if>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template match="APPLY-CHANGES" mode="initAfterBody">
		<xsl:call-template name="MODAL-FORM">
			<xsl:with-param name="formName">SbApplyChanges</xsl:with-param>
			<xsl:with-param name="formTitle" select="@TITLE"/>
			<xsl:with-param name="closeHint" select="@CLOSE-HINT"/>
			<xsl:with-param name="additionalFormStyle">width:300px; height:145px; display:none;</xsl:with-param>
			<xsl:with-param name="content" select="current()"/>
			<xsl:with-param name="onCloseAction">sbApplyChangesObject.hide();</xsl:with-param>
			<xsl:with-param name="showStatus">0</xsl:with-param>
		</xsl:call-template>
		<script type="text/javascript" language="javascript" src="/js/apply_changes.js?{$version}.{$build}"/>
		<script type="text/javascript" language="javascript">
			<xsl:comment>
				sbApplyChangesObject = new SB_ApplyChanges('SbApplyChanges');
			//</xsl:comment>
		</script>

		<xsl:if test="@IS-MODIFIED = '1'">
			<script type="text/javascript" language="javascript">
				<xsl:comment>
					sbApplyChangesObject.registerChange();
				//</xsl:comment>
			</script>
		</xsl:if>

	</xsl:template>

	<xsl:template match="APPLY-CHANGES" mode="content">
		<table width="80%" cellspacing="0" cellpadding="0" border="0" align="center">
			<tr>
				<td align="left" colspan="3" style="vertical-align: middle; padding-bottom:10px; padding-left:10px;">
					<table cellpadding="0" cellspacing="0" border="0">
						<tr>
							<td><img src="{$skinPath}/images/applychanges.gif" style="border: 0;"/></td>
							<td class="sb-text" style="padding-left:30px;"><xsl:value-of select="@QUESTION"/></td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td align="center" width="33%" style="padding-right:15px;">
					<xsl:call-template name="BUTTON">
						<xsl:with-param name="action">return sbApplyChangesObject.yes();</xsl:with-param>
						<xsl:with-param name="title" select="@YES"/>
					</xsl:call-template>
				</td>
				<td align="center" width="34%">
					<xsl:call-template name="BUTTON">
						<xsl:with-param name="action">return sbApplyChangesObject.no();</xsl:with-param>
						<xsl:with-param name="title" select="@NO"/>
					</xsl:call-template>
				</td>
				<td align="center" width="33%" style="padding-left:15px;">
					<xsl:call-template name="BUTTON">
						<xsl:with-param name="action">sbApplyChangesObject.cancel();</xsl:with-param>
						<xsl:with-param name="title" select="@CANCEL"/>
					</xsl:call-template>
				</td>
			</tr>
		</table>

		<!-- abelyaev@: for Modal forms debugging
		<div id="SbLogs" style="width:100%; height:100%; overflow:auto; vertical-align:top; border:solid 1px #000000">Logs:</div>
		<script type="text/javascript" language="javascript">
			<xsl:comment>
				SbInitLogging();
			//</xsl:comment>
		</script>
		-->
	</xsl:template>

	<xsl:template match="LOGOUT-DIALOG" mode="initAfterBody">
		<xsl:call-template name="MODAL-FORM">
			<xsl:with-param name="formName">SbLogoutDialog</xsl:with-param>
			<xsl:with-param name="formTitle" select="@TITLE"/>
			<xsl:with-param name="closeHint" select="@CLOSE-HINT"/>
			<xsl:with-param name="additionalFormStyle">width:320px; height:145px; display:none;</xsl:with-param>
			<xsl:with-param name="content" select="current()"/>
			<xsl:with-param name="onCloseAction">document.getElementById('SbLogoutDialog').hide();</xsl:with-param>
			<xsl:with-param name="showStatus">0</xsl:with-param>
		</xsl:call-template>
	</xsl:template>

	<xsl:template match="LOGOUT-DIALOG" mode="content">
		<table width="80%" cellspacing="0" cellpadding="0" border="0" align="center">
			<tr>
				<td align="left" colspan="3" style="vertical-align: middle; padding-bottom:10px; padding-left:0px;">
					<table cellpadding="0" cellspacing="0" border="0">
						<tr>
							<td><img src="{$skinPath}/images/applychanges.gif" style="border: 0;"/></td>
							<td class="sb-text" style="padding-left:30px;"><xsl:value-of select="@QUESTION"/></td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td align="center" width="33%" style="padding-right:15px;">
					<xsl:call-template name="BUTTON">
						<xsl:with-param name="action">doAdminNavigate('/Admin/Logout');</xsl:with-param>
						<xsl:with-param name="title" select="@YES"/>
					</xsl:call-template>
				</td>
				<td align="center" width="34%">
					<xsl:if test="@CHANGE">
							<xsl:call-template name="BUTTON">
								<xsl:with-param name="action">doAdminNavigate('/Admin/Logout?localLogout');</xsl:with-param>
								<xsl:with-param name="title" select="@CHANGE"/>
							</xsl:call-template>
					</xsl:if>
				</td>
				<td align="center" width="33%" style="padding-left:15px;">
					<xsl:call-template name="BUTTON">
						<xsl:with-param name="action">document.getElementById('SbLogoutDialog').hide();</xsl:with-param>
						<xsl:with-param name="title" select="@NO"/>
					</xsl:call-template>
				</td>
			</tr>
		</table>
	</xsl:template>

</xsl:stylesheet>
