<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:template match="DASHBOARD-CONTENT">
		<style>
			.sb-pagetitle { border-bottom: solid 1px #776655; }
		</style>
		
		<script type="text/javascript" src='/js/Sb/Views/Admin/Desktop.js?{$version}.{$build}'></script>
		
		<table width="100%" cellpadding="0" cellspacing="0">
			<xsl:if test="DASHBOARD-PANEL[@TYPE='TIPS']">
				<tr>
					<td colspan="2" style="padding-bottom: 10px;">
						<div id="panelGettingStarted">
							<xsl:apply-templates select="DASHBOARD-PANEL[@TYPE='TIPS']"/>
						</div>
					</td>
				</tr>
			</xsl:if>
			<tr>
				<td style="width: 50%; padding-right: 5px;" valign="top">
					<xsl:apply-templates select="DASHBOARD-PANEL[@TYPE='TASKS']"/>
				</td>
				<td style="width: 50%; padding-left: 5px;" valign="top">
					<xsl:apply-templates select="DASHBOARD-PANEL[@TYPE='STAT']"/>
				</td>
			</tr>
		 </table>
	</xsl:template>

	<xsl:template name="HIDE-DASHBOARD-PANEL">
		<xsl:param name="panelId"/>
		<script language="JavaScript" type="text/javascript">
			var panelId = '<xsl:value-of select="$panelId"/>';
			if( '' != panelId  &#38;&#38; 'off' == Sb.Cookie.get(panelId)) {
				SBPanelHide(panelId,'<xsl:value-of select="$skinPath"/>/images/dashboard-panel-show.gif','<xsl:value-of select="$skinPath"/>/images/dashboard-panel-hide.gif');
			}
		</script>
	</xsl:template>

	
	<xsl:template name="DASHBOARD-PANEL-TITLE">
		<xsl:param name="panelId"/>
		<input type="hidden" value="true" id="{$panelId}_hidden"/>
			<tr title="Minimize/Restore" style="cursor: pointer; cursor: hand;">
			<xsl:attribute name="title"><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/MINIMIZE-RESTORE"/></xsl:attribute>
			<xsl:attribute name="onmouseover">setClassName(document.getElementById('<xsl:value-of select="$panelId"/>_image'), 'dashboard-panel-icon-bg', true);</xsl:attribute>
			<xsl:attribute name="onmouseout">setClassName(document.getElementById('<xsl:value-of select="$panelId"/>_image'), 'dashboard-panel-icon-bg', false);</xsl:attribute>
			<xsl:attribute name="onclick">SBPanelToggle('<xsl:value-of select="$panelId"/>','<xsl:value-of select="$skinPath"/>/images/dashboard-panel-show.gif','<xsl:value-of select="$skinPath"/>/images/dashboard-panel-hide.gif');</xsl:attribute>
			<td class="sb-dashboard-panel-corner" style="width:3px;" background="{$skinPath}/images/dashboard_tl.gif">
				<img src="{$skinPath}/images/empty.gif" width="3" alt=""/>
			</td>
			<td class="sb-dashboard-panel-header">
				<table cellpadding="0" cellspacing="0" border="0" style="width:100%;height:100%;">
					<tr>
						<td align="Left" class="sb-dashboard-panel-header-text"><xsl:value-of select="@TITLE"/></td>
						<td align="Right" valign="Middle"></td>
					</tr>
				</table>
			</td>
			<td>
				<img id="{$panelId}_image" src="{$skinPath}/images/dashboard-panel-hide.gif"/>
			</td>
		</tr>
	</xsl:template>

	<xsl:template name="DASHBOARD-PANEL-FOOTER1">
		<tr>
			<td class="sb-dashboard-bottom" align="right" valign="middle">
				<table cellpadding="0" cellspacing="0" border="0" style="cursor:pointer;">
					<xsl:attribute name="onclick">Sb.Views.Admin.Desktop.closeGettingStartedPanel();</xsl:attribute>	

					<tr>
						<td style="width:0px;"></td><td align="center" valign="middle"><img src="{$skinPath}/icons/close.png" width="16" height="16" alt=""/></td><td align="left" class="sb-dashboard-bottom-link" style="padding-left:5px;padding-right:5px;"><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/CLOSE-GETTING-STARTED"/></td>
					</tr>
				</table>
			</td>
		</tr>
	</xsl:template>

	<xsl:template name="DASHBOARD-PANEL-FOOTER">
		<tr>
			<td colspan="2" class="sb-dashboard-bottom">&#160;</td>
		</tr>
	</xsl:template>
	
	
	<xsl:template match="DASHBOARD-PANEL[@TYPE='TIPS']">
	   <xsl:variable name="panelId">tips</xsl:variable>
   		<table cellpadding="0" cellspacing="0" border="0" style="width:100%;" id="{$panelId}">
   			<xsl:call-template name="DASHBOARD-PANEL-TITLE">
				<xsl:with-param name="panelId" select="$panelId"/>
			</xsl:call-template>
			<xsl:variable name="colspan" select="count(DASHBOARD-PANEL-ITEM)"/>
			<tr>
				<td class="sb-dashboard-panel-content" colspan="2" style="padding-bottom:0px;padding-top:0px;">
					<table cellspacing="0" width="100%" cellpadding="0" border="0" style="height: 100%;">
						<tr>
							<td align="left" class="sb-dashboard-top" style="padding-left: 15px;">
                                <xsl:value-of select="@DESCRIPTION"/>
                            </td>
						</tr>
						<tr>
							<td>
								<table class="sb-gettingstarted" cellspacing="0" width="100%" border="0">
									<tr>
										<xsl:for-each select="DASHBOARD-PANEL-ITEM">
											<td width="25%">
												<xsl:attribute name="class">sb-gettingstarted-item
													<xsl:choose>
														<xsl:when test="@ACTION = '/Admin/Host/List'">admin_host_list</xsl:when>
														<xsl:when test="@ACTION = '/Admin/Plan/List'">admin_plan_list</xsl:when>
														<xsl:when test="@ACTION = '/Admin/User/List'">admin_user_list</xsl:when>
														<xsl:when test="@ACTION = '/Admin/Site/List'">admin_site_list</xsl:when>
														<xsl:when test="@ACTION = '/Admin/Profile/View'">admin_profile_view</xsl:when>
														<xsl:when test="@ACTION = ''">admin_register_site</xsl:when>
														<xsl:otherwise></xsl:otherwise>
													</xsl:choose>
												</xsl:attribute>
												<span class="sb-gettingstarted-title"><xsl:value-of select="@TITLE"/></span>
												<br />
												<div class="sb-getting-started-description"><xsl:value-of select="@DESCRIPTION"/></div>
												 <a href="#" class="sb-gettingstarted-link">
												 	<xsl:attribute name="href"><xsl:value-of select="@ACTION"/></xsl:attribute>
												 	<xsl:value-of select="@ADDITIONAL-LINK"/>
												 </a>
											</td>
										</xsl:for-each>
									</tr>
									
									<xsl:if test="count(CONTROL[@TYPE='INPUT']) > 0">
										<tr>
											<td class="sb-gettingstarted-item">
												<xsl:attribute name="colspan"><xsl:value-of select="$colspan"/></xsl:attribute>
												<script type="text/javascript" src="/js/Admin/Sites.js?{$version}.{$build}"/>
													
												<form id="ownSite" method="post" name="ownSite" onsubmit="javascript:return validateOwnForm();">
													<xsl:attribute name="action"><xsl:value-of select="$baseUrl"/>/Admin/Site/Own</xsl:attribute>
											
													<table cellpadding="0" cellspacing="0" border="0" class="control-title-input">
														<xsl:for-each select="CONTROL[@TYPE='INPUT']">
															<tr>
																<td class="title-block">
																	<xsl:apply-templates select="." mode="label">
																		<xsl:with-param name="require">true</xsl:with-param>
																	</xsl:apply-templates>
																</td>
																<td class="input-block">
																	<xsl:apply-templates select="." mode="control">
																		<xsl:with-param name="require">true</xsl:with-param>
																	</xsl:apply-templates>
																	<div class="hint"><xsl:value-of select="@HINT"/></div>
																</td>
															</tr>
														</xsl:for-each>
														<tr>
															<td>&#160;</td>
															<td style="padding: 5px 10px 0 0;">
																<table cellspacing="0" cellpaddig="0" width="70" border="0">
																	<tr><td>
																		
																		<xsl:apply-templates select="CONTROL[@TYPE='BUTTON']">
																			<xsl:with-param name="style">width:90px;</xsl:with-param>
																			<xsl:with-param name="action">javascript: submitOwnForm();</xsl:with-param>
																		</xsl:apply-templates>
																	</td></tr>
																</table>
															</td>
														</tr>
													</table>
												</form>
											</td>
										</tr>
									</xsl:if>
									
									<tr>
										<td>
										<xsl:attribute name="colspan"><xsl:value-of select="$colspan"/></xsl:attribute>
										  <div class="sb-gettingstarted-footer">
											  <a class="sb-dashboard-link">
												  <xsl:attribute name="href">javascript:openWizard('<xsl:value-of select="@BOTTOM-LINK"/>?<xsl:value-of select="/SITEBUILDER-PAGE/PROPERTIES/SESSION/@NAME"/>=<xsl:value-of select="/SITEBUILDER-PAGE/PROPERTIES/SESSION"/>');</xsl:attribute>
												  <xsl:value-of select="@BOTTOM-DESCRIPTION"/>
											  </a>
											</div>
										</td>
									</tr>
								</table>
							</td>
						</tr>
						<xsl:call-template name="DASHBOARD-PANEL-FOOTER1"/>
					</table>
				</td>
			</tr>
		</table>
		<xsl:call-template name="HIDE-DASHBOARD-PANEL">
			<xsl:with-param name="panelId" select="$panelId"/>
		</xsl:call-template>
	</xsl:template>

	<xsl:template match="DASHBOARD-PANEL[@TYPE='TASKS']">
	   <xsl:variable name="total" select="count(DASHBOARD-PANEL-ITEM)"/>
	   <xsl:variable name="columns" select="2"/>
	   <xsl:variable name="panelId">tasks</xsl:variable>
   		<table cellpadding="0" cellspacing="0" border="0" style="width: 100%;" id="{$panelId}">
   			<xsl:call-template name="DASHBOARD-PANEL-TITLE">
				<xsl:with-param name="panelId" select="$panelId"/>
			</xsl:call-template>
			<tr>
				<td class="sb-dashboard-panel-content" colspan="2" style="padding-bottom:0px;padding-top:5px;">
					<table cellspacing="0" width="100%" cellpadding="5" border="0">
						<xsl:call-template name="DASHBOARD-PANEL-ROW">
							<xsl:with-param name="start" select="1"/>
							<xsl:with-param name="columns" select="$columns"/>
							<xsl:with-param name="total" select="$total"/>
						</xsl:call-template>
						<xsl:call-template name="DASHBOARD-PANEL-FOOTER"/>
					</table>
				</td>
			</tr>
		</table>
		<xsl:call-template name="HIDE-DASHBOARD-PANEL">
			<xsl:with-param name="panelId" select="$panelId"/>
		</xsl:call-template>
  	</xsl:template>
	
	<xsl:template match="DASHBOARD-PANEL[@TYPE='STAT']">
	   <xsl:variable name="panelId">statistics</xsl:variable>
		<table cellpadding="0" cellspacing="0" border="0" style="width:100%;" id="{$panelId}">
   			<xsl:call-template name="DASHBOARD-PANEL-TITLE">
				<xsl:with-param name="panelId" select="$panelId"/>
			</xsl:call-template>
			<tr>
				<td class="sb-dashboard-panel-content" colspan="2" style="padding-bottom:0px;padding-top:12px;">
					<table cellspacing="0" cellpadding="5" border="0" style="width:100%;border-collapse:collapse;">
						<xsl:for-each select="DASHBOARD-PANEL-ITEM|DASHBOARD-PANEL-SLIDER">
							<tr>
								<td valign="top" style="width:25%;height:40px;white-space:nowrap;padding-top:0px;">
									<table cellpadding="0" cellspacing="0" >
										<tr>
											<td valign="top">
												<img style="border-width:0px;" width="16" height="16" alt="">
													<xsl:attribute name="src"><xsl:value-of select="$skinPath"/>/icons/<xsl:value-of select="@ICON"/></xsl:attribute>
												</img>
											</td>
											<td style="padding-left: 10px; color: #000 !important;" class="sb-dashboard-item-description"><xsl:value-of select="@TITLE"/></td>
										</tr>
									</table>
								</td>
								<td valign="top" style="white-space:nowrap;padding-bottom:0px;padding-top:0px;padding-left:4px;padding-right:5px;" class="sb-dashboard-item-description">
									<xsl:apply-templates match="GAUGE-CONTROL"/>
									<xsl:value-of select="@DESCRIPTION"/>
								</td>
							</tr>
						</xsl:for-each>
   						<xsl:call-template name="DASHBOARD-PANEL-FOOTER"/>
					</table>
				</td>
			</tr>
		</table>
		<xsl:call-template name="HIDE-DASHBOARD-PANEL">
			<xsl:with-param name="panelId" select="$panelId"/>
		</xsl:call-template>
	</xsl:template>

	<xsl:template name="DASHBOARD-PANEL-ROW">
		<xsl:param name="start"/>
	   	<xsl:param name="columns"/>
	   	<xsl:param name="total"/>
	   	<xsl:variable name="next" select="$start + $columns"/>
	   	<tr>
			<xsl:for-each select="DASHBOARD-PANEL-ITEM[position() &gt;= $start and position() &lt; $next]">
			<td style="width: 50%; vertical-align: top;">
				<table>
					<xsl:if test="@DISABLED = '1'">
						<xsl:attribute name="style">filter: gray alpha(opacity=40); -moz-opacity: 0.4; opacity: 0.4;</xsl:attribute>
					</xsl:if>
					<xsl:attribute name="onmouseover">SetContextHelp('<xsl:value-of select="@CONTEXT-HELP"/>')</xsl:attribute>
					<xsl:attribute name="onmouseout">SetContextHelp()</xsl:attribute>
				
					<tr>
						<td rowspan="2" valign="top" align="left">
						
							<xsl:choose>
								<xsl:when test="@DISABLED = '1'">
									<img width="32" height="32" style="border-width:0px;" alt="">
										<xsl:attribute name="src"><xsl:value-of select="$skinPath"/>/icons/<xsl:value-of select="@ICON"/></xsl:attribute>
									</img>
								</xsl:when>
								<xsl:otherwise>
									<a href="#" class="sb-dashboard-item-title-link" style="color: rgb(2, 64, 163); font-weight: bold;">
										<xsl:choose>
											<xsl:when test="substring-before(@ACTION,':')='javascript'">
												<xsl:attribute name="onclick"><xsl:value-of select="@ACTION"/></xsl:attribute>
												<xsl:attribute name="href">#</xsl:attribute>
											</xsl:when>
											<xsl:otherwise>
												<xsl:attribute name="href"><xsl:value-of select="@ACTION"/></xsl:attribute>
											</xsl:otherwise>
										</xsl:choose>
										<img width="32" height="32" style="border-width:0px;" alt="">
											<xsl:attribute name="src"><xsl:value-of select="$skinPath"/>/icons/<xsl:value-of select="@ICON"/></xsl:attribute>
										</img>
									</a>
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td style="padding-left:10px;" valign="top">
							<xsl:choose>
								<xsl:when test="@DISABLED = '1'">
									<span class="sb-dashboard-item-title-link" style="color: rgb(2, 64, 163); font-weight: bold;"><xsl:value-of select="@TITLE"/></span>
								</xsl:when>
								<xsl:otherwise>
									<a href="#" class="sb-dashboard-item-title-link" style="color: rgb(2, 64, 163); font-weight: bold;">
										<xsl:choose>
											<xsl:when test="substring-before(@ACTION,':')='javascript'">
												<xsl:attribute name="onclick"><xsl:value-of select="@ACTION"/></xsl:attribute>
												<xsl:attribute name="href">#</xsl:attribute>
											</xsl:when>
											<xsl:otherwise>
												<xsl:attribute name="href"><xsl:value-of select="@ACTION"/></xsl:attribute>
											</xsl:otherwise>
										</xsl:choose>
										<xsl:value-of select="@TITLE"/>
									</a>
								</xsl:otherwise>
							</xsl:choose>
								
							
						</td>
					</tr>
					<tr>
						<td style="padding-left:10px;" valign="top" class="sb-dashboard-item-description"><xsl:value-of select="@DESCRIPTION"/></td>
					</tr>
				</table>
			</td>
		  </xsl:for-each>
		  <xsl:call-template name="DASHBOARD-PANEL-EMPTY-CELL">
			 <xsl:with-param name="next" select="$next - 1"/>
			 <xsl:with-param name="total" select="$total"/>
		  </xsl:call-template>
	   </tr>
	   <xsl:if test="$next &lt;= $total">
		  <xsl:call-template name="DASHBOARD-PANEL-ROW">
			 <xsl:with-param name="start" select="$next"/>
			 <xsl:with-param name="columns" select="$columns"/>
			 <xsl:with-param name="total" select="$total"/>
		  </xsl:call-template>
	   </xsl:if>
	</xsl:template>
	
	
	<xsl:template name="DASHBOARD-PANEL-EMPTY-CELL">
	   <xsl:param name="next"/>
	   <xsl:param name="total"/>
	   <xsl:if test="$next &gt; $total">
		  <td>
			 <br />
		  </td>
		  <xsl:call-template name="DASHBOARD-PANEL-EMPTY-CELL">
			 <xsl:with-param name="next" select="$next - 1"/>
			 <xsl:with-param name="total" select="$total"/>		
		  </xsl:call-template>
	   </xsl:if>
	</xsl:template>	
	
	<xsl:template match="AREA-MAP-WARNING">
		<xsl:apply-templates select="STATUS" mode="admin"/>
	</xsl:template>	
	
	<xsl:template match="AREA-MAP-WARNING/STATUS/@STATUS-TEXT">
		<xsl:value-of select="."/>&#160;<a class="sb-dashboard-link" href="{$baseUrl}{../@COMMAND-HREF}"><xsl:value-of select="../@COMMAND-TITLE"/></a><br/>
	</xsl:template>	

	<xsl:template match="LICENSE-WARNING">
		<xsl:apply-templates select="STATUS" mode="admin"/>
	</xsl:template>	
	
	<xsl:template match="LICENSE-WARNING/STATUS/@STATUS-TEXT">
		<xsl:value-of select="."/>&#160;<a class="sb-dashboard-link" href="{$baseUrl}{../@COMMAND-HREF}"><xsl:value-of select="../@COMMAND-TITLE"/></a><br/>
	</xsl:template>	
	
	
</xsl:stylesheet>