<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:template match="VIEW-CONTENT">
		<xsl:apply-templates select="/SITEBUILDER-PAGE/STATUS" mode="admin"/>
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="INTERFACE-CONTENT">
	<style>
			.sb-formtableheader-th { background-color: #f0f0f0; }
	</style>
		<script type="text/javascript" src="/js/Admin/InterfaceSettings.js?{$version}.{$build}"/>

		<form name="editInterfaceSettings" enctype="multipart/form-data" method="post" id="editInterfaceSettings" onsubmit="submitForm(); return false;">
			<input type="hidden" name="action" id="editInterfaceSettingsAction" value="/Admin/InterfaceSettings/Save"/>

			<table width="100%" cellpadding="0" cellspacing="0"  border="0">
				<tr>
			    	<td>
						<xsl:apply-templates/>
			    	</td>
				</tr>
			</table>

			<!-- input image needed for work default submit via Enter -->
			<input type="image" style="border-width: 0px; height: 0px; width: 0px;"/>
		</form>
		<table cellpadding="0" cellspacing="0" border="0" style="width: 100%;"><tr><td style="padding: 0 10px;">
	         <xsl:call-template name="OK-CANCEL-BUTTONS">
				<xsl:with-param name="okAction">submitForm();</xsl:with-param>
				<xsl:with-param name="cancelAction">document.location.href="<xsl:value-of select="$baseUrl"/>/Admin/Server";</xsl:with-param>
			</xsl:call-template>
		</td></tr></table>
	</xsl:template>

	<xsl:template match="GENERAL-CARD-CONTENT">

		<xsl:if test="LOGO-PREVIEW/@NEED-APPLY-CHANGES = '1'">
			<script type="text/javascript" language="javascript">
				sbApplyChangesObject.registerChange();
			</script>
		</xsl:if>

		<input type="hidden" name="MAX_FILE_SIZE">
			<xsl:attribute name="value"><xsl:value-of select="UPLOAD-LOGO/@MAX-FILE-SIZE"/></xsl:attribute>
		</input>

		<table cellpadding="0" cellspacing="0" border="0" class="control-title-input">
			<tr>
				<td class="title-block">
					<xsl:call-template name="LABEL" mode="label">
						<xsl:with-param name="title" select="LOGO-PREVIEW"/>
					</xsl:call-template>
				</td>
				<td class="input-block">
					<table cellpadding="0" cellspacing="0" border="0">
						<tr>
							<td valign="middle" align="center" style="width: 150px; height: 40px;" class="logotype-layer">
								<img style="border-width: 0px;">
									<xsl:attribute name="src">
										<xsl:choose>
											<xsl:when test="LOGO-PREVIEW/@IMAGE">
											<!-- hard code must be removed! -->
												<xsl:value-of select="LOGO-PREVIEW/@IMAGE"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="$skinPath"/>/images/<xsl:value-of select="LOGO-PREVIEW/@DEFAULT-IMAGE"/>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:attribute>
								</img>
							</td>
						</tr>
					</table>
				</td>
				<td></td>
			</tr>
			<tr>
				<td class="title-block">
					<xsl:call-template name="LABEL" mode="label">
						<xsl:with-param name="title" select="UPLOAD-LOGO"/>
					</xsl:call-template>
				</td>
				<td class="input-block">
					<xsl:call-template name="INPUT" mode="control">
						<xsl:with-param name="id">idUploadLogo</xsl:with-param>
						<xsl:with-param name="name" select="UPLOAD-LOGO/@NAME"/>
						<xsl:with-param name="size">60</xsl:with-param>
						<xsl:with-param name="type">file</xsl:with-param>
					</xsl:call-template>
				</td>
				<td>
					<xsl:apply-templates select="UPLOAD-LOGO/CONTROL[@NAME='uploadButton']">
						<xsl:with-param name="action">javascript:submitForUpload();</xsl:with-param>
						<xsl:with-param name="style">width: 100px;</xsl:with-param>
					</xsl:apply-templates>
				</td>
			</tr>
			<tr>
				<td class="title-block">
					<xsl:apply-templates select="CONTROL[@ID='logoLink']" mode="label"/>
				</td>
				<td class="input-block">
					<xsl:apply-templates select="CONTROL[@ID='logoLink']" mode="control">
						<xsl:with-param name="size">60</xsl:with-param>
						<xsl:with-param name="onchange">sbApplyChangesObject.registerChange();</xsl:with-param>
					</xsl:apply-templates>
				</td>
				<td></td>
			</tr>
			<tr>
				<td class="title-block">
					<xsl:apply-templates select="CONTROL[@ID='title']" mode="label"/>
				</td>
				<td class="input-block">
					<xsl:apply-templates select="CONTROL[@ID='title']" mode="control">
						<xsl:with-param name="size">60</xsl:with-param>
						<xsl:with-param name="onchange">sbApplyChangesObject.registerChange();</xsl:with-param>
					</xsl:apply-templates>
				</td>
				<td></td>
			</tr>
		</table>

		<table width="100%" cellpadding="0" cellspacing="0" border="0">
			<tr>
				<td>
					<xsl:apply-templates select="CONTROL[@NAME='restoreButton']">
						<xsl:with-param name="style">width: 140px;</xsl:with-param>
						<xsl:with-param name="action">javascript: if (confirm(SbGetLocaleByKey('SURE-TO-RESTORE'))) { document.getElementById('editInterfaceSettingsAction').value = '/Admin/InterfaceSettings/Restore'; return document.forms['editInterfaceSettings'].submit(); } return false;</xsl:with-param>
					</xsl:apply-templates>
				</td>
			</tr>
		</table>

	</xsl:template>

	<xsl:template match="HELP-LINKS-CONTAINER">
		<fieldset>
			<legend><xsl:value-of select="@TITLE"/></legend>
			<div class="fieldset-block">
				<table cellpadding="0" cellspacing="0" border="0" class="control-title-input">
					<xsl:for-each select="CONTROL">
						<tr>
							<td class="title-block">
								<xsl:apply-templates select="." mode="label"/>
							</td>
							<td class="input-block">
								<xsl:apply-templates select="." mode="control">
									<xsl:with-param name="onchange">sbApplyChangesObject.registerChange();</xsl:with-param>
									<xsl:with-param name="size">60</xsl:with-param>
								</xsl:apply-templates>
							</td>
						</tr>
					</xsl:for-each>
				</table>
			</div>
		</fieldset>
		<div style="width: 0; height: 10px;"><span></span></div>
	</xsl:template>

	<xsl:template match="SUPPORT-LINKS-CONTAINER">
		<fieldset>
			<legend><xsl:value-of select="@TITLE"/></legend>
			<div class="fieldset-block">
				<table cellpadding="0" cellspacing="0" border="0" class="control-title-input">
					<tr>
						<td class="title-block">
							<xsl:apply-templates select="." mode="label"/>
						</td>
						<td class="input-block">
							<xsl:apply-templates select="." mode="control">
								<xsl:with-param name="onchange">sbApplyChangesObject.registerChange();</xsl:with-param>
								<xsl:with-param name="size">60</xsl:with-param>
							</xsl:apply-templates>
						</td>
					</tr>
				</table>
			</div>
		</fieldset>
	</xsl:template>

</xsl:stylesheet>


