<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:template match="LICENSE-FORM">
		<style>
			.sb-pagetitle { border-bottom: solid 1px #776655; }
		</style>
		<script type="text/javascript" src="/js/Sb/Views/Admin/License.js?{$version}.{$build}"/>
		
		<form name="restoreDefaultKeyForm" id="restoreDefaultKeyForm" method="post" action="{$baseUrl}/Admin/License/RestoreDefaultKey"/>
		
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="ACTIVATION-CARD-CONTENT">
		<form name="activateKey" method="POST" action="{$baseUrl}/Admin/License/Activate" onsubmit="javascript:return Sb.Views.Admin.License.validateActivationForm();">
			
		<fieldset>
			<legend><xsl:value-of select="@TITLE"/></legend>
			<div class="fieldset-block">
				<xsl:value-of select="@DESCRIPTION"/>
				<div style="width: 0; height: 10px;"><span></span></div>
				<table cellpadding="0" cellspacing="0" border="0" class="control-title-input">
					<tr>
						<td class="title-block">
							<xsl:call-template name="LABEL" mode="label">
								<xsl:with-param name="id">activationCode</xsl:with-param>
								<xsl:with-param name="require">true</xsl:with-param>
								<xsl:with-param name="title" select="@ACT-CODE-TITLE"/>
								<xsl:with-param name="value" select="."/>
							</xsl:call-template>
							
						</td>
						<td class="input-block">
							<xsl:call-template name="INPUT" mode="control">
								<xsl:with-param name="id">activationCode</xsl:with-param>
								<xsl:with-param name="name">activationCode</xsl:with-param>
								<xsl:with-param name="onchange">self.sbApplyChangesObject.registerChange();</xsl:with-param>
								<xsl:with-param name="require">true</xsl:with-param>
								<xsl:with-param name="size">60</xsl:with-param>
								<xsl:with-param name="value" select="."/>
							</xsl:call-template>
						</td>
						<td class="description-block"><div class="hint" style="white-space: nowrap;">(<xsl:value-of select="@EXAMPLE"/>: 9FFT00-OGEE19-LQAA56-QCCU99)</div></td>
					</tr>
				</table>
			</div>
		</fieldset>
		<div class="form-separator"><span></span></div>
		<table cellpadding="0" cellspacing="0" class="form-tools-container">
			<tr>
				<td><div class="hint"><xsl:call-template name="REQUIRED-FIELDS"/></div></td>
				<td>
					<table cellpadding="0" cellspacing="0" class="ok-cancel-container">
						<tr>
							<td>
								<xsl:apply-templates select="CONTROL[@TYPE='BUTTON']">
									<xsl:with-param name="action">javascript:return Sb.Views.Admin.License.validateActivationForm();</xsl:with-param>
								</xsl:apply-templates>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
		</form>
	</xsl:template>
	
	<xsl:template match="UPLOADKEY-CARD-CONTENT">
		<form name="uploadKey" method="POST" action="{$baseUrl}/Admin/License/Upload" enctype="multipart/form-data" onsubmit="javascript:submitUploadForm(); return false;">
			<input type="hidden" name="MAX_FILE_SIZE">
				<xsl:attribute name="value"><xsl:value-of select="@MAX-FILE-SIZE"/></xsl:attribute>
			</input>
			
			<input type="hidden" id="savedFileName" name="savedFileName"/>
			
			<fieldset>
				<legend><xsl:value-of select="@TITLE"/></legend>
				<div class="fieldset-block">
					<table cellpadding="0" cellspacing="0" border="0" class="control-title-input">
						<tr>
							<td class="title-block">
								<xsl:call-template name="LABEL" mode="label">
									<xsl:with-param name="id">sbUploadKey</xsl:with-param>
									<xsl:with-param name="require">true</xsl:with-param>
									<xsl:with-param name="title" select="@DESCRIPTION"/>
									<xsl:with-param name="value" select="."/>
								</xsl:call-template>
							</td>
							<td class="input-block">
								<xsl:call-template name="INPUT" mode="control">
									<xsl:with-param name="id">sbUploadKey</xsl:with-param>
									<xsl:with-param name="name">sbUploadKey</xsl:with-param>
									<xsl:with-param name="onchange">self.sbApplyChangesObject.registerChange();</xsl:with-param>
									<xsl:with-param name="require">true</xsl:with-param>
									<xsl:with-param name="size">60</xsl:with-param>
									<xsl:with-param name="type">file</xsl:with-param>
									<xsl:with-param name="value" select="."/>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</div>
			</fieldset>
			<div class="form-separator"><span></span></div>
			<table cellpadding="0" cellspacing="0" class="form-tools-container">
				<tr>
					<td><div class="hint"><xsl:call-template name="REQUIRED-FIELDS"/></div></td>
					<td>
						<table cellpadding="0" cellspacing="0" class="ok-cancel-container">
							<tr>
								<td>
									<xsl:apply-templates select="CONTROL[@TYPE='BUTTON']">
										<xsl:with-param name="action">javascript:Sb.Views.Admin.License.submitUploadForm();</xsl:with-param>
									</xsl:apply-templates>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</form>
	</xsl:template>

	<xsl:template match="RETRIVEKEY-CARD-CONTENT">
		<table cellpadding="0" cellspacing="0" width="100%" border="0">
			<tr>
				<td align="center" >
					<fieldset>
						<div class="fieldset-block">
							<div class="sb-label">
								<xsl:value-of select="@RESPONSE-TITLE"/>:<br/><xsl:value-of select="@RESPONSE"/>
							</div>
						</div>
					</fieldset>
				</td>
			</tr>
				<tr>
					<td align="right">
								<xsl:apply-templates select="CONTROL[@TYPE='BUTTON']">
									<xsl:with-param name="action">document.location.href="<xsl:value-of select="$baseUrl"/>/Admin/License";</xsl:with-param>
								</xsl:apply-templates>
					</td>
				</tr>
		</table>
	</xsl:template>
	
	
</xsl:stylesheet>