<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:template match="VIEW-CONTENT">
		<xsl:apply-templates select="/SITEBUILDER-PAGE/STATUS" mode="admin"/>
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="LOGS-CONTENT">
		<script type="text/javascript" src="/js/Admin/Logs.js?{$version}.{$build}"/>
		<style>
			.sb-formtableheader-th { background-color: #f0f0f0; }
		</style>
	
		<xsl:apply-templates select="TAB-PANEL"/>
	</xsl:template>

	<xsl:template match="LOG-CARD-CONTENT">
		<form name="logDetailsForm" id="logDetailsForm" method="post" action="">
			<input type="hidden" name="logId" value=""/>
		</form>
		
		<table width="100%" cellpadding="0" cellspacing="0" border="0">
			<tr><td><xsl:apply-templates /></td></tr>
		</table>
	</xsl:template>
	
	
	<xsl:template match="PAGED-LIST/LIST/HEADER">
		<input type="hidden" name="logId"/>
	
	<tr class="fixed">			
			<xsl:call-template name="LIST-HEADER-ITEM">
				<xsl:with-param name="field">source</xsl:with-param>
				<xsl:with-param name="title"><xsl:value-of select="SOURCE"/></xsl:with-param>
				<xsl:with-param name="currentSortField"><xsl:value-of select="../../LIST/@ORDER-BY"/></xsl:with-param>
				<xsl:with-param name="currentSortType"><xsl:value-of select="../../LIST/@ORDER-TYPE"/></xsl:with-param>				
			</xsl:call-template>
			
			<xsl:call-template name="LIST-HEADER-ITEM">
				<xsl:with-param name="field">level</xsl:with-param>
				<xsl:with-param name="title"><xsl:value-of select="LEVEL"/></xsl:with-param>
				<xsl:with-param name="currentSortField"><xsl:value-of select="../../LIST/@ORDER-BY"/></xsl:with-param>
				<xsl:with-param name="currentSortType"><xsl:value-of select="../../LIST/@ORDER-TYPE"/></xsl:with-param>
			</xsl:call-template>
			
			<xsl:call-template name="LIST-HEADER-ITEM">
				<xsl:with-param name="field">creationDate</xsl:with-param>
				<xsl:with-param name="title"><xsl:value-of select="CREATION-DATE"/></xsl:with-param>
				<xsl:with-param name="currentSortField"><xsl:value-of select="../../LIST/@ORDER-BY"/></xsl:with-param>
				<xsl:with-param name="currentSortType"><xsl:value-of select="../../LIST/@ORDER-TYPE"/></xsl:with-param>
			</xsl:call-template>
		
			<xsl:call-template name="LIST-HEADER-ITEM">
				<xsl:with-param name="field">userName</xsl:with-param>
				<xsl:with-param name="title"><xsl:value-of select="USER-NAME"/></xsl:with-param>
				<xsl:with-param name="currentSortField"><xsl:value-of select="../../LIST/@ORDER-BY"/></xsl:with-param>
				<xsl:with-param name="currentSortType"><xsl:value-of select="../../LIST/@ORDER-TYPE"/></xsl:with-param>
			</xsl:call-template>
			
			<xsl:call-template name="LIST-HEADER-ITEM">
				<xsl:with-param name="field">ipAddress</xsl:with-param>
				<xsl:with-param name="title"><xsl:value-of select="IP-ADDRESS"/></xsl:with-param>
				<xsl:with-param name="currentSortField"><xsl:value-of select="../../LIST/@ORDER-BY"/></xsl:with-param>
				<xsl:with-param name="currentSortType"><xsl:value-of select="../../LIST/@ORDER-TYPE"/></xsl:with-param>
			</xsl:call-template>
			
			<xsl:call-template name="LIST-HEADER-ITEM">
				<xsl:with-param name="field">message</xsl:with-param>
				<xsl:with-param name="title"><xsl:value-of select="MESSAGE"/></xsl:with-param>
				<xsl:with-param name="currentSortField"><xsl:value-of select="../../LIST/@ORDER-BY"/></xsl:with-param>
				<xsl:with-param name="currentSortType"><xsl:value-of select="../../LIST/@ORDER-TYPE"/></xsl:with-param>
			</xsl:call-template>
			
		</tr>
	</xsl:template>
	
	<xsl:template match="PAGED-LIST/LIST/ITEM">
		<xsl:variable name="class">
			<xsl:call-template name="LIST-ROW-CLASS">
        		<xsl:with-param name="position"><xsl:value-of select="position()"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		
		<tr class="{$class}">
			<xsl:attribute name="id">logRecordRow<xsl:value-of select="LOG-ID"/></xsl:attribute>
			<xsl:attribute name="name">logRecordRow</xsl:attribute>
		
			<xsl:call-template name="LIST-ROW-ITEM">
				<xsl:with-param name="title"><xsl:value-of select="SOURCE"/></xsl:with-param>
				<xsl:with-param name="action">javascript:showRecord(<xsl:value-of select="LOG-ID"/>);</xsl:with-param>
			</xsl:call-template>
			
			<xsl:call-template name="LIST-ROW-ITEM">
				<xsl:with-param name="icon">
					<xsl:choose>
						<xsl:when test="LEVEL=1">verbose.gif</xsl:when>
						<xsl:when test="LEVEL=2">information.gif</xsl:when>
						<xsl:when test="LEVEL=3">warning.gif</xsl:when>
						<xsl:when test="LEVEL=4">error.gif</xsl:when>
						<xsl:when test="LEVEL=5">critical.gif</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="LEVEL"/> 
						</xsl:otherwise>
					</xsl:choose>
				</xsl:with-param>
			</xsl:call-template>
			
			<xsl:call-template name="LIST-ROW-ITEM">
				<xsl:with-param name="title"><xsl:value-of select="CREATION-DATE"/></xsl:with-param>
			</xsl:call-template>
			
			<xsl:call-template name="LIST-ROW-ITEM">
				<xsl:with-param name="title"><xsl:value-of select="USER-NAME"/></xsl:with-param>
			</xsl:call-template>
			
			<xsl:call-template name="LIST-ROW-ITEM">
				<xsl:with-param name="title"><xsl:value-of select="IP-ADDRESS"/></xsl:with-param>
			</xsl:call-template>
		
			<xsl:call-template name="LIST-ROW-ITEM">
				<xsl:with-param name="title"><xsl:value-of select="MESSAGE"/></xsl:with-param>
			</xsl:call-template>

		</tr>
	</xsl:template>
	
	<xsl:template match="LOG-RECORD-DETAILS">
		<div id="logRecordDetails"/>
	</xsl:template>
	
</xsl:stylesheet>