<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:template match="MENU-PANEL">	
		<xsl:param name="panelId"><xsl:value-of select="@ID"/></xsl:param>
		
		<script type="text/javascript" src="/js/Admin/context_help.js?{$version}.{$build}"/>
		
        <table cellspacing="0" cellpadding="0" border="0" style="width: 100%;">
			<xsl:attribute name="id"><xsl:value-of select="$panelId"/></xsl:attribute>				
			<tr>
				<td class="sb-leftmenu-panel-corner">
					<img src="/images/blank.gif" class="sb-leftmenu-panel-corner"/>
				</td> 	
				<td class="sb-leftmenu-panel-header">
					<table cellpadding="0" cellspacing="0" border="0" style="width:100%;height:100%;">
						<tr>
							<td align="Left" class="sb-leftmenu-panel-header-text"><xsl:value-of select="@TITLE"/></td>
							<td align="Right" valign="Middle">
								<img src="{$skinPath}/images/hide.gif">
									<xsl:if test="@DISABLED = 1">
										<xsl:attribute name="src"><xsl:value-of select="$skinPath"/>/images/show.gif</xsl:attribute>
									</xsl:if>
									<xsl:attribute name="id"><xsl:value-of select="$panelId"/>_image</xsl:attribute>		
								</img>
							</td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<xsl:if test="@DISABLED = 1">
					<xsl:attribute name="style">display: none</xsl:attribute>
				</xsl:if>
				
				<td class="sb-leftmenu-panel-content" colspan="2" valign="top" style="padding: 5px 5px 0 0;">
					<xsl:if test="MENU-PANEL-ITEM">
							<xsl:for-each select="MENU-PANEL-ITEM">
                                <table cellpadding="0" cellspacing="0" border="0">
        						<xsl:choose>
        							<xsl:when test="@SELECTED">
        								<xsl:attribute name="class">sb-leftmenu-item-active</xsl:attribute>
        							</xsl:when>
        							<xsl:otherwise>
        								<xsl:attribute name="class">sb-leftmenu-item</xsl:attribute>
        							</xsl:otherwise>
        						</xsl:choose>
                                    <tr>
                                        <td style="padding: 0 5px 0 15px;">
        									<a onmouseout="SetContextHelp()">
        										<xsl:attribute name="onmouseover">SetContextHelp('<xsl:value-of select="@CONTEXT-HELP"/>')</xsl:attribute>
        										<xsl:choose>
        											<xsl:when test="substring-before(@ACTION,':')='javascript'">
        												<xsl:attribute name="onclick"><xsl:value-of select="@ACTION"/></xsl:attribute>
        												<xsl:attribute name="href">#</xsl:attribute>
        											</xsl:when>
        											<xsl:otherwise>
        												<xsl:attribute name="onclick">javascript:sbNavigationObject.go('<xsl:value-of select="@ACTION"/>');</xsl:attribute>
        												<xsl:attribute name="href">#</xsl:attribute>
        											</xsl:otherwise>
        										</xsl:choose>
        										<img border="0" width="16" height="16" alt="">
        											<xsl:attribute name="src"><xsl:value-of select="$skinPath"/>/<xsl:value-of select="@ICON"/></xsl:attribute>
        										</img>
        									</a>
                                        </td>
                                        <td width="100%">
                                            <a onmouseout="SetContextHelp()">
                                            	<xsl:attribute name="onmouseover">SetContextHelp('<xsl:value-of select="@CONTEXT-HELP"/>')</xsl:attribute>
        										<xsl:choose>
        											<xsl:when test="@SELECTED">
        												<xsl:attribute name="class">sb-leftmenu-text-active</xsl:attribute>
        											</xsl:when>
        											<xsl:otherwise>
        												<xsl:attribute name="class">sb-leftmenu-text</xsl:attribute>
        											</xsl:otherwise>
        										</xsl:choose>
        										<xsl:choose>
        											<xsl:when test="substring-before(@ACTION,':')='javascript'">
        												<xsl:attribute name="onclick"><xsl:value-of select="@ACTION"/></xsl:attribute>
        												<xsl:attribute name="href">#</xsl:attribute>
        											</xsl:when>
        											<xsl:otherwise>
        												<xsl:attribute name="onclick">javascript:sbNavigationObject.go('<xsl:value-of select="@ACTION"/>');</xsl:attribute>
        												<xsl:attribute name="href">#</xsl:attribute>
        											</xsl:otherwise>
        										</xsl:choose>
        										<xsl:value-of select="@TITLE"/>
                                            </a>
                                        </td>
                                    </tr>
                                </table>
                                <div class="sb-leftmenu-separator"><span></span></div>
							</xsl:for-each>
					</xsl:if>
					
					<xsl:if test="CONTEXT-HELP">
						<table cellpadding="0" cellspacing="0" border="0" width="100%">
							<tr valign="top">
								<td width="100%" class="sb-leftmenu-help" style="padding: 0;">
									<div style="padding: 3px 0 3px 10px;"><div class="sb-leftmenu-help-separator"/></div>									
									<div style="padding: 0 15px 5px 15px;"><div class="sb-short-help" id="contextHelp"/></div>
								</td>
								<td><div style="width: 0; height: 77px;"><span></span></div></td>									
							</tr>
						</table>
						
						<script type="text/javascript" language="javascript">
							SetContextHelp();
						</script>
					</xsl:if>
				</td>
			</tr>
		</table>
		<input type="hidden" value="true">
			<xsl:if test="@DISABLED = 1">
				<xsl:attribute name="value">false</xsl:attribute>
			</xsl:if>
			<xsl:attribute name="name"><xsl:value-of select="$panelId"/>_hidden</xsl:attribute>
			<xsl:attribute name="id"><xsl:value-of select="$panelId"/>_hidden</xsl:attribute>
		</input>
		<br class="SB_LeftMenu_PanelsBreak"/>
	</xsl:template>

</xsl:stylesheet>

