<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:strip-space elements="*"/>
	<xsl:output method="html" indent="yes" encoding="utf-8"/>

	<xsl:template match="ESHOP-CUSTOM-PAYMENT-SYSTEM">
		<style>
				.sb-formtableheader-th { background-color: #f0f0f0; }
		</style>
		<script type="text/javascript" src="/js/Admin/Modules/Eshop/CustomPaymentSystem.js?{$version}.{$build}"/>

		<table cellpadding="0" cellspacing="0" border="0" class="control-input-title">
			<tr>
				<td class="input-block">
					<xsl:apply-templates select="CONTROL[@TYPE='CHECKBOX' and @NAME='isCustomPaymentSystemEnabled']" mode="control">
						<xsl:with-param name="onchange">changeCustomPaymentSystemFormStatus(this.checked); self.sbApplyChangesObject.registerChange();</xsl:with-param>
					</xsl:apply-templates>
				</td>
				<td class="title-block">
					<xsl:apply-templates select="CONTROL[@TYPE='CHECKBOX' and @NAME='isCustomPaymentSystemEnabled']" mode="label"/>
				</td>
			</tr>
		</table>
		<div style="width: 0; height: 10px;"><span></span></div>
		<table width="100%" cellpadding="0" cellspacing="0" border="0">

			<tr>
				<td id="customPaymentSystemSettingsContainer">
					<xsl:apply-templates select="ESHOP-CUSTOM-PAYMENT-SYSTEM-GENERAL"/>
					<br/>
					<xsl:apply-templates select="ESHOP-CUSTOM-PAYMENT-SYSTEM-OWNER"/>
					<br/>
					<xsl:apply-templates select="ESHOP-CUSTOM-PAYMENT-SYSTEM-CUSTOMER"/>
					<br/>
					<xsl:apply-templates select="ESHOP-CUSTOM-PAYMENT-SYSTEM-ADDITIONAL"/>
					<br/>
				</td>
			</tr>
		</table>
		<script type="text/javascript">
			initCustomPaymentSystemForm();
		</script>
	</xsl:template>

	<xsl:template match="ESHOP-CUSTOM-PAYMENT-SYSTEM-GENERAL">
		<fieldset>
			<legend><xsl:value-of select="@TITLE"/></legend>
			<div class="fieldset-block">
				<table cellpadding="0" cellspacing="0" border="0" class="control-title-input">
					<xsl:for-each select="CONTROL">
					<tr>
						<td class="title-block">
							<xsl:apply-templates select="." mode="label"/>
						</td>
						<td class="input-block">
							<xsl:apply-templates select="." mode="control">
								<xsl:with-param name="onchange">self.sbApplyChangesObject.registerChange();</xsl:with-param>
							</xsl:apply-templates>
							<div class="hint"><xsl:value-of select="@DESCRIPTION"/></div>
						</td>
					</tr>
					</xsl:for-each>
				</table>
			</div>
		</fieldset>
	</xsl:template>

	<xsl:template match="ESHOP-CUSTOM-PAYMENT-SYSTEM-OWNER|ESHOP-CUSTOM-PAYMENT-SYSTEM-CUSTOMER|ESHOP-CUSTOM-PAYMENT-SYSTEM-ADDITIONAL">
		<fieldset>
			<legend><xsl:value-of select="@TITLE"/></legend>
			<div class="fieldset-block">
				<script type="text/javascript" src="/js/Admin/Modules/Eshop/CustomPaymentSystemSettingsList.js?{$version}.{$build}"/>
				<xsl:apply-templates select="LIST"/>
			</div>
		</fieldset>
	</xsl:template>

	<xsl:template name="COMMON-FIELD-CONTROLS">
		<td style="text-align:center; cursor:pointer; padding-left: 4px; padding-right: 4px;">
			<img alt="{LOCALES/@UP}" style="border-width:0px;width:16px;height:16px;" src="{$skinPath}/images/sequence-up.gif" onclick="this.settingsList.moveUp(this.settingsObject); self.sbApplyChangesObject.registerChange();"/>
		</td>
		<td style="text-align:center; cursor:pointer; padding-left: 4px; padding-right: 4px;">
			<img alt="{LOCALES/@DOWN}" style="border-width:0px;width:16px;height:16px;" src="{$skinPath}/images/sequence-down.gif" onclick="this.settingsList.moveDown(this.settingsObject); self.sbApplyChangesObject.registerChange();"/>
		</td>
		<td style="text-align:center;cursor:pointer;">
			<img alt="{LOCALES/@DELETE}" style="border-width:0px;width:16px;height:16px;" src="{$skinPath}/icons/delete.png" onclick="this.settingsList.remove(this.settingsObject); self.sbApplyChangesObject.registerChange();"/>
			<input type="hidden" name=""/>
		</td>
	</xsl:template>

	<xsl:template match="ESHOP-CUSTOM-PAYMENT-SYSTEM-OWNER/LIST">
		<table cellspacing="1" border="0" id="ownerContainer" style="width: 100%;">
			<xsl:apply-templates select="HEADER"/>
			<tr class="sb-gridtext" style="display: none;" id="ownerTemplateRow">
				<td style="text-align:center;"><span>&#160;</span><input type="hidden" name=""/></td>
				<td style="text-align:center">
					<input class="sb-control-input-input" type="checkbox" name="" onClick="this.settingsObject.isRequired = this.checked; self.sbApplyChangesObject.registerChange();"/>
				</td>
				<td style="text-align:center">
					<input class="sb-control-input-input" type="text" autocomplete="off" style="width:100%;" onchange="self.sbApplyChangesObject.registerChange();"/>
				</td>
				<td style="text-align:center">
					<input class="sb-control-input-input" type="text" autocomplete="off" style="width:100%;" onchange="self.sbApplyChangesObject.registerChange();"/>
				</td>
				<td>
					<xsl:apply-templates select="CONTROL[@NAME='typesList']" mode="control">
						<xsl:with-param name="controlClass">sb-control-input-input</xsl:with-param>
						<xsl:with-param name="controlStyle">width:100%;</xsl:with-param>
						<xsl:with-param name="onChange">this.settingsObject.type = this.value; self.sbApplyChangesObject.registerChange();</xsl:with-param>
					</xsl:apply-templates>
				</td>
				<xsl:call-template name="COMMON-FIELD-CONTROLS"/>
			</tr>
			<tr class="sb-gridview-header" id="ownerAddFieldRow" style="display: none">
				<td colspan="5">&#160;</td>
				<td colspan="3" style="text-align:center;">
					<xsl:call-template name="BUTTON">
						<xsl:with-param name="action">self.ownerSettingsList.appendNew(); self.sbApplyChangesObject.registerChange();</xsl:with-param>
						<xsl:with-param name="title" select="LOCALES/@NEW"/>
						<xsl:with-param name="id">ownerAddButtonContainer</xsl:with-param>
					</xsl:call-template>
					<div style="width: 100px; height: 0;"><span></span></div>
				</td>
			</tr>
			<script type="text/javascript">
				self.ownerSettingsList = new CustomPaymentSystemSettings('forOwner', 'ownerContainer', 'ownerHeaderRow', 'ownerTemplateRow', 'ownerAddFieldRow', 'ownerAddButtonContainer', function() {return new CustomPaymentSystemForOwnerObject('', 0, false, '', '', '<xsl:value-of select="CONTROL/CONTROL"/>');});
				<xsl:apply-templates select="ITEM"/>
			</script>
		</table>
		<script type="text/javascript">
			self.ownerSettingsList.buildSelf();
		</script>
	</xsl:template>

	<xsl:template match="ESHOP-CUSTOM-PAYMENT-SYSTEM-OWNER/LIST/HEADER">
		<tr id="ownerHeaderRow" class="sb-gridview-header" align="left" style="height:24px;white-space:nowrap;">
			<th style="width:30px; text-align:center"><xsl:value-of select="POSITION"/></th>
			<th style="width:50px; text-align:center"><xsl:value-of select="IS-REQUIRED"/></th>
			<th style="text-align:center"><xsl:value-of select="INTERNAL-NAME"/></th>
			<th style="text-align:center"><xsl:value-of select="CAPTION"/></th>
			<th style="text-align:center"><xsl:value-of select="TYPE"/></th>
			<th style="width:25px; text-align:center"><xsl:value-of select="UP"/></th>
			<th style="width:25px; text-align:center"><xsl:value-of select="DOWN"/></th>
			<th style="width:25px; text-align:center"><xsl:value-of select="DELETE"/></th>
		</tr>
	</xsl:template>

	<xsl:template match="ESHOP-CUSTOM-PAYMENT-SYSTEM-OWNER/LIST/ITEM">
		self.ownerSettingsList.register(new CustomPaymentSystemForOwnerObject('<xsl:value-of select="ID"/>', '<xsl:value-of select="POSITION"/>', <xsl:value-of select="IS-REQUIRED"/>, '<xsl:value-of select="INTERNAL-NAME"/>', '<xsl:value-of select="CAPTION"/>', '<xsl:value-of select="TYPE"/>'));
	</xsl:template>

	<xsl:template match="ESHOP-CUSTOM-PAYMENT-SYSTEM-CUSTOMER/LIST">
		<table cellspacing="1" border="0" id="customerContainer" style="width: 100%;">
			<xsl:apply-templates select="HEADER"/>
			<tr class="sb-gridtext" style="display: none;" id="customerTemplateRow">
				<td style="text-align:center;"><span>&#160;</span><input type="hidden" name=""/></td>
				<td style="text-align:center">
					<input class="sb-control-input-input" type="checkbox" name="" onClick="this.settingsObject.isRequired = this.checked; self.sbApplyChangesObject.registerChange();"/>
				</td>
				<td style="text-align:center">
					<input class="sb-control-input-input" type="text" autocomplete="off" style="width:100%;" onchange="self.sbApplyChangesObject.registerChange();"/>
				</td>
				<td style="text-align:center">
					<input class="sb-control-input-input" type="text" autocomplete="off" style="width:100%;" onchange="self.sbApplyChangesObject.registerChange();"/>
				</td>
				<td>
					<xsl:apply-templates select="CONTROL[@NAME='typesList']" mode="control">
						<xsl:with-param name="controlClass">sb-control-input-input</xsl:with-param>
						<xsl:with-param name="controlStyle">width:100%;</xsl:with-param>
						<xsl:with-param name="onChange">this.settingsObject.type = this.value; self.sbApplyChangesObject.registerChange();</xsl:with-param>
					</xsl:apply-templates>
				</td>
				<xsl:call-template name="COMMON-FIELD-CONTROLS"/>
			</tr>
			<tr class="sb-gridview-header" id="customerAddFieldRow" style="display: none">
				<td colspan="5">&#160;</td>
				<td colspan="3" style="text-align:center;">
					<xsl:call-template name="BUTTON">
						<xsl:with-param name="action">self.customerSettingsList.appendNew(); self.sbApplyChangesObject.registerChange();</xsl:with-param>
						<xsl:with-param name="title" select="LOCALES/@NEW"/>
						<xsl:with-param name="id">customerAddButtonContainer</xsl:with-param>
					</xsl:call-template>
					<div style="width: 100px; height: 0;"><span></span></div>
				</td>
			</tr>
			<script type="text/javascript">
				self.customerSettingsList = new CustomPaymentSystemSettings('forCustomer', 'customerContainer', 'customerHeaderRow', 'customerTemplateRow', 'customerAddFieldRow', 'customerAddButtonContainer', function() {return new CustomPaymentSystemForCustomerObject('', 0, false, '', '', '<xsl:value-of select="CONTROL/CONTROL"/>');});
				<xsl:apply-templates select="ITEM"/>
			</script>
		</table>
		<script type="text/javascript">
			self.customerSettingsList.buildSelf();
		</script>
	</xsl:template>

	<xsl:template match="ESHOP-CUSTOM-PAYMENT-SYSTEM-CUSTOMER/LIST/HEADER">
		<tr id="customerHeaderRow" class="sb-gridview-header" align="left" style="height:24px;white-space:nowrap;">
			<th style="width:30px; text-align:center"><xsl:value-of select="POSITION"/></th>
			<th style="width:50px; text-align:center"><xsl:value-of select="IS-REQUIRED"/></th>
			<th style="text-align:center"><xsl:value-of select="INTERNAL-NAME"/></th>
			<th style="text-align:center"><xsl:value-of select="CAPTION"/></th>
			<th style="text-align:center"><xsl:value-of select="TYPE"/></th>
			<th style="width:25px; text-align:center"><xsl:value-of select="UP"/></th>
			<th style="width:25px; text-align:center"><xsl:value-of select="DOWN"/></th>
			<th style="width:25px; text-align:center"><xsl:value-of select="DELETE"/></th>
		</tr>
	</xsl:template>

	<xsl:template match="ESHOP-CUSTOM-PAYMENT-SYSTEM-CUSTOMER/LIST/ITEM">
		self.customerSettingsList.register(new CustomPaymentSystemForCustomerObject('<xsl:value-of select="ID"/>', '<xsl:value-of select="POSITION"/>', <xsl:value-of select="IS-REQUIRED"/>, '<xsl:value-of select="INTERNAL-NAME"/>', '<xsl:value-of select="CAPTION"/>', '<xsl:value-of select="TYPE"/>'));
	</xsl:template>

	<xsl:template match="ESHOP-CUSTOM-PAYMENT-SYSTEM-ADDITIONAL/LIST">
		<table cellspacing="1" border="0" id="additionalContainer" style="width: 100%;">
			<xsl:apply-templates select="HEADER"/>
			<tr class="sb-gridtext" style="display: none;" id="additionalTemplateRow">
				<td style="text-align:center;"><span>&#160;</span><input type="hidden" name=""/></td>
				<td style="text-align:center">
					<input class="sb-control-input-input" type="text" autocomplete="off" style="width:100%;" onchange="self.sbApplyChangesObject.registerChange();"/>
				</td>
				<td>
					<xsl:apply-templates select="CONTROL[@NAME='sourceList']" mode="control">
						<xsl:with-param name="controlClass">sb-control-input-input</xsl:with-param>
						<xsl:with-param name="controlStyle">width:100%;</xsl:with-param>
						<xsl:with-param name="onChange">this.settingsObject.type = this.value; self.sbApplyChangesObject.registerChange();</xsl:with-param>
					</xsl:apply-templates>
				</td>
				<xsl:call-template name="COMMON-FIELD-CONTROLS"/>
			</tr>
			<tr class="sb-gridview-header" id="additionalAddFieldRow" style="display: none">
				<td colspan="5">&#160;</td>
				<td colspan="3" style="text-align:center;">
					<xsl:call-template name="BUTTON">
						<xsl:with-param name="action">self.additionalSettingsList.appendNew(); self.sbApplyChangesObject.registerChange();</xsl:with-param>
						<xsl:with-param name="title" select="LOCALES/@NEW"/>
						<xsl:with-param name="id">additionalAddButtonContainer</xsl:with-param>
					</xsl:call-template>
					<div style="width: 100px; height: 0;"><span></span></div>
				</td>
			</tr>
			<script type="text/javascript">
				self.additionalSettingsList = new CustomPaymentSystemSettings('additional', 'additionalContainer', 'additionalHeaderRow', 'additionalTemplateRow', 'additionalAddFieldRow', 'additionalAddButtonContainer', function() {return new CustomPaymentSystemAdditionalObject('', 0, '', '<xsl:value-of select="CONTROL/CONTROL"/>');});
				<xsl:apply-templates select="ITEM"/>
			</script>
		</table>
		<script type="text/javascript">
			self.additionalSettingsList.buildSelf();
		</script>
	</xsl:template>

	<xsl:template match="ESHOP-CUSTOM-PAYMENT-SYSTEM-ADDITIONAL/LIST/HEADER">
		<tr id="additionalHeaderRow" class="sb-gridview-header" align="left" style="height:24px;white-space:nowrap;">
			<th style="width:30px; text-align:center"><xsl:value-of select="POSITION"/></th>
			<th style="text-align:center"><xsl:value-of select="INTERNAL-NAME"/></th>
			<th style="text-align:center"><xsl:value-of select="SOURCE"/></th>
			<th style="width:25px; text-align:center"><xsl:value-of select="UP"/></th>
			<th style="width:25px; text-align:center"><xsl:value-of select="DOWN"/></th>
			<th style="width:25px; text-align:center"><xsl:value-of select="DELETE"/></th>
		</tr>
	</xsl:template>

	<xsl:template match="ESHOP-CUSTOM-PAYMENT-SYSTEM-ADDITIONAL/LIST/ITEM">
		self.additionalSettingsList.register(new CustomPaymentSystemAdditionalObject('<xsl:value-of select="ID"/>', '<xsl:value-of select="POSITION"/>', '<xsl:value-of select="INTERNAL-NAME"/>', '<xsl:value-of select="SOURCE"/>'));
	</xsl:template>

</xsl:stylesheet>