<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template match="VIEW-CONTENT">
	<style>
			.sb-formtableheader-th { background-color: #f0f0f0; }
	</style>

<xsl:apply-templates select="/SITEBUILDER-PAGE/STATUS" mode="admin"/>

<script type="text/javascript" src="/js/Admin/Plans.js?{$version}.{$build}"/>

<form name="multiForm" method="POST" action="{$baseUrl}/Admin/Plan/Form" onsubmit="submitForm(); return false;">

	<!-- input image needed for work default submit via Enter -->
	<input type="image" style="border-width: 0px; height: 0px; width: 0px;"/>

	<input type="hidden" name="tab" value="general"/>
	<input type="hidden" name="pageNum"   value=""/>
	<input type="hidden" name="pageSize"  value=""/>
	<input type="hidden" name="orderBy"   value=""/>
	<input type="hidden" name="orderType" value=""/>

	<xsl:apply-templates />
</form>
<table cellpadding="0" cellspacing="0" border="0" style="width: 100%;"><tr><td style="padding: 0 10px;">
	<table cellpadding="0" cellspacing="0" class="form-tools-container">
		<tr>
			<td><div class="hint"><xsl:call-template name="REQUIRED-FIELDS"/></div></td>
			<td>
				<table cellpadding="0" cellspacing="0" class="ok-cancel-container">
					<tr>
						<td>
							<xsl:call-template name="OK-CANCEL-BUTTONS">
								<xsl:with-param name="okAction">submitForm();</xsl:with-param>
								<xsl:with-param name="cancelAction">document.forms.multiForm.action = '<xsl:value-of select="$baseUrl"/>/Admin/Plan/Cancel';document.forms.multiForm.submit();</xsl:with-param>
							</xsl:call-template>
						</td>
					</tr>
				</table>
			</td>
		</tr>
	</table>
</td></tr></table>
</xsl:template>

<xsl:template match="OBJECT[@TYPE='PLAN']">

	<table cellpadding="0" cellspacing="0" border="0" class="control-title-input">
		<tr>
			<td class="title-block">
				<xsl:apply-templates select="CONTROL[@NAME='name']" mode="label">
					<xsl:with-param name="require">true</xsl:with-param>
				</xsl:apply-templates>
			</td>
			<td class="input-block">
				<xsl:apply-templates select="CONTROL[@NAME='name']" mode="control">
					<xsl:with-param name="onchange">self.sbApplyChangesObject.registerChange();</xsl:with-param>
					<xsl:with-param name="require">true</xsl:with-param>
				</xsl:apply-templates>
			</td>
		</tr>
		<tr>
			<td class="title-block">
				<xsl:apply-templates select="CONTROL[@NAME='description']" mode="label"/>
			</td>
			<td class="input-block">
				<xsl:apply-templates select="CONTROL[@NAME='description']" mode="control">
					<xsl:with-param name="onchange">self.sbApplyChangesObject.registerChange();</xsl:with-param>
					<xsl:with-param name="size">60</xsl:with-param>
				</xsl:apply-templates>
			</td>
		</tr>
	</table>
	<div style="height: 1px; background-color: #e5e5e5; margin: 6px 0;"><span></span></div>
	<table cellpadding="0" cellspacing="0" border="0" class="control-title-input">
		<xsl:call-template name="PLAN-FORM-QUANTITY-ROW">
			<xsl:with-param name="name">maxPages</xsl:with-param>
			<xsl:with-param name="size">10</xsl:with-param>
			<xsl:with-param name="maxlength">2</xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name="PLAN-FORM-QUANTITY-ROW">
			<xsl:with-param name="name">maxRootPages</xsl:with-param>
			<xsl:with-param name="size">10</xsl:with-param>
			<xsl:with-param name="maxlength">2</xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name="PLAN-FORM-QUANTITY-ROW">
			<xsl:with-param name="name">maxSites</xsl:with-param>
			<xsl:with-param name="size">10</xsl:with-param>
			<xsl:with-param name="maxlength">8</xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name="PLAN-FORM-QUANTITY-ROW">
			<xsl:with-param name="name">maxUsers</xsl:with-param>
			<xsl:with-param name="size">10</xsl:with-param>
			<xsl:with-param name="maxlength">9</xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name="PLAN-FORM-QUANTITY-ROW">
			<xsl:with-param name="name">maxHosts</xsl:with-param>
			<xsl:with-param name="size">10</xsl:with-param>
			<xsl:with-param name="maxlength">9</xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name="PLAN-FORM-QUANTITY-ROW">
			<xsl:with-param name="name">trialLifeTime</xsl:with-param>
			<xsl:with-param name="size">10</xsl:with-param>
			<xsl:with-param name="maxlength">2</xsl:with-param>
		</xsl:call-template>
	</table>
</xsl:template>


<xsl:template name="PLAN-FORM-QUANTITY-ROW">
	<xsl:param name="name"/>
	<xsl:param name="size"/>
	<xsl:param name="maxlength"/>
	
	<xsl:variable name="node" select="CONTROL[@NAME=$name]"/> 
	
	<tr>
		<td rowspan="2" class="quantity-title-block"><xsl:apply-templates select="$node" mode="label"/></td>
		<td class="quantity-input-block">
			<xsl:call-template name="RADIO" mode="control">
				<xsl:with-param name="name">radio<xsl:value-of select="$name"/></xsl:with-param>
				<xsl:with-param name="onchange">self.sbApplyChangesObject.registerChange();</xsl:with-param>
				<xsl:with-param name="value">unlimited</xsl:with-param>
				
				<xsl:with-param name="disabled">
					<xsl:choose>
						<xsl:when test="$node/@PARENT-VALUE &gt;= 0">TRUE</xsl:when>
					</xsl:choose>
				</xsl:with-param>
				
				<xsl:with-param name="checked">
					<xsl:choose>
						<xsl:when test="not($node) or $node = '-1' or $node = ''">TRUE</xsl:when>
					</xsl:choose>
				</xsl:with-param>
				
			</xsl:call-template>
		</td>
		<td colspan="2" class="quantity-description-block"><div class="hint"><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/UNLIMITED"/></div></td>
	</tr>
	<tr>
		<td class="input-block">
			<xsl:call-template name="RADIO" mode="control">
				<xsl:with-param name="name">radio<xsl:value-of select="$name"/></xsl:with-param>
				<xsl:with-param name="onchange">self.sbApplyChangesObject.registerChange();</xsl:with-param>
				<xsl:with-param name="value">limited</xsl:with-param>
				
				<xsl:with-param name="checked">
					<xsl:choose>
						<xsl:when test="$node/@PARENT-VALUE &gt;= 0 or ($node and $node != '-1' and $node != '')">TRUE</xsl:when>
					</xsl:choose>
				</xsl:with-param>
			</xsl:call-template>

			<input type="hidden" id="hidden{$name}" name="hidden{$name}">
				<xsl:attribute name="value"><xsl:value-of select="$node/@PARENT-VALUE"/></xsl:attribute>
			</input>
		</td>
		<td class="input-block">
			<xsl:apply-templates select="CONTROL[@NAME=$name]" mode="control">
				<xsl:with-param name="maxlength" select="$maxlength"/>
				<xsl:with-param name="onchange">self.sbApplyChangesObject.registerChange(); if(this.value!='') multiForm.radio<xsl:value-of select="$name"/>[1].checked=true;</xsl:with-param>
				<xsl:with-param name="onkeyup">if(this.value!='') multiForm.radio<xsl:value-of select="$name"/>[1].checked=true;</xsl:with-param>
				<xsl:with-param name="size" select="$size"/>
				<xsl:with-param name="value">
					<xsl:choose>
						<xsl:when test="$node != ''">
							<xsl:if test="$node &gt;= 0">
								<xsl:value-of select="$node"/>
							</xsl:if>
						</xsl:when>
						<xsl:otherwise>
							<xsl:if test="$node/@PARENT-VALUE &gt;= 0">
								<xsl:value-of select="$node/@PARENT-VALUE"/>
							</xsl:if>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:with-param>
				
			</xsl:apply-templates>
		</td>
		<td class="input-block">
			<xsl:if test="$node/@NAME = 'trialLifeTime'">
				
				<xsl:variable name="value">
					<xsl:choose>
						<xsl:when test="CONTROL[@NAME='trialLifeTypeId'] != ''"><xsl:value-of select="CONTROL[@NAME='trialLifeTypeId']"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="CONTROL[@NAME='trialLifeTypeId']/@PARENT-VALUE"/></xsl:otherwise>
					</xsl:choose>
				</xsl:variable>

				<select name="trialLifeTypeId">								
					<xsl:attribute name="onchange">sbApplyChangesObject.registerChange();</xsl:attribute>
					<option value="1">
						<xsl:if test="$value = 1"><xsl:attribute name="selected">true</xsl:attribute></xsl:if>
						<xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/DAYS"/>
					</option>
					<option value="2">
						<xsl:if test="$value = 2"><xsl:attribute name="selected">true</xsl:attribute></xsl:if>
						<xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/HOURS"/>
					</option>
				</select>
				<input type="hidden" name="hiddentrialLifeTypeId" id="hiddentrialLifeTypeId">
					<xsl:attribute name="value">
							<xsl:value-of select="CONTROL[@NAME='trialLifeTypeId']/@PARENT-VALUE"/>
					</xsl:attribute>
				</input>
			</xsl:if>
		</td>
	</tr>
</xsl:template>

</xsl:stylesheet>