<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template match="PLANS-LIST">
	<style>
		.sb-pagetitle { border-bottom: solid 1px #776655; }
	</style>
<xsl:apply-templates/>

<xsl:if test="count(PAGED-LIST/LIST/ITEM) != 0">
<div class="list-table-row-strong" style="margin: 0 -20px; zoom: 1; padding: 2px 10px;">
		<xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/DEFAULT-PLAN-MSG"/>
</div>
</xsl:if>

<script language="javascript">
function activatePlans() {
	if (countSelectedCheckBoxes() > 0) {
		document.forms.listForm.action.value = '/Admin/Plan/Activate';
		document.forms.listForm.submit();
	}
	else {
		alert(SbGetLocaleByKey('SELECT-FOR-DELETE'));
	}
}
function deactivatePlans() {
	if (countSelectedCheckBoxes() > 0) {
		document.forms.listForm.action.value = '/Admin/Plan/Deactivate';
		document.forms.listForm.submit();
	}
	else {
		alert(SbGetLocaleByKey('SELECT-FOR-DELETE'));
	}
}
function deletePlans() {
	if (countSelectedCheckBoxes() > 0) {
		if (confirm(SbGetLocaleByKey('SURE-TO-DELETE'))) {
			document.forms.listForm.action.value = '/Admin/Plan/Delete';
			document.forms.listForm.submit();
		}
	}
	else {
		alert(SbGetLocaleByKey('SELECT-FOR-DELETE'));
	}
}
function setTrialPlan() {
	if (countSelectedCheckBoxes() != 1) {
		alert(SbGetLocaleByKey('SELECT-A-PLAN'));
	} else {
		document.forms.listForm.action.value = '/Admin/Plan/SetTrial';
		document.forms.listForm.submit();
	}
}
</script>

</xsl:template>

<xsl:template match="PAGED-LIST/LIST/HEADER">
<tr class="fixed">
	<th style="width:1%;">
		<div>
			<input type="checkbox" name="globalCheck" onclick="setCheckboxStatus(this.checked);" class="check"/>
		</div>
	</th>
	
	<xsl:call-template name="LIST-HEADER-ITEM">
		<xsl:with-param name="field">status</xsl:with-param>
		<xsl:with-param name="title"><xsl:value-of select="STATUS"/></xsl:with-param>
		<xsl:with-param name="width">1%</xsl:with-param>
		<xsl:with-param name="currentSortField"><xsl:value-of select="../../LIST/@ORDER-BY"/></xsl:with-param>
		<xsl:with-param name="currentSortType"><xsl:value-of select="../../LIST/@ORDER-TYPE"/></xsl:with-param>
		<xsl:with-param name="align">center</xsl:with-param>
	</xsl:call-template>

	<xsl:call-template name="LIST-HEADER-ITEM">
		<xsl:with-param name="field">name</xsl:with-param>
		<xsl:with-param name="title"><xsl:value-of select="NAME"/></xsl:with-param>
		<xsl:with-param name="width">25%</xsl:with-param>
		<xsl:with-param name="currentSortField"><xsl:value-of select="../../LIST/@ORDER-BY"/></xsl:with-param>
		<xsl:with-param name="currentSortType"><xsl:value-of select="../../LIST/@ORDER-TYPE"/></xsl:with-param>
	</xsl:call-template>

	<xsl:call-template name="LIST-HEADER-ITEM">
		<xsl:with-param name="field">description</xsl:with-param>
		<xsl:with-param name="title"><xsl:value-of select="DESCRIPTION"/></xsl:with-param>
		<xsl:with-param name="width">25%</xsl:with-param>
		<xsl:with-param name="currentSortField"><xsl:value-of select="../../LIST/@ORDER-BY"/></xsl:with-param>
		<xsl:with-param name="currentSortType"><xsl:value-of select="../../LIST/@ORDER-TYPE"/></xsl:with-param>
	</xsl:call-template>

	<xsl:call-template name="LIST-HEADER-ITEM">
		<xsl:with-param name="field">numberOfAccounts</xsl:with-param>
		<xsl:with-param name="title"><xsl:value-of select="NUMBER-OF-ACCOUNTS"/></xsl:with-param>
		<xsl:with-param name="width">25%</xsl:with-param>
		<xsl:with-param name="currentSortField"><xsl:value-of select="../../LIST/@ORDER-BY"/></xsl:with-param>
		<xsl:with-param name="currentSortType"><xsl:value-of select="../../LIST/@ORDER-TYPE"/></xsl:with-param>
		<xsl:with-param name="align">left</xsl:with-param>
	</xsl:call-template>

	<xsl:call-template name="LIST-HEADER-ITEM">
		<xsl:with-param name="field">creationDate</xsl:with-param>
		<xsl:with-param name="title"><xsl:value-of select="CREATION-DATE"/></xsl:with-param>
		<xsl:with-param name="width">25%</xsl:with-param>
		<xsl:with-param name="currentSortField"><xsl:value-of select="../../LIST/@ORDER-BY"/></xsl:with-param>
		<xsl:with-param name="currentSortType"><xsl:value-of select="../../LIST/@ORDER-TYPE"/></xsl:with-param>
		<xsl:with-param name="align">right</xsl:with-param>
	</xsl:call-template>
</tr>
</xsl:template>


<xsl:template match="PAGED-LIST/LIST/ITEM">
<!-- <xsl:variable name="class">
	<xsl:call-template name="LIST-ROW-CLASS">
        	<xsl:with-param name="position"><xsl:value-of select="position()"/></xsl:with-param>
	</xsl:call-template>
</xsl:variable> -->
<tr>
	<xsl:choose>
		<xsl:when test="IS-TRIAL = '1'">
			<xsl:attribute name="class">list-table-row-strong</xsl:attribute>
		</xsl:when>
		<xsl:when test="position() mod 2">
			<xsl:attribute name="class">list-table-row</xsl:attribute>
		</xsl:when>
		<xsl:otherwise>
			<xsl:attribute name="class">list-table-row-alter</xsl:attribute>
		</xsl:otherwise>
		
	</xsl:choose>

	<td style="width:1%;">
		<input type="checkbox" name="objectIds[]" class="check">
			<!--xsl:if test="IS-TRIAL = '1'"><xsl:attribute name="disabled">true</xsl:attribute></xsl:if-->
			<xsl:attribute name="value"><xsl:value-of select="PLAN-ID"/></xsl:attribute>
		</input>
	</td>
	
<!--	<xsl:attribute name="class"><xsl:choose><xsl:when test="IS-TRIAL = '1'">trial</xsl:when><xsl:otherwise><xsl:value-of select="class"/></xsl:otherwise></xsl:choose></xsl:attribute> -->

	<xsl:call-template name="LIST-ROW-ITEM">
		<xsl:with-param name="icon">
			<xsl:choose>
				<xsl:when test="STATUS = '1'">run.png</xsl:when>
				<xsl:otherwise>shutdown.png</xsl:otherwise>
			</xsl:choose>
		</xsl:with-param>
	</xsl:call-template>

	<xsl:call-template name="LIST-ROW-ITEM">
		<xsl:with-param name="title"><xsl:value-of select="NAME"/></xsl:with-param>
		<xsl:with-param name="action"><xsl:value-of select="$baseUrl"/>/Admin/Plan/Edit?planId=<xsl:value-of select="PLAN-ID"/></xsl:with-param>
	</xsl:call-template>

	<xsl:call-template name="LIST-ROW-ITEM">
		<xsl:with-param name="title"><xsl:value-of select="DESCRIPTION"/></xsl:with-param>
	</xsl:call-template>

	<xsl:call-template name="LIST-ROW-ITEM">
		<xsl:with-param name="title"><xsl:value-of select="NUMBER-OF-ACCOUNTS"/></xsl:with-param>
		<xsl:with-param name="align">right</xsl:with-param>
	</xsl:call-template>

	<xsl:call-template name="LIST-ROW-ITEM">
		<xsl:with-param name="title"><xsl:value-of select="CREATION-DATE"/></xsl:with-param>
		<xsl:with-param name="align">right</xsl:with-param>
	</xsl:call-template>
</tr>
</xsl:template>

</xsl:stylesheet>