<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template match="TAB-PANEL-CARD[@ID='SiteFamiliesList']/DEFAULT-SITE-FAMILY-MARK">
	<div class="list-table-row-strong" style="margin: 0 -20px; zoom: 1; padding: 2px 10px;">
		<xsl:value-of select="."/>
	</div>
</xsl:template>

<xsl:template match="PAGED-LIST/LIST[@PREFIX='SiteFamiliesList']/HEADER">
<tr class="fixed">
	<th style="width:1%;">
		<div>
			<input type="checkbox" name="TopSiteFamiliesList" onclick="setCheckboxStatus(this.checked, 'SiteFamiliesList');" class="check"/>
		</div>
	</th>

	<xsl:call-template name="LIST-HEADER-ITEM">
		<xsl:with-param name="title"><xsl:value-of select="STATUS"/></xsl:with-param>
		<xsl:with-param name="width">1%</xsl:with-param>
		<!--xsl:with-param name="tab"><xsl:value-of select="../@PREFIX"/></xsl:with-param-->
	</xsl:call-template>

	<xsl:call-template name="LIST-HEADER-ITEM">
		<xsl:with-param name="title"><xsl:value-of select="IS-ACTIVE"/></xsl:with-param>
		<xsl:with-param name="width">1%</xsl:with-param>
		<xsl:with-param name="tab"><xsl:value-of select="../@PREFIX"/></xsl:with-param>
	</xsl:call-template>

	<xsl:call-template name="LIST-HEADER-ITEM">
		<xsl:with-param name="field">code</xsl:with-param>
		<xsl:with-param name="title"><xsl:value-of select="CODE"/></xsl:with-param>
		<xsl:with-param name="currentSortField"><xsl:value-of select="../../LIST/@ORDER-BY"/></xsl:with-param>
		<xsl:with-param name="currentSortType"><xsl:value-of select="../../LIST/@ORDER-TYPE"/></xsl:with-param>
		<xsl:with-param name="tab"><xsl:value-of select="../@PREFIX"/></xsl:with-param>
	</xsl:call-template>

	<xsl:call-template name="LIST-HEADER-ITEM">
		<xsl:with-param name="field">title</xsl:with-param>
		<xsl:with-param name="title"><xsl:value-of select="TITLE"/></xsl:with-param>
		<xsl:with-param name="currentSortField"><xsl:value-of select="../../LIST/@ORDER-BY"/></xsl:with-param>
		<xsl:with-param name="currentSortType"><xsl:value-of select="../../LIST/@ORDER-TYPE"/></xsl:with-param>
		<xsl:with-param name="tab"><xsl:value-of select="../@PREFIX"/></xsl:with-param>
	</xsl:call-template>

	<xsl:call-template name="LIST-HEADER-ITEM">
		<xsl:with-param name="field">templateCategory</xsl:with-param>
		<xsl:with-param name="title"><xsl:value-of select="TEMPLATE-CATEGORY"/></xsl:with-param>
		<xsl:with-param name="currentSortField"><xsl:value-of select="../../LIST/@ORDER-BY"/></xsl:with-param>
		<xsl:with-param name="currentSortType"><xsl:value-of select="../../LIST/@ORDER-TYPE"/></xsl:with-param>
		<xsl:with-param name="tab"><xsl:value-of select="../@PREFIX"/></xsl:with-param>
	</xsl:call-template>

	<xsl:call-template name="LIST-HEADER-ITEM">
		<xsl:with-param name="field">pageSet</xsl:with-param>
		<xsl:with-param name="title"><xsl:value-of select="PAGE-SET"/></xsl:with-param>
		<xsl:with-param name="currentSortField"><xsl:value-of select="../../LIST/@ORDER-BY"/></xsl:with-param>
		<xsl:with-param name="currentSortType"><xsl:value-of select="../../LIST/@ORDER-TYPE"/></xsl:with-param>
		<xsl:with-param name="tab"><xsl:value-of select="../@PREFIX"/></xsl:with-param>
	</xsl:call-template>
</tr>
</xsl:template>

<xsl:template match="PAGED-LIST/LIST[@PREFIX='SiteFamiliesList']/ITEM">
	<xsl:variable name="class">
		<xsl:choose>
			<xsl:when test="IS-DEFAULT = '1'">list-table-row-strong</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="LIST-ROW-CLASS">
					<xsl:with-param name="position"><xsl:value-of select="position()"/></xsl:with-param>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<tr class="{$class}">
		<td style="width:1%;text-align:center">
			<input type="checkbox" name="SiteFamiliesListIds[]" value="{SITE-FAMILY-ID}">
				<xsl:if test="IS-DEFAULT = '1'">
					<xsl:attribute name="disabled">true</xsl:attribute>
				</xsl:if>
			</input>
		</td>

		<xsl:call-template name="LIST-ROW-ITEM">
			<xsl:with-param name="icon">
				<xsl:choose>
					<xsl:when test="IN-PLAN = '1'">run.png</xsl:when>
					<xsl:otherwise>shutdown.png</xsl:otherwise>
				</xsl:choose>
			</xsl:with-param>
		</xsl:call-template>

		<xsl:call-template name="LIST-ROW-ITEM">
			<xsl:with-param name="icon">
				<xsl:choose>
					<xsl:when test="IS-ACTIVE = '1'">run.png</xsl:when>
					<xsl:otherwise>shutdown.png</xsl:otherwise>
				</xsl:choose>
			</xsl:with-param>
		</xsl:call-template>

		<xsl:call-template name="LIST-ROW-ITEM">
			<xsl:with-param name="title"><xsl:value-of select="CODE"/></xsl:with-param>
		</xsl:call-template>

		<xsl:call-template name="LIST-ROW-ITEM">
			<xsl:with-param name="title"><xsl:value-of select="TITLE"/></xsl:with-param>
		</xsl:call-template>

		<xsl:call-template name="LIST-ROW-ITEM">
			<xsl:with-param name="title"><xsl:value-of select="TEMPLATE-CATEGORY"/></xsl:with-param>
		</xsl:call-template>

		<xsl:call-template name="LIST-ROW-ITEM">
			<xsl:with-param name="title"><xsl:value-of select="PAGE-SET"/></xsl:with-param>
		</xsl:call-template>
	</tr>
</xsl:template>

</xsl:stylesheet>