<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template match="VIEW-CONTENT">
	<style>
			.sb-formtableheader-th { background-color: #f0f0f0; }
	</style>
<xsl:apply-templates select="/SITEBUILDER-PAGE/STATUS" mode="admin"/>
<script type="text/javascript" src="/js/Admin/Profile.js?{$version}.{$build}"></script>
<form name="profileForm" method="POST" action="{$baseUrl}" onsubmit="submitForm(); return false;">
<input type="hidden" name="action" value="/Admin/Profile/Save"/>
<input type="hidden" name="tab" value=""/>
<xsl:apply-templates />
	<!-- input image needed for work default submit via Enter -->
	<input type="image" style="border-width: 0px; height: 0px; width: 0px;"/>
</form>
<table cellpadding="0" cellspacing="0" border="0" style="width: 100%;"><tr><td style="padding: 0 10px;">
	<table cellpadding="0" cellspacing="0" class="form-tools-container">
		<tr>
			<td><div class="hint"><xsl:call-template name="REQUIRED-FIELDS"/></div></td>
			<td>
				<xsl:call-template name="OK-CANCEL-BUTTONS">
					<xsl:with-param name="okAction">submitForm();</xsl:with-param>
					<xsl:with-param name="cancelAction">document.location.href='<xsl:value-of select="$baseUrl"/>/Admin/Profile/View';</xsl:with-param>
				</xsl:call-template>
			</td>
		</tr>
	</table>
</td></tr></table>
</xsl:template>


<xsl:template match="OBJECT[@TYPE='ACCOUNT']">
	<table cellpadding="0" cellspacing="0" border="0" class="control-title-input">
		<xsl:call-template name="PROFILE-FORM-ROW">
			<xsl:with-param name="name">firstName</xsl:with-param>
			<xsl:with-param name="require">true</xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name="PROFILE-FORM-ROW">
			<xsl:with-param name="name">lastName</xsl:with-param>
			<xsl:with-param name="require">true</xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name="PROFILE-FORM-ROW">
			<xsl:with-param name="name">userName</xsl:with-param>
			<xsl:with-param name="disabled">true</xsl:with-param>
		</xsl:call-template>
		<tr id="rowSetPassword">
			<xsl:if test="@IS-CHANGE-PASSWORD-ALLOWED != 1">
				<xsl:attribute name="style">display: none;</xsl:attribute>
			</xsl:if>
		
			<td class="title-block"></td>
			<td class="input-block">
				<xsl:call-template name="BUTTON-CONTROL">
					<xsl:with-param name="style"></xsl:with-param>
					<xsl:with-param name="title"><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/CHANGE-PASSWORD"/></xsl:with-param>
					<xsl:with-param name="action">showPassword();</xsl:with-param>
				</xsl:call-template>
			</td>
		</tr>
		<xsl:call-template name="PROFILE-PASSWORD-ROW">
			<xsl:with-param name="name">currentPassword</xsl:with-param>
			<xsl:with-param name="rowid">rowCurrentPassword</xsl:with-param>
			<xsl:with-param name="title"><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/CURRENT-PASSWORD"/></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name="PROFILE-PASSWORD-ROW">
			<xsl:with-param name="name">password</xsl:with-param>
			<xsl:with-param name="rowid">rowPassword</xsl:with-param>
			<xsl:with-param name="title"><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/PASSWORD"/></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name="PROFILE-PASSWORD-ROW">
			<xsl:with-param name="name">confirmPassword</xsl:with-param>
			<xsl:with-param name="rowid">rowPasswordConfirm</xsl:with-param>
			<xsl:with-param name="title"><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/CONFIRM-PASSWORD"/></xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name="PROFILE-FORM-ROW">
			<xsl:with-param name="name">email</xsl:with-param>
			<xsl:with-param name="require">true</xsl:with-param>
			<xsl:with-param name="size">60</xsl:with-param>
		</xsl:call-template>
	</table>
</xsl:template>

<xsl:template match="OBJECT[@TYPE='PROFILE']">
<table cellpadding="0" cellspacing="0" border="0" class="control-title-input">
	<xsl:call-template name="PROFILE-FORM-ROW">
		<xsl:with-param name="name">localeId</xsl:with-param>
	</xsl:call-template>
	<xsl:call-template name="PROFILE-FORM-ROW">
		<xsl:with-param name="name">skinId</xsl:with-param>
	</xsl:call-template>
	<xsl:call-template name="PROFILE-FORM-ROW">
		<xsl:with-param name="name">listSize</xsl:with-param>
		<xsl:with-param name="size">10</xsl:with-param>
		<xsl:with-param name="maxlength">3</xsl:with-param>	
		<xsl:with-param name="require">true</xsl:with-param>	
	</xsl:call-template>
</table>
</xsl:template>

	
<xsl:template name="PROFILE-FORM-ROW">
	<xsl:param name="disabled"/>
	<xsl:param name="maxlength">255</xsl:param>
	<xsl:param name="name"/>
	<xsl:param name="onchange">self.sbApplyChangesObject.registerChange();</xsl:param>
	<xsl:param name="require"/>
	<xsl:param name="size">25</xsl:param>

	<xsl:variable name="node" select="CONTROL[@NAME=$name]"/>      
				   
	<tr>
		<td class="title-block">
			<xsl:apply-templates select="$node" mode="label">
				<xsl:with-param name="require" select="$require"/>
			</xsl:apply-templates>
		</td>
		<td class="input-block">
			<xsl:apply-templates select="$node" mode="control">
				<xsl:with-param name="disabled" select="$disabled"/>
				<xsl:with-param name="maxlength"><xsl:value-of select="$maxlength"/></xsl:with-param>
				<xsl:with-param name="onchange"><xsl:value-of select="$onchange"/></xsl:with-param>
				<xsl:with-param name="require" select="$require"/>
				<xsl:with-param name="size"><xsl:value-of select="$size"/></xsl:with-param>
			</xsl:apply-templates>
		</td>
	</tr>
</xsl:template>	

<xsl:template name="PROFILE-PASSWORD-ROW">
	<xsl:param name="name"/>
	<xsl:param name="rowid"/>
	<xsl:param name="title"/>
	<xsl:param name="onchange">self.sbApplyChangesObject.registerChange();</xsl:param>

	<xsl:variable name="node" select="CONTROL[@NAME='userPassword']"/>      
				   
	<tr id="{$rowid}" style="display: none;">
		<td class="title-block">
			<xsl:apply-templates select="$node" mode="label">
				<xsl:with-param name="title" select="$title"/>
			</xsl:apply-templates>
		</td>
		<td class="input-block">
			<xsl:apply-templates select="$node" mode="control">
				<xsl:with-param name="id"><xsl:value-of select="$name"/></xsl:with-param>
				<xsl:with-param name="name"><xsl:value-of select="$name"/></xsl:with-param>
				<xsl:with-param name="onchange"><xsl:value-of select="$onchange"/></xsl:with-param>
				<xsl:with-param name="type">password</xsl:with-param>
				<xsl:with-param name="autocomplete">off</xsl:with-param>
			</xsl:apply-templates>
		</td>
	</tr>
</xsl:template>

</xsl:stylesheet>

