<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:template match="VIEW-CONTENT">
		<xsl:apply-templates select="/SITEBUILDER-PAGE/STATUS" mode="admin"/>
		<xsl:apply-templates/>
	</xsl:template>

<xsl:template match="SITE-FAMILIES-FORM">
	<style>
			.sb-formtableheader-th { background-color: #f0f0f0; }
	</style>
	<script type="text/javascript" src="/js/Sb/Views/Admin/SiteFamilies.js?{$version}.{$build}"/>

	<form name="siteFamilyForm" id="siteFamilyForm" enctype="multipart/form-data"  method="post" onsubmit="return Sb.Views.Admin.SiteFamilies.submitForm();">
		<input type="hidden" id="action" name="action" value="/Admin/SiteFamilies/Save"/>

		<xsl:apply-templates select="TAB-PANEL"/>

		<!-- input image needed for work default submit via Enter -->
		<input type="image" style="border-width: 0px; height: 0px; width: 0px;"/>
	</form>
	<table cellpadding="0" cellspacing="0" border="0" style="width: 100%;"><tr><td style="padding: 0 10px;">
		<table cellpadding="0" cellspacing="0" class="form-tools-container">
			<tr>
				<td><div class="hint"><xsl:call-template name="REQUIRED-FIELDS"/></div></td>
				<td>
					<table cellpadding="0" cellspacing="0" class="ok-cancel-container">
						<tr>
							<td>
								<xsl:call-template name="OK-CANCEL-BUTTONS">
									<xsl:with-param name="okAction">Sb.Views.Admin.SiteFamilies.submitForm();</xsl:with-param>
									<xsl:with-param name="cancelAction">document.location.href="<xsl:value-of select="$baseUrl"/>/Admin/SiteFamilies/List";</xsl:with-param>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</td></tr></table>
</xsl:template>

<xsl:template match="TAB-PANEL-CARD[@ID='presentation']/CONTENT">

	<input type="hidden" name="MAX_FILE_SIZE">
		<xsl:attribute name="value"><xsl:value-of select="UPLOAD-LOGO/@MAX-FILE-SIZE"/></xsl:attribute>
	</input>

	<table cellpadding="0" cellspacing="0" border="0" class="control-title-input">
		<tr>
			<td class="title-block">
				<xsl:apply-templates select="CONTROL[@NAME='code']" mode="label">
					<xsl:with-param name="require">true</xsl:with-param>
				</xsl:apply-templates>
			</td>
			<td class="input-block">
				<xsl:apply-templates select="CONTROL[@NAME='code']" mode="control">
					<xsl:with-param name="onchange">sbApplyChangesObject.registerChange();</xsl:with-param>
					<xsl:with-param name="require">true</xsl:with-param>
					<xsl:with-param name="size">60</xsl:with-param>
				</xsl:apply-templates>
			</td>
			<td></td>
		</tr>
		<tr>
			<td class="title-block">
				<xsl:apply-templates select="CONTROL[@NAME='title']" mode="label">
					<xsl:with-param name="require">true</xsl:with-param>
				</xsl:apply-templates>
			</td>
			<td class="input-block">
				<xsl:apply-templates select="CONTROL[@NAME='title']" mode="control">
					<xsl:with-param name="onchange">sbApplyChangesObject.registerChange();</xsl:with-param>
					<xsl:with-param name="require">true</xsl:with-param>
					<xsl:with-param name="size">60</xsl:with-param>
				</xsl:apply-templates>
			</td>
			<td></td>
		</tr>
		<tr>
			<td class="title-block" colspan="3" style="width: 100%;">
				<xsl:call-template name="LABEL" mode="label">
					<xsl:with-param name="title" select="/SITEBUILDER-PAGE/LOCALE/FIELD-DESCRIPTION"/>
				</xsl:call-template>
				<br/>
				<xsl:apply-templates select="WYSIWYG[@NAME='description']"/>
			</td>
		</tr>
		<tr>
			<td class="title-block">
				<xsl:call-template name="LABEL" mode="label">
					<xsl:with-param name="title" select="LOGO-PREVIEW"/>
				</xsl:call-template>
			</td>
			<td class="input-block">
				<table cellpadding="0" cellspacing="0" border="0">
					<tr>
						<td valign="middle" align="center" style="width: 160px; height: 100px;" class="logotype-layer">
							<img style="border-width: 0px;">
								<xsl:attribute name="src">
									<xsl:choose>
										<xsl:when test="LOGO-PREVIEW/@IMAGE">
											<xsl:value-of select="LOGO-PREVIEW/@IMAGE"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="$skinPath"/>/images/<xsl:value-of select="LOGO-PREVIEW/@DEFAULT-IMAGE"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:attribute>
							</img>
						</td>
					</tr>
				</table>
			</td>
			<td></td>
		</tr>
		<tr>
			<td class="title-block">
				<xsl:call-template name="LABEL" mode="label">
					<xsl:with-param name="id">idUploadLogo</xsl:with-param>
					<xsl:with-param name="title" select="UPLOAD-LOGO"/>
				</xsl:call-template>
			</td>
			<td class="input-block">
				<xsl:call-template name="INPUT" mode="control">
					<xsl:with-param name="id">idUploadLogo</xsl:with-param>
					<xsl:with-param name="name" select="UPLOAD-LOGO/@NAME"/>
					<xsl:with-param name="size">60</xsl:with-param>
					<xsl:with-param name="type">file</xsl:with-param>
				</xsl:call-template>
			</td>
			<td>
				<xsl:apply-templates select="UPLOAD-LOGO/CONTROL[@NAME='uploadButton']">
					<xsl:with-param name="action">javascript:Sb.Views.Admin.SiteFamilies.submitForUpload();</xsl:with-param>
					<xsl:with-param name="style">width: 100px;</xsl:with-param>
				</xsl:apply-templates>
			</td>
		</tr>
	</table>
</xsl:template>

<xsl:template match="TAB-PANEL-CARD[@ID='generic']/CONTENT">
	<table cellpadding="0" cellspacing="0" border="0" class="control-title-input">
		<tr>
			<td class="title-block"><xsl:apply-templates select="CONTROL[@NAME='templateCategoryId' and @TYPE='COMBO-BOX']" mode="label"/></td>
			<td class="input-block">
				<xsl:apply-templates select="CONTROL[@NAME='templateCategoryId' and @TYPE='COMBO-BOX']" mode="control">
					<xsl:with-param name="onchange">sbApplyChangesObject.registerChange();</xsl:with-param>
				</xsl:apply-templates>
			</td>
		</tr>
		<tr>
			<td class="title-block"><xsl:apply-templates select="CONTROL[@NAME='pagesetId' and @TYPE='COMBO-BOX']" mode="label"/></td>
			<td class="input-block">
				<xsl:apply-templates select="CONTROL[@NAME='pagesetId' and @TYPE='COMBO-BOX']" mode="control">
					<xsl:with-param name="onchange">sbApplyChangesObject.registerChange();</xsl:with-param>
				</xsl:apply-templates>
			</td>
		</tr>
	</table>
</xsl:template>

</xsl:stylesheet>