<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template match="USERS-LIST">
	<style>
		.sb-pagetitle { border-bottom: solid 1px #776655; }
	</style>

		<xsl:apply-templates/>
<script language="javascript">
function unlockUsers() {
	if (countSelectedCheckBoxes() > 0) {
		document.forms.listForm.action.value = '/Admin/User/Unlock';
		document.forms.listForm.submit();
	}
	else {
		alert(SbGetLocaleByKey('SELECT-FOR-DELETE'));
	}
}
function lockUsers() {
	if (countSelectedCheckBoxes() > 0) {
		document.forms.listForm.action.value = '/Admin/User/Lock';
		document.forms.listForm.submit();
	}
	else {
		alert(SbGetLocaleByKey('SELECT-FOR-DELETE'));
	}
}
function deleteUsers() {
	if (countSelectedCheckBoxes() > 0) {
		if (confirm(SbGetLocaleByKey('SURE-TO-DELETE'))) {
			document.forms.listForm.action.value = '/Admin/User/Delete';
			document.forms.listForm.submit();
		}
	}
	else {
		alert(SbGetLocaleByKey('SELECT-FOR-DELETE'));
	}
}
</script>

</xsl:template>

<xsl:template match="PAGED-LIST/LIST/HEADER">
<!--
<xsl:variable name="headerStructure" select="document('d:/1.xml')"/>
<xsl:for-each select="$headerStructure/root/item">
	<xsl:call-template name="LIST-HEADER-ITEM">
		<xsl:with-param name="field"><xsl:value-of select="field"/></xsl:with-param>
		<xsl:with-param name="title"><xsl:value-of select="title"/></xsl:with-param>
		<xsl:with-param name="width"><xsl:value-of select="width"/></xsl:with-param>
		<xsl:with-param name="align"><xsl:value-of select="align"/></xsl:with-param>
		<xsl:with-param name="currentSortField"><xsl:value-of select="../../LIST/@ORDER-BY"/></xsl:with-param>
		<xsl:with-param name="currentSortType"><xsl:value-of select="../../LIST/@ORDER-TYPE"/></xsl:with-param>
	</xsl:call-template>
</xsl:for-each>
-->
<tr class="fixed">
	<th style="width:1%;">
		<div>
			<input type="checkbox" name="globalCheck" onclick="setCheckboxStatus(this.checked);" class="check"/>
		</div>
	</th>

	<xsl:call-template name="LIST-HEADER-ITEM">
		<xsl:with-param name="field">status</xsl:with-param>
		<xsl:with-param name="title"><xsl:value-of select="STATUS"/></xsl:with-param>
		<xsl:with-param name="width">1%</xsl:with-param>
		<xsl:with-param name="currentSortField"><xsl:value-of select="../../LIST/@ORDER-BY"/></xsl:with-param>
		<xsl:with-param name="currentSortType"><xsl:value-of select="../../LIST/@ORDER-TYPE"/></xsl:with-param>
	</xsl:call-template>

	<xsl:call-template name="LIST-HEADER-ITEM">
		<xsl:with-param name="field">userName</xsl:with-param>
		<xsl:with-param name="title"><xsl:value-of select="USER-NAME"/></xsl:with-param>
		<xsl:with-param name="width">15%</xsl:with-param>
		<xsl:with-param name="currentSortField"><xsl:value-of select="../../LIST/@ORDER-BY"/></xsl:with-param>
		<xsl:with-param name="currentSortType"><xsl:value-of select="../../LIST/@ORDER-TYPE"/></xsl:with-param>
	</xsl:call-template>

	<xsl:call-template name="LIST-HEADER-ITEM">
		<xsl:with-param name="field">role</xsl:with-param>
		<xsl:with-param name="title"><xsl:value-of select="ROLE"/></xsl:with-param>
		<xsl:with-param name="width">15%</xsl:with-param>
		<xsl:with-param name="currentSortField"><xsl:value-of select="../../LIST/@ORDER-BY"/></xsl:with-param>
		<xsl:with-param name="currentSortType"><xsl:value-of select="../../LIST/@ORDER-TYPE"/></xsl:with-param>
	</xsl:call-template>

	<xsl:call-template name="LIST-HEADER-ITEM">
		<xsl:with-param name="field">email</xsl:with-param>
		<xsl:with-param name="title"><xsl:value-of select="EMAIL"/></xsl:with-param>
		<xsl:with-param name="width">15%</xsl:with-param>
		<xsl:with-param name="currentSortField"><xsl:value-of select="../../LIST/@ORDER-BY"/></xsl:with-param>
		<xsl:with-param name="currentSortType"><xsl:value-of select="../../LIST/@ORDER-TYPE"/></xsl:with-param>
	</xsl:call-template>

	<xsl:call-template name="LIST-HEADER-ITEM">
		<xsl:with-param name="field">fullName</xsl:with-param>
		<xsl:with-param name="title"><xsl:value-of select="FULL-NAME"/></xsl:with-param>
		<xsl:with-param name="width">15%</xsl:with-param>
		<xsl:with-param name="currentSortField"><xsl:value-of select="../../LIST/@ORDER-BY"/></xsl:with-param>
		<xsl:with-param name="currentSortType"><xsl:value-of select="../../LIST/@ORDER-TYPE"/></xsl:with-param>
		<xsl:with-param name="align">left</xsl:with-param>
	</xsl:call-template>

	<xsl:call-template name="LIST-HEADER-ITEM">
		<xsl:with-param name="field">owner</xsl:with-param>
		<xsl:with-param name="title"><xsl:value-of select="OWNER"/></xsl:with-param>
		<xsl:with-param name="width">15%</xsl:with-param>
		<xsl:with-param name="currentSortField"><xsl:value-of select="../../LIST/@ORDER-BY"/></xsl:with-param>
		<xsl:with-param name="currentSortType"><xsl:value-of select="../../LIST/@ORDER-TYPE"/></xsl:with-param>
		<xsl:with-param name="align">right</xsl:with-param>
	</xsl:call-template>

	<xsl:call-template name="LIST-HEADER-ITEM">
		<xsl:with-param name="field">creationDate</xsl:with-param>
		<xsl:with-param name="title"><xsl:value-of select="CREATION-DATE"/></xsl:with-param>
		<xsl:with-param name="width">15%</xsl:with-param>
		<xsl:with-param name="currentSortField"><xsl:value-of select="../../LIST/@ORDER-BY"/></xsl:with-param>
		<xsl:with-param name="currentSortType"><xsl:value-of select="../../LIST/@ORDER-TYPE"/></xsl:with-param>
		<xsl:with-param name="align">right</xsl:with-param>
	</xsl:call-template>

	<xsl:if test="../../../@IMPERSONATION-ALLOWED = 1">
		<xsl:call-template name="LIST-HEADER-ITEM">
			<xsl:with-param name="title"><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/LIST-HEADER-IMPERSONATION"/></xsl:with-param>
			<xsl:with-param name="width">1%</xsl:with-param>
			<xsl:with-param name="align">center</xsl:with-param>
		</xsl:call-template>
	</xsl:if>
	
	<xsl:call-template name="LIST-HEADER-ITEM">
		<xsl:with-param name="title"><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/LIST-HEADER-SITES"/></xsl:with-param>
		<xsl:with-param name="width">1%</xsl:with-param>
		<xsl:with-param name="align">center</xsl:with-param>
	</xsl:call-template>
</tr>
</xsl:template>


<xsl:template match="PAGED-LIST/LIST/ITEM">
<xsl:variable name="class">
	<xsl:call-template name="LIST-ROW-CLASS">
        	<xsl:with-param name="position"><xsl:value-of select="position()"/></xsl:with-param>
	</xsl:call-template>
</xsl:variable>
<tr class="{$class}">
	<td style="width:1%; text-align: center;">
		<input type="checkbox" name="objectIds[]" class="check">
			<xsl:if test="IS-BUILT-IN = 1"><xsl:attribute name="disabled">true</xsl:attribute></xsl:if>
			<xsl:attribute name="value"><xsl:value-of select="USER-ID"/></xsl:attribute>
		</input>
	</td>
	
	<xsl:call-template name="LIST-ROW-ITEM">
		<xsl:with-param name="icon">
			<xsl:choose>
				<xsl:when test="STATUS = '0'">run.png</xsl:when>
				<xsl:otherwise>shutdown.png</xsl:otherwise>
			</xsl:choose>
		</xsl:with-param>
	</xsl:call-template>

	<xsl:call-template name="LIST-ROW-ITEM">
		<xsl:with-param name="title"><xsl:value-of select="USER-NAME"/></xsl:with-param>
		<xsl:with-param name="action"><xsl:value-of select="$baseUrl"/>/Admin/User/Edit?userId=<xsl:value-of select="USER-ID"/></xsl:with-param>
		<xsl:with-param name="contextHelp">userName</xsl:with-param>
	</xsl:call-template>

	<xsl:call-template name="LIST-ROW-ITEM">
		<xsl:with-param name="title">
			<xsl:variable name="name">USER_TYPE_<xsl:value-of select="ROLE"/></xsl:variable>
			<xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/*[name()=$name]/."/>
		</xsl:with-param>
	</xsl:call-template>

	<xsl:call-template name="LIST-ROW-ITEM">
		<xsl:with-param name="title"><xsl:value-of select="EMAIL"/></xsl:with-param>
		<xsl:with-param name="action">mailto:<xsl:value-of select="EMAIL"/></xsl:with-param>
	</xsl:call-template>

	<xsl:call-template name="LIST-ROW-ITEM">
		<xsl:with-param name="title"><xsl:value-of select="FIRST-NAME"/>&#160;<xsl:value-of select="LAST-NAME"/></xsl:with-param>
	</xsl:call-template>

	<xsl:call-template name="LIST-ROW-ITEM">
		<xsl:with-param name="title">
			<xsl:if test="PARENT-USER-NAME != ''">
				<xsl:value-of select="PARENT-USER-NAME"/> (<xsl:value-of select="PARENT-FIRST-NAME"/>&#160;<xsl:value-of select="PARENT-LAST-NAME"/>)
			</xsl:if>
		</xsl:with-param>
		<xsl:with-param name="align">right</xsl:with-param>
	</xsl:call-template>

	<xsl:call-template name="LIST-ROW-ITEM">
		<xsl:with-param name="title"><xsl:value-of select="CREATION-DATE"/></xsl:with-param>
		<xsl:with-param name="align">right</xsl:with-param>
	</xsl:call-template>

	<xsl:if test="../../../@IMPERSONATION-ALLOWED = 1">
		<td style="width:16px; text-align:center;">
			<xsl:if test="ROLE != 1">
				<a>
					<xsl:attribute name="onmouseout">SetContextHelp();</xsl:attribute>
					<xsl:attribute name="onmouseover">SetContextHelp('CONTEXT-HELP-BUTTON-IMPERSONATION');</xsl:attribute>
					<xsl:attribute name="href"><xsl:value-of select="$baseUrl"/>/Admin/Impersonation/ChangeUser?userId=<xsl:value-of select="USER-ID"/></xsl:attribute>
					<img style="border-width:0px;" src="{$skinPath}/icons/s_usermgmt.png"/>
				</a>
			</xsl:if>
		</td>
	</xsl:if>
	
	<td style="width:16px; text-align:center;">
		<a>
			<xsl:attribute name="onmouseout">SetContextHelp();</xsl:attribute>
			<xsl:attribute name="onmouseover">SetContextHelp('CONTEXT-HELP-BUTTON-USERS-SITES');</xsl:attribute>
			<xsl:attribute name="href"><xsl:value-of select="$baseUrl"/>/Admin/Site/List?ownedByUserId=<xsl:value-of select="USER-ID"/>&amp;filterValue=9</xsl:attribute>
			<img style="border-width:0px;" src="{$skinPath}/icons/s_sitemgmt.png"/>
		</a>
	</td>	
</tr>
</xsl:template>

</xsl:stylesheet>