<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:strip-space elements="*"/>
	<xsl:output method="html" indent="yes" encoding="utf-8"/>

	<xsl:template match="VIEW-CONTENT">
		<div class="sb-publish-panel">
			<xsl:apply-templates select="STATUS" mode="publish"/>
			<xsl:apply-templates select="SITE-STATUS" mode="publish"/>
			<xsl:apply-templates select="LAST-PUBLICATION" mode="publish"/>
			<xsl:apply-templates select="CURRENT-SETTINGS" mode="publish"/>
			<xsl:apply-templates select="SETTINGS-FORM"/>
			<xsl:apply-templates select="PUBLISH-CONTROLS"/>
			<xsl:apply-templates select="SETTINGS-FORM" mode="INIT-JS"/>
		</div>
		<div id="ajaxViewLoaded" style="display:none;"/>
	</xsl:template>

	<xsl:template match="SETTINGS-FORM" mode="INIT-JS">
		<script type="text/javascript" src="/js/publication_settings.js?{$version}.{$build}"></script>
		<script type="text/javascript" language="javascript">
			self.sbPublicationSettingsForm = new SbPublicationSettingsForm(self.sbPublishStepManager);
		</script>
	</xsl:template>

	<xsl:template match="SETTINGS-FORM">
		<div style="width:0px; height:8px;"><span></span></div>
		<table border="0" cellpadding="0" cellspacing="0" style="width: 100%; border-collapse:collapse;">
			<tr>
				<td valign="top">
					<input type="hidden" id="{@ID}_hidden">
						<xsl:attribute name="value">
							<xsl:choose>
								<xsl:when test="@IS-OPENED">true</xsl:when>
								<xsl:otherwise>false</xsl:otherwise>
							</xsl:choose>
						</xsl:attribute>
					</input>
					<script type="text/javascript" language="javascript" src="/js/panel_toggle.js?{$version}.{$build}"/>
					<table id="{@ID}" cellpadding="0" cellspacing="0" border="0" style="width:100%;">
						<tr>
							<td style="cursor:pointer;" onclick="SBPanelToggle('{@ID}','{$skinPath}/images/show.gif','{$skinPath}/images/hide.gif');">
								<table cellpadding="0" cellspacing="0" border="0" class="sb-publish-header-block">
									<tr>
										<td style="white-space: nowrap;">
											<span class="sb-publish-header-text"><xsl:value-of select="@TITLE"/></span>
										</td>
										<td valign="middle" style="width:100%;"><img id="{@ID}_image" align="right"><xsl:attribute name="src"><xsl:value-of select="$skinPath"/>/images/<xsl:choose>
											<xsl:when test="@IS-OPENED">hide</xsl:when>
											<xsl:otherwise>show</xsl:otherwise>
										</xsl:choose>.gif</xsl:attribute></img></td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
							<xsl:choose>
								<xsl:when test="@IS-OPENED"/>
								<xsl:otherwise>
									<xsl:attribute name="style">display: none;</xsl:attribute>
								</xsl:otherwise>
							</xsl:choose>
							<td valign="top">
								<xsl:apply-templates select="PUBLICATION-SETTINGS-FORM">
									<xsl:with-param name="inOneRow">yes</xsl:with-param>
									<xsl:with-param name="descriptionClass">sb-publish-pale</xsl:with-param>
								</xsl:apply-templates>
								<xsl:call-template name="REQUIRED-FIELDS"/>
							<xsl:choose>
								<xsl:when test="REVERT-PUBLICATION-SETTINGS-FORM">
									<xsl:apply-templates select="REVERT-PUBLICATION-SETTINGS-FORM" mode="publish"/>
								</xsl:when>
								<xsl:otherwise>
									<div class="sb-publish-separator"><span></span></div>
								</xsl:otherwise>								
							</xsl:choose>
								
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
		<script type="text/javascript" language="javascript">
			SBPanel<xsl:choose>
				<xsl:when test="@IS-OPENED">Show</xsl:when>
				<xsl:otherwise>Hide</xsl:otherwise>
			</xsl:choose>('<xsl:value-of select="@ID"/>','<xsl:value-of select="$skinPath"/>/images/show.gif','<xsl:value-of select="$skinPath"/>/images/hide.gif');
		</script>
	</xsl:template>

	<xsl:template match="CURRENT-SETTINGS" mode="publish">
		<div style="width:0px; height:8px;"><span></span></div>
		<xsl:call-template name="PUBLICATION-FORM-HEADER">
			<xsl:with-param name="title" select="@TITLE"/>
		</xsl:call-template>
		<table cellpadding="0" cellspacing="8" border="0">
			<tr>
				<td width="170"><xsl:value-of select="@URL-TITLE"/></td>
				<td>
					<xsl:choose>
						<xsl:when test="@URL-WRONG">
							<xsl:attribute name="class">sb-wrong-publish-settings</xsl:attribute>
							<xsl:value-of select="@URL"/>
						</xsl:when>
						<xsl:otherwise>
							<a target="_blank" href="{@URL}" class="sb-publish-link"><xsl:value-of select="@URL"/></a>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
			<xsl:if test="@SETTINGS-STRING">
				<tr>
					<td><xsl:value-of select="@SETTINGS-TITLE"/></td>
					<td>
						<xsl:choose>
							<xsl:when test="@SETTINGS-WRONG">
								<xsl:attribute name="class">sb-wrong-publish-settings</xsl:attribute>
								<xsl:value-of select="@SETTINGS-STRING"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="SETTINGS-STRING">
									<xsl:with-param name="mode" select="@SETTINGS-MODE"/>
									<xsl:with-param name="value" select="@SETTINGS-STRING"/>
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<xsl:template match="LAST-PUBLICATION" mode="publish">
		<div style="width:0px; height:8px;"><span></span></div>
		<xsl:call-template name="PUBLICATION-FORM-HEADER">
			<xsl:with-param name="title" select="@TITLE"/>
		</xsl:call-template>
		<table cellpadding="0" cellspacing="0" border="0" width="100%" class="sb-publish-info">
			<tr>
				<td width="30%"><xsl:value-of select="@TIME-TITLE"/></td>
				<td><xsl:value-of select="@TIME"/></td>
			</tr>
			<tr>
				<td><xsl:value-of select="@URL-TITLE"/></td>
				<td><a target="_blank" href="{@URL}" class="sb-publish-link"><xsl:value-of select="@URL"/></a></td>
			</tr>
			<xsl:if test="@SETTINGS-STRING">
				<tr>
					<td><xsl:value-of select="@SETTINGS-TITLE"/></td>
					<td>
						<xsl:call-template name="SETTINGS-STRING">
							<xsl:with-param name="mode" select="@SETTINGS-MODE"/>
							<xsl:with-param name="value" select="@SETTINGS-STRING"/>
						</xsl:call-template>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>

	<xsl:template name="PUBLICATION-FORM-HEADER">
		<xsl:param name="title"/>
		<table cellpadding="0" cellspacing="0" border="0" class="sb-publish-header-block">
			<tr>
				<td>
					<span class="sb-publish-header-text"><xsl:value-of select="$title"/></span>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="SETTINGS-STRING">
		<xsl:param name="mode"/>
		<xsl:param name="value"/>

		<xsl:choose>
			<xsl:when test="$mode='ftp'"><a target="_blank" href="{$value}" class="sb-publish-link"><xsl:value-of select="$value"/></a></xsl:when>
			<xsl:otherwise><xsl:value-of select="$value"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="SITE-STATUS" mode="publish">
        <table cellpadding="5" cellspacing="0" border="0" class="sb-publish-status-block">
          <tr>
            <td>
              <span class="sb-publish-status-text"><xsl:value-of select="@MESSAGE"/></span>&#160;
              <a target="_blank" href="{@PREVIEW-LINK}" class="sb-publish-link"><xsl:value-of select="@PREVIEW-TITLE"/></a>
            </td>
          </tr>
        </table>
	</xsl:template>

	<xsl:template match="PUBLISH-CONTROLS">
		<div style="width:0px; height:8px;"><span></span></div>
		<table cellpadding="0" cellspacing="0" border="0" width="100%">
			<tr>
				<xsl:apply-templates select="CONTROL[@NAME='fullRepublication']" mode="publish"/>
				<xsl:apply-templates select="CONTROL[@NAME='publishButton']" mode="publish"/>
				<xsl:apply-templates select="CONTROL[@NAME='visitSite']" mode="publish"/>
			</tr>
		</table>
	</xsl:template>

	<xsl:template match="CONTROL[@NAME='visitSite']" mode="publish">
		<td align="right">
			<a target="_blank" id="visitSiteLink" style="display: none;">
				<xsl:attribute name="href"><xsl:value-of select="@HREF"/></xsl:attribute>
				<xsl:value-of select="@TITLE"/>
			</a>
			<a target="_blank" style="text-decoration: none;">
				<xsl:attribute name="href"><xsl:value-of select="@HREF"/></xsl:attribute>
				<xsl:call-template name="LARGE-BUTTON-CONTROL">
					<xsl:with-param name="style">width: 105px;</xsl:with-param>
					<xsl:with-param name="title"><xsl:value-of select="@TITLE"/></xsl:with-param>
					<xsl:with-param name="icon">icons/btn_visit_site.gif</xsl:with-param>
					<xsl:with-param name="leftImage">images/visit_site_left.gif</xsl:with-param>
					<xsl:with-param name="middleImage">images/visit_site_bg.gif</xsl:with-param>
					<xsl:with-param name="rightImage">images/visit_site_right.gif</xsl:with-param>
					<xsl:with-param name="action">clickLinkIE('visitSiteLink');</xsl:with-param>
				</xsl:call-template>
			</a>
		</td>
	</xsl:template>

	<xsl:template match="CONTROL[@NAME='fullRepublication']" mode="publish">
		<td width="100%">
			<table cellpadding="0" cellspacing="0" border="0" class="control-input-title">
				<tr>
					<td class="input-block">
						<xsl:apply-templates select="." mode="control"/>
					</td>
					<td class="title-block">
						<xsl:apply-templates select="." mode="label"/>
					</td>
				</tr>
			</table>
		</td>
	</xsl:template>

	<xsl:template match="CONTROL[@NAME='publishButton']" mode="publish">
		<td align="center" style="padding: 0 14px;">
			<xsl:call-template name="LARGE-BUTTON-CONTROL">
				<xsl:with-param name="style">width: 105px;</xsl:with-param>
				<xsl:with-param name="title"><xsl:value-of select="@TITLE"/></xsl:with-param>
				<xsl:with-param name="icon">icons/btn_publish_now.gif</xsl:with-param>
				<xsl:with-param name="leftImage">images/publish_now_left.gif</xsl:with-param>
				<xsl:with-param name="middleImage">images/publish_now_bg.gif</xsl:with-param>
				<xsl:with-param name="rightImage">images/publish_now_right.gif</xsl:with-param>
				<xsl:with-param name="action">self.sbPublishStepManager.publish();</xsl:with-param>
			</xsl:call-template>
		</td>
	</xsl:template>

	<xsl:template match="REVERT-PUBLICATION-SETTINGS-FORM" mode="publish">
		<xsl:apply-templates select=".">
			<xsl:with-param name="blockClass">sb-publish-block-footer</xsl:with-param>
			<xsl:with-param name="disabledDescriptionClass">sb-text-pale</xsl:with-param>
		</xsl:apply-templates>
	</xsl:template>

 </xsl:stylesheet>
