<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:strip-space elements="*"/>
	<xsl:output method="html" indent="yes" encoding="utf-8"/>

	<xsl:template name="MODAL-FORM">
		<xsl:param name="formName"/>
		<xsl:param name="formTitle"/>
		<xsl:param name="closeHint"/>
		<xsl:param name="helpHint"/>
		<xsl:param name="additionalFormStyle"/>
		<xsl:param name="content"/>
		<xsl:param name="onCloseAction"/>
		<xsl:param name="showStatus" select="1"/>
		<xsl:param name="paddingOn" select="1"/>
		<xsl:param name="statusShowClickHere" select="1"/>

		<script type="text/javascript" language="javascript" src="/js/modal_form.js?{$version}.{$build}"/>
		<div id="{$formName}Background" style="background-color:black; filter:alpha(opacity=15); opacity: 0.15; z-index:101; position:absolute; overflow:hidden; display:none;"/>
		<div id="{$formName}" style="{$additionalFormStyle}">
			<table cellpadding="0" cellspacing="0" border="0" style="width:100%; height:100%;">
				<tr>
					<td style="height: 100%;">
						<table cellspacing="0" cellpadding="0" style="width:100%; height: 100%;">
							<tr>
								<td style="width:100%; vertical-align:top;">
									<table cellpadding="0" cellspacing="0" border="0" style="width:100%; height:100%;">
										<tr>
											<td style="cursor:pointer; user-select:none; -moz-user-select:none; width: 100%;">
												<table cellspacing="0" cellpadding="2" border="0" class="sb-modalbox-header" style="width:100%; border-collapse:collapse;">
													<tr>
														<td id="{$formName}Header" class="sb-modalbox-header-left"><span id="{$formName}Title" class="sb-modalbox-header-text"><xsl:value-of select="$formTitle"/></span></td>
														<td class="sb-modalbox-header-right" onclick="{$onCloseAction}"><img width="45" height="19" src="{$skinPath}/icons/close-vista.png" alt="{$closeHint}" /></td>
													</tr>
												</table>
											</td>
										</tr>
										<tr>
											<td style="vertical-align:top; background: #fff; border: 1px solid #000; border-width: 0 1px;">
												<xsl:if test="$showStatus!=0">
													<xsl:apply-templates select="/SITEBUILDER-PAGE/ACTION-STATUS" mode="modalForm">
														<xsl:with-param name="showClickHere"><xsl:value-of select="$statusShowClickHere"/></xsl:with-param>
													</xsl:apply-templates>
												</xsl:if>
											</td>
										</tr>
										<tr>
											<td>
												<xsl:attribute name="style">width:100%; height:100%; background: #fff; border: 1px solid #000; border-top: 0;<xsl:if test="not(TAB-PANEL) and $paddingOn!=0">padding: 10px;</xsl:if></xsl:attribute>
												<table  cellpadding="0" cellspacing="0" border="0" style="width:100%; height:100%;">
													<tr>
														<td valign="top">
															<xsl:apply-templates select="$content" mode="content" />
														</td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
								<!--td style="width: 10px; padding-top:10px; height:100%;">
									<div style="width:10px; height:100%; filter:alpha(opacity=25); background-color:black; opacity:0.25; display: table;"><span></span></div>
								</td-->
							</tr>
						</table>
					</td>
				</tr>
				<!--tr>
					<td style="padding-left:10px; height: 10px;">
						<div style="width:100%; height:10px; filter:alpha(opacity=25); background-color:black; opacity:0.25;">
							<span></span>
						</div>
					</td>
				</tr-->
			</table>
		</div>
		<script type="text/javascript" language="javascript">
			SbInitModalForm('<xsl:value-of select="$formName"/>');
		</script>
	</xsl:template>
	<xsl:template match="ACTION-STATUS[@STATUS!=0][MESSAGE or DETAILS/MESSAGE-DETAILED]" mode="modalForm">
		<table class="sb-modalbox-help" style="padding-top: 5px; padding-bottom: 5px; width: 100%; padding-left: 10px;">
			<tr>
				<td valign="top" style="padding-right: 10px;">
					<xsl:apply-templates select="current()" mode="icon"/>
				</td>
				<td width="100%" onclick="sb_status.showDetails();" id="StatusBar">
					<div id="StatusMessage">
						<xsl:choose>
							<xsl:when test="/SITEBUILDER-PAGE/ACTION-STATUS/MESSAGE">
								<xsl:if test="/SITEBUILDER-PAGE/ACTION-STATUS/DETAILS/MESSAGE-DETAILED"><xsl:attribute name="style">cursor: pointer;</xsl:attribute></xsl:if>
								<xsl:value-of select="/SITEBUILDER-PAGE/ACTION-STATUS/MESSAGE"/>
								<xsl:if test="/SITEBUILDER-PAGE/ACTION-STATUS/DETAILS/MESSAGE-DETAILED">
									<xsl:text> </xsl:text>
									<xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/DETAILED-CLICK-HERE"/>
								</xsl:if>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="SHORT-HELP/@TITLE"/>
							</xsl:otherwise>
						</xsl:choose>
					</div>				
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template match="ACTION-STATUS[@STATUS=0]" mode="modalForm">
	</xsl:template>


	<xsl:template match="MESSAGE" mode="modalForm">
		<xsl:value-of select="."/>
	</xsl:template>

	<xsl:template match="DETAILS/MESSAGE-DETAILED" mode="modalForm">
		<br/><xsl:value-of select="."/>
	</xsl:template>

</xsl:stylesheet>