<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template match="PAGED-LIST">
	<div id="pagedListContainer" style="margin: 0 -20px 0 -20px; zoom: 1;">
		<script type="text/javascript" src="/js/list.js?{$version}.{$build}"/>
		<script type="text/javascript" src="/js/single_list.js?{$version}.{$build}"/>
		<script type="text/javascript" language="javascript">
			pagedList = new PagedList('<xsl:value-of select="PAGER/URL"/>', <xsl:value-of select="@USE-AJAX"/>);
		</script>

			<xsl:apply-templates select="TOOLBAR"/>
			<xsl:choose>
				<xsl:when test="PAGER/TOTAL-RECORDS &gt; 0">
					<xsl:apply-templates select="PAGER"/>
					<form name="listForm" method="post" action="{$baseUrl}">
						<input type="hidden" name="action" value=""/>
						<xsl:apply-templates select="LIST"/>
					</form>
					<xsl:apply-templates select="PAGER"/>
				</xsl:when>
				<xsl:otherwise>
					<div style="padding: 10px;"><xsl:value-of select="MSG-NO-RECORDS"/></div>
				</xsl:otherwise>
			</xsl:choose>
		</div>
</xsl:template>

<xsl:template match="PAGED-LIST/LIST">
<div class="scroll-table">
	<table cellspacing="0" cellpadding="0" border="0" class="list-table">
		<xsl:apply-templates select="HEADER" />
		<xsl:apply-templates select="ITEM" />
	</table>
</div>
<script type="text/javascript" language="javascript">
	observeCheckboxesClick('objectIds[]', 'globalCheck');
	observeListRowsHighlight();
</script>
</xsl:template>

<xsl:template name="LIST-HEADER-ITEM">
<xsl:param name="align"/>
<xsl:param name="field"/>
<xsl:param name="title"/>
<xsl:param name="width"/>
<xsl:param name="currentSortField"/>
<xsl:param name="currentSortType"/>

<xsl:variable name="orderType">
<xsl:choose>
	<xsl:when test="$field = $currentSortField">
		<xsl:choose>
			<xsl:when test="$currentSortType = 'ASC'">DESC</xsl:when>
			<xsl:otherwise>ASC</xsl:otherwise>
		</xsl:choose>
	</xsl:when>
	<xsl:otherwise>ASC</xsl:otherwise>
</xsl:choose>
</xsl:variable>

<th scope="col" style="width:{$width}; text-align:{$align};" >
	<xsl:if test="$field != ''">
		<xsl:if test="$field = $currentSortField">
			<xsl:attribute name="class">list-table-active-area</xsl:attribute>
		</xsl:if>

		<xsl:if test="../../LIST[@CONTEXT-HELP-SUPPORT = '1']">
			<xsl:attribute name="onmouseout">SetContextHelp();</xsl:attribute>
			<xsl:attribute name="onmouseover">SetContextHelp('CONTEXT-HELP-LIST-HEADER-<xsl:value-of select="$field"/>');</xsl:attribute>
		</xsl:if>
	</xsl:if>
	<div>
		<xsl:choose>
			<xsl:when test="$field and $field != ''">
				<a href="#" onclick="javascript:pagedList.doSort('{$field}','{$orderType}');">
					<xsl:if test="$field != $currentSortField">
						<xsl:attribute name="style"></xsl:attribute>
					</xsl:if>
					<xsl:value-of select="$title"/>
				</a>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$title"/>
			</xsl:otherwise>
		</xsl:choose>

		<xsl:if test="$field = $currentSortField and $field != ''">
			<xsl:choose>
				<xsl:when test="$currentSortType = 'ASC'">
					<img style="display: inline; vertical-align: middle; border-width:0px;">
						<xsl:attribute name="src"><xsl:value-of select="/SITEBUILDER-PAGE/PROPERTIES/SKIN-PATH/."/>/images/dlg_sort_up.gif</xsl:attribute>
					</img>
				</xsl:when>
				<xsl:otherwise>
					<img style="display: inline; vertical-align: middle; border-width:0px;">
						<xsl:attribute name="src"><xsl:value-of select="/SITEBUILDER-PAGE/PROPERTIES/SKIN-PATH/."/>/images/dlg_sort_down.gif</xsl:attribute>
					</img>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<img style="display: inline; vertical-align: middle; border-width:0px; width: 1px; height:16px;">
			<xsl:attribute name="src"><xsl:value-of select="/SITEBUILDER-PAGE/PROPERTIES/SKIN-PATH/."/>/images/empty.gif</xsl:attribute>
		</img>
	</div>
</th>
</xsl:template>

<xsl:template name="LIST-ROW-CLASS">
<xsl:param name="position"/>
<xsl:choose>
	<xsl:when test="$position mod 2">list-table-row</xsl:when>
	<xsl:otherwise>list-table-row-alter</xsl:otherwise>
</xsl:choose>
</xsl:template>

<xsl:template name="LIST-ROW-ITEM">
<xsl:param name="align"/>
<xsl:param name="title"/>
<xsl:param name="action"/>
<xsl:param name="icon"/>
<xsl:param name="contextHelp"/>
<td style="text-align:{$align};">
	<xsl:choose>
		<xsl:when test="$action != ''">
			<a>
				<xsl:choose>
					<xsl:when test="substring-before($action,':')='javascript'">
						<xsl:attribute name="onclick"><xsl:value-of select="$action"/></xsl:attribute>
						<xsl:attribute name="href">#</xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="href"><xsl:value-of select="$action"/></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>

				<xsl:if test="$contextHelp">
					<xsl:attribute name="onmouseout">SetContextHelp();</xsl:attribute>
					<xsl:attribute name="onmouseover">SetContextHelp('CONTEXT-HELP-LIST-ROW-<xsl:value-of select="$contextHelp"/>');</xsl:attribute>
				</xsl:if>
				<xsl:if test="$icon">
				<img style="border-width:0px;">
					<xsl:attribute name="src"><xsl:value-of select="/SITEBUILDER-PAGE/PROPERTIES/SKIN-PATH/."/>/icons/<xsl:value-of select="$icon"/></xsl:attribute>
				</img>
				</xsl:if>
				<xsl:value-of select="$title"/>
			</a>
		</xsl:when>
		<xsl:otherwise>
			<xsl:if test="$icon">
				<img border="0">
					<xsl:if test="$contextHelp">
						<xsl:attribute name="onmouseout">SetContextHelp();</xsl:attribute>
						<xsl:attribute name="onmouseover">SetContextHelp('CONTEXT-HELP-LIST-ROW-<xsl:value-of select="$contextHelp"/>');</xsl:attribute>
					</xsl:if>
					<xsl:attribute name="src"><xsl:value-of select="/SITEBUILDER-PAGE/PROPERTIES/SKIN-PATH/."/>/icons/<xsl:value-of select="$icon"/></xsl:attribute>
				</img>
			</xsl:if>

			<xsl:call-template name="nl2br">
				<xsl:with-param name="string" select="$title"/>
			</xsl:call-template>
		</xsl:otherwise>
	</xsl:choose>
</td>
</xsl:template>


<xsl:template match="PAGED-LIST/TOOLBAR">
	<xsl:choose>
		<xsl:when test="@FORM-TAG='no'">
			<xsl:call-template name="TOOLBAR-FORM-CONTENT" />
		</xsl:when>
		<xsl:otherwise>
			<form name="toolBarForm" method="get" action="{@ACTION}" style="padding:0px; margin:0px" onsubmit="pagedList.searchItems(); return false;">
				<xsl:call-template name="TOOLBAR-FORM-CONTENT" />
			</form>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="TOOLBAR-FORM-CONTENT">
	<input type="hidden" name="pageNum" value="1"/>
		<div class="clear"/>
		<xsl:if test="LIST-VIEW-STATES or SEARCH-PANEL">
			<div style="height: 50px; background-color:#CED8E1; border-top: 1px solid #B6BCCC;">
				<table cellpadding="0" cellspacing="0" border="0" style="height:50px; width:100%;">
					<tr>
						<td style="padding-left: 7px;"><xsl:apply-templates select="LIST-VIEW-STATES"/></td>
						<td><xsl:apply-templates select="SEARCH-PANEL"/></td>
						<td style="width: 100%;"></td>
					</tr>
				</table>
			</div>
		</xsl:if>
		<xsl:if test="count(OPERATIONS/OPERATION) &gt; 0 and (count(../LIST/ITEM) &gt; 0 or ../TOOLBAR[@ALWAYS-SHOW-OPERATIONS])">
			<div style="height: 30px;  padding-top: 3px; background-image: url('{$skinPath}/images/list-tool-block-bg.gif'); border-top: 1px solid #B6BCCC; border-bottom: 1px solid #B6BCCC; margin-bottom: 18px;">
			<xsl:apply-templates select="OPERATIONS"/>
			</div>
		</xsl:if>
</xsl:template>

<xsl:template match="PAGED-LIST/TOOLBAR/OPERATIONS">
	<xsl:for-each select="OPERATION">
		<div class="list-tool-block">
			<table cellspacing="0" cellpadding="0" border="0" class="link-button-container">			
				<xsl:choose>
					<xsl:when test="@DISABLED = '1'">
							<xsl:attribute name="style">cursor: default; filter: gray alpha(opacity=40); -moz-opacity: 0.4; opacity: 0.4;</xsl:attribute>
							
							<tr>
								<td class="link-button-image-area">
									<img border="0" alt="">
										<xsl:attribute name="src"><xsl:value-of select="$skinPath"/>/icons/<xsl:value-of select="@ICON"/></xsl:attribute>
									</img>
								</td>
								<td class="link-button-text-area"><xsl:value-of select="@TITLE"/></td>
							</tr>
					</xsl:when>
					<xsl:otherwise>
							<tr>
								<td class="link-button-image-area">
									<a href="#">
										<xsl:attribute name="onclick"><xsl:value-of select="@ACTION"/></xsl:attribute>
										<img border="0" alt="">
											<xsl:attribute name="src"><xsl:value-of select="$skinPath"/>/icons/<xsl:value-of select="@ICON"/></xsl:attribute>
										</img>
									</a>
								</td>
								<td class="link-button-text-area">
									<a href="#">
										<xsl:attribute name="onclick"><xsl:value-of select="@ACTION"/></xsl:attribute>
										<xsl:value-of select="@TITLE"/>
									</a>
								</td>
							</tr>
					</xsl:otherwise>
				</xsl:choose>
			</table>
		</div>
	</xsl:for-each>
</xsl:template>

<xsl:template match="PAGED-LIST/TOOLBAR/LIST-VIEW-STATES">
	<table cellpadding="0" cellspacing="0" border="0" class="list-show-container">
		<tr>
			<td class="list-show-view-text-area">
				<xsl:call-template name="LABEL" mode="label">
					<xsl:with-param name="title" select="@TITLE"/>
				</xsl:call-template>
			</td>
		</tr>
		<tr>
			<td class="list-show-view-list-area" style="vertical-align: top;">
				<select name="filterValue" id="filterValue" onchange="pagedList.searchItems();">
					<xsl:if test="@DISABLED = 1"><xsl:attribute name="disabled">true</xsl:attribute></xsl:if>
					<xsl:for-each select="STATE">
						<option>
							<xsl:if test="../@SELECTED = ."><xsl:attribute name="selected">true</xsl:attribute></xsl:if>
							<xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
							<xsl:value-of select="@TITLE"/>
						</option>
					</xsl:for-each>
				</select>
			</td>
		</tr>
	</table>
</xsl:template>

<xsl:template match="PAGED-LIST/TOOLBAR/SEARCH-PANEL">
	<table cellpadding="0" cellspacing="0" border="0" class="list-show-container">
		<xsl:if test="../LIST-VIEW-STATES/@TITLE">
			<tr><td colspan="3">&#160;</td></tr>
		</xsl:if>
		<tr>
			<td class="list-show-search-input-area">
				<xsl:if test="../LIST-VIEW-STATES/@TITLE">
					<xsl:attribute name="style">vertical-align: top;</xsl:attribute>
				</xsl:if>
				<xsl:call-template name="INPUT" mode="control">
					<xsl:with-param name="id">searchString</xsl:with-param>
					<xsl:with-param name="name">searchString</xsl:with-param>
					<xsl:with-param name="value"><xsl:value-of select="."/></xsl:with-param>
				</xsl:call-template>
			</td>
			<td class="list-show-search-tool-area">
				<xsl:if test="../LIST-VIEW-STATES/@TITLE">
					<xsl:attribute name="style">vertical-align: top;</xsl:attribute>
				</xsl:if>
				<table cellpadding="0" cellspacing="0" border="0" onclick="pagedList.searchItems();" type="button" style="cursor:pointer;" class="link-button-container">
					<tr>
						<td class="link-button-image-area">
							<img src="{$skinPath}/icons/search.png" alt=""/>
						</td>
						<td class="link-button-text-area"><span style="text-decoration: underline;"><xsl:value-of select="@SEARCH-TITLE"/></span></td>
					</tr>
				</table>
			</td>
			<td class="list-show-showall-tool-area">
				<xsl:if test="../LIST-VIEW-STATES/@TITLE">
					<xsl:attribute name="style">vertical-align: top;</xsl:attribute>
				</xsl:if>
				<table cellpadding="0" cellspacing="0" border="0" onclick="pagedList.searchShowAll();" type="button" name="ImageButtonShowAll" style="cursor:pointer;" class="link-button-container">
					<tr>
						<td class="link-button-image-area">
							<img src="{$skinPath}/icons/showall.png" alt=""/>
						</td>
							<td class="link-button-text-area"><span style="text-decoration: underline;"><xsl:value-of select="@SHOW-ALL-TITLE"/></span></td>
					</tr>
				</table>
			</td>
		</tr>
	</table>
</xsl:template>

</xsl:stylesheet>
