<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	
	<xsl:template match="TOOLBAR" name="TOOLBAR"> 
		<fieldset>
			<legend><xsl:value-of select="@TITLE"/></legend>
			<div class="fieldset-block">
				<xsl:if test="TOOLBAR-ITEM">
					<table cellspacing="0" border="0" style="border-collapse:collapse;">
					<tr>
						<xsl:apply-templates select="TOOLBAR-ITEM"/>
					</tr>
					</table>
				</xsl:if>
				<xsl:if test="TOOLBAR-FIELD">
					<table cellspacing="0" border="0" style="border-collapse:collapse;width:100%;">
						<xsl:for-each select="TOOLBAR-FIELD">
							<tr>
								<td valign="top">
									<xsl:apply-templates select="."/>
								</td>
							</tr>
						</xsl:for-each>
					</table>
				</xsl:if>
			</div>
		</fieldset>
	</xsl:template>
	
	<xsl:template match="TOOLBAR/TOOLBAR-ITEM/@ACTION">
		<xsl:choose>
			<xsl:when test="substring-before(.,':')='javascript'">
				<xsl:attribute name="onclick"><xsl:value-of select="."/></xsl:attribute>
				<xsl:attribute name="href">#</xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="href"><xsl:value-of select="."/></xsl:attribute>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="TOOLBAR/TOOLBAR-ITEM">
		<xsl:param name="disabled" select="@DISABLED"/>
		<xsl:choose>
			<xsl:when test="$disabled = 1">
				<td valign="top">
					<table cellpadding="0" cellspacing="0" border="0">
						<xsl:if test="@CONTEXT-HELP">
							<xsl:attribute name="onmouseout">SetContextHelp();</xsl:attribute>
							<xsl:attribute name="onmouseover">SetContextHelp('<xsl:value-of select="@CONTEXT-HELP"/>');</xsl:attribute>
						</xsl:if>
						<xsl:attribute name="style">width: 120px; filter: gray alpha(opacity=40); -moz-opacity: 0.4; opacity: 0.4;</xsl:attribute>
						<tr>
							<td align="center" valign="top" width="32">
								<img border="0" alt="">
									<xsl:choose>
										<xsl:when test="@ICON">
											<xsl:attribute name="src"><xsl:value-of select="$skinPath"/>/icons/<xsl:value-of select="@ICON"/></xsl:attribute>
										</xsl:when>
										<xsl:otherwise>
											<xsl:attribute name="src"><xsl:value-of select="$skinPath"/>/images/<xsl:value-of select="@IMAGE"/></xsl:attribute>
										</xsl:otherwise>
									</xsl:choose>
									
								</img>
							</td>
							<td align="left" class="sb-button-tool-text">
								<xsl:value-of select="@TITLE"/>
							</td>
						</tr>
					</table>
				</td>				
			</xsl:when>
			<xsl:otherwise>
				<td valign="top">
					<table cellpadding="0" cellspacing="0" border="0" class="sb-button-tool-table">
						<xsl:attribute name="onclick">
							<xsl:choose>
								<xsl:when test="substring-before(./@ACTION,':')='javascript'"><xsl:value-of select="./@ACTION"/></xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="@TARGET">javascript:try{window.open('<xsl:value-of select="./@ACTION"/>','<xsl:value-of select="@TARGET"/>');}catch(e){}; void(0);</xsl:when>
										<xsl:otherwise>
											window.location='<xsl:value-of select="./@ACTION"/>';
										</xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:attribute>
						
						<xsl:if test="@CONTEXT-HELP">
							<xsl:attribute name="onmouseout">SetContextHelp();</xsl:attribute>
							<xsl:attribute name="onmouseover">SetContextHelp('<xsl:value-of select="@CONTEXT-HELP"/>');</xsl:attribute>
						</xsl:if>
						<xsl:attribute name="style">cursor: pointer; width: 147px;</xsl:attribute>
						<tr>
							<td align="center" valign="top" width="32">
								<img border="0" alt="">
									<xsl:choose>
										<xsl:when test="@ICON">
											<xsl:attribute name="src"><xsl:value-of select="$skinPath"/>/icons/<xsl:value-of select="@ICON"/></xsl:attribute>
										</xsl:when>
										<xsl:otherwise>
											<xsl:attribute name="src"><xsl:value-of select="$skinPath"/>/images/<xsl:value-of select="@IMAGE"/></xsl:attribute>
										</xsl:otherwise>
									</xsl:choose>
								</img>
							</td>
							<td align="left" class="sb-button-tool-text">
								<xsl:value-of select="@TITLE"/>
							</td>
						</tr>
					</table>
				</td>	
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
</xsl:stylesheet>	