<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:strip-space elements="*"/>
	<xsl:output method="html" indent="yes" encoding="utf-8"/>

	<xsl:template name="PAGES-TREE-PANEL">
		<xsl:param name="isSwitchable"/>
		<xsl:param name="onToggle"/>
		<xsl:param name="onSelect"/>
		<xsl:param name="onAfterSelect"/>
		<xsl:param name="onChange"/>
		<xsl:param name="onCheck"/>
		<xsl:param name="treeId"><xsl:value-of select="PAGES-TREE/@NAME"/></xsl:param>
		<xsl:param name="panelId"><xsl:value-of select="$treeId"/>Panel</xsl:param>
		<input type="hidden" value="true" id="{$panelId}_hidden"/>
		<script type="text/javascript" language="javascript" src="/js/panel_toggle.js?{$version}.{$build}"/>
		<div style="height:100%;">
			<table id="{$panelId}" cellpadding="0" cellspacing="0" border="0" class="sb-page-sets-menu">
				<tr>
					<td class="sb-pages-panel-pages-leftcorner">
						<input id="{$treeId}SelectAll" type="checkbox" onclick="SbPanelTreeChecksToggle('{$treeId}SelectAll', '{$treeId}', false);"/>
					</td>
					<td class="sb-pages-panel-pages-header" style="cursor:pointer; user-select:none; -moz-user-select:none;">
						<table cellpadding="0" cellspacing="0" border="0" style="width:100%; height:100%;">
							<tr>
								<td align="left" style="white-space:nowrap; font-weight:bold;" onclick="SbPanelTreeChecksToggle('{$treeId}SelectAll', '{$treeId}', true);"><xsl:value-of select="@SELECT-ALL"/></td>
								<xsl:if test="$isSwitchable='true'">
									<td align="Right" valign="Middle" class="sb-pages-panel-pagesets-header" onclick="SBPanelToggle('{$panelId}','{$skinPath}/images/show.gif','{$skinPath}/images/hide.gif');{$onToggle}"><img id="{$panelId}_image" src="{$skinPath}/images/hide.gif"/></td>
								</xsl:if>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td valign="top" colspan="2" style="border-color:White; border-width:1px; border-style:solid;">
						<table cellpadding="0" cellspacing="0" border="0" style="width:100%; height:100%; table-layout: fixed;">
							<tr style="height: 100%;" valign="top">
								<td valign="top">
									<xsl:apply-templates select="PAGES-TREE">
										<xsl:with-param name="isSwitchable" select="$isSwitchable"/>
										<xsl:with-param name="onSelect" select="$onSelect"/>
										<xsl:with-param name="onAfterSelect" select="$onAfterSelect"/>
										<xsl:with-param name="onChange" select="$onChange"/>
										<xsl:with-param name="onCheck" select="$onCheck"/>
									</xsl:apply-templates>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</div>
	</xsl:template>

</xsl:stylesheet>
