<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:strip-space elements="*"/>
	<xsl:output method="html" indent="yes" encoding="utf-8"/>

	<xsl:template match="LAST-PUBLICATION">
<!--
:TODO: abelyaev 20070405: implement here
-->
	</xsl:template>

	<xsl:template match="PUBLICATION-SETTINGS-FORM">
		<xsl:param name="inOneRow"/>
		<xsl:variable name="hostName" select="CONTROL[@NAME='hostName']"/>
		<xsl:variable name="changeFtpPassword" select="CONTROL[@NAME='changeFtpPassword']"/>
		<xsl:variable name="changeMysqlPassword" select="CONTROL[@NAME='changeMysqlPassword']"/>

		<!-- input image needed for work default submit via Enter -->
		<input type="image" style="border-width: 0px; height: 0px; width: 0px;"/>

		<table cellpadding="0" cellspacing="0" border="0" class="control-title-input">
			<xsl:call-template name="PUBLICATION-SETTINGS-FORM-ROW">
				<xsl:with-param name="name">publicationMode</xsl:with-param>
				<xsl:with-param name="inOneRow" select="$inOneRow"/>
				<xsl:with-param name="onchange">self.sbApplyChangesObject.registerChange(); sbPublicationSettingsForm.onPublicationModeChange(); sbPublicationSettingsForm.onChange();</xsl:with-param>
			</xsl:call-template>
			<xsl:choose>
				<xsl:when test="$hostName/@TYPE='COMBO-BOX'">
					<xsl:call-template name="PUBLICATION-SETTINGS-FORM-ROW">
						<xsl:with-param name="name">hostName</xsl:with-param>
						<xsl:with-param name="inOneRow" select="$inOneRow"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$hostName/@TYPE='INPUT'">
					<xsl:call-template name="PUBLICATION-SETTINGS-FORM-ROW">
						<xsl:with-param name="name">hostName</xsl:with-param>
						<xsl:with-param name="size">30</xsl:with-param>
						<xsl:with-param name="inOneRow" select="$inOneRow"/>
					</xsl:call-template>
				</xsl:when>
			</xsl:choose>
			<xsl:call-template name="PUBLICATION-SETTINGS-FORM-ROW">
				<xsl:with-param name="name">ftpPort</xsl:with-param>
				<xsl:with-param name="size">10</xsl:with-param>
				<xsl:with-param name="maxlength">5</xsl:with-param>
				<xsl:with-param name="inOneRow" select="$inOneRow"/>
			</xsl:call-template>
			<xsl:call-template name="PUBLICATION-SETTINGS-FORM-ROW">
				<xsl:with-param name="name">ftpUser</xsl:with-param>
				<xsl:with-param name="inOneRow" select="$inOneRow"/>
			</xsl:call-template>
			<xsl:call-template name="PUBLICATION-SETTINGS-FORM-ROW">
				<xsl:with-param name="name">ftpPassword</xsl:with-param>
				<xsl:with-param name="inOneRow" select="$inOneRow"/>
			</xsl:call-template>
			<xsl:if test="CONTROL[@NAME='changeFtpPassword']">
				<tr id="changeFtpPasswordRow" style="display: none;">
					<td class="title-block">
						<xsl:apply-templates select="CONTROL[@NAME='changeFtpPassword']" mode="label"/>
					</td>
					<td class="input-block">
						<input type="hidden" name="isFtpPasswordChanged" id="isFtpPasswordChanged">
							<xsl:attribute name="value">
								<xsl:choose>
									<xsl:when test="CONTROL[@NAME='ftpPassword']/@EMPTY">true</xsl:when>
									<xsl:otherwise>false</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
						</input>
						<xsl:call-template name="BUTTON-CONTROL">
							<xsl:with-param name="title"><xsl:value-of select="$changeFtpPassword/@CAPTION"/></xsl:with-param>
							<xsl:with-param name="action">sbPublicationSettingsForm.onChangeFtpPassword();</xsl:with-param>
						</xsl:call-template>
						<xsl:if test="$changeFtpPassword/@DESCRIPTION and $inOneRow = ''">
							<div class="sb-publish-pale"><xsl:value-of select="$changeFtpPassword/@DESCRIPTION"/></div>
						</xsl:if>
					</td>
					<xsl:if test="$inOneRow">
						<td class="description-block">
							<xsl:if test="$changeFtpPassword/@DESCRIPTION">
								<div class="sb-publish-pale"><xsl:value-of select="$changeFtpPassword/@DESCRIPTION"/></div>
							</xsl:if>
						</td>
					</xsl:if>
				</tr>
			</xsl:if>
			<xsl:call-template name="PUBLICATION-SETTINGS-FORM-ROW">
				<xsl:with-param name="name">vpsId</xsl:with-param>
				<xsl:with-param name="inOneRow" select="$inOneRow"/>
			</xsl:call-template>
			<xsl:call-template name="PUBLICATION-SETTINGS-FORM-ROW">
				<xsl:with-param name="name">vpsUser</xsl:with-param>
				<xsl:with-param name="inOneRow" select="$inOneRow"/>
			</xsl:call-template>
			<xsl:call-template name="PUBLICATION-SETTINGS-FORM-ROW">
				<xsl:with-param name="name">vpsGroup</xsl:with-param>
				<xsl:with-param name="inOneRow" select="$inOneRow"/>
			</xsl:call-template>
			<xsl:call-template name="PUBLICATION-SETTINGS-FORM-ROW">
				<xsl:with-param name="name">workDir</xsl:with-param>
				<xsl:with-param name="size">30</xsl:with-param>
				<xsl:with-param name="inOneRow" select="$inOneRow"/>
			</xsl:call-template>
			<xsl:call-template name="PUBLICATION-SETTINGS-FORM-ROW">
				<xsl:with-param name="name">siteUrl</xsl:with-param>
				<xsl:with-param name="size">30</xsl:with-param>
				<xsl:with-param name="inOneRow" select="$inOneRow"/>
			</xsl:call-template>
			<xsl:call-template name="PUBLICATION-SETTINGS-FORM-ROW">
				<xsl:with-param name="name">databaseType</xsl:with-param>
				<xsl:with-param name="rowstyle">display: none;</xsl:with-param>
				<xsl:with-param name="inOneRow" select="$inOneRow"/>
				<xsl:with-param name="onchange">self.sbApplyChangesObject.registerChange(); sbPublicationSettingsForm.onDatabaseTypeChange(); sbPublicationSettingsForm.onChange();</xsl:with-param>
			</xsl:call-template>
			<xsl:call-template name="PUBLICATION-SETTINGS-FORM-ROW">
				<xsl:with-param name="name">mysqlHost</xsl:with-param>
				<xsl:with-param name="size">60</xsl:with-param>
				<xsl:with-param name="inOneRow" select="$inOneRow"/>
			</xsl:call-template>
			<xsl:call-template name="PUBLICATION-SETTINGS-FORM-ROW">
				<xsl:with-param name="name">mysqlPort</xsl:with-param>
				<xsl:with-param name="size">10</xsl:with-param>
				<xsl:with-param name="maxlength">5</xsl:with-param>
				<xsl:with-param name="inOneRow" select="$inOneRow"/>
			</xsl:call-template>
			<xsl:call-template name="PUBLICATION-SETTINGS-FORM-ROW">
				<xsl:with-param name="name">mysqlUser</xsl:with-param>
				<xsl:with-param name="inOneRow" select="$inOneRow"/>
			</xsl:call-template>
			<xsl:call-template name="PUBLICATION-SETTINGS-FORM-ROW">
				<xsl:with-param name="name">mysqlPassword</xsl:with-param>
				<xsl:with-param name="inOneRow" select="$inOneRow"/>
			</xsl:call-template>
			<xsl:if test="CONTROL[@NAME='changeMysqlPassword']">
				<tr id="changeMysqlPasswordRow" style="display: none;">
					<td class="title-block">
						<xsl:apply-templates select="CONTROL[@NAME='changeMysqlPassword']" mode="label"/>
					</td>
					<td class="input-block">
						<input type="hidden" name="isMysqlPasswordChanged" id="isMysqlPasswordChanged">
							<xsl:attribute name="value">
								<xsl:choose>
									<xsl:when test="CONTROL[@NAME='mysqlPassword']/@EMPTY">true</xsl:when>
									<xsl:otherwise>false</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
						</input>
						<xsl:call-template name="BUTTON-CONTROL">
							<xsl:with-param name="title"><xsl:value-of select="$changeMysqlPassword/@CAPTION"/></xsl:with-param>
							<xsl:with-param name="action">sbPublicationSettingsForm.onChangeMysqlPassword();</xsl:with-param>
						</xsl:call-template>
						<xsl:if test="$changeMysqlPassword/@DESCRIPTION and $inOneRow = ''">
							<div class="sb-publish-pale"><xsl:value-of select="$changeMysqlPassword/@DESCRIPTION"/></div>
						</xsl:if>
					</td>
					<xsl:if test="$inOneRow">
						<td class="description-block">
							<xsl:if test="$changeMysqlPassword/@DESCRIPTION">
								<div class="sb-publish-pale"><xsl:value-of select="$changeMysqlPassword/@DESCRIPTION"/></div>
							</xsl:if>
						</td>
					</xsl:if>
				</tr>
			</xsl:if>
			<xsl:call-template name="PUBLICATION-SETTINGS-FORM-ROW">
				<xsl:with-param name="name">mysqlDatabase</xsl:with-param>
				<xsl:with-param name="inOneRow" select="$inOneRow"/>
			</xsl:call-template>
		</table>
	</xsl:template>

	<xsl:template match="PUBLICATION-SETTINGS-FORM" mode="INIT-JS">
		<script type="text/javascript" src="/js/publication_settings.js?{$version}.{$build}"></script>
		<script type="text/javascript" language="javascript">
			self.sbPublicationSettingsForm = new SbPublicationSettingsForm(sbNavigationObject);
		</script>
	</xsl:template>

	<xsl:template match="@HIDDEN" mode="publicationSettings">
		<xsl:attribute name="style">display: none;</xsl:attribute>
	</xsl:template>

	<xsl:template name="PUBLICATION-SETTINGS-FORM-ROW">
			<xsl:param name="name"/>
			<xsl:param name="size">25</xsl:param>
			<xsl:param name="maxlength">255</xsl:param>
			<xsl:param name="inOneRow"/>
			<xsl:param name="onchange">self.sbApplyChangesObject.registerChange(); sbPublicationSettingsForm.onChange();</xsl:param>
			<xsl:param name="rowstyle"/>

			<xsl:variable name="node" select="CONTROL[@NAME=$name]"/>

			<tr id="{$name}Row">
				<xsl:attribute name="style"><xsl:value-of select="$rowstyle"/></xsl:attribute>
			
				<xsl:apply-templates select="CONTROL[@NAME=$name]/@HIDDEN" mode="publicationSettings"/>
				<td class="title-block">
					<xsl:apply-templates select="CONTROL[@NAME=$name]" mode="label"/>
				</td>
				<td class="input-block">

						<xsl:apply-templates select="CONTROL[@NAME=$name]" mode="control">
							<xsl:with-param name="id"><xsl:value-of select="$name"/></xsl:with-param>
							<xsl:with-param name="maxlength"><xsl:value-of select="$maxlength"/></xsl:with-param>
							<xsl:with-param name="name"><xsl:value-of select="$name"/></xsl:with-param>
							<xsl:with-param name="onchange"><xsl:value-of select="$onchange"/></xsl:with-param>
							<xsl:with-param name="require">
								<xsl:if test="$node/@REQUIRE">1</xsl:if>
							</xsl:with-param>
							<xsl:with-param name="size"><xsl:value-of select="$size"/></xsl:with-param>
							<xsl:with-param name="type"><xsl:value-of select="$node/@TYPE"/></xsl:with-param>
							<xsl:with-param name="value"><xsl:value-of select="$node"/></xsl:with-param>
						</xsl:apply-templates>

						<xsl:if test="$node/@DESCRIPTION and $inOneRow = ''">
								<div class="hint"><xsl:value-of select="$node/@DESCRIPTION"/></div>
						</xsl:if>
				</td>
				<xsl:if test="$inOneRow">
						<td class="description-block">
								<xsl:if test="$node/@DESCRIPTION">
										<div class="hint"><xsl:value-of select="$node/@DESCRIPTION"/></div>
								</xsl:if>
						</td>
				</xsl:if>
			</tr>
	</xsl:template>

	<xsl:template match="REVERT-PUBLICATION-SETTINGS-FORM">
		<xsl:param name="blockClass"/>
		<xsl:param name="disabledDescriptionClass"/>

		<table cellpadding="0" cellspacing="0" border="0" class="{$blockClass}">
			<tr>
				<td style="padding-right: 8px;">
					<xsl:call-template name="BUTTON-CONTROL">
						<xsl:with-param name="title"><xsl:value-of select="CONTROL[@NAME='revertSettings']/@CAPTION"/></xsl:with-param>
						<xsl:with-param name="id">revertSettings</xsl:with-param>
						<xsl:with-param name="action">sbPublicationSettingsForm.revertSettings();</xsl:with-param>
					</xsl:call-template>
				</td>
				<td style="padding-right: 8px;" id="revertSettingsText" class="sb-text">
					<xsl:value-of select="CONTROL[@NAME='revertSettings']/@DISABLED-TITLE"/>
				</td>
			</tr>
		</table>
		<script type="text/javascript" language="javascript">
			var revertSettingsButton = self.document.getElementById('revertSettings');
			revertSettingsButton.textContainer = self.document.getElementById('revertSettingsText');
			revertSettingsButton.disabledTextClass = '<xsl:value-of select="$disabledDescriptionClass"/>';
			revertSettingsButton.enabledTextClass = 'sb-text';
			revertSettingsButton.disabledText = '<xsl:value-of select="CONTROL[@NAME='revertSettings']/@DISABLED-TITLE"/>';
			revertSettingsButton.enabledText = '<xsl:value-of select="CONTROL[@NAME='revertSettings']/@TITLE"/>';
			disableButton(revertSettingsButton);
			revertSettingsButton.textContainer.className = revertSettingsButton.disabledTextClass;
			revertSettingsButton.textContainer.innerHTML = htmlSpecialChars(revertSettingsButton.disabledText);
			self.sbPublishStepManager.restoreRevertSettings();
			<xsl:apply-templates select="CONTROL[@NAME='revertSettings']/@SETTINGS-CHANGED" mode="publicationSettings"/>
		</script>
	</xsl:template>

	<xsl:template match="CONTROL[@NAME='revertSettings']/@SETTINGS-CHANGED" mode="publicationSettings">
		revertSettingsButton.revertMode = 'submit';
		enableButton(revertSettingsButton);
		revertSettingsButton.textContainer.className = revertSettingsButton.enabledTextClass;
		revertSettingsButton.textContainer.innerHTML = htmlSpecialChars(revertSettingsButton.enabledText);
	</xsl:template>

</xsl:stylesheet>