<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:strip-space elements="*"/>
<xsl:output method="html" indent="yes" encoding="utf-8"/>
	
<xsl:template match="FORGET-PASSWORD">
	<script type="text/javascript" src="/js/ForgetPassword.js?{$version}.{$build}"/>
		
			<table cellspacing="0" class="admin-contentbar-container">
				<tr>
					<td class="admin-content-area" style="text-align: center; background-color: transparent;;">
						<table cellspacing="0" class="login-container">
							<tr>
								<td class="login-header-area">
									<span><xsl:value-of select="RESET-PASSWORD"/></span>
								</td>
							</tr>
							<tr>
								<td class="login-content-area">		
									<form name="loginForm" method="post" id="fpForm" action="{$baseUrl}/ForgetPassword" onsubmit="javascript:return validateForm();">
									<xsl:if test="../../STATUS">
										<xsl:apply-templates select="../../STATUS" mode="admin"/>
									</xsl:if>
									<div><xsl:value-of select="@DESCRIPTION"/></div>
									<div class="form-spacer"></div>
									<table cellpadding="0" cellspacing="0" border="0" class="control-title-input">
										<tr>
											<td class="title-block">
												<xsl:apply-templates select="CONTROL[@NAME='login']" mode="label">
													<xsl:with-param name="require">true</xsl:with-param>
												</xsl:apply-templates>
											</td>
											<td class="input-block">
												<xsl:apply-templates select="CONTROL[@NAME='login']" mode="control">
													<xsl:with-param name="require">true</xsl:with-param>
												</xsl:apply-templates>
											</td>
										</tr>
										<tr>
											<td class="title-block">
												<xsl:apply-templates select="CONTROL[@NAME='email']" mode="label">
													<xsl:with-param name="require">true</xsl:with-param>
												</xsl:apply-templates>
											</td>
											<td class="input-block">
												<xsl:apply-templates select="CONTROL[@NAME='email']" mode="control">
													<xsl:with-param name="require">true</xsl:with-param>
												</xsl:apply-templates>
											</td>
										</tr>
									</table>
									<div class="form-spacer"></div>
									<table cellpadding="0" cellspacing="0" class="form-tools-container">
										<tr>
											<td><div class="hint"><xsl:call-template name="REQUIRED-FIELDS"/></div></td>
											<td>
												<table cellpadding="0" cellspacing="0" class="ok-cancel-container">
													<tr>
														<td>
															<table width="1%" border="0" cellpadding="0" cellpacing="0"> 
																<tr>
																	<td>
																		<xsl:call-template name="BUTTON-CONTROL">
																			<xsl:with-param name="class">sb-login-control-button</xsl:with-param>
																			<xsl:with-param name="title"><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/SEND"/></xsl:with-param>
																			<xsl:with-param name="action">javascript:validateForm();</xsl:with-param>
																		</xsl:call-template>
																	</td>
																	<td style="padding-left: 5px;">
																		<xsl:call-template name="BUTTON-CONTROL">
																			<xsl:with-param name="class">sb-login-control-button</xsl:with-param>
																			<xsl:with-param name="title"><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/CANCEL"/></xsl:with-param>
																			<xsl:with-param name="action">document.location.href='<xsl:value-of select="$baseUrl" disable-output-escaping="yes"/>/Login';</xsl:with-param>
																		</xsl:call-template>
																	</td>
																</tr>
															</table>
														</td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
									
									<!-- input image needed for work default submit via Enter -->
									<input type="image" style="border-width: 0px; height: 0px; width: 0px;"/>
									</form>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
	</xsl:template>

	<xsl:template match="SITEBUILDER-PAGE">
		<table cellpadding="0" cellspacing="0" border="0" style="width: 100%; height: 100%">
			<tr>
				<td class="sb-adminpanel-header">
					<xsl:if test="NAVIGATION">
						<xsl:attribute name="colspan">2</xsl:attribute>
					</xsl:if>
					<xsl:call-template name="TOP-HEADER"/>
				</td>
			</tr>
			<tr><td valign="top" class="sb-page" style="background:#3080BB url({$skinPath}/images/bg_main_login.jpg) no-repeat scroll 50% 100%;"><xsl:apply-templates select="VIEW-CONTENT/*"/></td></tr>
		</table>
	</xsl:template>
	
	<xsl:template name="MAIN-PAGE-CONTENT">
		<tr>
			<td valign="top">
				<xsl:apply-templates select="VIEW-CONTENT"/>
			</td>
		</tr>
	</xsl:template>
</xsl:stylesheet>
