<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:template match="CONTROL" mode="label">
		<!--alphabet order-->
		<xsl:param name="class">name</xsl:param>
		<xsl:param name="id" select="@ID"/>
		<xsl:param name="require" select="@REQUIRE"/>
		<xsl:param name="style"/>
		<xsl:param name="title" select="@TITLE"/>
		<xsl:param name="value" select="."/>

		<xsl:param name="for"><xsl:value-of select="$id"/></xsl:param>

		<label class="{$class}">
			<xsl:if test="$for != ''"><xsl:attribute name="for"><xsl:value-of select="$for"/></xsl:attribute></xsl:if>
			<xsl:if test="$style != ''"><xsl:attribute name="style"><xsl:value-of select="$style"/></xsl:attribute></xsl:if>
			<xsl:value-of select="$title"/>
		</label>
		<xsl:if test="$require != '' and $require != '0'">
			<span id="{$id}_asterix" class="sb-asterix">
				<xsl:attribute name="style">
					<xsl:if test="$value != ''">display: none;</xsl:if>
				</xsl:attribute>
				&#160;*
			</span>
		</xsl:if>
	</xsl:template>

	<xsl:template name="LABEL" mode="label">
		<!--alphabet order-->
		<xsl:param name="class">name</xsl:param>
		<xsl:param name="id"/>
		<xsl:param name="require"/>
		<xsl:param name="style"/>
		<xsl:param name="title"/>
		<xsl:param name="value"/>

		<xsl:param name="for"><xsl:value-of select="$id"/></xsl:param>

		<label class="{$class}">
			<xsl:if test="$for != ''"><xsl:attribute name="for"><xsl:value-of select="$for"/></xsl:attribute></xsl:if>
			<xsl:if test="$style != ''"><xsl:attribute name="style"><xsl:value-of select="$style"/></xsl:attribute></xsl:if>
			<xsl:value-of select="$title"/>
		</label>
		<xsl:if test="$require != '' and $require != '0'">
			<span id="{$id}_asterix" class="sb-asterix">
				<xsl:attribute name="style">
					<xsl:if test="$value != ''">display: none;</xsl:if>
				</xsl:attribute>
				&#160;*
			</span>
		</xsl:if>
	</xsl:template>

	<xsl:template match="CONTROL[@TYPE='INPUT' or @TYPE='PASSWORD']" mode="control">
		<!--alphabet order-->
		<xsl:param name="autocomplete"/>
		<xsl:param name="class">sb-input</xsl:param>
		<xsl:param name="disabled" select="@DISABLED"/>
		<xsl:param name="id" select="@ID"/>
		<xsl:param name="maxlength">255</xsl:param>
		<xsl:param name="name" select="@NAME"/>
		<xsl:param name="onblur"/>
		<xsl:param name="onchange"/>
		<xsl:param name="onclick"/>
		<xsl:param name="onfocus"/>
		<xsl:param name="onkeyup"/>
		<xsl:param name="require" select="@REQUIRE"/>
		<xsl:param name="tabindex"/>
		<xsl:param name="type" select="@TYPE"/>
		<xsl:param name="size">25</xsl:param>
		<xsl:param name="style"/>
		<xsl:param name="value" select="."/>

		<input size="{$size}" maxlength="{$maxlength}" class="{$class}">
			<!--alphabet order-->
			<xsl:if test="$autocomplete != ''"><xsl:attribute name="autocomplete"><xsl:value-of select="$autocomplete"/></xsl:attribute></xsl:if>
			<xsl:if test="$disabled != '' and $disabled != '0'"><xsl:attribute name="disabled">true</xsl:attribute></xsl:if>
			<xsl:if test="$id != ''"><xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute></xsl:if>
			<xsl:if test="$name != ''"><xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute></xsl:if>
			<xsl:if test="$onchange != ''"><xsl:attribute name="onchange"><xsl:value-of select="$onchange"/></xsl:attribute></xsl:if>
			<xsl:if test="$onclick != ''"><xsl:attribute name="onclick"><xsl:value-of select="$onclick"/></xsl:attribute></xsl:if>
			<xsl:if test="$onfocus != ''"><xsl:attribute name="onfocus"><xsl:value-of select="$onfocus"/></xsl:attribute></xsl:if>
			<xsl:if test="$onkeyup != ''"><xsl:attribute name="onkeyup"><xsl:value-of select="$onkeyup"/></xsl:attribute></xsl:if>
			<xsl:choose>
				<xsl:when test="$onblur != ''">
					<xsl:attribute name="onblur"><xsl:value-of select="$onblur"/></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="$require != '' and $require != '0'">
						<xsl:attribute name="onblur">showAsterix(this.id);</xsl:attribute>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:if test="$style != ''"><xsl:attribute name="style"><xsl:value-of select="$style"/></xsl:attribute></xsl:if>
			<xsl:if test="$tabindex != ''"><xsl:attribute name="tabindex"><xsl:value-of select="$tabindex"/></xsl:attribute></xsl:if>
			<xsl:attribute name="type">
				<xsl:choose>
					<xsl:when test="$type != ''"><xsl:value-of select="$type"/></xsl:when>
					<xsl:otherwise>text</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			<xsl:if test="$value != ''"><xsl:attribute name="value"><xsl:value-of select="$value"/></xsl:attribute></xsl:if>
		</input>
	</xsl:template>

	<xsl:template name="INPUT" mode="control">
		<!--alphabet order-->
		<xsl:param name="autocomplete"/>
		<xsl:param name="class">sb-input</xsl:param>
		<xsl:param name="disabled"/>
		<xsl:param name="id"/>
		<xsl:param name="maxlength">255</xsl:param>
		<xsl:param name="name"/>
		<xsl:param name="onblur"/>
		<xsl:param name="onchange"/>
		<xsl:param name="onclick"/>
		<xsl:param name="onfocus"/>
		<xsl:param name="onkeyup"/>
		<xsl:param name="onkeypress"/>
		<xsl:param name="require"/>
		<xsl:param name="tabindex"/>
		<xsl:param name="type">text</xsl:param>
		<xsl:param name="size">25</xsl:param>
		<xsl:param name="style"/>
		<xsl:param name="value"/>

		<input type="{$type}" size="{$size}" maxlength="{$maxlength}" class="{$class}">
			<!--alphabet order-->
			<xsl:if test="$autocomplete != ''"><xsl:attribute name="autocomplete"><xsl:value-of select="$autocomplete"/></xsl:attribute></xsl:if>
			<xsl:if test="$disabled != '' and $disabled != '0'"><xsl:attribute name="disabled">true</xsl:attribute></xsl:if>
			<xsl:if test="$id != ''"><xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute></xsl:if>
			<xsl:if test="$name != ''"><xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute></xsl:if>
			<xsl:if test="$onchange != ''"><xsl:attribute name="onchange"><xsl:value-of select="$onchange"/></xsl:attribute></xsl:if>
			<xsl:if test="$onclick != ''"><xsl:attribute name="onclick"><xsl:value-of select="$onclick"/></xsl:attribute></xsl:if>
			<xsl:if test="$onfocus != ''"><xsl:attribute name="onfocus"><xsl:value-of select="$onfocus"/></xsl:attribute></xsl:if>
			<xsl:if test="$onkeyup != ''"><xsl:attribute name="onkeyup"><xsl:value-of select="$onkeyup"/></xsl:attribute></xsl:if>
			<xsl:if test="$onkeypress != ''"><xsl:attribute name="onkeypress"><xsl:value-of select="$onkeypress"/></xsl:attribute></xsl:if>
			<xsl:choose>
				<xsl:when test="$onblur != ''">
					<xsl:attribute name="onblur"><xsl:value-of select="$onblur"/></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="$require != '' and $require != '0'">
						<xsl:attribute name="onblur">showAsterix(this.id);</xsl:attribute>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:if test="$style != ''"><xsl:attribute name="style"><xsl:value-of select="$style"/></xsl:attribute></xsl:if>
			<xsl:if test="$tabindex != ''"><xsl:attribute name="tabindex"><xsl:value-of select="$tabindex"/></xsl:attribute></xsl:if>
			<xsl:if test="$value != ''"><xsl:attribute name="value"><xsl:value-of select="$value"/></xsl:attribute></xsl:if>
		</input>
	</xsl:template>

	<xsl:template match="CONTROL[@TYPE='TEXTAREA']" mode="control">
		<!--alphabet order-->
		<xsl:param name="class"/>
		<xsl:param name="disabled" select="@DISABLED"/>
		<xsl:param name="id" select="@ID"/>
		<xsl:param name="name" select="@NAME"/>
		<xsl:param name="onblur"/>
		<xsl:param name="onchange"/>
		<xsl:param name="require" select="@REQUIRE"/>
		<xsl:param name="cols">25</xsl:param>
		<xsl:param name="rows">5</xsl:param>
		<xsl:param name="style"/>
		<xsl:param name="value" select="."/>

		<textarea cols="{$cols}" rows="{$rows}">
			<!--alphabet order-->
			<xsl:if test="$class != ''"><xsl:attribute name="class"><xsl:value-of select="$class"/></xsl:attribute></xsl:if>
			<xsl:if test="$disabled != '' and $disabled != '0'"><xsl:attribute name="disabled">true</xsl:attribute></xsl:if>
			<xsl:if test="$id != ''"><xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute></xsl:if>
			<xsl:if test="$name != ''"><xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute></xsl:if>
			<xsl:if test="$onchange != ''"><xsl:attribute name="onchange"><xsl:value-of select="$onchange"/></xsl:attribute></xsl:if>
			<xsl:choose>
				<xsl:when test="$onblur != ''">
					<xsl:attribute name="onblur"><xsl:value-of select="$onblur"/></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="$require != '' and $require != '0'">
						<xsl:attribute name="onblur">showAsterix(this.id);</xsl:attribute>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:if test="$style != ''"><xsl:attribute name="style"><xsl:value-of select="$style"/></xsl:attribute></xsl:if>

			<xsl:value-of select="$value"/>
		</textarea>
	</xsl:template>

	<xsl:template name="TEXTAREA" mode="control">
		<!--alphabet order-->
		<xsl:param name="class"/>
		<xsl:param name="disabled"/>
		<xsl:param name="id"/>
		<xsl:param name="name"/>
		<xsl:param name="onblur"/>
		<xsl:param name="onchange"/>
		<xsl:param name="require"/>
		<xsl:param name="cols">25</xsl:param>
		<xsl:param name="rows">5</xsl:param>
		<xsl:param name="style"/>
		<xsl:param name="value"/>

		<textarea cols="{$cols}" rows="{$rows}">
			<!--alphabet order-->
			<xsl:if test="$class != ''"><xsl:attribute name="class"><xsl:value-of select="$class"/></xsl:attribute></xsl:if>
			<xsl:if test="$disabled != '' and $disabled != '0'"><xsl:attribute name="disabled">true</xsl:attribute></xsl:if>
			<xsl:if test="$id != ''"><xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute></xsl:if>
			<xsl:if test="$name != ''"><xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute></xsl:if>
			<xsl:if test="$onchange != ''"><xsl:attribute name="onchange"><xsl:value-of select="$onchange"/></xsl:attribute></xsl:if>
			<xsl:choose>
				<xsl:when test="$onblur != ''">
					<xsl:attribute name="onblur"><xsl:value-of select="$onblur"/></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="$require != '' and $require != '0'">
						<xsl:attribute name="onblur">showAsterix(this.id);</xsl:attribute>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:if test="$style != ''"><xsl:attribute name="style"><xsl:value-of select="$style"/></xsl:attribute></xsl:if>

			<xsl:value-of select="$value"/>
		</textarea>
	</xsl:template>

	<xsl:template match="CONTROL[@TYPE='COMBO-BOX']" mode="control">
		<!--alphabet order-->
		<xsl:param name="class"/>
		<xsl:param name="disabled" select="@DISABLED"/>
		<xsl:param name="id" select="@ID"/>
		<xsl:param name="name" select="@NAME"/>
		<xsl:param name="onchange"/>
		<xsl:param name="style"/>

		<select>
			<!--alphabet order-->
			<xsl:if test="$disabled != '' and $disabled != '0'"><xsl:attribute name="disabled">true</xsl:attribute></xsl:if>
			<xsl:if test="$id != ''"><xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute></xsl:if>
			<xsl:if test="$name != ''"><xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute></xsl:if>
			<xsl:if test="$onchange != ''"><xsl:attribute name="onchange"><xsl:value-of select="$onchange"/></xsl:attribute></xsl:if>
			<xsl:if test="$style != ''"><xsl:attribute name="style"><xsl:value-of select="$style"/></xsl:attribute></xsl:if>
			<xsl:apply-templates select="CONTROL[@TYPE='COMBO-BOX-OPTION']"/>
		</select>
	</xsl:template>

	<xsl:template match="CONTROL[@TYPE='COMBO-BOX-OPTION']">
		<option>
<!--			<xsl:attribute name="value"><xsl:value-of select="@VALUE"/></xsl:attribute> -->
			<xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
			<xsl:if test="@SELECTED">
				<xsl:attribute name="selected">true</xsl:attribute>
			</xsl:if>
			<xsl:if test="@LEVEL">
				<xsl:attribute name="style">white-space: pre;</xsl:attribute>
				<xsl:call-template name="LOOP-STRING">
					<xsl:with-param name="string">&#160;</xsl:with-param>
					<xsl:with-param name="level" select="3*@LEVEL"/>
				</xsl:call-template>
			</xsl:if>
			<xsl:value-of select="@TITLE"/>
		</option>
	</xsl:template>

	<xsl:template name="LOOP-STRING">
		<xsl:param name="string"/>
		<xsl:param name="level"/>

		<xsl:if test="$level > 0">
			<xsl:value-of select="$string"/>
			<xsl:call-template name="LOOP-STRING">
				<xsl:with-param name="string" select="$string"/>
				<xsl:with-param name="level" select="$level - 1"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>

	<xsl:template match="CONTROL[@TYPE='CHECKBOX']" mode="control">
		<!--alphabet order-->
		<xsl:param name="checked" select="@CHECKED"/>
		<xsl:param name="class">sb-check</xsl:param>
		<xsl:param name="disabled" select="@DISABLED"/>
		<xsl:param name="id" select="@ID"/>
		<xsl:param name="name" select="@NAME"/>
		<xsl:param name="onchange"/>
		<xsl:param name="onclick"/>
		<xsl:param name="style"/>
		<xsl:param name="value" select="."/>


		<input type="checkbox" class="{$class}">
			<!--alphabet order-->
			<xsl:if test="$checked != '' and $checked != '0'"><xsl:attribute name="checked"><xsl:value-of select="$checked"/></xsl:attribute></xsl:if>
			<xsl:if test="$disabled != '' and $disabled != '0'"><xsl:attribute name="disabled">true</xsl:attribute></xsl:if>
			<xsl:if test="$id != ''"><xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute></xsl:if>
			<xsl:if test="$name != ''"><xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute></xsl:if>
			<xsl:if test="$onchange != ''"><xsl:attribute name="onchange"><xsl:value-of select="$onchange"/></xsl:attribute></xsl:if>
			<xsl:if test="$onclick != ''"><xsl:attribute name="onclick"><xsl:value-of select="$onclick"/></xsl:attribute></xsl:if>
			<xsl:if test="$style != ''"><xsl:attribute name="style"><xsl:value-of select="$style"/></xsl:attribute></xsl:if>
			<xsl:if test="$value != ''"><xsl:attribute name="value"><xsl:value-of select="$value"/></xsl:attribute></xsl:if>
		</input>
	</xsl:template>

	<xsl:template name="CHECKBOX" mode="control">
		<!--alphabet order-->
		<xsl:param name="checked"/>
		<xsl:param name="class">sb-check</xsl:param>
		<xsl:param name="disabled"/>
		<xsl:param name="id"/>
		<xsl:param name="name"/>
		<xsl:param name="onchange"/>
		<xsl:param name="onclick"/>
		<xsl:param name="style"/>
		<xsl:param name="value"/>


		<input type="checkbox" class="{$class}">
			<!--alphabet order-->
			<xsl:if test="$checked != '' and $checked != '0'"><xsl:attribute name="checked"><xsl:value-of select="$checked"/></xsl:attribute></xsl:if>
			<xsl:if test="$disabled != '' and $disabled != '0'"><xsl:attribute name="disabled">true</xsl:attribute></xsl:if>
			<xsl:if test="$id != ''"><xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute></xsl:if>
			<xsl:if test="$name != ''"><xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute></xsl:if>
			<xsl:if test="$onchange != ''"><xsl:attribute name="onchange"><xsl:value-of select="$onchange"/></xsl:attribute></xsl:if>
			<xsl:if test="$onclick != ''"><xsl:attribute name="onclick"><xsl:value-of select="$onclick"/></xsl:attribute></xsl:if>
			<xsl:if test="$style != ''"><xsl:attribute name="style"><xsl:value-of select="$style"/></xsl:attribute></xsl:if>
			<xsl:if test="$value != ''"><xsl:attribute name="value"><xsl:value-of select="$value"/></xsl:attribute></xsl:if>
		</input>
	</xsl:template>

	<xsl:template match="CONTROL[@TYPE='RADIO']" mode="control">
		<!--alphabet order-->
		<xsl:param name="checked" select="@CHECKED"/>
		<xsl:param name="class">sb-radio</xsl:param>
		<xsl:param name="disabled" select="@DISABLED"/>
		<xsl:param name="id" select="@ID"/>
		<xsl:param name="name" select="@NAME"/>
		<xsl:param name="onchange"/>
		<xsl:param name="onclick"/>
		<xsl:param name="style"/>
		<xsl:param name="value" select="."/>

		<input type="radio" class="{$class}">
			<xsl:if test="$checked != '' and $checked != '0'"><xsl:attribute name="checked"><xsl:value-of select="$checked"/></xsl:attribute></xsl:if>
			<xsl:if test="$disabled != '' and $disabled != '0'"><xsl:attribute name="disabled"><xsl:value-of select="$disabled"/></xsl:attribute></xsl:if>
			<xsl:if test="$id != ''"><xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute></xsl:if>
			<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
			<xsl:attribute name="onchange"><xsl:value-of select="$onchange"/></xsl:attribute>
			<xsl:attribute name="onclick"><xsl:value-of select="$onclick"/></xsl:attribute>
			<xsl:if test="$style != ''"><xsl:attribute name="style"><xsl:value-of select="$style"/></xsl:attribute></xsl:if>
			<xsl:attribute name="value"><xsl:value-of select="$value"/></xsl:attribute>
		</input>
	</xsl:template>

	<xsl:template match="CONTROL[@TYPE='RADIO-OPTION']" mode="control">
		<!--alphabet order-->
		<xsl:param name="checked" select="@CHECKED"/>
		<xsl:param name="class">sb-radio</xsl:param>
		<xsl:param name="disabled" select="@DISABLED"/>
		<xsl:param name="id" select="../@ID"/>
		<xsl:param name="name" select="../@NAME"/>
		<xsl:param name="onchange"/>
		<xsl:param name="onclick"/>
		<xsl:param name="style"/>
		<xsl:param name="value" select="."/>

		<input type="radio" class="{$class}">
			<xsl:if test="$checked != '' and $checked != '0'"><xsl:attribute name="checked"><xsl:value-of select="$checked"/></xsl:attribute></xsl:if>
			<xsl:if test="$disabled != '' and $disabled != '0'"><xsl:attribute name="disabled"><xsl:value-of select="$disabled"/></xsl:attribute></xsl:if>
			<xsl:if test="$id != ''"><xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute></xsl:if>
			<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
			<xsl:attribute name="onchange"><xsl:value-of select="$onchange"/></xsl:attribute>
			<xsl:attribute name="onclick"><xsl:value-of select="$onclick"/></xsl:attribute>
			<xsl:if test="$style != ''"><xsl:attribute name="style"><xsl:value-of select="$style"/></xsl:attribute></xsl:if>
			<xsl:attribute name="value"><xsl:value-of select="$value"/></xsl:attribute>
		</input>
	</xsl:template>

	<xsl:template name="RADIO" mode="control">
		<!--alphabet order-->
		<xsl:param name="checked" select="@CHECKED"/>
		<xsl:param name="class">sb-radio</xsl:param>
		<xsl:param name="disabled" select="@DISABLED"/>
		<xsl:param name="id" select="@ID"/>
		<xsl:param name="name" select="@NAME"/>
		<xsl:param name="onchange"/>
		<xsl:param name="onclick"/>
		<xsl:param name="style"/>
		<xsl:param name="value" select="."/>

		<input type="radio" class="{$class}">
			<xsl:if test="$checked != '' and $checked != '0'"><xsl:attribute name="checked"><xsl:value-of select="$checked"/></xsl:attribute></xsl:if>
			<xsl:if test="$disabled != '' and $disabled != '0'"><xsl:attribute name="disabled"><xsl:value-of select="$disabled"/></xsl:attribute></xsl:if>
			<xsl:if test="$id != ''"><xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute></xsl:if>
			<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
			<xsl:attribute name="onchange"><xsl:value-of select="$onchange"/></xsl:attribute>
			<xsl:attribute name="onclick"><xsl:value-of select="$onclick"/></xsl:attribute>
			<xsl:if test="$style != ''"><xsl:attribute name="style"><xsl:value-of select="$style"/></xsl:attribute></xsl:if>
			<xsl:attribute name="value"><xsl:value-of select="$value"/></xsl:attribute>
		</input>
	</xsl:template>

	<xsl:template match="CONTROL" mode="status">
		<xsl:choose>
			<xsl:when test=".='--On--'">
				<img width="15" height="15" src="{$skinPath}/icons/checked.png" alt=""/>
			</xsl:when>
			<xsl:when test=".='--Off--'">
				<img width="15" height="15" src="{$skinPath}/icons/unchecked.png" alt=""/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="."/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="CONTROL[@TYPE='BUTTON']" name="BUTTON-CONTROL">
		<xsl:param name="style"/>
		<xsl:param name="class"/>
		<xsl:param name="title"/>
		<xsl:param name="conhelp" select="@CONTEXT-HELP" />
		<xsl:param name="icon" select="@ICON"/>
		<xsl:param name="action" select="@ACTION"/>
		<xsl:param name="id" value="@NAME"/>
		<xsl:param name="disabled" select="@DISABLED"/>
		<table cellpadding="0" cellspacing="0" border="0">
			<xsl:attribute name="style">
				<xsl:choose>
					<xsl:when test="$disabled != ''">
						filter:alpha(opacity=40); opacity: 0.4;
						<xsl:value-of select="$style"/>
					</xsl:when>
					<xsl:otherwise>
						cursor: pointer;
					</xsl:otherwise>
				</xsl:choose>
				<xsl:choose>
					<xsl:when test="$title">
						<xsl:choose> 	  	 
							<xsl:when test="string-length($title)&lt;=7">width:70px;</xsl:when> 	  	 
							<xsl:otherwise>width:<xsl:value-of select="string-length($title)" />0px;</xsl:otherwise> 	  	 
						</xsl:choose> 	  	 
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose> 	  	 
							<xsl:when test="string-length(@TITLE)&lt;=7">width:70px;</xsl:when> 	  	 
							<xsl:otherwise>width:<xsl:value-of select="string-length(@TITLE)" />0px;</xsl:otherwise> 	  	 
						</xsl:choose> 	  	 
					</xsl:otherwise>
				</xsl:choose>
				<xsl:value-of select="$style"/>
			</xsl:attribute>
			<xsl:attribute name="class"><xsl:value-of select="$class"/></xsl:attribute>
			<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
			<xsl:attribute name="onclick">
				<xsl:value-of select="$action"/>
			</xsl:attribute>
			<xsl:attribute name="onmouseover">setButtonClassName(this.getElementsByTagName('td'), 'sb-selected-button-bg-' , true);
				<xsl:if test="$conhelp">
					 SetContextHelp('<xsl:value-of select="$conhelp" />')
				</xsl:if>
			</xsl:attribute>
			<xsl:attribute name="onmouseout">setButtonClassName(this.getElementsByTagName('td'), 'sb-selected-button-bg-' , false);
				<xsl:if test="$conhelp">
					SetContextHelp();
				</xsl:if>
			</xsl:attribute>

			<tr>
				<td class="sb-button-bg-left"></td>
				<xsl:if test="$icon!=''">
					<td style="padding-left:5px;padding-right:5px;">
						<xsl:attribute name="class">sb-button-bg-middle 
							<xsl:choose> 
								<xsl:when test="$action=''">sb-button-disabled</xsl:when>
								<xsl:otherwise><!--<xsl:value-of select="$class"/>--></xsl:otherwise>
							</xsl:choose>
						</xsl:attribute>
						<img src="{$skinPath}/icons/{$icon}" />
					</td>
				</xsl:if>
				<td class="" style="white-space: nowrap; text-align: center; padding: 0px; padding-right: 4px;padding-left: 4px; width: 100%;">
					<xsl:attribute name="id"><xsl:value-of select="$id"/>MainText</xsl:attribute>
					<xsl:attribute name="class">sb-button-bg-middle 
						<xsl:choose>
							<xsl:when test="$action=''">sb-button-disabled</xsl:when>
							<xsl:otherwise><!--<xsl:value-of select="$class"/>--></xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
					<xsl:choose>
						<xsl:when test="$title"><xsl:value-of select="$title"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="@TITLE"/></xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="sb-button-bg-right"></td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template match="CONTROL[@TYPE='BUTTON']" name="LARGE-BUTTON-CONTROL" mode="LARGE">
		<xsl:param name="style"/>
		<xsl:param name="class"/>
		<xsl:param name="title" select="@TITLE"/>
		<xsl:param name="icon" select="@ICON"/>
		<xsl:param name="leftImage">images/large_button_left.gif</xsl:param>
		<xsl:param name="middleImage">images/large_button_middle.gif</xsl:param>
		<xsl:param name="rightImage">images/large_button_right.gif</xsl:param>
		<xsl:param name="action" select="@ACTION"/>

		<table cellpadding="0" cellspacing="0" border="0">
			<xsl:attribute name="style">cursor: pointer;<xsl:value-of select="$style"/></xsl:attribute>
			<xsl:if test="$class!=''">
				<xsl:attribute name="class"><xsl:value-of select="$class"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="$action!=''">
				<xsl:attribute name="onclick">
					<xsl:value-of select="$action"/>
				</xsl:attribute>
			</xsl:if>
			<tr>
				<td><img src="{$skinPath}/{$leftImage}" border="0" alt=""/></td>
				<td class="sb-large-button-text" style="white-space: nowrap; background-image: url('{$skinPath}/{$middleImage}');">
					<xsl:if test="$icon!=''">
						<img src="{$skinPath}/{$icon}" border="0" alt="" style="margin-right: 5px; vertical-align: middle;"/>
					</xsl:if>
					<xsl:value-of select="$title"/>
				</td>
				<td><img src="{$skinPath}/{$rightImage}" border="0" alt=""/></td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="OK-CANCEL-BUTTONS">
		<xsl:param name="okAction"/>
		<xsl:param name="cancelAction"/>
		<xsl:param name="isRequiredFieldsExists"/>
		<xsl:param name="okblockstyle"/>
		<xsl:param name="cancelblockstyle"/>
		<table cellpadding="0" cellspacing="0" class="form-tools-container">
		<tr>
		<xsl:if test="$isRequiredFieldsExists != ''">
			<td><xsl:call-template name="REQUIRED-FIELDS"/></td>
		</xsl:if>
		<td>
			<table cellpadding="0" cellspacing="0" class="ok-cancel-container">
			<tr>
				<td>
					<xsl:if test="/SITEBUILDER-PAGE/JS-LOCALE/CONTEXT-HELP-BUTTON-OK">
						<xsl:attribute name="onmouseout">SetContextHelp();</xsl:attribute>
						<xsl:attribute name="onmouseover">SetContextHelp('CONTEXT-HELP-BUTTON-OK');</xsl:attribute>
					</xsl:if>
					<xsl:if test="$okblockstyle!=''">
						<xsl:attribute name="style"><xsl:value-of select="$okblockstyle"/></xsl:attribute>
					</xsl:if>
					<xsl:call-template name="OK-BUTTON">
						<xsl:with-param name="action"><xsl:value-of select="$okAction"/></xsl:with-param>
					</xsl:call-template>
				</td>
				<td class="cancel-area">
					<xsl:if test="/SITEBUILDER-PAGE/JS-LOCALE/CONTEXT-HELP-BUTTON-CANCEL">
						<xsl:attribute name="onmouseout">SetContextHelp();</xsl:attribute>
						<xsl:attribute name="onmouseover">SetContextHelp('CONTEXT-HELP-BUTTON-CANCEL');</xsl:attribute>
					</xsl:if>
					<xsl:if test="$cancelblockstyle!=''">
						<xsl:attribute name="style"><xsl:value-of select="$cancelblockstyle"/></xsl:attribute>
					</xsl:if>
					<xsl:call-template name="CANCEL-BUTTON">
						<xsl:with-param name="action"><xsl:value-of select="$cancelAction"/></xsl:with-param>
					</xsl:call-template>
				</td>
			</tr>
			</table>
		</td>
		</tr>
		</table>
	</xsl:template>

	<xsl:template name="OK-BUTTON">
	<xsl:param name="action"/>
<!--	<table onclick="{$action}" style="cursor: pointer; width: 70px;" border="0" cellpadding="0" cellspacing="0"> -->
	<table cellspacing="0" cellpadding="0" border="0" style="cursor: pointer; width: 90px;" onclick="{$action}" onmouseover="setButtonClassName(this.getElementsByTagName('td'), 'sb-selected-button-bg-' , true);" onmouseout="setButtonClassName(this.getElementsByTagName('td'), 'sb-selected-button-bg-' , false);">
		<tr>
			<td class="sb-button-bg-left"></td>
			<!--td class="sb-button-bg-middle" style="width: 1px;padding-left: 5px;"><img src="{$skinPath}/icons/ok.gif"/></td-->
			<td class="sb-button-bg-middle sb-button-ok" style="width:100%;" align="center"><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/OK-TITLE"/></td>
			<td class="sb-button-bg-right"></td>
		</tr>
	</table>
	</xsl:template>

	<xsl:template name="CANCEL-BUTTON">
	<xsl:param name="action"/>
	<table onclick="{$action}" style="cursor: pointer; width: 90px;" border="0" cellpadding="0" cellspacing="0" onmouseover="setButtonClassName(this.getElementsByTagName('td'), 'sb-selected-button-bg-' , true);" onmouseout="setButtonClassName(this.getElementsByTagName('td'), 'sb-selected-button-bg-' , false);">
		<tr>
			<td class="sb-button-bg-left"></td>
			<!--td class="sb-button-bg-middle" style="width: 1px;padding-left: 5px;"><img src="{$skinPath}/icons/cancel.gif"/></td-->
			<td class="sb-button-bg-middle sb-button-cancel"  style="width:100%;" align="center"><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/CANCEL-TITLE"/></td>
			<td class="sb-button-bg-right"></td>
		</tr>
	</table>
	</xsl:template>

	<xsl:template name="BUTTON">
		<xsl:param name="action"/>
		<xsl:param name="title"/>
		<xsl:param name="id"/>
		<xsl:param name="align" select="'center'"/>
		<table align="{$align}" onclick="{$action} return false;" style="cursor:pointer; width:70px;" border="0" cellpadding="0" cellspacing="0"  onmouseover="setButtonClassName(this.getElementsByTagName('td'), 'sb-selected-button-bg-' , true);" onmouseout="setButtonClassName(this.getElementsByTagName('td'), 'sb-selected-button-bg-' , false);">
			<xsl:if test="$id">
				<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
			</xsl:if>
			<tr>
				<td class="sb-button-bg-left"></td>
				<td class="sb-button-bg-middle sb-text" style="width:100%; white-space: nowrap;" align="center"><xsl:value-of select="$title"/></td>
				<td class="sb-button-bg-right"></td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="CONTROL-WIDTH">
		<xsl:param name="inOneRow"></xsl:param>
		<xsl:param name="titleStyle"></xsl:param>
		<xsl:attribute name="style">
			<xsl:choose>
				<xsl:when test="$inOneRow and @DESCRIPTION">width: 208px;</xsl:when>
				<xsl:otherwise>width: 208px;</xsl:otherwise>
			</xsl:choose>
			padding-left: 0;
			<xsl:value-of select="$titleStyle"/>
		</xsl:attribute>
	</xsl:template>

	<xsl:template name="CONTROL-ENV-WIDTH">
		<xsl:param name="inOneRow"></xsl:param>
		<xsl:param name="controlEnvStyle"></xsl:param>
		<xsl:attribute name="style">
			<xsl:choose>
				<xsl:when test="$inOneRow and @DESCRIPTION"></xsl:when>
				<xsl:otherwise></xsl:otherwise>
			</xsl:choose>
			<xsl:value-of select="$controlEnvStyle"/>
		</xsl:attribute>
	</xsl:template>

	<xsl:template match="CONTROL[@TYPE='LINK']">
		<xsl:param name="style"></xsl:param>
		<a href="#">
			<xsl:attribute name="class"><xsl:value-of select="$style"/></xsl:attribute>
			<xsl:attribute name="href"><xsl:value-of select="@HREF"/></xsl:attribute>
			<xsl:value-of select="@TITLE"/>
		</a>
    </xsl:template>

	<xsl:template match="CONTROL[@TYPE='DATE']">
<!--
	:TODO: abelyaev@ 20070806: implement here
	@see resources/styles/Wizard/Edit/Modules/Eshop/Payments.xsl
	@see http://bugs.plesk.ru/show_bug.cgi?id=122685
-->
	</xsl:template>

	<xsl:template match="CONTROL[@TYPE='GAUGE']" name="GAUGE-CONTROL">
		<table cellspacing="0" cellpadding="0" border="0" style="width:100%;">
			<tr>
				<td>
					<xsl:choose>
						<xsl:when test="@CURRENT > 0">
							<xsl:attribute name="class">sb-statbar-left-filled</xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="class">sb-statbar-left</xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<img src="/images/blank.gif" width="3" height="9"/>
				</td>
				<td class="sb-statbar-middle" width="100%">
					<xsl:choose>
						<xsl:when test="@CURRENT > 0">
							<img src="{$skinPath}/images/statline_abg.gif" height="9" width="0">
								<xsl:if test="@CURRENT > @TOTAL">
									<xsl:attribute name="width">100%</xsl:attribute>
								</xsl:if>
								<xsl:if test="@CURRENT > 0">
									<xsl:if test="@TOTAL > 0">
										<xsl:attribute name="width"><xsl:value-of select="(@CURRENT*100) div @TOTAL"/>%</xsl:attribute>
									</xsl:if>
								</xsl:if>
							</img>
						</xsl:when>
						<xsl:otherwise>
							<img src="/images/blank.gif" width="1" height="9"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td class="sb-statbar-right">
					<xsl:choose>
						<xsl:when test="@CURRENT >= @TOTAL">
							<xsl:attribute name="class">sb-statbar-right-filled</xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="class">sb-statbar-right</xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<img src="/images/blank.gif" width="3" height="9"/>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="REQUIRED-FIELDS">
		<span class="sb-asterix">*</span>&#160;<span class="hint"><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/REQUIRED-FIELDS"/></span>
	</xsl:template>

	<xsl:template match="WYSIWYG">
		<xsl:param name="titleStyle"/>
		<xsl:param name="controlEnvStyle"/>
		<xsl:param name="titleClass"/>
		<xsl:param name="descriptionClass">sb-text-pale</xsl:param>
		<xsl:param name="title" select="@TITLE"/>
		<xsl:param name="value" select="CONTENT"/>
		<xsl:param name="name" select="@NAME"/>
		<xsl:param name="require" select="@REQUIRE"/>
		<xsl:param name="disabled" select="@DISABLED"/>
		<xsl:param name="rowClass"/>
		<xsl:param name="inOneRow"></xsl:param>
		<table cellspacing="0" cellpadding="0" border="0" style="width:100%;">
			<tr>
				<xsl:attribute name="class"><xsl:value-of select="$rowClass"/></xsl:attribute>
				<td>
					<xsl:if test="$titleClass != ''">
						<xsl:attribute name="class"><xsl:value-of select="$titleClass"/></xsl:attribute>
					</xsl:if>
					<xsl:call-template name="CONTROL-WIDTH">
						<xsl:with-param name="inOneRow" select="$inOneRow"/>
						<xsl:with-param name="titleStyle" select="$titleStyle"/>
					</xsl:call-template>
					<xsl:value-of select="$title"/>
					<xsl:if test="$require = 'on'">
						<span><xsl:attribute name="style">color:Red; width: 10px;<xsl:if test="$value != ''">display:none;</xsl:if></xsl:attribute><xsl:attribute name="id"><xsl:choose>
							<xsl:when test="$id"><xsl:value-of select="$id"/></xsl:when>
							<xsl:when test="@ID"><xsl:value-of select="@ID"/></xsl:when>
							<xsl:when test="$name"><xsl:value-of select="$name"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="@NAME"/></xsl:otherwise>
						</xsl:choose>_asterix</xsl:attribute>&#160;*</span>
					</xsl:if>
				</td>
				<td>
					<xsl:call-template name="CONTROL-ENV-WIDTH">
						<xsl:with-param name="inOneRow" select="$inOneRow"/>
						<xsl:with-param name="controlEnvStyle" select="$controlEnvStyle"/>
					</xsl:call-template>
					<xsl:apply-templates select="."/>
					<xsl:if test="$inOneRow = '' and @DESCRIPTION">
						<div class="{$descriptionClass}"><xsl:value-of select="@DESCRIPTION"/></div>
					</xsl:if>
				</td>
				<xsl:if test="$inOneRow and @DESCRIPTION">
					<td style="width: 40%;">
						<div class="{$descriptionClass}"><xsl:value-of select="@DESCRIPTION"/></div>
					</td>
				</xsl:if>
			</tr>
		</table>
	</xsl:template>
</xsl:stylesheet>