<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:strip-space elements="*"/>
	<xsl:output method="html" indent="yes" encoding="utf-8"/>

	<xsl:template match="PANEL[@TYPE='LOGIN']">
		<script type="text/javascript" src="/js/Login.js?{$version}.{$build}"/>

		<form name="loginForm" method="post" id="loginForm" onsubmit="javascript:return validateForm();">
			<xsl:attribute name="action"><xsl:value-of select="@ACTION"/></xsl:attribute>

			<input type="hidden" name="byChangeLocale"/>
			<table cellspacing="0" class="admin-contentbar-container">
				<tr>
					<td class="admin-content-area" style="text-align: center; background-color: transparent;;">
						<table cellspacing="0" class="login-container">
							<tr>
								<td class="login-header-area">
									<span><xsl:value-of select="@TITLE"/></span>
								</td>
							</tr>
							<tr>
								<td class="login-content-area">		
									<xsl:if test="../../STATUS">
										<xsl:apply-templates select="../../STATUS" mode="admin"/>
									</xsl:if>
									<div><xsl:value-of select="@DESCRIPTION"/></div>
									<div class="form-spacer"></div>
									<table cellpadding="0" cellspacing="0" border="0" class="control-title-input">
										<xsl:call-template name="LOGIN-FORM-ROW">
											<xsl:with-param name="name">username</xsl:with-param>
											<xsl:with-param name="tabindex">1</xsl:with-param>
										</xsl:call-template>
										<xsl:call-template name="LOGIN-FORM-ROW">
											<xsl:with-param name="name">password</xsl:with-param>
											<xsl:with-param name="type">password</xsl:with-param>
										</xsl:call-template>
										<xsl:call-template name="LOGIN-FORM-ROW">
											<xsl:with-param name="name">interfaceLanguage</xsl:with-param>
											<xsl:with-param name="onchange">chLocale();</xsl:with-param>
										</xsl:call-template>
									</table>
									<table cellspacing="0" class="login-tools-container">
										<tr>
											<td class="login-tools-link-area">
												<a class="sb-login-description">
													<xsl:attribute name='href'><xsl:value-of select="$baseUrl"/>/ForgetPassword</xsl:attribute>
													<xsl:value-of select="FORGOT-PASSWORD/@TITLE"/>
												</a>
											</td>
											<td class="login-tools-button-area">
												<xsl:apply-templates select="CONTROL[@TYPE='BUTTON']">
													<xsl:with-param name="class">sb-login-control-button</xsl:with-param>
													<xsl:with-param name="action">javascript:validateForm();</xsl:with-param>
												</xsl:apply-templates>

												<!-- input image needed for work default submit via Enter -->
												<input type="image" style="border-width: 0px; height: 0px; width: 0px;"/>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>						
						<xsl:if test="VZ[.='1']">
							<div class="login-footer-block">
								<span>Powered by</span>&#160;<a href="http://www.parallels.com/products/virtuozzo/" target="_blank">Parallels Virtuozzo Containers</a>&#160;<sup>TM</sup>
							</div>
						</xsl:if>
					</td>
				</tr>
			</table>
		</form>
		<script language="javascript">
			function chLocale() {
				if (0 != document.forms.loginForm.interfaceLanguage.value) {
					document.forms.loginForm.byChangeLocale.value=1;
					document.forms.loginForm.submit();
				}
			}
		</script>
	</xsl:template>

	<xsl:template name="LOGIN-FORM-ROW">
			<xsl:param name="name"/>
			<xsl:param name="onchange"/>
			<xsl:param name="tabindex"/>
			<xsl:param name="type" select="CONTROL[@NAME=$name]/@TYPE"/>

			<xsl:variable name="node" select="CONTROL[@NAME=$name]"/>
			
			<xsl:if test="not(CONTROL[@NAME=$name]/@HIDDEN) or CONTROL[@NAME=$name]/@HIDDEN=false or CONTROL[@NAME=$name]/@HIDDEN = 0">
			<tr>
				<td class="title-block">
					<xsl:apply-templates select="$node" mode="label"/>
				</td>
				<td class="input-block">
					<xsl:apply-templates select="CONTROL[@NAME=$name]" mode="control">
						<xsl:with-param name="onchange"><xsl:value-of select="$onchange"/></xsl:with-param>
						<xsl:with-param name="tabindex"><xsl:value-of select="$tabindex"/></xsl:with-param>
						<xsl:with-param name="type" select="$type"/>
					</xsl:apply-templates>
				</td>
			</tr>
			</xsl:if>
	</xsl:template>

	<xsl:template match="SITEBUILDER-PAGE">
		<table cellpadding="0" cellspacing="0" border="0" style="width: 100%; height: 100%">
			<tr>
				<td class="sb-adminpanel-header">
					<xsl:if test="NAVIGATION">
						<xsl:attribute name="colspan">2</xsl:attribute>
					</xsl:if>
					<xsl:call-template name="TOP-HEADER"/>
				</td>
			</tr>
			<tr><td valign="top" class="sb-page" style="background:#3080BB url({$skinPath}/images/bg_main_login.jpg) no-repeat scroll 50% 100%;"><xsl:apply-templates select="VIEW-CONTENT/PANEL"/></td></tr>
		</table>

		<script language="javascript">
			RegisterOnloadAction('elem = document.getElementById(\'username\');if(elem) elem.focus();');
		</script>
	</xsl:template>


	<xsl:template name="MAIN-PAGE-CONTENT">
		<tr>
			<td valign="top">
				<xsl:apply-templates select="VIEW-CONTENT"/>
			</td>
		</tr>
	</xsl:template>

	<xsl:template name="MAIN-PAGE-FOOTER">
		<!-- Nothing to do in PAGE-FOOTER -->
	</xsl:template>

</xsl:stylesheet>
