<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:strip-space elements="*"/>
	<xsl:output method="html" indent="yes" encoding="utf-8"/>

	<xsl:template match="DELEGATED-CONTENT">
		<xsl:param name="additionalContent" />
		<xsl:param name="status" />

		<script type="text/javascript" src="/js/SSO/Login.js?{$version}.{$build}"/>

		<form name="loginForm" action="{@ACTION}" method="post" id="loginForm" onsubmit="javascript:return validateForm();">

			<!-- render any additional content required by the specification -->
			<xsl:apply-templates select="$additionalContent" />

			<input type="hidden" name="byChangeLocale"/>
			<table width="100%" border="0">
				<tr>
					<td align="center" style="padding-top: 40px" >
						<table cellspacing="0" cellpadding="0" border="0" class="sb-logintable">
							<tr><td class="sb-logintitle" colspan="2"><xsl:value-of select="@TITLE"/></td></tr>
							<xsl:if test="$status">
								<tr>
									<td>
										<xsl:apply-templates select="$status" mode="admin">
											<xsl:with-param name="controlStyle">padding: 10px 10px 0px 10px;</xsl:with-param>
										</xsl:apply-templates>
									</td>
								</tr>
							</xsl:if>
							<tr class="login-content-area">
								<td style="padding: 10px 10px 10px 10px;">
									<table width="100%" border="0">
										<tr>
											<td colspan="2" class="sb-login-description"><xsl:value-of select="@DESCRIPTION"/></td>
										</tr>
										<tr>
											<td class="sb-login-control-title">
												<xsl:apply-templates select="CONTROL[@NAME='user_name']" mode="label"></xsl:apply-templates>
											</td>
											<td>
												<xsl:apply-templates select="CONTROL[@NAME='user_name']" mode="control">
													<xsl:with-param name="tabindex">1</xsl:with-param>
												</xsl:apply-templates>
											</td>
										</tr>
										<tr>
											<td class="sb-login-control-title">
												<xsl:apply-templates select="CONTROL[@NAME='user_password']" mode="label"></xsl:apply-templates>
											</td>
											<td>
												<xsl:apply-templates select="CONTROL[@NAME='user_password']" mode="control">
													<xsl:with-param name="tabindex">2</xsl:with-param>
													<xsl:with-param name="type">password</xsl:with-param>
												</xsl:apply-templates>
											</td>
										</tr>
										<tr>
											<td class="sb-login-control-title">
												<xsl:apply-templates select="CONTROL[@TYPE='COMBO-BOX']" mode="label"></xsl:apply-templates>
											</td>
											<td>
												<xsl:apply-templates select="CONTROL[@TYPE='COMBO-BOX']" mode="control">
												</xsl:apply-templates>
											</td>
										</tr>
										<tr>
											<td>
												<a class="sb-login-description">
													<xsl:attribute name='href'><xsl:value-of select="$baseUrl"/>/ForgetPassword</xsl:attribute>
													<xsl:value-of select="FORGOT-PASSWORD/@TITLE"/>
												</a>
											</td>

											<td align="right" style="padding-top: 5px;">

												<xsl:apply-templates select="CONTROL[@TYPE='BUTTON']">
													<xsl:with-param name="class">sb-login-control-button</xsl:with-param>
													<xsl:with-param name="action">javascript:validateForm();</xsl:with-param>
												</xsl:apply-templates>

												<!-- input image needed for work default submit via Enter -->
												<input type="image" style="border-width: 0px; height: 0px; width: 0px;"/>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
						<xsl:if test="VZ[.='1']">
							<div style="width:453px; text-align: center; padding-top: 8px;">
								<div align="right" class="sb-powered-virtuozzo">Powered by <a href="http://www.parallels.com/products/virtuozzo/" target="_blank">Parallels Virtuozzo Containers</a> <sup>TM</sup></div>
							</div>
						</xsl:if>
					</td>
				</tr>
			</table>
		</form>
	</xsl:template>
</xsl:stylesheet>
