<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:strip-space elements="*"/>
	<xsl:output method="html" indent="yes" encoding="utf-8"/>

	<xsl:template match="VIEW-CONTENT">

		<xsl:apply-templates select="STEP-DESIGN/CUSTOM"/>

		<script src='/js/Wizard/Design.js?{$version}.{$build}' type='text/javascript'></script>
		<script type="text/javascript">
			function checkBrowserSize() {checkSize('This window size is too small for this application. Correct work is not guaranteed.');}attachCheckToResize();sb_design=new SB_Design('<xsl:value-of select="/SITEBUILDER-PAGE/VIEW-CONTENT/STEP-DESIGN/TEMPLATES-LIST/@URL"/>');
			RegisterOnloadAction('resizeDivContent()');
		</script>
		<xsl:apply-templates select="STEP-DESIGN"/>
		<script type="text/javascript">
			<!-- sb_design.save(); -->
			<xsl:choose>
				<xsl:when test="STEP-DESIGN/TEMPLATES-LIST/TEMPLATE[@SELECTED='1']">
					<xsl:apply-templates select="STEP-DESIGN/TEMPLATES-LIST/TEMPLATE[@SELECTED='1'][1]" mode="selected"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates select="STEP-DESIGN/TEMPLATES-LIST/TEMPLATE[VISIBLE='1'][1]" mode="set"/>
				</xsl:otherwise>
			</xsl:choose>
		</script>
	</xsl:template>

	<xsl:template match="TEMPLATE" mode="selected">
		<xsl:text>addEvent(window,'resize',resizeDivContent);</xsl:text>
		<xsl:apply-templates select="." mode="set"/>
	</xsl:template>

	<xsl:template match="TEMPLATE" mode="set">
		sb_design.selectTemplate(
			'<xsl:value-of select="@CODE"/>'
			, '<xsl:value-of select="COLOR-SCHEMES/@SELECTED"/>'
			, '<xsl:value-of select="COLOR-SCHEMES"/>'
			, 'icon_selected.gif'
			, '<xsl:value-of select="@LOGO"/>'
			, '<xsl:value-of select="HEADERS/@SELECTED"/>'
			, '<xsl:value-of select="HEADERS"/>'
			, '<xsl:value-of select="BUTTONS/@SELECTED"/>'
			, '<xsl:value-of select="BUTTONS"/>'
			, '<xsl:value-of select="@CATEGORY"/>'
			, '<xsl:value-of select="@KEYWORDS"/>'
			,
				<xsl:choose>
					<xsl:when test="HEADERS/@HEADER-UPLOAD-SUPPORT=1">customHeaders, true</xsl:when>
					<xsl:otherwise>new Array(), false</xsl:otherwise>
				</xsl:choose>
			, customLogo
		);
	</xsl:template>

	<xsl:template match="TEMPLATE" mode="reset" name="selectNewTemplate">
		sb_design.selectNewTemplate(
			'<xsl:value-of select="@CODE"/>'
			, '<xsl:value-of select="COLOR-SCHEMES/@SELECTED"/>'
			, '<xsl:value-of select="COLOR-SCHEMES"/>'
			, 'icon_selected.gif'
			, '<xsl:value-of select="@LOGO"/>'
			, '<xsl:value-of select="HEADERS"/>'
			, '<xsl:value-of select="BUTTONS"/>'
			, '<xsl:value-of select="@CATEGORY"/>'
			, '<xsl:value-of select="@KEYWORDS"/>'
			,
				<xsl:choose>
					<xsl:when test="HEADERS/@HEADER-UPLOAD-SUPPORT=1">customHeaders, true</xsl:when>
					<xsl:otherwise>new Array(), false</xsl:otherwise>
				</xsl:choose>
			, customLogo
		);
	</xsl:template>

	<xsl:template match="TEMPLATE[@VISIBLE='1']" mode="choosing">
		<span style="padding: 5px; float: left; width: 130px;">
			<table cellspacing="0" cellpadding="0" border="0" align="center" style="cursor: pointer;">
				<xsl:attribute name="onclick">
					<xsl:call-template name="selectNewTemplate" mode="reset"/>
					<xsl:text>return false;</xsl:text>
				</xsl:attribute>
				<tr>
					<td valign="top" align="center" style="border: 1px solid rgb(204, 204, 204);">
						<xsl:attribute name="id">template_<xsl:value-of select="@CODE"/></xsl:attribute>
						<table cellspacing="0" cellpadding="0">
							<tr>
								<td valign="top" align="center" style="padding: 5px 5px 10px;">
									<xsl:variable name="colorScheme"><xsl:value-of select="COLOR-SCHEMES/@DEFAULT"/></xsl:variable>
<!--									<xsl:if test="COLOR-SCHEMES/@SELECTED = '1'">
										<xsl:variable name="colorScheme"><xsl:value-of select="COLOR-SCHEMES/@SELECTED"/></xsl:variable>
									</xsl:if> -->
									<img style="border-width: 0px; height: 89px; width: 118px;">
										<xsl:attribute name="src"><xsl:value-of select="../../TEMPLATES-LIST/@URL"/>/<xsl:value-of select="@CODE"/>/<xsl:value-of select="$colorScheme"/>/icon.gif</xsl:attribute>
									</img>
								</td>
							</tr>
							<tr>
								<td valign="top" align="left" style="padding-left: 5px; padding-right: 5px; padding-bottom: 10px; white-space: nowrap;">
									<div style="width: 118px; overflow: hidden;">
										<b class="sb-text"><xsl:value-of select="../../TEMPLATES-LIST/LOCALES/TEMPLATE-ID"/>:</b>
										<span class="sb-text" style="padding-left: 5px;">
											<xsl:choose>
												<xsl:when test='string-length(@CODE) &gt; 17'>
													<xsl:value-of select="substring(@CODE,1,15)"/>..
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="@CODE"/>
												</xsl:otherwise>
											</xsl:choose>
										</span>
									</div>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</span>
	</xsl:template>

	<xsl:template name="BOTTOM-SEPARATOR">
		<div class="sb-wizard-content-settings-separator"><span></span></div>
	</xsl:template>

	<xsl:template match="TEMPLATE-HEADERS">
		<input type="hidden" name="headersList_hidden" id="headersList_hidden" value="false"/>
		<table cellpadding="0" cellspacing="0" border="0" class="sb-wizard-content-settings-banners" id="headersList">
			<tr>
				<td class="sb-wizard-content-settings-banners-thumbnails">
					<table cellpadding="0" cellspacing="0" id="headerSelectionCombobox" class="sb-wizard-content-settings-banners-thumbnails-block" onclick="sb_design.showHeadersList(document.getElementById('headersList'));">
						<tr>
							<td class="sb-wizard-content-settings-banners-thumbnails-current">
								<table cellspacing="0" cellpadding="0" border="0" style="width:100%;border-collapse:collapse;">
									<tr>
										<td align="center" id="selectedHeader" valign="middle" style="background-color:White;width:100%;">
											&#160;
										</td>
									</tr>
								</table>
							</td>
							<td class="sb-wizard-content-settings-banners-thumbnails-drop">
								<img src="{$skinPath}/images/DropDownMiddle.gif" style="border-width:0px;" /></td>
						</tr>
						<tr>
							<td>
								<div id="headersList_popup" class="sb-wizard-content-settings-banners-thumbnails-alternative"></div>
							</td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td class="sb-wizard-content-settings-banners-upload">
					<table cellpadding="0" cellspacing="0" border="0" class="sb-wizard-content-settings-banners-upload-block">
						<tr>
							<td class="sb-wizard-content-settings-banners-upload-input-block">
								<xsl:call-template name="INPUT" mode="control">
									<xsl:with-param name="disabled">
										<xsl:if test="@UPLOAD-SUPPORT != '1'">1</xsl:if>
									</xsl:with-param>
									<xsl:with-param name="id">customHeader</xsl:with-param>
									<xsl:with-param name="name">customHeader</xsl:with-param>
									<xsl:with-param name="size">17</xsl:with-param>
									<xsl:with-param name="type">file</xsl:with-param>
								</xsl:call-template>
							</td>
							<td class="sb-wizard-content-settings-banners-upload-button-block">
								<xsl:variable name="headerUploadButtonStyle">
									<xsl:choose>
										<xsl:when test="@UPLOAD-SUPPORT != '1'">width: 70px; filter: gray alpha(opacity=40); -moz-opacity: 0.4; opacity: 0.4;</xsl:when>
										<xsl:otherwise>width: 70px; cursor: pointer;</xsl:otherwise>
									</xsl:choose>
								</xsl:variable>

								<xsl:variable name="headerUploadButtonAction">
									<xsl:if test="@UPLOAD-SUPPORT = '1'">sb_design.submitHeaderUploadForm('customHeader');</xsl:if>
								</xsl:variable>

								<xsl:call-template name="BUTTON-CONTROL">
									<xsl:with-param name="id">headerUploadButton</xsl:with-param>
									<xsl:with-param name="action"><xsl:value-of select="$headerUploadButtonAction"/></xsl:with-param>
									<xsl:with-param name="title"><xsl:value-of select="//TEMPLATES-LIST/LOCALES/UPLOAD-BTN-TITLE"/></xsl:with-param>
									<xsl:with-param name="style"><xsl:value-of select="$headerUploadButtonStyle"/></xsl:with-param>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template match="TEMPLATE-LOGO">
		<table cellpadding="0" cellspacing="0" border="0" class="sb-wizard-content-settings-logo">
	    	<tr>
	        	<td class="sb-wizard-content-settings-logo-control">
	            	<table cellspacing="0" cellpadding="0" border="0" class="sb-wizard-content-settings-logo-control-block">
	                	<tr>
							<td class="sb-wizard-content-settings-logo-control-thumbnail">
								<table cellpadding="0" cellspacing="0" border="0" class="sb-wizard-content-settings-logo-control-thumbnail-block" style="width: 55px;">
									<tr>
										<td id="templateLogo" class="sb-wizard-content-settings-logo-control-thumbnail-block-inner" style="height: 53px;"></td>
									</tr>
								</table>
							</td>
	                    	<td class="sb-wizard-content-settings-logo-control-restore">
								<input type="hidden" name="isLogoReseted" id="isLogoReseted" value="no"/>
								<xsl:call-template name="BUTTON-CONTROL">
									<xsl:with-param name="action">sb_design.setDefaultLogo();</xsl:with-param>
									<xsl:with-param name="title"><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/LOGO-RESTORE"/></xsl:with-param>
									<xsl:with-param name="style">width: 70px;</xsl:with-param>
									<xsl:with-param name="class">sb-button sb-wizard-content-settings-logo-control-restore</xsl:with-param>
								</xsl:call-template>
	                    	</td>
	                    	<td class="sb-wizard-content-settings-logo-control-clear">
	                    		<input type="hidden" name="isLogoDeleted" id="isLogoDeleted" value="no"/>
								<xsl:call-template name="BUTTON-CONTROL">
									<xsl:with-param name="action">sb_design.setEmptyLogo();</xsl:with-param>
									<xsl:with-param name="title"><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/LOGO-CLEAR"/></xsl:with-param>
									<xsl:with-param name="style">width: 70px; cursor: pointer;</xsl:with-param>
								</xsl:call-template>
	                    	</td>
	                	</tr>
	            	</table>
	        	</td>
	    	</tr>
	    	<tr>
	        	<td class="sb-wizard-content-settings-logo-upload">
	            	<table cellspacing="0" cellpadding="0" class="sb-wizard-content-settings-logo-upload-block">
	                	<tr>
	                    	<td class="sb-wizard-content-settings-logo-upload-input-block">
								<xsl:call-template name="INPUT" mode="control">
									<xsl:with-param name="id">customLogo</xsl:with-param>
									<xsl:with-param name="name">customLogo</xsl:with-param>
									<xsl:with-param name="size">17</xsl:with-param>
									<xsl:with-param name="type">file</xsl:with-param>
								</xsl:call-template>
	                        </td>
	                    	<td class="sb-wizard-content-settings-logo-upload-button-block">
								<xsl:call-template name="BUTTON-CONTROL">
									<xsl:with-param name="action">sb_design.submitLogoUploadForm('customLogo');</xsl:with-param>
									<xsl:with-param name="title"><xsl:value-of select="//TEMPLATES-LIST/LOCALES/UPLOAD-BTN-TITLE"/></xsl:with-param>
									<xsl:with-param name="style">width: 70px; cursor: pointer;</xsl:with-param>
								</xsl:call-template>
	                    	</td>
	                	</tr>
	            	</table>
	        	</td>
	    	</tr>
		</table>
	</xsl:template>


	<xsl:template match="TEMPLATE-SITEINFO">
		<table cellpadding="0" cellspacing="0" border="0" class="control-float-title-input">
	        <tr>
	            <td class="sb-wizard-content-settings-fields">
	                <table cellpadding="2" cellspacing="0" class="sb-wizard-content-settings-fields-block">
						<xsl:call-template name="TEMPLATE-SITEINFO-FORM-ROW">
							<xsl:with-param name="name">companyName</xsl:with-param>
							<xsl:with-param name="value" select="/SITEBUILDER-PAGE/VIEW-CONTENT//STEP-DESIGN/COMPANY/@NAME"/>
							<xsl:with-param name="title" select="@COMPANY-NAME"/>
						</xsl:call-template>
						<xsl:call-template name="TEMPLATE-SITEINFO-FORM-ROW">
							<xsl:with-param name="name">companySlogan</xsl:with-param>
							<xsl:with-param name="value" select="/SITEBUILDER-PAGE/VIEW-CONTENT//STEP-DESIGN/COMPANY/@SLOGAN"/>
							<xsl:with-param name="title" select="/SITEBUILDER-PAGE/LOCALE/SITE-INFO-SLOGAN"/>
						</xsl:call-template>
						<xsl:call-template name="TEMPLATE-SITEINFO-FORM-ROW">
							<xsl:with-param name="name">copyright</xsl:with-param>
							<xsl:with-param name="value" select="/SITEBUILDER-PAGE/VIEW-CONTENT/STEP-DESIGN/COMPANY/@COPYRIGHT"/>
							<xsl:with-param name="title" select="/SITEBUILDER-PAGE/LOCALE/SITE-INFO-COPYRIGHT"/>
						</xsl:call-template>
	                </table>
	            </td>
	        </tr>
		</table>
	</xsl:template>

	<xsl:template name="TEMPLATE-SITEINFO-FORM-ROW">
			<xsl:param name="name"/>
			<xsl:param name="value"/>
			<xsl:param name="title"/>
			<xsl:param name="onchange">self.sbApplyChangesObject.registerChange(); self.sbApplyChangesObject.registerForcedSaving();</xsl:param>

			<tr>
				<td class="title-block">
					<xsl:call-template name="LABEL" mode="label">
						<xsl:with-param name="id" select="$name"/>
						<xsl:with-param name="title" select="$title"/>
					</xsl:call-template>
				</td>
				<td class="input-block">
					<xsl:call-template name="INPUT" mode="control">
						<xsl:with-param name="id"><xsl:value-of select="$name"/></xsl:with-param>
						<xsl:with-param name="name"><xsl:value-of select="$name"/></xsl:with-param>
						<xsl:with-param name="onchange"><xsl:value-of select="$onchange"/></xsl:with-param>
						<xsl:with-param name="value"><xsl:value-of select="$value"/></xsl:with-param>
					</xsl:call-template>
				</td>
			</tr>
	</xsl:template>

	<xsl:template match="FOTOLIA">
		<table cellpadding="0" cellspacing="0" border="0" class="sb-wizard-content-settings-buy">
		<xsl:attribute name="onclick">
			javascript:window.open('<xsl:value-of select="@URL"/>', '_blank'); return false;
		</xsl:attribute>
			<tr>
				<td class="sb-wizard-content-settings-buy-inner">
					<a href="#" class="sb-wizard-content-settings-buy-link">
						<img src="{$skinPath}/icons/s_fotolia.png" alt="" border="0" align="absmiddle"/><span class="sb-text sb-wizard-content-settings-buy-text"><xsl:value-of select="@TITLE"/></span>
					</a>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template match="TEMPLATE-BUTTONS">
		<span id="buttonsList"></span>
 	</xsl:template>

	<xsl:template match="TEMPLATE-COLOR-SCHEMES">
		<span id="colorSchemesList"></span>
	</xsl:template>

	<xsl:template match="TEMPLATE-CONTENT">
		<xsl:for-each select="*">
			<div class="sb-wizard-content-settings-title"><span class="sb-wizard-content-settings-title-text"><xsl:value-of select="."/></span></div>
			<xsl:apply-templates select="."/>
			<xsl:if test="position()!=last()">
		 		<xsl:call-template name="BOTTOM-SEPARATOR"/>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>

	<xsl:template match="STEP-DESIGN">
		<table border="0" cellpadding="0" cellspacing="0" class="sb-wizard-content-block">
			<tr>
				<td class="sb-wizard-content-templates">
		            <table cellpadding="0" cellspacing="0" border="0" class="sb-wizard-content-templates-block">
						<tr>
							<td class="sb-wizard-content-templates-categories">
								<xsl:call-template name="TOP-TOOLBAR"/>
							</td>
						</tr>
						<tr>
							<td class="sb-wizard-content-templates-thumbnails" id="outerTemplateListContainer">
								<input type="hidden" value="divTemplateList,190" name="inputResizeOption" id="inputResizeOption"/>
								<div style="overflow: auto; width: 100%; height: 423px;" id="divTemplateList">
									<span style="width: 100%;">
										<xsl:call-template name="ACTIVE-TEMPLATE"/>
										<xsl:apply-templates select="TEMPLATES-LIST"/>
									</span>
								</div>
							</td>
						</tr>
		                <tr>
		                  <td class="sb-wizard-content-templates-pager">
							<xsl:call-template name="PAGER-PANEL"/>
							</td>
						</tr>
					</table>
				</td>
				<td class="sb-wizard-content-settings">
					<table cellpadding="0" cellspacing="0" border="0" class="sb-wizard-content-settings-block">
						<tr>
							<td class="sb-wizard-content-settings-block-inner">
								<xsl:apply-templates select="TEMPLATE-CONTENT"/>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="PAGE-NAVIGATION-BUTTON">
		<xsl:param name="title"/>
		<xsl:param name="style"/>
		<xsl:param name="action" select="''"/>
		<xsl:call-template name="BUTTON-CONTROL">
			<xsl:with-param name="title" select="$title"/>
			<xsl:with-param name="style" select="$style"/>
			<xsl:with-param name="action" select="$action"/>
		</xsl:call-template>
	</xsl:template>

	<xsl:template match="TEMPLATES-LIST/@*[.&gt;=1]" mode="pageNavigationButton">
		<xsl:param name="title"/>
		<xsl:call-template name="PAGE-NAVIGATION-BUTTON">
			<xsl:with-param name="title" select="$title"/>
			<xsl:with-param name="action">sb_design.goToPage(<xsl:value-of select="."/>);</xsl:with-param>
			<xsl:with-param name="style">width: 60px; cursor: pointer;</xsl:with-param>
		</xsl:call-template>
	</xsl:template>

	<xsl:template match="TEMPLATES-LIST/@*[.&lt;1]" mode="pageNavigationButton">
		<xsl:param name="title"/>
		<xsl:call-template name="PAGE-NAVIGATION-BUTTON">
			<xsl:with-param name="title" select="$title"/>
			<xsl:with-param name="style">width: 60px; opacity: 0.4; cursor: default;</xsl:with-param>
		</xsl:call-template>
	</xsl:template>

	<xsl:template name="PAGER-PANEL">
		<xsl:variable name="pageCount" select="/SITEBUILDER-PAGE/VIEW-CONTENT/STEP-DESIGN/TEMPLATES-LIST/@PAGES-COUNT" />
			<table cellspacing="0" cellpadding="0" border="0" class="sb-wizard-content-templates-pager-block">
				<tr>
					<td>
						<xsl:value-of select="TEMPLATES-LIST/LOCALES/TEMPLATES-PER-PAGE"/>&#160;

						<a href="#" onclick="sb_design.changeTemplatesPerPage(11);" class="sb-pager-link">11</a>&#160;
						<a href="#" onclick="sb_design.changeTemplatesPerPage(26);" class="sb-pager-link">26</a>&#160;
						<a href="#" onclick="sb_design.changeTemplatesPerPage(50);" class="sb-pager-link">50</a>&#160;
						<a href="#" onclick="sb_design.changeTemplatesPerPage(sb_design.getBestFitTemplatesNumber());" class="sb-pager-link"><xsl:value-of select="TEMPLATES-LIST/LOCALES/TEMPLATES-BEST-FIT"/></a>
					</td>
					<td>
					  <div class="sb-wizard-content-templates-pager-separator"><span></span></div>
					</td>
					<td>
						<xsl:apply-templates select="/SITEBUILDER-PAGE/VIEW-CONTENT/STEP-DESIGN/TEMPLATES-LIST/@PREVIOUS-PAGE" mode="pageNavigationButton">
							<xsl:with-param name="title">&lt;</xsl:with-param>
						</xsl:apply-templates>
					</td>
					<td>
						<span class="sb-wizard-content-templates-pager-page-text"><xsl:value-of select="TEMPLATES-LIST/LOCALES/PAGE-OF"/></span>
					</td>
					<td>
						<xsl:apply-templates select="/SITEBUILDER-PAGE/VIEW-CONTENT/STEP-DESIGN/TEMPLATES-LIST/@NEXT-PAGE" mode="pageNavigationButton">
							<xsl:with-param name="title">&gt;</xsl:with-param>
						</xsl:apply-templates>
					</td>
					<td>
					  <div class="sb-wizard-content-templates-pager-separator"><span></span></div>
					</td>
					<td>
						<span class="sb-wizard-content-templates-pager-go-text"><xsl:value-of select="TEMPLATES-LIST/LOCALES/GO-TO-PAGE"/></span>
						<input type="text" class="sb-input sb-wizard-content-templates-pager-input" size="2" id="goToPage">
							<xsl:if test="$pageCount &lt;= 1">
								<xsl:attribute name="disabled">true</xsl:attribute>
							</xsl:if>
						</input>
						<span style="color: Red; visibility: hidden;"/>
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="$pageCount &gt; 1">
								<xsl:call-template name="BUTTON-CONTROL">
									<xsl:with-param name="action">sb_design.validateAndGoToPage(document.getElementById('goToPage').value, <xsl:value-of select="$pageCount" />);</xsl:with-param>
									<xsl:with-param name="style">width: 60px; cursor: pointer;</xsl:with-param>
									<xsl:with-param name="title">
										<xsl:value-of select="TEMPLATES-LIST/LOCALES/GO-BTN-TITLE"/>
									</xsl:with-param>
								</xsl:call-template>
								<script type="text/javascript" language="javascript">
									<xsl:comment>
										sb_design.prepareGoToPageInput(<xsl:value-of select="$pageCount" />);
									//</xsl:comment>
								</script>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="BUTTON-CONTROL">
									<xsl:with-param name="style">width: 60px; opacity: 0.4; cursor: default;</xsl:with-param>
									<xsl:with-param name="title">
										<xsl:value-of select="TEMPLATES-LIST/LOCALES/GO-BTN-TITLE"/>
									</xsl:with-param>
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
					</td>
				</tr>
			</table>
	</xsl:template>

	<xsl:template name="TOP-TOOLBAR">
		<table cellpadding="0" cellspacing="0" border="0" class="sb-wizard-content-templates-categories-block">
		  <tr>
			<xsl:apply-templates select="SELECT-CATEGORY"/>
			<td>
			  <div class="sb-wizard-content-templates-categories-category-separator"><span></span></div>
			</td>
			<td><span class="sb-wizard-content-templates-categories-search-text"><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/DESIGN-SEARCH"/></span></td>
			<td>
				<xsl:call-template name="INPUT" mode="control">
					<xsl:with-param name="id">search</xsl:with-param>
					<xsl:with-param name="name">search</xsl:with-param>
					<xsl:with-param name="size">60</xsl:with-param>
					<xsl:with-param name="value" select="/SITEBUILDER-PAGE/VIEW-CONTENT/STEP-DESIGN/TEMPLATES-LIST/@SEARCH"/>
				</xsl:call-template>
				<script type="text/javascript" language="javascript">
					<xsl:comment>
						sb_design.prepareSearchInput();
					//</xsl:comment>
				</script>
			</td>
			<td>
				<xsl:call-template name="BUTTON-CONTROL">
					<xsl:with-param name="title" select="/SITEBUILDER-PAGE/LOCALE/DESIGN-GO"/>
					<xsl:with-param name="style">width: 60px;</xsl:with-param>
					<xsl:with-param name="class">sb-wizard-content-templates-categories-search-go</xsl:with-param>
					<xsl:with-param name="action">sb_design.searchSubstring(document.getElementById('search').value);</xsl:with-param>
				</xsl:call-template>
			</td>
			<td>
				<xsl:call-template name="BUTTON-CONTROL">
					<xsl:with-param name="title" select="/SITEBUILDER-PAGE/LOCALE/DESIGN-SHOW-ALL"/>
					<xsl:with-param name="style">width: 60px;</xsl:with-param>
					<xsl:with-param name="class">sb-wizard-content-templates-categories-search-show-block</xsl:with-param>
					<xsl:with-param name="action">sb_design.showAllTemplates();</xsl:with-param>
				</xsl:call-template>
			</td>
		  </tr>
		</table>
	</xsl:template>

	<xsl:template name="ACTIVE-TEMPLATE">
		<span style="padding: 5px; float: left; width: 270px;">
			<table cellspacing="0" cellpadding="0" border="0" align="center" >
				<tr>
					<td valign="top" height="248" align="center" style="border: 1px solid #D5D5D5; border-bottom: none;">
						<table cellspacing="0" cellpadding="0" border="0">
							<tr>
								<td valign="top" align="center" style="padding: 3px 7px 2px;">
									<img border="0" id="smallPreview" style="cursor: pointer; width: 252px; height: 189px;" onclick="sb_design.previewBigIcon();"/>
								</td>
							</tr>
						</table>
						<div style="text-align: left; width: 260px; overflow: hidden;">
							<table cellspacing="0" cellpadding="0" border="0">
								<tr>
									<td align="left" valign="top" style="padding-left: 7px; padding-right: 7px; padding-bottom: 2px; ">
										<b class="sb-text"><xsl:value-of select="TEMPLATES-LIST/LOCALES/TEMPLATE-ID"/>:</b>
										<span id="labelIdContent" class="sb-text" style="padding-left: 5px;"></span>
									</td>
								</tr>
								<tr>
									<td align="left" valign="top" style="padding-left: 7px; padding-right: 7px; padding-bottom: 3px;">
										<span style="font-weight: bolder;"><xsl:value-of select="TEMPLATES-LIST/LOCALES/TEMPLATE-CATEGORY"/>:</span>
										<span id="labelCategoryContent" style="padding-left: 5px;"></span>
									</td>
								</tr>
								<tr>
									<td align="left" valign="top" style="padding-left: 7px; padding-right: 7px; padding-bottom: 2px;">
										<span style="font-weight: bolder;"><xsl:value-of select="TEMPLATES-LIST/LOCALES/TEMPLATE-KEYWORDS"/>:</span>
										<span id="labelKeywordsContent" style="padding-left: 5px;">none</span>
									</td>
								</tr>
							</table>
						</div>
					</td>
				</tr>
				<tr>
					<td align="right" valign="top">
						<table cellpadding="0" cellspacing="0" width="100%" border="0">
							<tr>
								<td><img src="{$skinPath}/images/design_button_selected_left.gif" style="border-width:0px;" /></td>
								<td width="100%" valign="middle" align="center" nowrap="true" background="{$skinPath}/images/design_button_selected_m.gif" onclick="sb_design.previewBigIcon();" class="sb-text" style="cursor:pointer; text-transform: capitalize; font-weight: bold;"><xsl:value-of select="TEMPLATES-LIST/LOCALES/PREVIEW-TEMPLATE-BUTTON-TITLE"/></td>
								<td><img src="{$skinPath}/images/design_button_selected_r.gif" style="border-width:0px;" /></td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</span>
		<input type="hidden" value="" name="activeTemplate" id="activeTemplate"/>
		<input type="hidden" value="" name="activeColorScheme" id="activeColorScheme"/>
		<input type="hidden" value="" name="activeHeader" id="activeHeader"/>
		<input type="hidden" value="" name="activeButton" id="activeButton"/>
	</xsl:template>

	<xsl:template match="TEMPLATES-LIST">
		<xsl:apply-templates select="TEMPLATE[@VISIBLE='1']" mode="choosing"/>
	</xsl:template>

	<xsl:template match="CATEGORY">
		<option value="{.}">
			<xsl:if test="@SELECTED='1'">
				<xsl:attribute name="selected">1</xsl:attribute>
			</xsl:if>
			<xsl:value-of select="@TITLE"/>
		</option>
	</xsl:template>

	<xsl:template match="SELECT-CATEGORY">
        <td><span class="sb-wizard-content-templates-categories-category-text"><xsl:value-of select="@TITLE"/></span></td>
		<td>
			<select id="category" onchange="sb_design.searchCategory(this.value);return false;">
				<xsl:apply-templates select="CATEGORY"/>
			</select>
		</td>
	</xsl:template>

	<xsl:template match="CUSTOM">
		<script language="javascript">
		customHeaderUrl = '<xsl:value-of select="HEADER/@URL"/>';
		customLogoUrl = '<xsl:value-of select="LOGO/@URL"/>';
		customHeaders = new Array(
		<xsl:for-each select="HEADER/ITEM"><xsl:if test="position() != 1">,</xsl:if>'<xsl:value-of select="."/>'</xsl:for-each>
		);
		customLogo = '<xsl:value-of select="LOGO/."/>';
		</script>
	</xsl:template>
</xsl:stylesheet>