<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:strip-space elements="*"/>
	<xsl:output method="html" indent="yes" encoding="utf-8"/>
	
	<xsl:template match="POST-FORM">
	</xsl:template>	
	
	<xsl:template match="POST-FORM" mode="initAfterBody">
		<xsl:call-template name="MODAL-FORM">
			<xsl:with-param name="formName">modalForm</xsl:with-param>
			<xsl:with-param name="formTitle" select="/SITEBUILDER-PAGE/LOCALE/FORM-TITLE"/>
			<!--<xsl:with-param name="helpHint" select="/SITEBUILDER-PAGE/LOCALE/HELP-HINT"/>-->
			<!--<xsl:with-param name="closeHint" select="@CLOSE-HINT"/>-->
			<xsl:with-param name="additionalFormStyle">width: 650px; height: 470px;</xsl:with-param>
			<xsl:with-param name="content" select="current()" />
			<xsl:with-param name="onCloseAction">sbNavigationObject.go();</xsl:with-param>
		</xsl:call-template>
	</xsl:template>	
		
	<xsl:template match="MAIN-CARD">
		<script type="text/javascript" src="/modules/Blogger/js/Post.js?{$version}.{$build}"/>
		
		<xsl:apply-templates select="CONTROL[@NAME='title']" mode="label">
			<xsl:with-param name="require">true</xsl:with-param>
		</xsl:apply-templates><br/>		
		<xsl:apply-templates select="CONTROL[@NAME='title']" mode="control">
			<xsl:with-param name="onchange">sbApplyChangesObject.registerChange();</xsl:with-param>
			<xsl:with-param name="require">true</xsl:with-param>
		</xsl:apply-templates>
		<div style="width: 0; height: 5px;"><span></span></div>
		<xsl:call-template name="LABEL" mode="label">
			<xsl:with-param name="title" select="/SITEBUILDER-PAGE/LOCALE/COMMENT"/>
		</xsl:call-template><br/>
		<xsl:apply-templates select="WYSIWYG"/>
	</xsl:template>	
	
	<xsl:template match="CATEGORIES-CARD">
		<script language="javascript">	
			function setCheckboxStatus(status) {
				var form = document.forms['SB_WizardForm'];
				for (var n = 0; n &lt; form.elements.length; n++) {
					if (form.elements[n].type == 'checkbox' &amp;&amp; form.elements[n].name=='objectIds[]') {
						if (!form.elements[n].disabled) {
							form.elements[n].checked = status;
						}
					}
				}
			}
		</script>
		<input type="hidden" name="product_category_pageNum"   value=""/>
		<input type="hidden" name="product_category_pageSize"  value=""/>
		
		<div style="overflow:auto; height:250px; margin: 0 -20px;">
			<xsl:apply-templates select="PAGED-LIST" />
		</div>
	</xsl:template>	
	
	<xsl:template match="CATEGORIES-CARD/PAGED-LIST/LIST/HEADER">
		<tr class="fixed">
			<th style="width:1%;">
				<div><input type="checkbox" name="globalCheck" onclick="setCheckboxStatus(this.checked);" class="check"/></div>
			</th>
			<th><div><xsl:value-of select="NAME"/></div></th>
		</tr> 
	</xsl:template>
	
	<xsl:template match="CATEGORIES-CARD/PAGED-LIST/LIST/ITEM">
		<xsl:variable name="class">
			<xsl:call-template name="LIST-ROW-CLASS">
				<xsl:with-param name="position"><xsl:value-of select="position()"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		
		<tr class="{$class}">
			<td style="width:1%;">
				<input type="checkbox" name="objectIds[]" class="check">
					<xsl:attribute name="value"><xsl:value-of select="ID"/></xsl:attribute>
					<xsl:if test="../../../SELECTED-CATEGORIES/CATEGORY/@ID=ID">
						<xsl:attribute name="checked">true</xsl:attribute>
					</xsl:if>
				</input>
			</td>
			
			<xsl:call-template name="LIST-ROW-ITEM">
				<xsl:with-param name="title"><xsl:value-of select="NAME"/></xsl:with-param>
			</xsl:call-template>
		</tr>
	</xsl:template>		
	
	<xsl:template match="WYSIWYG[@MODE='bloggerPost']">
		<xsl:call-template name="WYSIWYG-MODULE">
			<xsl:with-param name="config">BloggerPostForm.js</xsl:with-param>
		</xsl:call-template>
	</xsl:template>		
	
</xsl:stylesheet>	