<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:strip-space elements="*"/>
	<xsl:output method="html" indent="yes" encoding="utf-8"/>

	<xsl:template match="PRODUCT-FORM">
	</xsl:template>

	<xsl:template match="PRODUCT-FORM" mode="initAfterBody">
		<xsl:call-template name="MODAL-FORM">
			<xsl:with-param name="formName">modalForm</xsl:with-param>
			<xsl:with-param name="formTitle" select="/SITEBUILDER-PAGE/LOCALE/FORM-TITLE"/>
			<!--<xsl:with-param name="helpHint" select="/SITEBUILDER-PAGE/LOCALE/HELP-HINT"/>-->
			<!--<xsl:with-param name="closeHint" select="@CLOSE-HINT"/>-->
			<xsl:with-param name="additionalFormStyle">width: 900px; height: 640px;</xsl:with-param>
			<xsl:with-param name="content" select="current()" />
			<xsl:with-param name="onCloseAction">sbNavigationObject.go();</xsl:with-param>
		</xsl:call-template>

		<!--<xsl:call-template name="MODULE-MODAL-FORM" />-->
	</xsl:template>

	<xsl:template match="PRODUCT-FORM" mode="content">
		<script type="text/javascript" src="/modules/Eshop/js/validate.js?{$version}.{$build}"></script>
		<input type="hidden" name="productCurrentView" value="{@CURRENT-VIEW}"/>

		<xsl:apply-templates select="TAB-PANEL" />
		
		<table cellpadding="0" cellspacing="0" border="0" style="width: 100%;"><tr><td style="padding: 0 10px;">
			<xsl:call-template name="OK-CANCEL-BUTTONS">
				<xsl:with-param name="okAction">if(validateProduct()) {wizardFormSubmit();}</xsl:with-param>
				<xsl:with-param name="cancelAction">document.location.href='<xsl:value-of select="/SITEBUILDER-PAGE/APPLY-CHANGES/@VIEW-URL"/>';</xsl:with-param>
			</xsl:call-template>
		</td></tr></table>
	</xsl:template>

	<xsl:template match="MAIN-CARD">
		<input type="hidden" name="id">
			<xsl:attribute name="value"><xsl:value-of select="PRODUCT-INFO/@PRODUCT-ID"/></xsl:attribute>
		</input>
		<input type="hidden" name="image">
			<xsl:attribute name="value"><xsl:value-of select="PRODUCT-INFO/IMAGE/@FILE-PATH"/></xsl:attribute>
		</input>
		<input type="hidden" name="image_original">
			<xsl:attribute name="value"><xsl:value-of select="PRODUCT-INFO/IMAGE/@ORIG-PATH"/></xsl:attribute>
		</input>
		<table cellspacing="0" cellpadding="0" border="0" style="border-width:0px;width:100%;">
		<tr>
		<td valign="top" style="width:120px">
		<xsl:choose>
			<xsl:when test="PRODUCT-INFO/IMAGE/@FILE-PATH!=''">
				<table cellspacing="0" cellpadding="0" border="0">
				<tr>
					<td align="center">
					<a href="#">
						<xsl:attribute name="onclick">
							window.open(
								'<xsl:value-of select="PRODUCT-INFO/IMAGE/@ORIG-PATH"/>',
								'imagepreview',
								'width=<xsl:value-of select="PRODUCT-INFO/IMAGE/@ORIG-WIDTH"/>, height=<xsl:value-of select="PRODUCT-INFO/IMAGE/@ORIG-HEIGHT"/>, resizable=yes, tolbar=no, status=yes, scrollbars=yes'
							);
							return false;
						</xsl:attribute>
						<img border="0">
							<xsl:attribute name="src"><xsl:value-of select="PRODUCT-INFO/IMAGE/@FILE-PATH"/></xsl:attribute>
						</img>
					</a>
					</td>
				</tr>
				<tr>
					<td align="center" style="padding-top: 10px">
						<xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/IMAGE-DIMENSION"/>:<br/>
						<xsl:value-of select="PRODUCT-INFO/IMAGE/@ORIG-WIDTH"/>x<xsl:value-of select="PRODUCT-INFO/IMAGE/@ORIG-HEIGHT"/>
					</td>
				</tr>
				</table>
			</xsl:when>
			<xsl:otherwise>
				<img border="0" width="100" height="110">
					<xsl:attribute name="src">/modules/Eshop/images/noImage.gif</xsl:attribute>
				</img>
			</xsl:otherwise>
		</xsl:choose>
		</td>
		<td>
			<table cellpadding="0" cellspacing="0" border="0" class="control-title-input">
				<xsl:call-template name="MAIN-CARD-FORM-ROW">
					<xsl:with-param name="id">name</xsl:with-param>
					<xsl:with-param name="maxlength">50</xsl:with-param>
					<xsl:with-param name="name">name</xsl:with-param>
					<xsl:with-param name="require">true</xsl:with-param>
					<xsl:with-param name="title"><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/PRODUCT-NAME"/></xsl:with-param>
					<xsl:with-param name="value" select="PRODUCT-INFO/@NAME"/>
				</xsl:call-template>
				<tr>
					<td class="title-block">
						<xsl:call-template name="LABEL" mode="label">
							<xsl:with-param name="id">price</xsl:with-param>
							<xsl:with-param name="require">true</xsl:with-param>
							<xsl:with-param name="title"><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/PRODUCT-PRICE"/></xsl:with-param>
							<xsl:with-param name="value" select="PRODUCT-INFO/@PRICE"/>
						</xsl:call-template>
					</td>
					<td class="input-block">
						<xsl:if test="PRODUCT-INFO/@CURRENCY != ''">
							<xsl:value-of select="PRODUCT-INFO/@CURRENCY"/>&#160;
						</xsl:if>
						<xsl:call-template name="INPUT" mode="control">
							<xsl:with-param name="id">price</xsl:with-param>
							<xsl:with-param name="maxlength">50</xsl:with-param>
							<xsl:with-param name="name">price</xsl:with-param>
							<xsl:with-param name="require">true</xsl:with-param>
							<xsl:with-param name="value" select="PRODUCT-INFO/@PRICE"/>
						</xsl:call-template>
						<xsl:if test="PRODUCT-INFO/@CURRENCY-RIGHT != ''">
							&#160;<xsl:value-of select="PRODUCT-INFO/@CURRENCY-RIGHT"/>
						</xsl:if>
					</td>
				</tr>
				<xsl:call-template name="MAIN-CARD-FORM-ROW">
					<xsl:with-param name="id">inventory</xsl:with-param>
					<xsl:with-param name="maxlength">10</xsl:with-param>
					<xsl:with-param name="name">inventory</xsl:with-param>
					<xsl:with-param name="onchange">self.sbApplyChangesObject.registerChange();</xsl:with-param>
					<xsl:with-param name="require">true</xsl:with-param>
					<xsl:with-param name="size">10</xsl:with-param>
					<xsl:with-param name="title"><xsl:value-of select="PRODUCT-INFO/CONTROL[@NAME='inventory']/@TITLE"/></xsl:with-param>
					<xsl:with-param name="value" select="PRODUCT-INFO/CONTROL[@NAME='inventory']"/>
				</xsl:call-template>
				<tr>
					<td class="title-block">
						<xsl:call-template name="LABEL" mode="label">
							<xsl:with-param name="id">advertise</xsl:with-param>
							<xsl:with-param name="title" select="/SITEBUILDER-PAGE/LOCALE/PRODUCT-ADVERTISE"/>
						</xsl:call-template>
					</td>
					<td class="input-block">
						<xsl:call-template name="CHECKBOX" mode="control">
							<xsl:with-param name="id">advertise</xsl:with-param>
							<xsl:with-param name="name">advertise</xsl:with-param>
							<xsl:with-param name="checked">
								<xsl:if test="PRODUCT-INFO/@ADVERTISE = '1'">true</xsl:if>
							</xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</table>
			<table cellpadding="0" cellspacing="0" border="0">
				<tr>
					<td>
						<table cellpadding="0" cellspacing="0" border="0" class="control-title-input">
							<tr>
								<td class="title-block">
									<xsl:call-template name="LABEL" mode="label">
										<xsl:with-param name="id">image</xsl:with-param>
										<xsl:with-param name="title" select="/SITEBUILDER-PAGE/LOCALE/NEW-IMAGE"/>
									</xsl:call-template>
								</td>
								<td class="input-block">
									<input type="file" id="image" name="image" size="25" class="sb-input"/>
								</td>
							</tr>
						</table>
					</td>
					<td>
						<xsl:call-template name="BUTTON-CONTROL">
							<xsl:with-param name="title"><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/UPLOAD"/></xsl:with-param>
							<xsl:with-param name="action">setWizardFormAction("<xsl:value-of select="/SITEBUILDER-PAGE/VIEW-CONTENT/@ACTION"/>/Modules/Eshop/Product/Image/Upload");wizardFormSubmit();</xsl:with-param>
						</xsl:call-template>
					</td>
					<td class="input-block">
						<xsl:if test="PRODUCT-INFO/IMAGE/@FILE-PATH!=''">
							<input type="hidden" name="is_modified">
								<xsl:attribute name="value"><xsl:value-of select="PRODUCT-INFO/IMAGE/@IS-MODIFIED"/></xsl:attribute>
							</input>

							<xsl:call-template name="BUTTON-CONTROL">
								<xsl:with-param name="title"><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/DELETE"/></xsl:with-param>
								<xsl:with-param name="action">setWizardFormAction("<xsl:value-of select="/SITEBUILDER-PAGE/VIEW-CONTENT/@ACTION"/>/Modules/Eshop/Product/Image/Delete");wizardFormSubmit();</xsl:with-param>
								<xsl:with-param name="icon">delete.png</xsl:with-param>
							</xsl:call-template>
						</xsl:if>
					</td>
				</tr>
			</table>
			</td>
		</tr>
		<tr><td colspan="2" height="3"></td></tr>
		<tr>
			<td></td>
			<td><xsl:apply-templates select="BRIEF-DESCRIPTION" /></td>
		</tr>
		<tr><td colspan="2" height="3"></td></tr>
		<tr>
			<td></td>
			<td><xsl:apply-templates select="FULL-DESCRIPTION" /></td>
		</tr>
		</table>
	</xsl:template>

	<xsl:template name="MAIN-CARD-FORM-ROW">
			<xsl:param name="id"/>
			<xsl:param name="maxlength"/>
			<xsl:param name="name"/>
			<xsl:param name="onchange"/>
			<xsl:param name="require"/>
			<xsl:param name="size"/>
			<xsl:param name="title"/>
			<xsl:param name="value"/>

			<tr>
				<td class="title-block">
					<xsl:call-template name="LABEL" mode="label">
						<xsl:with-param name="id" select="$id"/>
						<xsl:with-param name="require" select="$require"/>
						<xsl:with-param name="title" select="$title"/>
						<xsl:with-param name="value" select="$value"/>
					</xsl:call-template>
				</td>
				<td class="input-block">
					<xsl:call-template name="INPUT" mode="control">
						<xsl:with-param name="id"><xsl:value-of select="$name"/></xsl:with-param>
						<xsl:with-param name="maxlength"><xsl:value-of select="$maxlength"/></xsl:with-param>
						<xsl:with-param name="name"><xsl:value-of select="$name"/></xsl:with-param>
						<xsl:with-param name="onchange"><xsl:value-of select="$onchange"/></xsl:with-param>
						<xsl:with-param name="require">
							<xsl:if test="$require != ''">true</xsl:if>
						</xsl:with-param>
						<xsl:with-param name="size"><xsl:value-of select="$size"/></xsl:with-param>
						<xsl:with-param name="value"><xsl:value-of select="$value"/></xsl:with-param>
					</xsl:call-template>
				</td>
			</tr>
	</xsl:template>

	<xsl:template match="BRIEF-DESCRIPTION">
		<label class="name" style="padding-left:3px;"><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/PRODUCT-BRIEF-DESCRIPTION"/></label>
		<table width="100%" border="0">
			<tr>
				<td>
					<xsl:apply-templates select="WYSIWYG" mode="product"/>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template match="FULL-DESCRIPTION">
		<label class="name" style="padding-left:3px;"><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/PRODUCT-FULL-DESCRIPTION"/></label>
		<table width="100%" border="0">
			<tr>
				<td>
					<xsl:apply-templates select="WYSIWYG" mode="product" />
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template match="WYSIWYG" mode="product">
		<xsl:call-template name="WYSIWYG-MODULE">
			<xsl:with-param name="config">EshopProductForm.js</xsl:with-param>
			<xsl:with-param name="height">135</xsl:with-param>
		</xsl:call-template>
	</xsl:template>

<!--	<xsl:template name="NO-IMAGE">
		<table style="width: 100px; height: 80px; background-color: #A4A4A4;">
			<tr>
				<td valign="middle" align="center">
					<span style="vertical-align: middle; color: #FFFFFF;"><b><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/NO-IMAGE"/></b></span>
				</td>
			</tr>
		</table>
	</xsl:template>
-->
<!--	<xsl:template match="POSITION">
		<option >
			<xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
			<xsl:if test="position()=last()">
				<xsl:attribute name="selected">true</xsl:attribute>
			</xsl:if>
			<xsl:value-of select="."/>
		</option>
	</xsl:template>
-->
	<xsl:template match="CATEGORIES-CARD">
		<script language="javascript">
			function setCheckboxStatus(status) {
				var form = document.forms['SB_WizardForm'];
				for (var n = 0; n &lt; form.elements.length; n++) {
					if (form.elements[n].type == 'checkbox' &amp;&amp; form.elements[n].name=='objectIds[]') {
						if (!form.elements[n].disabled) {
							form.elements[n].checked = status;
						}
					}
				}
			}
		</script>
		<input type="hidden" name="product_category_pageNum"   value=""/>
		<input type="hidden" name="product_category_pageSize"  value=""/>

		<div style="overflow:auto; height:365px; margin: 0 -20px;">
			<xsl:apply-templates select="PAGED-LIST" />
		</div>
	</xsl:template>

	<xsl:template match="CATEGORIES-CARD/PAGED-LIST/LIST/HEADER">
		<tr class="fixed">
			<th style="width:1%;">
				<div>
					<input type="checkbox" name="globalCheck" onclick="setCheckboxStatus(this.checked);" id="categoryCheckboxGlobal" class="check"/>
				</div>
			</th>
			<th>
				<div><label for="categoryCheckboxGlobal"><xsl:value-of select="NAME"/></label></div></th>
		</tr>
	</xsl:template>

	<xsl:template match="CATEGORIES-CARD/PAGED-LIST/LIST/ITEM">
		<xsl:variable name="class">
			<xsl:call-template name="LIST-ROW-CLASS">
				<xsl:with-param name="position"><xsl:value-of select="position()"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<tr class="{$class}">
			<td style="width:1%;">
				<input type="checkbox" name="objectIds[]" id="categoryCheckbox_{ID}" class="check">
					<xsl:attribute name="value"><xsl:value-of select="ID"/></xsl:attribute>
					<xsl:if test="../../../SELECTED-CATEGORIES/CATEGORY/@ID=ID">
						<xsl:attribute name="checked">true</xsl:attribute>
					</xsl:if>
				</input>
			</td>
			<xsl:call-template name="LIST-ROW-ITEM">
				<xsl:with-param name="title">
					<label for="categoryCheckbox_{ID}">
						<xsl:if test="LEVEL">
							<xsl:call-template name="LOOP-STRING">
								<xsl:with-param name="string">&#160;</xsl:with-param>
								<xsl:with-param name="level" select="6*LEVEL"/>
							</xsl:call-template>
						</xsl:if>
						<xsl:value-of select="NAME"/>
					</label>
				</xsl:with-param>
				<xsl:with-param name="copyTitle">yes</xsl:with-param>
			</xsl:call-template>
		</tr>
	</xsl:template>

</xsl:stylesheet>
