<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:strip-space elements="*"/>
	<xsl:output method="html" indent="yes" encoding="utf-8"/>
	
		
	
<xsl:template match="PAGED-LIST">
<script type="text/javascript" src="/js/list.js?{$version}.{$build}"/>
<script language="javascript">
function pagedListDoSort(tab, orderBy, orderType) {
	var formName = '<xsl:value-of select="@FORM-NAME"/>';
	var form = document.forms[formName];
	form.action = '<xsl:value-of select="@URL"/>';
	form.tab.value = tab;
	form.pageNum.value = 1;
	form.orderBy.value = orderBy;
	form.orderType.value = orderType;
	form.submit();
}
</script>
		<div class="module-list-block">
			<xsl:apply-templates select="TOOLBAR"/>
			<xsl:choose>
				<xsl:when test="count(LIST/ITEM) &gt; 0">
					<xsl:apply-templates select="PAGER"/>
					<xsl:apply-templates select="LIST"/>
					<xsl:apply-templates select="PAGER"/>
					<script type="text/javascript" language="javascript">
						observeCheckboxesClick('<xsl:value-of select="LIST/@PREFIX"/>Ids[]',
							'Top<xsl:value-of select="LIST/@PREFIX"/>'
						);
						observeListRowsHighlight();
					</script>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/MSG-NO-RECORDS|MSG-NO-RECORDS"/>
				</xsl:otherwise>
			</xsl:choose>
		</div>
</xsl:template>
	

	<xsl:template match="PAGED-LIST/LIST">
		<script type='text/javascript'>feedbackFields=null; feedbackFieldAdd=null;</script>
	
		<div class="scroll-table" style="height: 280px;">
			<table class="list-table" cellspacing="0" cellpadding="0" border="0" id="fieldsList">
				<thead>
					<xsl:apply-templates select="HEADER"/>
				</thead>
				<tbody>
					<xsl:call-template name="ITEM-TEMPLATE">
						<xsl:with-param name="number">1</xsl:with-param>
					</xsl:call-template>
					<xsl:call-template name="BUTTON-ADD-ITEM"/>
				</tbody>
			</table>
			<a name="listBottom"/>
		</div>
		<script src='/modules/Feedback/js/Fields.js?{$version}.{$build}' type='text/javascript'></script>
		<script type='text/javascript'>feedbackFields=new Modules_Feedback_Fields('<xsl:value-of select="$skinPath"/>','<xsl:value-of select="/SITEBUILDER-PAGE/JS-LOCALE/NEW-FIELD"/>','<xsl:value-of select="/SITEBUILDER-PAGE/JS-LOCALE/ONE-INCLUDED-REQUIRES"/>');</script>
		<script type='text/javascript' language="javascript">
			<xsl:comment>
				<xsl:apply-templates select="ITEM"/>
				feedbackFields.reBuildList();
			//</xsl:comment>	
		</script>
	</xsl:template>

	<xsl:template match="PAGED-LIST/LIST/HEADER">
		<tr class="fixed">
			<th style="width:30px;text-align:center"><div>#</div></th>
			<!--<th style="width:30px;text-align:center">
				<xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/TITLE-STATUS"/>
			</th>
			-->
			<th style="width:30px;text-align:center">
				<div><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/TITLE-REQUIRED"/></div>
			</th>
			<th style="text-align:center">
				<div><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/TITLE-NAME"/></div>
			</th>
			<th style="width:150px;text-align:center">
				<div><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/TITLE-TYPE"/></div>
			</th>
			<th style="width:20px;">
				<div><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/TITLE-UP"/></div>
			</th>
			<th style="width:20px;">
				<div><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/TITLE-DOWN"/></div>
			</th>
			<th style="width:65px; text-align:center;">
				<div><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/TITLE-DELETE"/></div>
				<!--<input type="checkbox" onclick="feedbackFields.selectAll(this.checked);" autocomplete="off"/>-->
			</th>
			<!--<th>&#160;</th>-->
		</tr>
    </xsl:template>

    <xsl:template match="PAGED-LIST/LIST/ITEM">
   		feedbackFields.register('<xsl:value-of select="TITLE"/>','<xsl:value-of select="TYPE"/>',<xsl:value-of select="IS-INCLUDED"/>,<xsl:value-of select="IS-REQUIRED"/>, <xsl:value-of select="RESERVE-FIELD"/>);
	</xsl:template>
    
    <xsl:template name="BUTTON-ADD-ITEM">
    	<tr id="addFieldButton" style="display: none">
    		<td style="text-align:center">&#160;</td>
    		<td style="text-align:center;"><input type="checkbox" name="required" value="" class="check"/></td>
			<td style="text-align:center">
				<select name="" style="width:150px;">
				</select>
			</td>
			<td style="text-align:center">
				<xsl:apply-templates select="/SITEBUILDER-PAGE/VIEW-CONTENT/FEEDBACK-EDITOR/FIELD-TYPES"/>
			</td>
			<td colspan="3" style="text-align:center;">			
				<img src="{$skinPath}/icons/AddField.png" width="32" height="32" style="cursor:pointer;" onclick="javascript: feedbackFields.append();//feedbackFields.getNewField();"/>
				<div style="width: 100px; height: 0;"><span></span></div>
			</td>
    	</tr>
    </xsl:template>
    
    <xsl:template name="ITEM-TEMPLATE">
    	<xsl:param name="number"/>
        <xsl:variable name="class">
        	<xsl:call-template name="LIST-ROW-CLASS">
                	<xsl:with-param name="position"><xsl:value-of select="position()"/></xsl:with-param>
        	</xsl:call-template>
        </xsl:variable>
    	<tr class="{$class}" style="display: none" id="fieldList">
			<td style="text-align:center;">&#160;</td>
			<!--<td style="text-align:center">&#160;</td>-->
			<td style="text-align:center">&#160;</td>
			<td style="text-align:center">
				<input type="text" autocomplete="off" style="width:150px;"/>
			</td>
			<td style="text-align:center">
				<xsl:apply-templates select="/SITEBUILDER-PAGE/VIEW-CONTENT/FEEDBACK-EDITOR/FIELD-TYPES"/>
			</td>
			
			<td style="text-align:center;">&#160;</td>
			<td style="text-align:center;">&#160;</td>
			<td style="text-align:center; padding-right: 20px;">
				<img src="{$skinPath}/icons/delete.png" style="cursor: pointer;" width="16" height="16" border="0"/>
			</td>
			<!--<th>&#160;</th>-->
		</tr>
    </xsl:template>

    <xsl:template match="FIELD-TYPES">
    	<select style="width:100px;">
    		<xsl:apply-templates select="FIELD-TYPE"/>
    	</select>
    </xsl:template>
    
    <xsl:template match="FIELD-TYPE">
    	<option value="{@CODE}">
    		<xsl:value-of select="@TITLE"/>
    	</option>
    </xsl:template>

</xsl:stylesheet>