<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:template match="FORUM-MODAL-FORM">
	</xsl:template>

	<xsl:template match="FORUM-MODAL-FORM" mode="initAfterBody">
		<xsl:call-template name="MODAL-FORM">
			<xsl:with-param name="formName">modalForm</xsl:with-param>
			<xsl:with-param name="formTitle" select="/SITEBUILDER-PAGE/LOCALE/FORM-TITLE"/>
			<xsl:with-param name="additionalFormStyle">width: 650px; height: 450px;</xsl:with-param>
			<xsl:with-param name="content" select="current()" />
			<xsl:with-param name="onCloseAction">sbNavigationObject.go();</xsl:with-param>
		</xsl:call-template>
	</xsl:template>

	<xsl:template match="FORUM-MODAL-FORM" mode="content">
		<input type="hidden" name="tab" value="main"/>
		<input type="hidden" name="topicId">
			<xsl:attribute name="value">
				<xsl:value-of select="@TOPIC-ID"/>
			</xsl:attribute>
		</input>
		<xsl:apply-templates select="TAB-PANEL"/>
		<table cellpadding="0" cellspacing="0" border="0" style="width: 100%;"><tr><td style="padding: 0 10px;">
			<xsl:call-template name="MODULE-MODAL-FORM-OK-CANCEL-BUTTONS"/>
		</td></tr></table>
	</xsl:template>

	<xsl:template match="FORUM-TOPIC-MAIN-CARD">
		<script type="text/javascript" src="/modules/Forum/js/Edit.js?{$version}.{$build}"></script>
		<script type="text/javascript">document.forms.SB_WizardForm.submit=ForumSubmitTopic;</script>
		
		<table cellpadding="0" cellspacing="0" border="0" class="control-title-input">
			<tr>
				<td class="title-block">
					<xsl:apply-templates select="CONTROL[@NAME='subject']" mode="label">
						<xsl:with-param name="require">true</xsl:with-param>
					</xsl:apply-templates>
				</td>
				<td class="input-block">
					<xsl:apply-templates select="CONTROL[@NAME='subject']" mode="control">
						<xsl:with-param name="maxlenth">100</xsl:with-param>
						<xsl:with-param name="onchange">sbApplyChangesObject.registerChange();</xsl:with-param>
						<xsl:with-param name="require">true</xsl:with-param>
					</xsl:apply-templates>
				</td>
			</tr>
		</table>
		
		<div style="width: 0; height: 5px;"><span></span></div>
		
		<xsl:call-template name="LABEL" mode="label">
			<xsl:with-param name="title" select="/SITEBUILDER-PAGE/LOCALE/TOPIC-DESCRIPTION"/>
		</xsl:call-template><br/>
		<xsl:apply-templates select="WYSIWYG"/>
	</xsl:template>	
	
	<xsl:template match="FORUM-TOPIC-CATEGORIES-CARD">
		<div style="overflow:auto; height:220px; margin: 0 -20px;">
			<xsl:apply-templates select="PAGED-LIST"/>
		</div>	
	</xsl:template>	
	
	<xsl:template match="FORUM-TOPIC-CATEGORIES-CARD/PAGED-LIST/LIST/HEADER">
		<tr class="fixed">	
			<th style="width:1%;">
				<div><input type="checkbox" name="globalCheck" onclick="setCheckboxStatus(this.checked,'topicCategory');" class="check"/></div>
			</th>
			<th>
				<div><xsl:value-of select="NAME"/></div>
			</th>
		</tr> 
	</xsl:template>
	
	<xsl:template match="FORUM-TOPIC-CATEGORIES-CARD/PAGED-LIST/LIST/ITEM">
		<xsl:variable name="class">
	<xsl:call-template name="LIST-ROW-CLASS">
        	<xsl:with-param name="position"><xsl:value-of select="position()"/></xsl:with-param>
	</xsl:call-template>
</xsl:variable>
		<tr class="{$class}">
			<td style="width:1%;">
				<input type="checkbox" name="topicCategory_objectIds[]" class="check">
					<xsl:attribute name="value">
						<xsl:value-of select="ID"/>
					</xsl:attribute>
					<xsl:if test="../../../SELECTED-CATEGORIES/CATEGORY/@ID=ID">
						<xsl:attribute name="checked">true</xsl:attribute>
					</xsl:if>
				</input>
			</td>
			<xsl:call-template name="LIST-ROW-ITEM">
				<xsl:with-param name="title">
					<xsl:value-of select="NAME"/>
				</xsl:with-param>
			</xsl:call-template>
		</tr>
	</xsl:template>		
	
</xsl:stylesheet>