<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:strip-space elements="*"/>
	<xsl:output method="html" indent="yes" encoding="utf-8"/>

	<xsl:template match="IMAGE-FORM">
	</xsl:template>

	<xsl:template match="IMAGE-FORM" mode="initAfterBody">
		<xsl:call-template name="MODAL-FORM">
			<xsl:with-param name="formName">modalForm</xsl:with-param>
			<xsl:with-param name="formTitle" select="/SITEBUILDER-PAGE/LOCALE/FORM-TITLE"/>
			<!--<xsl:with-param name="helpHint" select="/SITEBUILDER-PAGE/LOCALE/HELP-HINT"/>-->
			<!--<xsl:with-param name="closeHint" select="@CLOSE-HINT"/>-->
			<xsl:with-param name="additionalFormStyle">width: 650px; height: 420px;</xsl:with-param>
			<xsl:with-param name="content" select="current()" />
			<xsl:with-param name="onCloseAction">sbNavigationObject.go();</xsl:with-param>
		</xsl:call-template>
	</xsl:template>

	<xsl:template match="MAIN-CARD">
		<table cellspacing="0" cellpadding="5" border="0" style="border-width:0px;width:100%;">
			<tr>
				<td><xsl:value-of select="CURRENT-IMAGE/@TITLE"/></td>
				<td>
					<input type="text" name="title" id="title" class="sb-control-input-input" maxlength="50">
						<xsl:attribute name="value">
							<xsl:value-of select="CURRENT-IMAGE"/>
						</xsl:attribute>
					</input>
				</td>
			</tr>
			<tr>
				<td> <xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/CURRENT-IMAGE"/> </td>
				<td>
					<xsl:choose>
						<xsl:when test="CURRENT-IMAGE/@IMAGE-FILE-PATH!=''">
							<img border="0">
								<xsl:attribute name="src"><xsl:value-of select="CURRENT-IMAGE/@IMAGE-URL"/></xsl:attribute>
							</img>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="NO-IMAGE" >
								<xsl:with-param name="width">102px</xsl:with-param>
								<xsl:with-param name="heigth">70px</xsl:with-param>
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
					<input type="hidden" name="image">
						<xsl:attribute name="value"><xsl:value-of select="CURRENT-IMAGE/@IMAGE-FILE-PATH"/></xsl:attribute>
					</input>
				</td>
			</tr>
			<tr>
				<td> <xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/NEW-IMAGE"/> </td>
				<td>
					<table cellspacing="0" cellpadding="0" border="0">
					<tr>
						<td>
							<input type="file" name="image" size="40" style="border-color:#999EA1;border-width:1px;border-style:Solid;" />
						</td>
						<td style="padding-left:5px;">
							<xsl:call-template name="BUTTON-CONTROL">
								<xsl:with-param name="title"><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/UPLOAD"/></xsl:with-param>
								<xsl:with-param name="action">setWizardFormAction("<xsl:value-of select="/SITEBUILDER-PAGE/VIEW-CONTENT/@ACTION"/>/Modules/ImageGallery/Image/Form/Upload");wizardFormSubmit();</xsl:with-param>
							</xsl:call-template>
						</td>
					</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template match="DESCRIPTION-CARD">
<!--		<table width="100%" border="0">
			<tr>
				<td>
					<xsl:apply-templates select="WYSIWYG" />
				</td>
			</tr>
		</table>-->
		<xsl:call-template name="DESCRIPTION"/>

	</xsl:template>

<!--	<xsl:template name="NO-IMAGE">
		<table style="width: 102px; height: 70px; background-color: #A4A4A4;">
			<tr>
				<td valign="middle" align="center">
					<span style="vertical-align: middle; color: #FFFFFF;"><b><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/NO-IMAGE"/></b></span>
				</td>
			</tr>
		</table>
	</xsl:template>
-->
<!--	<xsl:template match="POSITION">
		<option >
			<xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
			<xsl:if test="position()=last()">
				<xsl:attribute name="selected">true</xsl:attribute>
			</xsl:if>
			<xsl:value-of select="."/>
		</option>
	</xsl:template>
-->
	<xsl:template match="CATEGORIES-CARD">
		<script language="javascript">
			function setCategoryCheckbox(status) {
				var form = document.forms['SB_WizardForm'];
				for (var n = 0; n &lt; form.elements.length; n++) {
					if (form.elements[n].type == 'checkbox' &amp;&amp; form.elements[n].name=='objectIds[]') {
						if (!form.elements[n].disabled) {
							form.elements[n].checked = status;
						}
					}
				}
			}
		</script>
		<!--<input type="hidden" name="product_category_pageNum"   value=""/>-->
		<!--<input type="hidden" name="product_category_pageSize"  value=""/>-->

		<div style="overflow:auto; height:206px; margin: 0 -20px;">
			<xsl:apply-templates select="PAGED-LIST"/>
		</div>
	</xsl:template>

	<xsl:template match="CATEGORIES-CARD/PAGED-LIST/LIST/HEADER">
		<tr class="fixed">
			<th style="width:1%;">
				<div><input type="checkbox" name="globalCheck" onclick="setCategoryCheckbox(this.checked);" class="check"/></div>
			</th>
			<th><div><xsl:value-of select="NAME"/></div></th>
		</tr>
	</xsl:template>

	<xsl:template match="CATEGORIES-CARD/PAGED-LIST/LIST/ITEM">
		<xsl:variable name="class">
			<xsl:call-template name="LIST-ROW-CLASS">
				<xsl:with-param name="position"><xsl:value-of select="position()"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<tr class="{$class}">
			<td style="width:1%;">
				<input type="checkbox" name="objectIds[]" class="check">
					<xsl:attribute name="value"><xsl:value-of select="ID"/></xsl:attribute>
					<xsl:if test="../../../SELECTED-CATEGORIES/CATEGORY/@ID=ID">
						<xsl:attribute name="checked">true</xsl:attribute>
					</xsl:if>
				</input>
			</td>
			<xsl:call-template name="LIST-ROW-ITEM">
				<xsl:with-param name="title"><xsl:value-of select="NAME"/></xsl:with-param>
			</xsl:call-template>
		</tr>
	</xsl:template>

</xsl:stylesheet>