<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:strip-space elements="*"/>
	<xsl:output method="html" indent="yes" encoding="utf-8"/>
	
	<xsl:template match="PAGED-LIST/LIST">
		<script type='text/javascript'>votingAnswers=null;</script>
		
	<style type="text/css">
	.scroll-table {
		width: 100%;
		overflow: auto;
		height: 200px;
		position: relative;
	}
	.scroll-table tr.fixed {
		position: relative;
		top: expression(this.parentElement.parentElement.parentElement.scrollTop)
	}

	.scroll-table>table tbody {
		height: 170px;
		overflow: auto;
		overflow-x: hidden;
	}

	</style>
	
	
		<div class="scroll-table">
			<table cellspacing="1" border="0" id="fieldsList" width="100%" style="margin-top: -1px; height: 200px;">
				<thead>
					<xsl:apply-templates select="HEADER"/>
				</thead>
				<tbody>
				<xsl:call-template name="ITEM-TEMPLATE">
					<xsl:with-param name="number">1</xsl:with-param>
				</xsl:call-template>
				<xsl:call-template name="ITEM-TEMPLATE">
					<xsl:with-param name="number">2</xsl:with-param>
				</xsl:call-template>
				</tbody>
			</table>
		</div>
		<script src='/modules/Voting/js/Answers.js?{$version}.{$build}' type='text/javascript'></script>
		<script type='text/javascript'>
			votingAnswers = new Modules_Voting_Answers(
				'<xsl:value-of select="$skinPath"/>'
			);
		</script>
		<script type='text/javascript'>
			<xsl:apply-templates select="ITEM"/>
			votingAnswers.reBuildList();
		</script>
	</xsl:template>

	
	<xsl:template match="PAGED-LIST/LIST/HEADER">
		<tr class="sb-gridview-header fixed" align="left" style="background-color: transparent;">
			<th class="sb-gridview-header" style="width:20px;text-align:center;">
				<input type="checkbox" onclick="votingAnswers.selectAll(this.checked);" autocomplete="off"/>
			</th>
			<th class="sb-gridview-header" style="width:30px;text-align:center">#</th>
			<th class="sb-gridview-header" style="width:440px;text-align:left">
				<xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/TITLE-ANSWERS"/>
			</th>
			<th class="sb-gridview-header" style="width:20px;">&#160;</th>
			<th class="sb-gridview-header" style="width:20px;">&#160;</th>
		</tr>
    </xsl:template>

    <xsl:template match="PAGED-LIST/LIST/ITEM">
    	votingAnswers.register (
    		<xsl:value-of select="ID"/>,
    		'<xsl:value-of select="ANSWER"/>'
    	);
    </xsl:template>
    
    <xsl:template name="ITEM-TEMPLATE">
    	<xsl:param name="number"/>
    	<xsl:variable name="class" select="$number mod 2"/>
    	<tr class="{$class}" style="display: none">
    		<td style="text-align:center;">
				<input type="checkbox" autocomplete="off"/>
			</td>
			<td style="text-align:center;">&#160;</td>
			<td style="text-align:left">
				<input type="text" autocomplete="off" class="sb-control-input-input" style="width:100%;" maxlength="100"/>
			</td>
			<td style="text-align:center; padding-left: 4px; padding-right: 4px;">&#160;</td>
			<td style="text-align:center; padding-left: 4px; padding-right: 20px;">&#160;</td>
		</tr>
    </xsl:template>
    
</xsl:stylesheet>