<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:strip-space elements="*"/>
	<xsl:output method="html" indent="yes" encoding="utf-8"/>

	<xsl:template match="VIEW-CONTENT">
		<script type="text/javascript" language="javascript" src="/js/Wizard/pages.js?{$version}.{$build}"/>
		
		<script type="text/javascript">
			function validateForm() {
				if (!$('counterTurnOn').checked) {
					return true;
				}
				
				if (validateField('SB_Validator.notEmpty', 		'counterValue', 	'EMPTY-COUNTER-VALUE')
					&amp;&amp; validateField('SB_Validator.isInt', 		'counterValue', 	'INVALID-COUNTER-VALUE')
					&amp;&amp; extendedValidateField("SB_Validator.isGreaterThan(document.getElementById('counterValue').value, -1)", 'counterValue', 'INVALID-COUNTER-VALUE')
				) {
					return true;
				} else {
					return false;
				}
			}
		</script>

		
		<table border="0" cellpadding="10" cellspacing="0" style="height:100%; width:100%; vertical-align: top;" align="left" class="sb-pages-form">
			<tr>
				<td valign="top" style="width: 30%;">
					<table cellpadding="0" cellspacing="0" border="0" style="height:100%; width:100%;">
						<tr valign="top">
							<td style="height:100%;">
								<table style="height:100%; width:100%;" cellpadding="0" cellspacing="0" border="0">
									<tr>
										<td style="height: 100%; width: 100%;" valign="top">
											<xsl:apply-templates select="PAGESET-LIST"/>
										</td>
									</tr>
									<tr>
										<td style="width: 100%;" valign="top">
											<xsl:apply-templates select="REGIONAL-OPTIONS"/>
										</td>
									</tr>
									<tr>
										<td style="height: 0%; width: 100%;" valign="top"></td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
				</td>
				<td valign="top" style="width: 25%;">
					<table cellpadding="0" cellspacing="0" border="0" style="height:100%; width:100%;">
						<tr valign="top">
							<td style="height:100%;">
								<table style="height:100%; width:100%;" cellpadding="0" cellspacing="0" border="0">
									<tr>
										<td style="height: 50%; width: 100%;" valign="top" id="{PAGESET-CONTENT/PAGES-TREE/@NAME}PanelPlace">
											<xsl:apply-templates select="PAGESET-CONTENT"/>
										</td>
									</tr>
									<tr>
										<td style="height: 50%; width: 100%;" valign="top" id="{SPECIAL-PAGES/PAGES-TREE/@NAME}PanelPlace">
											<xsl:apply-templates select="SPECIAL-PAGES"/>
										</td>
									</tr>
									<tr>
										<td style="height: 0%; width: 100%;" valign="top" id="EmptyPanelPlace"></td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
				</td>
				<td style="width: 10%; vertical-align: middle;">
					<table style="width:100%;" cellpadding="0" cellspacing="0" border="0">
						<tr>
							<td>
								<xsl:call-template name="BUTTON">
									<xsl:with-param name="action">SbPagesSiteAdd('<xsl:value-of select="PAGESET-CONTENT/PAGES-TREE/@NAME"/>', '<xsl:value-of select="SITE-STRUCTURE/PAGES-TREE/@NAME"/>'); SbPagesSiteAdd('<xsl:value-of select="SPECIAL-PAGES/PAGES-TREE/@NAME"/>', '<xsl:value-of select="SITE-STRUCTURE/PAGES-TREE/@NAME"/>');</xsl:with-param>
									<xsl:with-param name="title" select="BUTTONS/@ADD"/>
									<xsl:with-param name="id">buttonAdd</xsl:with-param>
								</xsl:call-template>
							</td>
						</tr>
						<tr>
							<td style="padding-top:15px;">
								<xsl:call-template name="BUTTON">
									<xsl:with-param name="action">SbPagesSiteRemove('<xsl:value-of select="SITE-STRUCTURE/PAGES-TREE/@NAME"/>');</xsl:with-param>
									<xsl:with-param name="title" select="BUTTONS/@REMOVE"/>
									<xsl:with-param name="id">buttonRemove</xsl:with-param>
								</xsl:call-template>
							</td>
						</tr>
					</table>
				</td>
				<td valign="top" style="width: 25%;">
					<table cellpadding="0" cellspacing="0" border="0" style="height:100%; width:100%;">
						<tr valign="top">
							<td style="height:100%;">
								<table style="height:100%; width:100%;" cellpadding="0" cellspacing="0" border="0">
									<tr>
										<td style="width: 100%;" valign="top">
											<xsl:apply-templates select="SITE-STRUCTURE"/>
										</td>
									</tr>
									<tr>
										<td valign="bottom" style="height: 10px;">
											<table cellpadding="0" cellspacing="0" border="0" style="width: 100%; margin-top: 5px;">
												<tr>
													<td>
														<div id="counterControlPanel" style="width: 100%; overflow: hidden;">
															<table cellpadding="0" cellspacing="0" border="0">
																<tr>
																	<td style="padding: 10px;">
																		<xsl:apply-templates select="COUNTER-CONTROL-PANEL"/>
																	</td>
																</tr>
															</table>
														</div>
														<script type="text/javascript">
															Sb.Views.Wizard.Pages.updateCounterPanelSize();
														</script>
													</td>
												</tr>
											</table>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>					
				</td>
				<td valign="top" style="width: 10%;">
					<table style="height:100%; width:100%" cellpadding="0" cellspacing="0" border="0">
						<tr>
							<td style="width: 100%; vertical-align: top;">
								<table style="width:100%;" cellpadding="0" cellspacing="0" border="0">
									<tr>
										<td align="left" style="font-weight: bold;">
											<xsl:value-of select="SITE-STRUCTURE/BUTTONS/@TITLE"/>
										</td>
									</tr>
									<tr>
										<td style="padding-top:15px;">
											<xsl:call-template name="BUTTON">
												<xsl:with-param name="action">SbPagesSiteMoveUp('<xsl:value-of select="SITE-STRUCTURE/PAGES-TREE/@NAME"/>');</xsl:with-param>
												<xsl:with-param name="title" select="SITE-STRUCTURE/BUTTONS/@UP"/>
												<xsl:with-param name="id">buttonUp</xsl:with-param>
											</xsl:call-template>
										</td>
									</tr>
									<tr>
										<td style="padding-top:15px;">
											<xsl:call-template name="BUTTON">
												<xsl:with-param name="action">SbPagesSiteMoveDown('<xsl:value-of select="SITE-STRUCTURE/PAGES-TREE/@NAME"/>');</xsl:with-param>
												<xsl:with-param name="title" select="SITE-STRUCTURE/BUTTONS/@DOWN"/>
												<xsl:with-param name="id">buttonDown</xsl:with-param>
											</xsl:call-template>
										</td>
									</tr>
									<tr>
										<td style="padding-top:15px;">
											<xsl:call-template name="BUTTON">
												<xsl:with-param name="action">SbPagesSiteMoveLeft('<xsl:value-of select="SITE-STRUCTURE/PAGES-TREE/@NAME"/>');</xsl:with-param>
												<xsl:with-param name="title" select="SITE-STRUCTURE/BUTTONS/@LEFT"/>
												<xsl:with-param name="id">buttonLeft</xsl:with-param>
											</xsl:call-template>
										</td>
									</tr>
									<tr>
										<td style="padding-top:15px;">
											<xsl:call-template name="BUTTON">
												<xsl:with-param name="action">SbPagesSiteMoveRight('<xsl:value-of select="SITE-STRUCTURE/PAGES-TREE/@NAME"/>');</xsl:with-param>
												<xsl:with-param name="title" select="SITE-STRUCTURE/BUTTONS/@RIGHT"/>
												<xsl:with-param name="id">buttonRight</xsl:with-param>
											</xsl:call-template>
										</td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
							<td style="height: 50%; width: 100%; vertical-align: bottom;">
								<xsl:call-template name="BUTTON">
									<xsl:with-param name="action">SbPagesSiteRename('<xsl:value-of select="SITE-STRUCTURE/PAGES-TREE/@NAME"/>');</xsl:with-param>
									<xsl:with-param name="title" select="SITE-STRUCTURE/BUTTONS/@RENAME"/>
									<xsl:with-param name="id">buttonRename</xsl:with-param>
								</xsl:call-template>
							</td>
						</tr>
					</table>
<!-- abelyaev@: for PAGES-TREE debugging
<div id="SbLogs" style="width:100%; height:100%; overflow:auto; vertical-align:top; border:solid 1px #000000">Logs:</div>
<script type="text/javascript" language="javascript">
	<xsl:comment>
		SbInitLogging();
	//</xsl:comment>
</script>
-->
				</td>
			</tr>
		</table>
		<script type="text/javascript" language="javascript">
			<xsl:comment>
				SbPagesDisableButton('buttonAdd');
				SbPagesDisableButton('buttonRemove');
				SbPagesDisableButton('buttonUp');
				SbPagesDisableButton('buttonDown');
				SbPagesDisableButton('buttonLeft');
				SbPagesDisableButton('buttonRight');
				SbPagesDisableButton('buttonRename');
			//</xsl:comment>
		</script>
	</xsl:template>

	<xsl:template match="COUNTER-CONTROL-PANEL">
		<table cellpadding="0" cellspacing="0" border="0" class="control-title-input">
			<tr>
				<td colspan="2" style="padding-bottom: 10px;">
					<xsl:apply-templates select="CONTROL[@NAME='counterTurnOn']" mode="control">
						<xsl:with-param name="onclick">self.sbApplyChangesObject.registerChange(); Sb.Views.Wizard.Pages.updateCounterPanelSize();</xsl:with-param>
					</xsl:apply-templates>
					
					<span style="padding-left: 6px;">
						<xsl:apply-templates select="CONTROL[@NAME='counterTurnOn']" mode="label"/>
					</span>
				</td>
			</tr>
			<tr>
				<td class="title-block" style="width: 115px;">
					<xsl:apply-templates select="CONTROL[@NAME='counterValue']" mode="label">
						<xsl:with-param name="require">true</xsl:with-param>
					</xsl:apply-templates>
				</td>
				<td class="input-block">
					<xsl:apply-templates select="CONTROL[@NAME='counterValue']" mode="control">
						<xsl:with-param name="maxlength">10</xsl:with-param>
						<xsl:with-param name="onchange">self.sbApplyChangesObject.registerChange();</xsl:with-param>
						<xsl:with-param name="require">true</xsl:with-param>
						<xsl:with-param name="size">10</xsl:with-param>
					</xsl:apply-templates>
				</td>
			</tr>
			<tr>
				<td class="title-block" style="width: 115px;">
					<xsl:apply-templates select="CONTROL[@NAME='counterStyle']" mode="label"/>
				</td>
				<td class="input-block">
					<xsl:apply-templates select="CONTROL[@NAME='counterStyle']" mode="control">
						<xsl:with-param name="onchange">self.sbApplyChangesObject.registerChange();</xsl:with-param>
					</xsl:apply-templates>
				</td>
			</tr>
		</table>
	</xsl:template>
	
<xsl:template match="PAGESET-CONTENT">
	<xsl:call-template name="PAGES-TREE-PANEL">
		<xsl:with-param name="isSwitchable">true</xsl:with-param>
		<xsl:with-param name="onToggle">SbTreeOnPanelToggle('<xsl:value-of select="PAGES-TREE/@NAME"/>Panel', '<xsl:value-of select="../SPECIAL-PAGES/PAGES-TREE/@NAME"/>Panel');</xsl:with-param>
		<xsl:with-param name="onCheck">
			function() {
				SbPagesUpdateMainCheckBox('<xsl:value-of select="PAGES-TREE/@NAME"/>');
				SbUpdateAddButton('<xsl:value-of select="PAGES-TREE/@NAME"/>', '<xsl:value-of select="../SPECIAL-PAGES/PAGES-TREE/@NAME"/>');
			}
		</xsl:with-param>
	</xsl:call-template>
</xsl:template>

<xsl:template match="SPECIAL-PAGES">
	<xsl:call-template name="PAGES-TREE-PANEL">
		<xsl:with-param name="isSwitchable">true</xsl:with-param>
		<xsl:with-param name="onToggle">SbTreeOnPanelToggle('<xsl:value-of select="PAGES-TREE/@NAME"/>Panel', '<xsl:value-of select="../PAGESET-CONTENT/PAGES-TREE/@NAME"/>Panel');</xsl:with-param>
		<xsl:with-param name="onCheck">
			function() {
				SbPagesUpdateMainCheckBox('<xsl:value-of select="PAGES-TREE/@NAME"/>');
				SbUpdateAddButton('<xsl:value-of select="../PAGESET-CONTENT/PAGES-TREE/@NAME"/>', '<xsl:value-of select="PAGES-TREE/@NAME"/>');
			}
		</xsl:with-param>
	</xsl:call-template>
</xsl:template>

<xsl:template match="SITE-STRUCTURE">
	<xsl:call-template name="PAGES-TREE-PANEL">
		<xsl:with-param name="onChange">
			function() {
				SbUpdatePagesStates('<xsl:value-of select="PAGES-TREE/@NAME"/>', '<xsl:value-of select="../PAGESET-CONTENT/PAGES-TREE/@NAME"/>', '<xsl:value-of select="../SPECIAL-PAGES/PAGES-TREE/@NAME"/>');
				self.sbApplyChangesObject.registerChange();
				SbPagesUpdateMainCheckBox('<xsl:value-of select="PAGES-TREE/@NAME"/>');
				SbPagesUpdateMainCheckBox('<xsl:value-of select="../PAGESET-CONTENT/PAGES-TREE/@NAME"/>');
				SbPagesUpdateMainCheckBox('<xsl:value-of select="../SPECIAL-PAGES/PAGES-TREE/@NAME"/>');
				SbPagesSiteButtonsUpdate('<xsl:value-of select="PAGES-TREE/@NAME"/>');
			}
		</xsl:with-param>
		<xsl:with-param name="onCheck">
			function() {
				SbPagesSiteButtonsUpdate('<xsl:value-of select="PAGES-TREE/@NAME"/>');
			}
		</xsl:with-param>
	</xsl:call-template>
	<script type="text/javascript" language="javascript">
		<xsl:comment>
			SbUpdatePagesStates('<xsl:value-of select="PAGES-TREE/@NAME"/>', '<xsl:value-of select="../PAGESET-CONTENT/PAGES-TREE/@NAME"/>', '<xsl:value-of select="../SPECIAL-PAGES/PAGES-TREE/@NAME"/>');
			sbNavigationObject.registerOnSubmitFunction(
				function () {
					sbNavigationObject.addHidden('sbSiteStructure', SbGetTreeXml('<xsl:value-of select="PAGES-TREE/@NAME"/>'));
				}
			);
		//</xsl:comment>
	</script>
</xsl:template>

<xsl:template match="PAGESET-LIST">
	<table cellpadding="0" cellspacing="0" border="0" class="sb-page-sets-menu">
		<tr>
			<td class="sb-pages-panel-pagesets-header">
				<table cellpadding="0" cellspacing="0" border="0" style="width:100%; height:100%;">
					<tr>
						<td align="left" style="font-weight: bold;"><xsl:value-of select="@TITLE"/></td>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td valign="top">
				<xsl:apply-templates select="PAGESET-ITEM"/>
			</td>
		</tr>
	</table>
</xsl:template>

<xsl:template match="PAGESET-ITEM">
	<table cellspacing="0" cellpadding="0" border="0" class="sb-page-sets-menu-item">
		<xsl:call-template name="PAGESET-SOURCE"/>
	</table>
</xsl:template>

<xsl:template match="PAGESET-ITEM[@SELECTED='true']">
	<table cellspacing="0" cellpadding="0" border="0" class="sb-pages-pageset-selected">
		<xsl:call-template name="PAGESET-SOURCE"/>
	</table>
</xsl:template>

<xsl:template name="PAGESET-SOURCE">
	<xsl:attribute name="onclick">sbNavigationObject.setViewParam('selectedPagesetId', '<xsl:value-of select="@ID"/>'); return sbNavigationObject.go();</xsl:attribute>
	<tr>
		<td style="padding-left:10px; padding-right:5px;">
			<img src="{$skinPath}/images/pages_arrow.gif"/>
		</td>
		<td align="left" style="width: 100%;"><xsl:value-of select="@NAME"/></td>
	</tr>
</xsl:template>

<xsl:template match="REGIONAL-OPTIONS">
	<xsl:variable name="panelId">regionalOptions</xsl:variable>

	<input type="hidden" value="true" id="{$panelId}_hidden"/>

	<div style="height:100%;">
		<table id="{$panelId}" cellpadding="0" cellspacing="0" border="0" class="sb-page-sets-menu">
			<tr>
				<td class="sb-pages-panel-pagesets-header" style="cursor:pointer; user-select:none; -moz-user-select:none;" onclick="SBPanelToggle('{$panelId}','{$skinPath}/images/show.gif','{$skinPath}/images/hide.gif');">
					<table cellpadding="0" cellspacing="0" border="0" style="width:100%; height:100%;">
						<tr>
							<td align="left" style="white-space: nowrap; font-weight: bold;"><xsl:value-of select="@TITLE"/></td>
							<td align="Right" valign="Middle" style="width:100%;"><img id="{$panelId}_image" src="{$skinPath}/images/hide.gif"/></td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td valign="top" colspan="2" style="border-color:White; border-width:1px; border-style:solid;">
					<table cellpadding="0" cellspacing="0" border="0" style="width:100%; height:100%; table-layout: fixed; padding-left: 10px; padding-right: 10px; padding-top: 5px;">
						<tr style="height: 100%;" valign="top">
							<td valign="top">
								<xsl:apply-templates select="OPTIONS-LANGUAGE-BOX"/>
								<xsl:apply-templates select="OPTIONS-STANDARDS-BOX"/>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</div>
</xsl:template>

<xsl:template match="OPTIONS-LANGUAGE-BOX">
	<fieldset style="padding: 5px;" class="sb-form-fieldset">
		<legend>
			<span class="sb-label"><xsl:value-of select="@TITLE"/></span>
		</legend>

		<span class="sb-label"><xsl:value-of select="@DESCRIPTION"/></span>
		<div style="width: 0; height: 3px;"><span></span></div>
		<xsl:apply-templates select="CONTROL[@TYPE='COMBO-BOX']" mode="control">
			<xsl:with-param name="onchange">submitFormByChangeLocale();</xsl:with-param>
		</xsl:apply-templates>

		<script type="text/javascript" language="javascript">
			function submitFormByChangeLocale() {
				selectedLocaleElement = document.forms.SB_WizardForm.interfaceLanguage;
				var selectedLocale = selectedLocaleElement.options[selectedLocaleElement.selectedIndex].value;
				selectedLocaleElement.selectedIndex = originalSelectedLocaleIndex;

				addHiddenToForm('newSelectedLocale', selectedLocale, 'SB_WizardForm');
				sbApplyChangesObject.registerChange();
				sbNavigationObject.go('/Wizard/Pages');
			}

			var originalSelectedLocaleIndex = document.forms.SB_WizardForm.interfaceLanguage.selectedIndex;
		</script>
	</fieldset>
</xsl:template>

<xsl:template match="OPTIONS-STANDARDS-BOX">
	<fieldset style="padding: 5px;" class="sb-form-fieldset">
		<legend>
			<span class="sb-label"><xsl:value-of select="@TITLE"/></span>
		</legend>

		<span class="sb-label"><xsl:value-of select="SAMPLES-BOX/@TITLE"/></span>

		<table style="width: 80%; margin-left: 5px;">
			<xsl:for-each select="SAMPLES-BOX/SAMPLE-ITEM">
				<tr>
					<td><span class="sb-label"><xsl:value-of select="@TITLE"/></span></td>
					<td><xsl:value-of select="."/></td>
				</tr>
			</xsl:for-each>
		</table>
	</fieldset>
</xsl:template>

</xsl:stylesheet>