<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:strip-space elements="*"/>
	<xsl:output method="html" indent="yes" encoding="utf-8"/>

	<xsl:template match="VIEW-CONTENT">
		<xsl:apply-templates select="SEND-EMAIL"/>
	</xsl:template>

	<xsl:template match="SEND-EMAIL">
		<script src="/js/Wizard/Publish/Trial.js?{$version}.{$build}" type="text/javascript"></script>
		<table cellpadding="0" cellspacing="0" border="0" style="width: 100%; height: 100%;">
			<tr>
				<td style="vertical-align: middle;">
					<div align="center">
						<div class="sb-publish-panel">
							<xsl:apply-templates select="STATUS" mode="publish"/>
							<div style="width:0px; height:8px;"><span></span></div>
							<table cellpadding="0" cellspacing="8" border="0" width="100%">
								<tr>
									<td>
										<span class="sb-text">
											<xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/PUBLISH-SCREEN-MESSAGE" disable-output-escaping="yes"/>
										</span>
									</td>
								</tr>
								<tr>
									<td align="center">
										<table cellpadding="0" cellspacing="0" border="0" width="150px;">
											<tr>
												<td>
													<a target="_blank" id="visitSiteLink" style="display: none;">
														<xsl:attribute name="href"><xsl:value-of select="CONTROL[@NAME='visitSite']/@HREF"/></xsl:attribute>
														<xsl:value-of select="CONTROL[@NAME='visitSite']/@TITLE"/>
													</a>
													<a target="_blank" style="text-decoration: none;">
														<xsl:attribute name="href"><xsl:value-of select="CONTROL[@NAME='visitSite']/@HREF"/></xsl:attribute>
														<xsl:call-template name="LARGE-BUTTON-CONTROL">
															<xsl:with-param name="style">width: 105px;</xsl:with-param>
															<xsl:with-param name="title"><xsl:value-of select="CONTROL[@NAME='visitSite']/@TITLE"/></xsl:with-param>
															<xsl:with-param name="icon">icons/btn_visit_site.gif</xsl:with-param>
															<xsl:with-param name="leftImage">images/visit_site_left.gif</xsl:with-param>
															<xsl:with-param name="middleImage">images/visit_site_bg.gif</xsl:with-param>
															<xsl:with-param name="rightImage">images/visit_site_right.gif</xsl:with-param>
															<xsl:with-param name="action">clickLinkIE('visitSiteLink');</xsl:with-param>
															<xsl:with-param name="action">clickLinkIE('visitSiteLink');</xsl:with-param>
														</xsl:call-template>
													</a>
												</td>
											</tr>
										</table>
									</td>
								</tr>
							</table>
							<div style="width:0px; height:15px;"><span></span></div>
							<hr class="sb-publish-hr"/>
							<div style="width:0px; height:10px;"><span></span></div>
							<table cellpadding="0" cellspacing="0" border="0" align="center">
								<tr>
									<td style="padding-right: 10px;">
										<xsl:apply-templates select="CONTROL[@NAME='email']" mode="label"/>
									</td>
									<td>
										<xsl:apply-templates select="CONTROL[@NAME='email']" mode="control">
											<xsl:with-param name="require">true</xsl:with-param>
											<xsl:with-param name="size">60</xsl:with-param>
										</xsl:apply-templates>
									</td>
								</tr>
								<tr>
									<td></td>
									<td style="padding-top: 10px;">
										<xsl:call-template name="BUTTON-CONTROL">
											<xsl:with-param name="title">&#160;&#160;&#160;<xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/SEND"/>&#160;&#160;&#160;&#160;&#160;&#160;&#160;</xsl:with-param>
											<xsl:with-param name="icon">send.gif</xsl:with-param>
											<xsl:with-param name="action">sendMail1();</xsl:with-param>
										</xsl:call-template>
									</td>
								</tr>
							</table>
						</div>
					</div>
				</td>
			</tr>
		</table>
	</xsl:template>

</xsl:stylesheet>