<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:strip-space elements="*"/>
	<xsl:output method="html" indent="yes" encoding="utf-8"/>

<!--	<xsl:template match="FAMILIA">
	</xsl:template>
-->
	<xsl:template match="FAMILIA" mode="init">
		siteFamilies.register('<xsl:value-of select="@ID"/>', 'DataListSiteFamily_<xsl:value-of select="@ID"/>');
	</xsl:template>
	<xsl:template match="SITE-FAMILIES">
		<xsl:variable name="inactiveFamilia">border: solid 1px #DBE0E8; background-color: #FFFFFF;</xsl:variable>
		<xsl:variable name="activeFamilia">border: solid 1px #06c; background-color: #FFFFFF</xsl:variable>
		<table cellspacing="0" cellpadding="0" border="0" style="border-width:0px;width:100%;border-collapse:collapse;">
			<xsl:for-each select="FAMILIA">
			<tr>
				<td style="border-width: 0px; width: 100%; padding-bottom: 10px;">
					<table width="100%" cellspacing="5" cellpadding="0" border="0" style="border: solid 2px #E3E3E3; background-color: #FFFFFF;">
						<xsl:if test="@PLAN_IN=1">
							<xsl:attribute name="onclick">siteFamilies.activate(this);</xsl:attribute>
							<xsl:attribute name="onmouseover">siteFamilies.highLightOn(this);</xsl:attribute>
							<xsl:attribute name="onmouseout">siteFamilies.highLightOff(this);</xsl:attribute>
							<xsl:attribute name="style">border: solid 1px #DBE0E8; background-color: #FFFFFF; cursor: pointer;</xsl:attribute>
						</xsl:if>
						<xsl:if test="@PLAN_IN=0">
							<xsl:attribute name="style">border: solid 1px #DBE0E8;background-color: #F7F7F7;</xsl:attribute>
						</xsl:if>

						<xsl:attribute name="title"><xsl:value-of select="@HINT"/></xsl:attribute>

						<xsl:if test="@ACTIVE=1">
							<xsl:attribute name="style"><xsl:value-of select="$activeFamilia"/></xsl:attribute>
						</xsl:if>
						<tr>
							<td>
								<img style="border-width:0px;">
									<xsl:attribute name="src">
										<xsl:choose>
											<xsl:when test="@IS-BUILT-IN = 1"><xsl:value-of select="$skinPath"/>/images/sitefamily_<xsl:value-of select="@ID"/>.gif</xsl:when>
											<xsl:otherwise>
												<xsl:choose>
													<xsl:when test="@LOGO = ''"><xsl:value-of select="$skinPath"/>/images/sitefamily_generic.gif</xsl:when>
													<xsl:otherwise>/images/logos/<xsl:value-of select="@LOGO"/></xsl:otherwise>
												</xsl:choose>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:attribute>
								</img>
							</td>
							<td align="left" width="100%" style="padding: 0px 10px 0px 30px;">
								<span class="sb-family-title"><xsl:value-of select="@TITLE"/></span><br />
								<span class="sb-text"><xsl:value-of select="@DESCRIPTION" disable-output-escaping="yes"/></span>
							</td>
							<td style="padding-right: 10px">
								<img src="{$skinPath}/images/check_disabled.gif" align="absmiddle" style="border-width:0px;">
									<xsl:attribute name="id">DataListSiteFamily_<xsl:value-of select="@ID"/></xsl:attribute>
									<xsl:if test="@ACTIVE=1">
										<xsl:attribute name="src"><xsl:value-of select="$skinPath"/>/images/check_active.gif</xsl:attribute>
									</xsl:if>
								</img>
							</td>
						</tr>
					</table>
				</td>
			</tr>
			</xsl:for-each>
		</table>
	</xsl:template>

	<xsl:template match="VIEW-CONTENT">
		<table border="0" cellpadding="0" cellspacing="0" style="height: 100%; width:100%" align="center">
			<tr>
				<td style="vertical-align: top; padding: 10px; height: 100%;" align="center">
					<table class="sb-start-table" cellpadding="6" cellspacing="0" style="width: 100%; height: 100%;" border="0">
						<tr>
							<td style="width: 100%; height: 100%">
								<table border="0" cellpadding="0" cellspacing="0" style="width: 100%; height: 100%" class="sb-start-panel">
									<tr>
										<td style="padding: 10px 10px 0px 10px">
											<span class="sb-family-title" style="color: #039 !important;"><xsl:value-of select="START-DESCRIPTION/@TITLE"/></span><br/>
											<span class="sb-text"><xsl:value-of select="START-DESCRIPTION/@TEXT"/></span>
										</td>
									</tr>
									<tr>
										<td align="center" style="padding: 10px 10px 0px 10px; vertical-align: top">
											<input type="hidden" name="siteFamilia" id="siteFamilia">
												<xsl:attribute name="value">
													<xsl:value-of select="SITE-FAMILIES/FAMILIA[@ACTIVE=1]/@ID"/>
												</xsl:attribute>
											</input>
											<script type="text/javascript" src="/js/Wizard/SiteFamilies.js?{$version}.{$build}"></script>
											<script language="JavaScript" type="text/javascript">
												siteFamilies = new SiteFamilies('siteFamilia');
												siteFamilies.imageActive='<xsl:value-of select="$skinPath"/>/images/check_active.gif';
												siteFamilies.imageHighLight='<xsl:value-of select="$skinPath"/>/images/check_notactive.gif';
												siteFamilies.imageDisabled='<xsl:value-of select="$skinPath"/>/images/check_disabled.gif';
												siteFamilies.colorActive='#06c';
												siteFamilies.colorHighLight='#DBE0E8';
												siteFamilies.colorDisabled='#DBE0E8';
											</script>
											<xsl:apply-templates select="SITE-FAMILIES"/>
											<script language="JavaScript" type="text/javascript">
												<xsl:apply-templates select="SITE-FAMILIES/FAMILIA" mode="init"/>
											</script>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
		<xsl:apply-templates select="SELECT-TRIAL-SITE-FORM"/>
	</xsl:template>

<!--	-->

	<xsl:template match="SELECT-TRIAL-SITE-FORM" mode="content">
		<script language="JavaScript" type="text/javascript">
			function changeSite() {
				self.sbApplyChangesObject.registerChange();
				self.sbApplyChangesObject.registerForcedSaving();
				try {
					var selectedSiteId = document.getElementById('selectedSiteId').value;
				}catch(e){};

				if (selectedSiteId) {
					sbNavigationObject.setViewParam('siteId', selectedSiteId);
				}
				return sbNavigationObject.go();
			}
		</script>

		<input type="hidden" name="messageId">
			<xsl:attribute name="value"><xsl:value-of select="@MESSAGE-ID"/></xsl:attribute>
		</input>
		<table width="100%" border="0" style="height:100%; background-color: #F7F7F7;">
			<tr>
				<td>
					<xsl:call-template name="SELECT-TRIAL-SITE">
						<xsl:with-param name="TITLE" select="@TITLE"/>
						<xsl:with-param name="TEXT" select="@TEXT"/>
					</xsl:call-template>
				</td>
			</tr>
			<tr>
				<td align="center" style="height:40px; align: middle;">
					<xsl:call-template name="OK-BUTTON">
						<xsl:with-param name="action">
							return changeSite();
						</xsl:with-param>
					</xsl:call-template>
				</td>
			</tr>
		</table>
	</xsl:template>

<!--	-->

	<xsl:template match="SELECT-TRIAL-SITE-FORM">
		<xsl:call-template name="MODAL-FORM">
			<xsl:with-param name="formName">SB_SelectSiteForm</xsl:with-param>
			<xsl:with-param name="formTitle" select="@TITLE"/>
			<xsl:with-param name="closeHint" select="@CLOSE-HINT"/>
			<xsl:with-param name="additionalFormStyle">width: 530px; height: 300px;</xsl:with-param>
			<xsl:with-param name="content" select="current()" />
			<xsl:with-param name="onCloseAction">changeSite();</xsl:with-param>
		</xsl:call-template>
	</xsl:template>

<!--	-->
	<xsl:template name="SELECT-TRIAL-SITE">
		<xsl:param name="TITLE"></xsl:param>
		<xsl:param name="TEXT"></xsl:param>

		<table cellspacing="0" cellpadding="0" border="0" style="width: 100%; height: 100%; margin-top:0px;">
			<tr style="background-color: #FFFFFF;">
				<td align="center" style="height: 75px;">
					<table border="0" cellspacing="0" cellpadding="0">
						<tr>
							<td>
								<img border="0">
									<xsl:attribute name="src"><xsl:value-of select="$skinPath"/>/images/info.gif</xsl:attribute>
								</img>
							</td>
							<td style="padding-left: 10px; valign:middle;">
								<b><xsl:value-of select="$TITLE"/></b>
							</td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td align="center">
					<table cellspacing="0" cellpadding="0" border="0" style="width: 100%; margin-left:10px; margin-top:20px;">
						<tr>
							<td>
								<xsl:value-of select="$TEXT"/>
							</td>
						</tr>
						<xsl:apply-templates select="TRIAL-SITE-MODE">
						</xsl:apply-templates>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template match="TRIAL-SITE-MODE">
		<tr>
			<td style="padding-top:2px;">
				<input name="selectedSiteId" type="radio" style="margin-right: 10px;">
					<xsl:attribute name="id">radioSelectedSiteId<xsl:value-of select="position()"/></xsl:attribute>
					<xsl:if test="@CHECKED=1">
						<xsl:attribute name="checked">true</xsl:attribute>
					</xsl:if>
					<xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
					<xsl:attribute name="onChange">document.getElementById('selectedSiteId').value = this.value</xsl:attribute>
				</input>
				<label>
					<xsl:attribute name='for'>radioSelectedSiteId<xsl:value-of select="position()"/></xsl:attribute>
					<xsl:value-of select="@TITLE"/>
				</label>
				<xsl:if test="@CHECKED=1">
					<input type="hidden" id="selectedSiteId">
						<xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
					</input>
				</xsl:if>
			</td>
		</tr>
	</xsl:template>

</xsl:stylesheet>