<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template match="MODULES-LIST">
	<style>
		.sb-pagetitle { border-bottom: solid 1px #776655; }
	</style>
	<xsl:apply-templates/>
</xsl:template>

<xsl:template match="PAGED-LIST/LIST/HEADER">
<tr class="fixed">	
		<xsl:call-template name="LIST-HEADER-ITEM">
			<xsl:with-param name="title"><xsl:value-of select="NAME"/></xsl:with-param>
		</xsl:call-template>
	
		<xsl:call-template name="LIST-HEADER-ITEM">
			<xsl:with-param name="field">typeName</xsl:with-param>
			<xsl:with-param name="title"><xsl:value-of select="TYPE-NAME"/></xsl:with-param>
			<!--xsl:with-param name="width">25%</xsl:with-param-->
			<xsl:with-param name="currentSortField"><xsl:value-of select="../../LIST/@ORDER-BY"/></xsl:with-param>
			<xsl:with-param name="currentSortType"><xsl:value-of select="../../LIST/@ORDER-TYPE"/></xsl:with-param>
			<xsl:with-param name="align">right</xsl:with-param>
		</xsl:call-template>
		
		<xsl:call-template name="LIST-HEADER-ITEM">
			<xsl:with-param name="field">version</xsl:with-param>
			<xsl:with-param name="title"><xsl:value-of select="VERSION"/></xsl:with-param>
			<!--xsl:with-param name="width">25%</xsl:with-param-->
			<xsl:with-param name="currentSortField"><xsl:value-of select="../../LIST/@ORDER-BY"/></xsl:with-param>
			<xsl:with-param name="currentSortType"><xsl:value-of select="../../LIST/@ORDER-TYPE"/></xsl:with-param>
			<xsl:with-param name="align">right</xsl:with-param>
		</xsl:call-template>
	
	</tr>
</xsl:template>

<xsl:template match="PAGED-LIST/LIST/ITEM">
	<xsl:variable name="class">
	<xsl:call-template name="LIST-ROW-CLASS">
        	<xsl:with-param name="position"><xsl:value-of select="position()"/></xsl:with-param>
	</xsl:call-template>
</xsl:variable>
	<tr class="{$class}">
		<xsl:attribute name="id">module<xsl:value-of select="CODE"/></xsl:attribute>
		
		<xsl:choose>
			<xsl:when test="EDIT-VIEW!=''">
				<xsl:call-template name="LIST-ROW-ITEM">
					<xsl:with-param name="title"><xsl:value-of select="NAME"/></xsl:with-param>
					<xsl:with-param name="action"><xsl:value-of select="$baseUrl"/><xsl:value-of select="EDIT-VIEW"/></xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="LIST-ROW-ITEM">
					<xsl:with-param name="title"><xsl:value-of select="NAME"/></xsl:with-param>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	
		<xsl:call-template name="LIST-ROW-ITEM">
			<xsl:with-param name="title"><xsl:value-of select="TYPE-NAME"/></xsl:with-param>
			<xsl:with-param name="align">right</xsl:with-param>
		</xsl:call-template>
		
		<xsl:call-template name="LIST-ROW-ITEM">
			<xsl:with-param name="title"><xsl:value-of select="VERSION"/></xsl:with-param>
			<xsl:with-param name="align">right</xsl:with-param>
		</xsl:call-template>
	
	</tr>
</xsl:template>

</xsl:stylesheet>