<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template match="PAGESETS-LIST">
	<style>
		.sb-pagetitle { border-bottom: solid 1px #776655; }
	</style>
	<script type="text/javascript" src="/js/Admin/Pagesets.js?{$version}.{$build}"/>
	<xsl:apply-templates/>
</xsl:template>

<xsl:template match="PAGED-LIST/LIST/HEADER">
	<!--
	<xsl:variable name="headerStructure" select="document('d:/1.xml')"/>
	<xsl:for-each select="$headerStructure/root/item">
		<xsl:call-template name="LIST-HEADER-ITEM">
			<xsl:with-param name="field"><xsl:value-of select="field"/></xsl:with-param>
			<xsl:with-param name="title"><xsl:value-of select="title"/></xsl:with-param>
			<xsl:with-param name="width"><xsl:value-of select="width"/></xsl:with-param>
			<xsl:with-param name="align"><xsl:value-of select="align"/></xsl:with-param>
			<xsl:with-param name="currentSortField"><xsl:value-of select="../../LIST/@ORDER-BY"/></xsl:with-param>
			<xsl:with-param name="currentSortType"><xsl:value-of select="../../LIST/@ORDER-TYPE"/></xsl:with-param>
		</xsl:call-template>
	</xsl:for-each>
	-->

	<tr class="fixed">
		<th scope="col" style="width:1%;">
			<div>
				<input type="checkbox" name="globalCheck" onclick="setCheckboxStatus(this.checked);" class="check"/>
			</div>
		</th>
		
		<xsl:call-template name="LIST-HEADER-ITEM">
			<xsl:with-param name="field">code</xsl:with-param>
			<xsl:with-param name="title"><xsl:value-of select="CODE"/></xsl:with-param>
			<xsl:with-param name="currentSortField"><xsl:value-of select="../../LIST/@ORDER-BY"/></xsl:with-param>
			<xsl:with-param name="currentSortType"><xsl:value-of select="../../LIST/@ORDER-TYPE"/></xsl:with-param>
		</xsl:call-template>
		
		<xsl:call-template name="LIST-HEADER-ITEM">
			<xsl:with-param name="title"><xsl:value-of select="NAME"/></xsl:with-param>
		</xsl:call-template>
		
		<xsl:call-template name="LIST-HEADER-ITEM">
			<xsl:with-param name="title"><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/PAGES-COLUMN-TITLE"/></xsl:with-param>
		</xsl:call-template>
		
		<xsl:call-template name="LIST-HEADER-ITEM">
			<xsl:with-param name="title"><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/CLONE-COLUMN-TITLE"/></xsl:with-param>
		</xsl:call-template>
	</tr>
</xsl:template>

<xsl:template match="PAGED-LIST/LIST/ITEM">
	<xsl:variable name="class">
		<xsl:call-template name="LIST-ROW-CLASS">
        	<xsl:with-param name="position"><xsl:value-of select="position()"/></xsl:with-param>
		</xsl:call-template>
	</xsl:variable>
	
	<tr class="{$class}">	
		<td style="width:1%;text-align:center;">
			<input type="checkbox" name="objectIds[]" class="check">
				<xsl:if test="IS-BUILT-IN = 1 or IS-SINGLE-AT-PLAN = 1 or IS-OWN != 1"><xsl:attribute name="disabled">true</xsl:attribute></xsl:if>
				<xsl:attribute name="value"><xsl:value-of select="ID"/></xsl:attribute>
			</input>
		</td>
		
		<xsl:call-template name="LIST-ROW-ITEM">
			<xsl:with-param name="title"><xsl:value-of select="CODE"/></xsl:with-param>
			
			<xsl:with-param name="action"><xsl:if test="IS-BUILT-IN != 1 and IS-OWN = 1"><xsl:value-of select="$baseUrl"/>/Admin/Pagesets/Edit?pagesetId=<xsl:value-of select="PAGESET-ID"/></xsl:if></xsl:with-param>
				
			<xsl:with-param name="contextHelp">code</xsl:with-param>
		</xsl:call-template>
	
		<xsl:call-template name="LIST-ROW-ITEM">
			<xsl:with-param name="title"><xsl:value-of select="NAME"/></xsl:with-param>
		</xsl:call-template>
	
		<xsl:call-template name="LIST-ROW-ITEM">
			<xsl:with-param name="title"><xsl:value-of select="PAGES"/></xsl:with-param>
			<xsl:with-param name="align">right</xsl:with-param>
		</xsl:call-template>
	
		<td style="width:1%; text-align:center;">
			<a>
				<xsl:attribute name="href"><xsl:value-of select="$baseUrl"/>/Admin/Pagesets/Create?clonedPagesetId=<xsl:value-of select="PAGESET-ID"/></xsl:attribute>
				<xsl:attribute name="onmouseout">SetContextHelp();</xsl:attribute>
				<xsl:attribute name="onmouseover">SetContextHelp('CONTEXT-HELP-BUTTON-CLONE');</xsl:attribute>
						
				<img style="border-width:0px;width:16px;height:16px" src="{$skinPath}/icons/clonepageset.gif"/>
			</a>
		</td>
	</tr>
</xsl:template>

</xsl:stylesheet>