<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:output method="html" indent="yes" encoding="utf-8" doctype-public="-//W3C//DTD HTML 4.0 Transitional//EN"/>

	<xsl:variable name="skinPath"><xsl:value-of select="/SITEBUILDER-PAGE/PROPERTIES/SKIN-PATH" disable-output-escaping="yes"/></xsl:variable>
	<xsl:variable name="windowTitle">
		<xsl:if test="/SITEBUILDER-PAGE/VIEW-CONTENT/@TITLE">
			<xsl:value-of select="/SITEBUILDER-PAGE/VIEW-CONTENT/@TITLE"/> -
		</xsl:if>
		<xsl:value-of select="/SITEBUILDER-PAGE/PROPERTIES/CUSTOM-TITLE"/>
	</xsl:variable>

	<xsl:template match="/">

		<html>
			<head>
				<link href="/skins/common.css?{$version}.{$build}" type="text/css" rel="stylesheet" />
				<link href="{$skinPath}/style.css?{$version}.{$build}" type="text/css" rel="stylesheet" />
				<link href="/skins/style_ext.css?{$version}.{$build}" type="text/css" rel="stylesheet" />

				<link rel="shortcut icon" href="/favicon.ico?{$version}.{$build}" />

				<xsl:call-template name="JS-INCLUDE">
					<xsl:with-param name="file">/js/externals/prototype.js</xsl:with-param>
				</xsl:call-template>

				<xsl:call-template name="JS-INCLUDE">
					<xsl:with-param name="file">/js/externals/scriptaculous/scriptaculous.js</xsl:with-param>
				</xsl:call-template>

				<script type="text/javascript" src='/js/Sb.js?{$version}.{$build}'></script>
				<script type="text/javascript" src='/js/Sb/Console.js?{$version}.{$build}'></script>				
				<script type="text/javascript" src='/js/util.js?{$version}.{$build}'></script>
				<script type="text/javascript" src='/js/preloader.js?{$version}.{$build}'></script>
				<script type="text/javascript" src="/js/Sb/Cookie.js?{$version}.{$build}"/>
				<script type="text/javascript" src='/js/common.js?{$version}.{$build}'></script>
				<script type="text/javascript" src='/js/validator.js?{$version}.{$build}'></script>
				<script type="text/javascript" src='/js/SbAjaxRequest.js?{$version}.{$build}'></script>

				<style type="text/css">img{ behavior:url('/images/pngbehavior.htc?<xsl:value-of select="$version"/>.<xsl:value-of select="$build"/>'); }</style>

				<title><xsl:value-of select="$windowTitle"/></title>
			</head>

			<body onload="ProcessOnloadActions();">
				<script type='text/javascript'>
					if ('1' == '<xsl:value-of select="$debug"/>') {
						Sb.Console.enable();

						<xsl:for-each select="/SITEBUILDER-PAGE/PROPERTIES/DEBUG-LOG-MESSAGES/*">
							Sb.Console.log('<xsl:value-of select="./@MESSAGE"/>');
						</xsl:for-each>
					}
									
					Sb.Cookie.set('testCookie', 'test', '', '/');

					if ('test' != Sb.Cookie.get('testCookie')) {
						document.location.href = "<xsl:value-of select="$baseUrl"/>/NoCookies";
					}

					// define global variables
					sbSkinPath = '<xsl:value-of select="$skinPath"/>';
					sbBrowserEngine = '<xsl:value-of select="$browserEngine"/>';
					sbBaseUrl = '<xsl:value-of select="$baseUrl"/>';
					sbVersion = '<xsl:value-of select="$version"/>';
					sbBuild = '<xsl:value-of select="$build"/>';
				</script>

				<xsl:apply-templates select="SITEBUILDER-PAGE/JS-LOCALE"/>
				<div id="fullScreenDiv" style="position:absolute; background: #ffffff; filter:alpha(opacity=0); opacity: 0;"></div>
				<div id="disablerDiv" style="display: none; filter:alpha(opacity=40); background-color: #FFFFFF; opacity: 0.4;"/>

				<xsl:call-template name="PRELOADER"/>

				<script type='text/javascript'>
					sb_status = null;
				</script>
				<!--modal forms -->
				<xsl:apply-templates select="SITEBUILDER-PAGE/APPLY-CHANGES" mode="initAfterBody"/>
				<xsl:apply-templates select="SITEBUILDER-PAGE/LOGOUT-DIALOG" mode="initAfterBody" />
				<!--/modal forms -->
				<xsl:apply-templates select="SITEBUILDER-PAGE"/>
				<!--/form-->

				<xsl:if test="$googleAnalyticsId != ''">
					<script type="text/javascript">
						var gaJsHost = (("https:" == document.location.protocol) ? "https://ssl." : "http://www.");
						document.write(unescape("%3Cscript src='" + gaJsHost + "google-analytics.com/ga.js' type='text/javascript'%3E%3C/script%3E"));
					</script>
					<script type="text/javascript">
						var pageTracker = _gat._getTracker("<xsl:value-of select="$googleAnalyticsId"/>");
						pageTracker._initData();
						pageTracker._trackPageview();
					</script>
				</xsl:if>
			</body>
		</html>
	</xsl:template>

	<xsl:template match="*" mode="initAfterBody">
	</xsl:template>

	<xsl:template match="JS-LOCALE">
		<script src='/js/locale.js?{$version}.{$build}' type='text/javascript'></script>
		<script type="text/javascript" language="javascript">
			<xsl:for-each select="*">
				SbAppendLocaleKey('<xsl:value-of select="name()"/>', '<xsl:value-of select="."/>');
			</xsl:for-each>
		</script>
	</xsl:template>

	<xsl:template name="PRELOADER">
		<table id="SB_loader_table" cellpadding="0" cellspacing="0" border="0" width="100%" height="100%" style="display:none;z-index:1098;position:absolute;">
			<tr>
				<td id="SB_loader_td" style="filter:alpha(opacity=40);background-color:#ffffff;opacity:0.40;-moz-opacity:0.40;"></td>
			</tr>
		</table>
		<div id="DIV_DESKTOP" style="width:1%;height:1%;display:none;text-align:center;position:absolute;left:0px;top:0px;z-index:1001;"></div>
		<div id="loader" style="height:56px;width:320px;display:none;position:absolute;left:0px;top:0px;z-index:1100;">
			<table border="0" cellspacing="3" cellpadding="3" width="100%" height="100%"  class="sb-preloader-table">
				<tr>
					<td align="center" valign="middle" width="15%"><img id="ImagePreloader" src="{$skinPath}/images/loading.gif" style="border-width:0px;" /></td>
					<td align="left" valign="middle">
						<span id="LabelPreloader">
							<strong><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/LOADER-MESSAGE2" disable-output-escaping="yes"/></strong>&#160;<strong><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/LOADER-MESSAGE1" disable-output-escaping="yes"/></strong>
						</span>
					</td>
				</tr>
			</table>
		</div>
		<iframe src="/blank.html" id="SB_loader_iframe" name="SB_loader_iframe" frameborder="0" scrolling="no" style="border-width:0;display:none;z-index:1099;position:absolute;height:56px;width:320px;"></iframe>
		<script type="text/javascript" language="javascript">
			<xsl:comment>
				var sbPreloader = new SbPreloader();
				<xsl:choose>
					<xsl:when test="$preloader = 1">
						sbPreloader.show();
					</xsl:when>
					<xsl:otherwise>
						sbPreloader.disable();
					</xsl:otherwise>
				</xsl:choose>
			//</xsl:comment>
		</script>
	</xsl:template>

	<xsl:template name="HEADER-LOGO">
		<div style="width: 205px; text-align: center;">
			<img align="middle" style="" alt="" border="0">
				<xsl:attribute name="src"><xsl:value-of select="/SITEBUILDER-PAGE/PROPERTIES/CUSTOM-LOGO"/>?<xsl:value-of select="$version"/>.<xsl:value-of select="$build"/></xsl:attribute>
				<xsl:if test="/SITEBUILDER-PAGE/PROPERTIES/CUSTOM-LINK!=''">
					<xsl:attribute name="onclick">window.open('<xsl:value-of select="/SITEBUILDER-PAGE/PROPERTIES/CUSTOM-LINK"/>', '_new'); return false;</xsl:attribute>
					<xsl:attribute name="style">cursor: pointer;</xsl:attribute>
				</xsl:if>
			</img>
		</div>
	</xsl:template>
	
	<xsl:template name="TOP-HEADER">
		<table class="sb-adminpanel-header-inner" border="0" cellpadding="0" cellspacing="0" width="100%">
			<tr>
				<td valign="middle">
					<xsl:call-template name="HEADER-LOGO"/>
				</td>
				<td align="right" class="sb-header-copyright" style="padding-right: 15px; width: 100%;">
					<xsl:if test="$hideCopyright != 1">
						<xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/COPYRIGHT"/><br/><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/ALL-RIGHTS-RESERVED"/>
					</xsl:if>
				</td>
				<xsl:call-template name="HEADER-COMPANY-LOGO"/>
			</tr>
		</table>		
	</xsl:template>
	
	<xsl:template name="HEADER-COMPANY-LOGO">
		<xsl:param name="logoFileName">def_parallels_logo.gif</xsl:param>
	
		<xsl:if test="$isCustomLogo != 1">
			<td align="right" class="sb-header-company-logo">
				<img style="cursor: pointer" onclick="window.open('http://www.parallels.com', '_new'); return false;" border="0" src="{$skinPath}/images/{$logoFileName}"/>
			</td>
		</xsl:if>
	</xsl:template>
	

<!--	<xsl:template match="NAVIGATION">
		<xsl:comment>Nothing to do in NAVIGATION</xsl:comment>
	</xsl:template>
-->

<!--	<xsl:template match="VIEW-CONTENT">
		<xsl:comment>Nothing to do in VIEW-CONTENT</xsl:comment>
	</xsl:template>
-->

<!--	<xsl:template name="MAIN-PAGE-HEADER">
		<xsl:choose>
			<xsl:when test="PAGE-HEADER">
				<xsl:apply-templates select="PAGE-HEADER"/>
			</xsl:when>
			<xsl:otherwise>
				<tr>
					<td class="sb-adminpanel-header">
						<xsl:if test="NAVIGATION">
							<xsl:attribute name="colspan">2</xsl:attribute>
						</xsl:if>
						<table class="sb-adminpanel-header-inner" border="0" width="100%">
							<tr>
								<td valign="middle" style="padding-left:20;">
									<img onclick="window.open('http://swsoft.com', '_new'); return false;" src="{$skinPath}/images/def_sb_logo.gif" align="middle" style="border-width:0px;cursor:pointer;" alt=""/>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
-->

	<xsl:template match="SELECT-LANGUAGE">
		<xsl:param name="name" select="@NAME"/>
		<xsl:param name="onchange"/>

		<table cellpadding="0" cellspacing="0" border="0" class="control-title-near-input">
			<tr>
				<td valign="middle" style="width: 30px; padding-left: 14px;"><img src="{$skinPath}/images/language.gif" border="0" /></td>
				<td class="title-block">
					<xsl:call-template name="LABEL" mode="label">
						<xsl:with-param name="title" select="@TITLE"/>
					</xsl:call-template>
				</td>
				<td class="input-block">
					<select>
						<xsl:attribute name="name">
							<xsl:value-of select="$name"/></xsl:attribute>
						<xsl:attribute name="onchange"><xsl:value-of select="$onchange"/></xsl:attribute>
						<xsl:if test="@DISABLED = 1"><xsl:attribute name="disabled">true</xsl:attribute></xsl:if>
						<xsl:for-each select="LANGUAGE">
							<option value="">
								<xsl:attribute name="value"><xsl:value-of select="@ID"/></xsl:attribute>
								<xsl:if test="@SELECTED = 1">
									<xsl:attribute name="selected"><xsl:value-of select="@SELECTED"/></xsl:attribute>
								</xsl:if>
								<xsl:value-of select="@TITLE"/>
							</option>
						</xsl:for-each>
					</select>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template match="SELECT-SITE">
		<xsl:param name="id" select="@ID"></xsl:param>
		<xsl:param name="name" select="@NAME"></xsl:param>
		<xsl:param name="onchange"></xsl:param>

		<table cellpadding="0" cellspacing="0" border="0" class="control-title-near-input">
			<tr>
				<td class="title-block">
					<xsl:call-template name="LABEL" mode="label">
						<xsl:with-param name="id" select="$id"/>
						<xsl:with-param name="title" select="@TITLE"/>
					</xsl:call-template>
				</td>
				<td class="input-block">
					<select>
						<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
						<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
						<xsl:attribute name="onchange"><xsl:value-of select="$onchange"/></xsl:attribute>
						<xsl:if test="@DISABLED = 1"><xsl:attribute name="disabled">true</xsl:attribute></xsl:if>
						<xsl:for-each select="SITE">
							<option>
								<xsl:attribute name="value"><xsl:value-of select="@ID"/></xsl:attribute>
								<xsl:if test="@SELECTED = 1">
									<xsl:attribute name="selected"><xsl:value-of select="@SELECTED"/></xsl:attribute>
								</xsl:if>
								<xsl:value-of select="@TITLE"/>
							</option>
						</xsl:for-each>
					</select>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="nl2br">
		<xsl:param name="string"/>
		<xsl:value-of select="normalize-space(substring-before($string,'&#10;'))" />
		<xsl:choose>
			<xsl:when test="contains($string,'&#10;')">
				<br />
				<xsl:call-template name="nl2br">
					<xsl:with-param name="string" select="substring-after($string,'&#10;')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy-of select="$string"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="JS-INCLUDE">
		<xsl:param name="file"/>
		<xsl:variable name="compressExt">
			<xsl:if test="1 = $useGzip">.gz</xsl:if>
		</xsl:variable>

		<script type="text/javascript" src='{$file}{$compressExt}?{$version}.{$build}'/>
	</xsl:template>

</xsl:stylesheet>