<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template match="PAGED-LIST">
<script type="text/javascript" src="/js/list.js?{$version}.{$build}"/>
<script language="javascript">
function pagedListDoSort(tab, orderBy, orderType) {
	var formName = '<xsl:value-of select="@FORM-NAME"/>';
	var form = document.forms[formName];
	form.action = '<xsl:value-of select="@URL"/>';
	form.tab.value = tab;
	form.pageNum.value = 1;
	form.orderBy.value = orderBy;
	form.orderType.value = orderType;
	form.submit();
}
</script>
	<fieldset>
		<legend><xsl:value-of select="TOOLBAR/@TITLE"/></legend>
		<div class="fieldset-block">
			<xsl:apply-templates select="TOOLBAR"/>
			<xsl:choose>
				<xsl:when test="count(LIST/ITEM) &gt; 0">
					<xsl:apply-templates select="PAGER"/>
					<xsl:apply-templates select="LIST"/>
					<xsl:apply-templates select="PAGER"/>
					<script type="text/javascript" language="javascript">
						observeCheckboxesClick('<xsl:value-of select="LIST/@PREFIX"/>Ids[]',
							'Top<xsl:value-of select="LIST/@PREFIX"/>'
						);
						observeListRowsHighlight();
					</script>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/MSG-NO-RECORDS|MSG-NO-RECORDS"/>
				</xsl:otherwise>
			</xsl:choose>
		</div>
	</fieldset>
</xsl:template>

<xsl:template match="PAGED-LIST/LIST">
<div class="scroll-table">
	<table cellspacing="0" cellpadding="0" border="0" class="list-table">
		<xsl:apply-templates select="HEADER" />
		<xsl:apply-templates select="ITEM" />
	</table>
</div>
</xsl:template>

<xsl:template name="LIST-HEADER-ITEM">
<xsl:param name="align"/>
<xsl:param name="field"/>
<xsl:param name="title"/>
<xsl:param name="width"/>
<xsl:param name="currentSortField" value=''/>
<xsl:param name="currentSortType"/>
<xsl:param name="tab"/>

<xsl:variable name="orderType">
<xsl:choose>
	<xsl:when test="$field = $currentSortField">
		<xsl:choose>
			<xsl:when test="$currentSortType = 'ASC'">DESC</xsl:when>
			<xsl:otherwise>ASC</xsl:otherwise>
		</xsl:choose>
	</xsl:when>
	<xsl:otherwise>ASC</xsl:otherwise>
</xsl:choose>
</xsl:variable>

<th scope="col" style="width:{$width}; text-align:{$align};">
	<xsl:if test="$field = $currentSortField">
		<xsl:attribute name="class">list-table-active-area</xsl:attribute>
	</xsl:if>
	<div>
		<xsl:choose>
			<xsl:when test="$field">
				<a href="javascript:pagedListDoSort('{$tab}','{$field}','{$orderType}');">
					<xsl:value-of select="$title"/>
				</a>
				<xsl:if test="$field = $currentSortField">
					<xsl:choose>
						<xsl:when test="$currentSortType = 'ASC'">
							<img style="border-width:0px;vertical-align: middle; ">
								<xsl:attribute name="src"><xsl:value-of select="/SITEBUILDER-PAGE/PROPERTIES/SKIN-PATH/."/>/images/dlg_sort_up.gif</xsl:attribute>
							</img>
						</xsl:when>
						<xsl:otherwise>
							<img style="border-width:0px;vertical-align: middle; ">
								<xsl:attribute name="src"><xsl:value-of select="/SITEBUILDER-PAGE/PROPERTIES/SKIN-PATH/."/>/images/dlg_sort_down.gif</xsl:attribute>
							</img>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$title"/>
			</xsl:otherwise>
		</xsl:choose>
	</div>
</th>
</xsl:template>

<xsl:template name="LIST-ROW-CLASS">
<xsl:param name="position"/>
<xsl:choose>
	<xsl:when test="$position mod 2">list-table-row</xsl:when>
	<xsl:otherwise>list-table-row-alter</xsl:otherwise>
</xsl:choose>
</xsl:template>

<xsl:template name="LIST-ROW-ITEM">
<xsl:param name="align"/>
<xsl:param name="title"/>
<xsl:param name="action"/>
<xsl:param name="icon"/>
<xsl:param name="copyTitle">no</xsl:param>
<xsl:param name="wrap">wrap</xsl:param>
<td style="text-align:{$align};">
	<xsl:choose>
		<xsl:when test="$action">
			<a href="{$action}">
				<xsl:if test="$icon">
				<img style="border-width:0px;">
					<xsl:attribute name="src"><xsl:value-of select="/SITEBUILDER-PAGE/PROPERTIES/SKIN-PATH/."/>/icons/<xsl:value-of select="$icon"/></xsl:attribute>
				</img>
				</xsl:if>
				<xsl:value-of select="$title"/>
			</a>
		</xsl:when>
		<xsl:otherwise>
			<xsl:if test="$icon">
				<img border="0">
					<xsl:attribute name="src"><xsl:value-of select="/SITEBUILDER-PAGE/PROPERTIES/SKIN-PATH/."/>/icons/<xsl:value-of select="$icon"/></xsl:attribute>
				</img>
			</xsl:if>
			<xsl:choose>
				<xsl:when test="$copyTitle='yes'">
					<xsl:copy-of select="$title"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$title"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:otherwise>
	</xsl:choose>
</td>
</xsl:template>

<xsl:template match="PAGED-LIST/TOOLBAR">
	<xsl:choose>
		<xsl:when test="@TITLE">
			<xsl:call-template name="TOOLBAR-CONTENT"/>
<!--			</fieldset> -->
		</xsl:when>
		<xsl:otherwise>
			<xsl:call-template name="TOOLBAR-CONTENT"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="TOOLBAR-CONTENT">
	<xsl:apply-templates select="OPERATIONS"/>
	<div class="clear"/>	
	<table cellpadding="0" cellspacing="0" border="0">		
		<tr>
			<td><xsl:apply-templates select="LIST-VIEW-STATES"/></td>
			<td><xsl:apply-templates select="SEARCH-PANEL"/></td>
		</tr>
	</table>
</xsl:template>

<xsl:template match="PAGED-LIST/TOOLBAR/OPERATIONS">
<xsl:if test="count(../../LIST/ITEM) &gt; 0">
	<xsl:for-each select="OPERATION">
		<div class="list-tool-block">
			<table cellspacing="0" cellpadding="0" border="0" class="link-button-container">
				<tr>
					<td class="link-button-image-area">
						<a href="#">
							<xsl:attribute name="onclick"><xsl:value-of select="@ACTION"/></xsl:attribute>
							<img border="0" alt="">
								<xsl:attribute name="src"><xsl:value-of select="$skinPath"/>/icons/<xsl:value-of select="@ICON"/></xsl:attribute>
							</img>
						</a>
					</td>
					<td class="link-button-text-area">
						<a href="#" style="color: Black;">
							<xsl:attribute name="onclick"><xsl:value-of select="@ACTION"/></xsl:attribute>
							<xsl:value-of select="@TITLE"/>
						</a>
					</td>
				</tr>
			</table>
		</div>
	</xsl:for-each>
</xsl:if>
</xsl:template>

<xsl:template match="PAGED-LIST/TOOLBAR/SEARCH-PANEL">
<xsl:variable name="tab"><xsl:value-of select="ancestor::TAB-PANEL-CARD/@ID"/></xsl:variable>
<script language="javascript">
function pagedListShowAll(tab) {
	var formName = '<xsl:value-of select="../../@FORM-NAME"/>';
	var form = document.forms[formName];
	form.tab.value = tab;
	form.action = '<xsl:value-of select="../../@URL"/>';

	if (form.filterValue) {
		form.filterValue.selectedIndex = 0;
	}
	form.elements[tab+'searchString'].value='';
	form.submit();
}
function pagedListSearchItems(tab) {
	var formName = '<xsl:value-of select="../../@FORM-NAME"/>';
	var form = document.forms[formName];
	form.tab.value = tab;
	form.pageNum.value = 1;
	form.action = '<xsl:value-of select="../../@URL"/>';

	form.submit();
}
function pagedListChangeFilter(tab) {
	var formName = '<xsl:value-of select="../../@FORM-NAME"/>';
	var form = document.forms[formName];
	form.tab.value = tab;
	form.pageNum.value = 1;
	form.action = '<xsl:value-of select="../../@URL"/>';

	form.submit();
}
</script>

<table cellpadding="0" cellspacing="0" border="0" class="list-show-container">
	<tr>
		<td class="list-show-search-input-area">
			<xsl:call-template name="INPUT" mode="simple">
				<xsl:with-param name="name"><xsl:value-of select="$tab"/>searchString</xsl:with-param>
				<xsl:with-param name="value"><xsl:value-of select="."/></xsl:with-param>
			</xsl:call-template>
		</td>
		<td class="list-show-search-tool-area">
			<table cellpadding="0" cellspacing="0" border="0" type="button" style="cursor:pointer;" class="link-button-container">
				<xsl:attribute name="onclick">pagedListSearchItems('<xsl:value-of select="$tab"/>');</xsl:attribute>
				<tr>
					<td class="link-button-image-area">
						<img src="{$skinPath}/icons/search.png" alt=""/>
					</td>
					<td class="link-button-text-area"><span style="text-decoration: underline;"><xsl:value-of select="@SEARCH-TITLE"/></span></td>
				</tr>
			</table>
		</td>
		<td class="list-show-showall-tool-area">
			<table cellpadding="0" cellspacing="0" border="0" type="button" name="ImageButtonShowAll" style="cursor:pointer;" class="link-button-container">
				<xsl:attribute name="onclick">pagedListShowAll('<xsl:value-of select="$tab"/>');</xsl:attribute>
				<tr>
					<td class="link-button-image-area">
						<img src="{$skinPath}/icons/showall.png" alt=""/>
					</td>
						<td class="link-button-text-area"><span style="text-decoration: underline;"><xsl:value-of select="@SHOW-ALL-TITLE"/></span></td>
				</tr>
			</table>
		</td>
	</tr>
</table>
</xsl:template>

<xsl:template match="PAGED-LIST/TOOLBAR/LIST-VIEW-STATES">
<xsl:variable name="tab"><xsl:value-of select="ancestor::TAB-PANEL-CARD/@ID"/></xsl:variable>
<script language="javascript">
function pagedListChangeFilter(tab) {
	var formName = '<xsl:value-of select="../../@FORM-NAME"/>';
	var form = document.forms[formName];
	form.tab.value = tab;
	form.action = '<xsl:value-of select="../../@URL"/>';

	form.submit();
}
</script>

<table cellpadding="0" cellspacing="0" border="0" class="list-show-container">
	<tr>
		<td class="list-show-view-text-area">
			<xsl:call-template name="LABEL" mode="label">
				<xsl:with-param name="id"><xsl:value-of select="$tab"/>filterValue</xsl:with-param>
				<xsl:with-param name="title" select="@TITLE"/>
			</xsl:call-template>
		</td>
		<td class="list-show-view-list-area">
			<select>
				<xsl:if test="@DISABLED = 1"><xsl:attribute name="disabled">true</xsl:attribute></xsl:if>
				<xsl:attribute name="id"><xsl:value-of select="$tab"/>filterValue</xsl:attribute>
				<xsl:attribute name="name"><xsl:value-of select="$tab"/>filterValue</xsl:attribute>
				<xsl:attribute name="onchange">pagedListChangeFilter('<xsl:value-of select="$tab"/>');</xsl:attribute>
				<xsl:for-each select="STATE">
					<option>
						<xsl:if test="../@SELECTED = ."><xsl:attribute name="selected">true</xsl:attribute></xsl:if>
						<xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
						<xsl:if test="@LEVEL">
							<xsl:attribute name="style">white-space:pre;</xsl:attribute>
							<xsl:call-template name="LOOP-STRING">
								<xsl:with-param name="string">&#160;</xsl:with-param>
								<xsl:with-param name="level" select="3*@LEVEL"/>
							</xsl:call-template>
						</xsl:if>
						<xsl:value-of select="@TITLE"/>
					</option>
				</xsl:for-each>
			</select>
		</td>
	</tr>
</table>
</xsl:template>

</xsl:stylesheet>
