<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<!-- :INFO: add slashes to the end in every new version of SB - it's a cache protection -->
	<xsl:variable name="wysiwygPath">/wysiwyg//</xsl:variable>

	<xsl:template match="WYSIWYG[@MODE='wizard']">
		<xsl:variable name="Wysiwyg">
			<xsl:text>wysiwyg</xsl:text>
		</xsl:variable>
		<xsl:variable name="WysiwygIniter">
			<xsl:text>Init_</xsl:text>
			<xsl:value-of select="$Wysiwyg"/>
		</xsl:variable>
		<script type="text/javascript" src="/js/Wizard/Wysiwyg/SbImageHelper.js?{$version}.{$build}"></script>
		<script type="text/javascript" src="/js/Wizard/Wysiwyg/SbWysiwygForm.js?{$version}.{$build}"></script>
		<script type="text/javascript" src="/js/Wizard/Wysiwyg/SbPreserveSelectionForm.js?{$version}.{$build}"></script>
		<script type="text/javascript" src="/js/Wizard/Wysiwyg/SbImageFormLoader.js?{$version}.{$build}"></script>
		<script type="text/javascript" src="/js/Wizard/Wysiwyg/SbCropFormLoader.js?{$version}.{$build}"></script>
		<script type="text/javascript" src="/wysiwyg/fckeditor.js?{$version}.{$build}"></script>
		<script type="text/javascript">
			var editableSiteFolder="<xsl:value-of select="@EDITABLE-SITE-FOLDER"/>";
			self.siteFolder="<xsl:value-of select="@SITE-FOLDER"/>";
		 	function <xsl:value-of select="$WysiwygIniter"/>(editorFileFullPath) {
				if ('undefined'==typeof(editorFileFullPath)) {
					var editorFileFullPath="<xsl:value-of select="@EDITORFILEFULLPATH"/>";
				}
		 		<xsl:value-of select="$Wysiwyg"/>= new FCKeditor('<xsl:value-of select="$Wysiwyg"/>','100%','100%');
		 		<xsl:value-of select="$Wysiwyg"/>.BasePath = '<xsl:value-of select="$wysiwygPath"/>';		 		
		 		<xsl:value-of select="$Wysiwyg"/>.Config["CustomConfigurationsPath"] = <xsl:value-of select="$Wysiwyg"/>.BasePath + "/custom/config/<xsl:value-of select="@MODE"/>.js?<xsl:value-of select="$version"/>.<xsl:value-of select="$build"/>";
		 		<xsl:value-of select="$Wysiwyg"/>.Config["SkinPath"] = <xsl:value-of select="$Wysiwyg"/>.BasePath + 'editor/skins/silver/';
				<xsl:value-of select="$Wysiwyg"/>.ToolbarSet="<xsl:value-of select="@MODE"/>";
				<xsl:value-of select="$Wysiwyg"/>.EditorFile="<xsl:value-of select="@EDITOR"/>";
				<xsl:value-of select="$Wysiwyg"/>.EditorFileFullPath=editorFileFullPath;
				<xsl:value-of select="$Wysiwyg"/>.Config["AutoDetectLanguage"] = false;
				<xsl:value-of select="$Wysiwyg"/>.Config["DefaultLanguage"]="<xsl:value-of select="@LANGUAGE"/>";
				
				<xsl:if test="@IS-CSS-USED = '1'">
					<xsl:value-of select="$Wysiwyg"/>.Config["EditorAreaCSS"]=editableSiteFolder+"css/styles.css<xsl:value-of select="@CSS-UNIQUE-STRING"/>.<xsl:value-of select="$version"/>.<xsl:value-of select="$build"/>";
				</xsl:if>
				<xsl:value-of select="$Wysiwyg"/>.Config["Version"]="<xsl:value-of select="$version"/>.<xsl:value-of select="$build"/>";
				<xsl:value-of select="$Wysiwyg"/>.ReplaceTextarea();
			}
			var <xsl:value-of select="$Wysiwyg"/>=null;
			<xsl:call-template name="CUSTOM-SCRIPT">
				<xsl:with-param name="Initer">
					<xsl:value-of select="$WysiwygIniter"/>
				</xsl:with-param>
			</xsl:call-template>
		</script>
		<textarea id="{$Wysiwyg}" name="{@NAME}" style="border-width: 0px;"><xsl:value-of select="CONTENT"/></textarea>
	</xsl:template>


	<xsl:template match="WYSIWYG[@MODE!='module' and @MODE!='wizard']">
		<xsl:param name="Wysiwyg"><xsl:value-of select="@NAME"/></xsl:param>
		<xsl:variable name="WysiwygIniter">
			<xsl:text>Init_</xsl:text>
			<xsl:value-of select="$Wysiwyg"/>
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="@DISABLED = '1'">
				<textarea id="{$Wysiwyg}" name="{@NAME}" class="sb-control-input-input" style="height: 200px; width: 100%" disabled="disabled"><xsl:value-of select="CONTENT"/></textarea>
			</xsl:when>
			<xsl:otherwise>
				<script type="text/javascript" src="/wysiwyg/fckeditor.js?{$version}.{$build}"></script>
				<script language="JavaScript" type="text/javascript">
				 	function <xsl:value-of select="$WysiwygIniter"/>() {
				 		if (!<xsl:value-of select="$Wysiwyg"/>) {
					 		<xsl:value-of select="$Wysiwyg"/> = new FCKeditor('<xsl:value-of select="$Wysiwyg"/>', '100%', '250');
					 		<xsl:value-of select="$Wysiwyg"/>.BasePath = '<xsl:value-of select="$wysiwygPath"/>';
					 		<xsl:value-of select="$Wysiwyg"/>.Config["CustomConfigurationsPath"] = <xsl:value-of select="$Wysiwyg"/>.BasePath + "/custom/config/<xsl:value-of select="@MODE"/>.js?<xsl:value-of select="$version"/>.<xsl:value-of select="$build"/>";
					 		<xsl:value-of select="$Wysiwyg"/>.Config["SkinPath"] = <xsl:value-of select="$Wysiwyg"/>.BasePath + 'editor/skins/silver/';
							<xsl:value-of select="$Wysiwyg"/>.ToolbarSet = "<xsl:value-of select="@MODE"/>";
							<xsl:value-of select="$Wysiwyg"/>.EditorFile = "<xsl:value-of select="@EDITOR"/>";
							<xsl:value-of select="$Wysiwyg"/>.Config["AutoDetectLanguage"] = false;
							<xsl:value-of select="$Wysiwyg"/>.Config["DefaultLanguage"] = "<xsl:value-of select="@LANGUAGE"/>";
							<xsl:value-of select="$Wysiwyg"/>.Config["Version"] = "<xsl:value-of select="$version"/>.<xsl:value-of select="$build"/>";
							<xsl:value-of select="$Wysiwyg"/>.ReplaceTextarea();
						}
					}
					var <xsl:value-of select="$Wysiwyg"/>=null;
					<xsl:call-template name="CUSTOM-SCRIPT">
						<xsl:with-param name="Initer"><xsl:value-of select="$WysiwygIniter"/></xsl:with-param>
					</xsl:call-template>
				</script>
				<textarea id="{$Wysiwyg}" name="{@NAME}" style="border-width: 0px;"><xsl:value-of select="CONTENT"/></textarea>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="WYSIWYG[@MODE='module']" name="WYSIWYG-MODULE">
		<xsl:param name="config">default.js</xsl:param>
		<xsl:param name="height" value="200"/>
		<xsl:param name="Wysiwyg">
			<xsl:text>Wysiwyg_</xsl:text>
			<xsl:value-of select="@NAME"/>
		</xsl:param>
		
		<xsl:variable name="WysiwygIniter">
			<xsl:text>Init_</xsl:text>
			<xsl:value-of select="$Wysiwyg"/>
		</xsl:variable>
		
		<script type="text/javascript" src="/wysiwyg/fckeditor.js?{$version}.{$build}"></script>
		
		<script language="JavaScript" type="text/javascript">
		 	function <xsl:value-of select="$WysiwygIniter"/>() {
		 		if (!<xsl:value-of select="$Wysiwyg"/>) {
		 			<xsl:value-of select="$Wysiwyg"/> = new FCKeditor('<xsl:value-of select="$Wysiwyg"/>', '100%', '<xsl:value-of select="$height"/>');
		 			<xsl:value-of select="$Wysiwyg"/>.BasePath = '<xsl:value-of select="$wysiwygPath"/>';
		 			<xsl:value-of select="$Wysiwyg"/>.Config["CustomConfigurationsPath"] = <xsl:value-of select="$Wysiwyg"/>.BasePath + "/custom/config/modules/<xsl:value-of select="$config"/>?<xsl:value-of select="$version"/>.<xsl:value-of select="$build"/>";
		 			<xsl:value-of select="$Wysiwyg"/>.Config["SkinPath"] = <xsl:value-of select="$Wysiwyg"/>.BasePath + 'editor/skins/silver/';
		 			<xsl:value-of select="$Wysiwyg"/>.ToolbarSet = "module";
		 			
		 			<xsl:value-of select="$Wysiwyg"/>.Config["LinkUpload"] = false;
		 			<xsl:value-of select="$Wysiwyg"/>.Config["LinkBrowser"] = false;
		 			<xsl:value-of select="$Wysiwyg"/>.Config["ImageBrowser"] = false;
		 			
		 			<xsl:value-of select="$Wysiwyg"/>.Config["ImageUploadURL"] = '/Wizard/Edit/Wysiwyg/ImageUpload';
		 			
		 			<xsl:value-of select="$Wysiwyg"/>.Config["SmileyPath"] = '/images/modules/smiley/';
		 			
		 			<xsl:value-of select="$Wysiwyg"/>.Config["AutoDetectLanguage"] = false;
					<xsl:value-of select="$Wysiwyg"/>.Config["DefaultLanguage"]="<xsl:value-of select="@LANGUAGE"/>";
					<xsl:value-of select="$Wysiwyg"/>.Config["Version"]="<xsl:value-of select="$version"/>.<xsl:value-of select="$build"/>";
					<xsl:value-of select="$Wysiwyg"/>.ReplaceTextarea();
				}
			}
			var <xsl:value-of select="$Wysiwyg"/>=null;
			<xsl:call-template name="CUSTOM-SCRIPT">
				<xsl:with-param name="Initer">
					<xsl:value-of select="$WysiwygIniter"/>
				</xsl:with-param>
			</xsl:call-template>
			function checkUserAgent(r) {
				ua = navigator.userAgent.toLowerCase();
				return r.test(ua);
			}
			function resizeWysiwygContent() {
				var isChrome = checkUserAgent(/\bchrome\b/);
				if (!isChrome) return;
				var iframe = document.getElementById('<xsl:value-of select="$Wysiwyg"/>___Frame');
				iframe.onload = function() {
					setTimeout(
						function() {
							var oCell = iframe.contentWindow.document.getElementById('xEditingArea');
							if (oCell) {
								var eInnerElement = oCell.firstChild;
								if (eInnerElement) {
									eInnerElement.style.height = '0px';
									eInnerElement.style.height = (oCell.scrollHeight - 19) + 'px';
								}
							}
						},
						500
					)
				}
			}
			<xsl:call-template name="CUSTOM-SCRIPT">
				<xsl:with-param name="Initer">resizeWysiwygContent</xsl:with-param>
			</xsl:call-template>

		</script>
		<textarea id="{$Wysiwyg}" name="{@NAME}" style="border-width: 0px; height: 100%;">
			<xsl:value-of select="CONTENT"/>
		</textarea>
		<xsl:apply-templates select="JS-LOCALE"/>
	</xsl:template>

	<xsl:template match="WYSIWYG/JS-LOCALE">
        <script type="text/javascript">
			<xsl:for-each select="*">
				SbAppendLocaleKey('<xsl:value-of select="name()"/>', '<xsl:value-of select="."/>');
			</xsl:for-each>
        </script>
    </xsl:template>

	<xsl:template name="CUSTOM-SCRIPT">
		<xsl:param name="Initer" />
		<xsl:variable name="tabpanelId" select="ancestor::TAB-PANEL/@ID"/>
		<xsl:variable name="NotActiveTabCardId" select="ancestor::TAB-PANEL-CARD[not(@ACTIVE='1')]/@ID"/>
		<xsl:choose>
			<xsl:when test="$NotActiveTabCardId!=''" >
				RegisterOnloadAction('<xsl:call-template name="TAB-PANEl-CARD-ONLOAD-ACTION">
						<xsl:with-param name="tabpanelId"><xsl:value-of select="$tabpanelId"/></xsl:with-param>
						<xsl:with-param name="tabpanelCard"><xsl:value-of select="$NotActiveTabCardId"/></xsl:with-param>
						<xsl:with-param name="action"><xsl:value-of select="$Initer"/>();</xsl:with-param>
					</xsl:call-template>');
			</xsl:when>
			<xsl:otherwise>
				RegisterOnloadAction('<xsl:value-of select="$Initer"/>();');
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>