<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:output method="html" indent="yes" encoding="utf-8" doctype-public="-//W3C//DTD HTML 4.0 Transitional//EN"/>
	
	<xsl:template match="/">

		<html>
			<head>
				<title><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/PAGE-TITLE"/></title>				
				<script type="text/javascript" src='/js/Sb.js?{$version}.{$build}'></script>
				<script type="text/javascript" src="/js/Sb/Cookie.js?{$version}.{$build}"/>
			</head>
			
			<body>
				
				<script type="text/javascript">
					<xsl:comment>
						function continueAnyway() {
							Sb.Cookie.set('allowUnsupportedBrowser', 'yes', '', '/');
							document.location.href = document.getElementById('continueUrl').value;
						}
					//</xsl:comment>
				</script>
				
				<input type="hidden" name="continueUrl" id="continueUrl" value="{/SITEBUILDER-PAGE/LOCALE/CONTINUE-ANYWAY-LINK}"/>
			
				<table width="100%" style="height: 100%" cellspacing="0" cellpadding="0" border="0">
					<tr>
						<td width="100%" height="100%" align="center" valign="middle">
							<table width="467" border="0" cellpadding="0" cellspacing="0" style="color: #606060; font-family: Verdana; font-size: 11px; font-weight: bold;">
								<tr>
									<td width="60">
										<img src="/images/unsupported_browser/warning_left.gif" alt=""/>
									</td>
									<td width="400" valign="middle" height="40" align="center" style="background: #EEEEEE;">
										<xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/UNSUPPORTED-BROWSER"/><br/>
										<xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/RECOMMENDED-BROWSERS"/>
									</td>
									<td width="7"><img src="/images/unsupported_browser/warning_right.gif" alt=""/></td>
								</tr>
								<tr>
									<td colspan="3" align="right" style="padding-top: 10px;">
										<a href="#" onclick="continueAnyway();"><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/CONTINUE-ANYWAY"/></a>
									</td>
								</tr>
							</table>							
						</td>
					</tr>
				</table>
			</body>
		</html>
		
	</xsl:template>

</xsl:stylesheet>