<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:strip-space elements="*"/>
	<xsl:output method="html" indent="yes" encoding="utf-8"/>

	<xsl:template match="SITEBUILDER-PAGE">
		<xsl:apply-templates select="/SITEBUILDER-PAGE/ACTION-STATUS/DETAILS" mode="initAfterBody"/>
		<script type="text/javascript" language="javascript" src="/js/wizard.js?{$version}.{$build}"/>
		<script type="text/javascript" language="javascript" src="/js/navigation.js?{$version}.{$build}"/>
		<script type="text/javascript" language="javascript">
			var baseUrl='<xsl:value-of select="$baseUrl"/>';
			var sbNavigationObject;
			sbNavigationObject = new SB_Navigation('<xsl:value-of select="APPLY-CHANGES/@FORM-ID"/>', '<xsl:value-of select="APPLY-CHANGES/@VIEW-URL"/>');
			<xsl:apply-templates select="PREVIEW" mode="showPreview"/>
		</script>
		<form name="SB_WizardForm" method="post" enctype="multipart/form-data" onsubmit="return wizardFormSubmit();">
			<xsl:attribute name="action">
				<!--<xsl:value-of select="$baseUrl"/>-->
				<xsl:value-of select="/SITEBUILDER-PAGE/VIEW-CONTENT/@CURRENT-ACTION"/>
			</xsl:attribute>
			<xsl:apply-templates select="VIEW-CONTENT/EDITOR-AREA/*" mode="initAfterBody"/>
			<xsl:apply-templates select="VIEW-CONTENT/PUBLISH-MODAL-FORM" mode="initAfterBody"/>
			<table cellpadding="0" cellspacing="0" border="0" style="width: 100%; height: 100%">
				<xsl:call-template name="MAIN-PAGE-HEADER"/>
				<xsl:call-template name="MAIN-PAGE-CONTENT"/>
				<xsl:call-template name="MAIN-PAGE-FOOTER"/>
			</table>
		</form>
	</xsl:template>

	<xsl:template match="HINTBAR">
		<table cellpadding="0" cellspacing="0" border="0" width="100%" class="sb-header-bottom">
			<tr>
				<xsl:if test="SAVE-BUTTON">
					<td style="padding-left: 10px;">
						<xsl:call-template name="BUTTON-CONTROL">
							<xsl:with-param name="id">saveChangesButton</xsl:with-param>
							<xsl:with-param name="icon">save_icon.gif</xsl:with-param>
							<xsl:with-param name="title"><xsl:value-of select="SAVE-BUTTON/@TITLE"/></xsl:with-param>
							<xsl:with-param name="disabled">true</xsl:with-param>
						</xsl:call-template>

						<script type="text/javascript">
							sbApplyChangesObject.addListener(enableSaveChangesButton);
						</script>
					</td>
				</xsl:if>
				<td style="padding-left: 10px; width: 100%;" onclick="sb_status.showDetails();" id="StatusBar">
					<table cellpadding="0" cellspacing="3" width="100%" border="0" style="display:inline-block;width:100%;">
						<tr>
							<td valign="middle">
								<xsl:apply-templates select="/SITEBUILDER-PAGE/ACTION-STATUS" mode="icon"/>
							</td>
							<td valign="middle" width="100%" style="padding-left: 10px;">
								<div id="StatusMessage" class="sb-statusbar-text">
									<xsl:choose>
										<xsl:when test="/SITEBUILDER-PAGE/ACTION-STATUS/MESSAGE">
											<xsl:if test="/SITEBUILDER-PAGE/ACTION-STATUS/DETAILS/MESSAGE-DETAILED"><xsl:attribute name="style">cursor: pointer;</xsl:attribute></xsl:if>
											<xsl:value-of select="/SITEBUILDER-PAGE/ACTION-STATUS/MESSAGE"/>
											<xsl:if test="/SITEBUILDER-PAGE/ACTION-STATUS/DETAILS/MESSAGE-DETAILED">
												<xsl:text> </xsl:text>
												<xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/DETAILED-CLICK-HERE"/>
											</xsl:if>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="SHORT-HELP/@TITLE"/>
										</xsl:otherwise>
									</xsl:choose>
								</div>
							</td>
						</tr>
					</table>
					<script type="text/javascript" language="javascript" src="/js/Wizard/Status.js?{$version}.{$build}"/>
					<script type="text/javascript" language="javascript">
						sb_status = new SB_Status('<xsl:value-of select="$skinPath"/>');
						<xsl:apply-templates select="/SITEBUILDER-PAGE/ACTION-STATUS/DETAILS/MESSAGE-DETAILED"/>
					</script>
                </td>
                <td class="sb-header-bottom-right">
					<table cellspacing="0" cellpadding="0" border="0" style="height: 100%;">
						<tr>
							<xsl:for-each select="ITEM">
							<td>
								<a style="text-decoration: none">
									<xsl:choose>
										<xsl:when test="substring-before(@ACTION,':')='javascript'">
											<xsl:attribute name="onclick"><xsl:value-of select="@ACTION"/></xsl:attribute>
											<xsl:attribute name="href">#</xsl:attribute>
										</xsl:when>
										<xsl:otherwise>
											<xsl:attribute name="href"><xsl:value-of select="@ACTION"/></xsl:attribute>
										</xsl:otherwise>
									</xsl:choose>

									<xsl:if test="@ACTION-TARGET != ''">
										<xsl:attribute name="target"><xsl:value-of select="@ACTION-TARGET"/></xsl:attribute>
									</xsl:if>

									<table cellpadding="0" cellspacing="0" border="0" type="button" style="height:100%;">
										<tr>
											<xsl:if test="@ICON != ''">
												<td style="padding: 5px;">
													<img style="border-width:0px;" width="16" height="16">
														<xsl:attribute name="src"><xsl:value-of select="$skinPath"/>/icons/<xsl:value-of select="@ICON"/></xsl:attribute>
													</img>
												</td>
											</xsl:if>
											<td class="sb-tools-text" style="padding-right:10px;">
												<xsl:value-of select="@TITLE"/>
											</td>
										</tr>
									</table>
								</a>
						   	</td>
							</xsl:for-each>
						</tr>
					</table>
                </td>
            </tr>
        </table>
	</xsl:template>

	<xsl:template name="MAIN-PAGE-HEADER">
		<tr id="TRHeader">
		<td COLSPAN="2">
			<table cellpadding="0" cellspacing="0" border="0" width="100%" class="sb-header-top-container">
				<tr>
					<td>
						<table cellpadding="0" cellspacing="0" border="0" style="width: 100%; height: 100%;" class="sb-header-top">
							<tr>
								<td width="100%">
								    <xsl:call-template name="HEADER-LOGO"/>
								</td>
								<td style="padding-right: 10px;">
									<table cellspacing="0" cellpadding="0" border="0" style="border-width:0px;border-collapse:collapse;">
										<tr>
											<xsl:apply-templates select="NAVIGATION/STEP"/>
										</tr>
									</table>
								</td>
								<xsl:call-template name="HEADER-COMPANY-LOGO">
									<xsl:with-param name="logoFileName">def_parallels_logo_wizard.gif</xsl:with-param>
								</xsl:call-template>
							</tr>
						</table>
					</td>
				</tr>
			</table>
			<xsl:apply-templates select="HINTBAR"/>
		</td>
		</tr>
	</xsl:template>

	<xsl:template name="MAIN-PAGE-CONTENT">
		<xsl:if test="VIEW-CONTENT/SELECT-LANGUAGE and (not(VIEW-CONTENT/SELECT-LANGUAGE/@HIDDEN) or VIEW-CONTENT/SELECT-LANGUAGE/@HIDDEN=false or VIEW-CONTENT/SELECT-LANGUAGE/@HIDDEN = 0) or VIEW-CONTENT/SELECT-SITE">
		<tr>
			<td style="vertical-align: top; padding: 10px 10px 0px 10px;" align="center" colspan="2" >
				<table class="sb-overview-table" cellpadding="6" cellspacing="0" width="100%" border="0">
					<tr>
					<xsl:if test="VIEW-CONTENT/SELECT-LANGUAGE and (not(VIEW-CONTENT/SELECT-LANGUAGE/@HIDDEN) or VIEW-CONTENT/SELECT-LANGUAGE/@HIDDEN=false or VIEW-CONTENT/SELECT-LANGUAGE/@HIDDEN = 0)">
						<td align="left">
							<table class="sb-start-panel" width="100%">
								<tr>
									<td>
										<xsl:apply-templates select="VIEW-CONTENT/SELECT-LANGUAGE">
											<xsl:with-param name="onchange">
												sbApplyChangesObject.registerChange();
												sbApplyChangesObject.registerForcedSaving();
												return sbNavigationObject.go();
											</xsl:with-param>
										</xsl:apply-templates>
									</td>
								</tr>
							</table>
						</td>
					</xsl:if>

					<xsl:if test="VIEW-CONTENT/SELECT-SITE">
						<td align="right">
							<table class="sb-start-panel" width="100%">
								<tr>
									<td align="right">
										<xsl:apply-templates select="VIEW-CONTENT/SELECT-SITE">
											<xsl:with-param name="onchange">
												sbApplyChangesObject.registerChange();
												sbApplyChangesObject.registerForcedSaving();

												try {
													var selectSite = document.getElementById('selectSite').value;
												}catch(e){};

												if (selectSite) {
													sbNavigationObject.setViewParam('siteId', selectSite);
												}

												return sbNavigationObject.go();
											</xsl:with-param>
										</xsl:apply-templates>
									</td>
								</tr>
							</table>
						</td>
					</xsl:if>

					</tr>
				</table>
			</td>
		</tr>
		</xsl:if>
		<tr>
			<td class="sb-wizard-layout-content">
				<xsl:apply-templates select="VIEW-CONTENT"/>
			</td>
		</tr>
	</xsl:template>

	<xsl:template name="ACTIVE-NAVIGATION-STEP">
		<td style="background-image:url({$skinPath}/images/steps_abg.gif);padding-left:5px;padding-right:3px;">
			<img>
				<xsl:attribute name="src"><xsl:value-of select="$skinPath"/>/images/steps_<xsl:value-of select="@ID"/>_abullet.gif</xsl:attribute>
			</img>
		</td>
		<td class="sb-steps-text-active" style="padding: 0 5px 0 2px; background-image:url({$skinPath}/images/steps_abg.gif);">
			<xsl:value-of select="@TITLE"/>
		</td>
	</xsl:template>

	<xsl:template name="INACTIVE-NAVIGATION-STEP">
		<td style="background-image:url({$skinPath}/images/steps_bg.gif);padding-left:5px;padding-right:3px;">
			<img>
				<xsl:attribute name="src"><xsl:value-of select="$skinPath"/>/images/steps_<xsl:value-of select="@ID"/>_bullet.gif</xsl:attribute>
			</img>
		</td>
		<td class="sb-steps-text" style="padding: 0 5px 0 2px; background-image:url({$skinPath}/images/steps_bg.gif);white-space:nowrap;">
			<xsl:value-of select="@TITLE"/>
		</td>
	</xsl:template>

	<xsl:template match="NAVIGATION/STEP">
		<xsl:variable name="nextActive" select="following-sibling::STEP[1]/@ACTIVE='1'"/>
		<td>
			<table cellpadding="0" cellspacing="0" border="0" type="button" >
				<xsl:if test="not(@ACTIVE='1')">
					<xsl:attribute name="onclick">return sbNavigationObject.go('<xsl:value-of select="@ACTION"/>');</xsl:attribute>
					<xsl:attribute name="style">cursor: pointer;</xsl:attribute>
				</xsl:if>
				<tr>
				<xsl:choose>
					<xsl:when test="position() = 1 and @ACTIVE='1'">
						<td><img src="{$skinPath}/images/steps_separator_aleft.gif" /></td>
					</xsl:when>
					<xsl:when test="position() > 1 and @ACTIVE='1'">
						<td><img src="{$skinPath}/images/steps_separator_al.gif" /></td>
					</xsl:when>
					<xsl:when test="position() = 1">
						<td><img src="{$skinPath}/images/steps_separator_left.gif" /></td>
					</xsl:when>
				</xsl:choose>

				<xsl:choose>
					<xsl:when test="@ACTIVE='1'">
						<xsl:call-template name="ACTIVE-NAVIGATION-STEP"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="INACTIVE-NAVIGATION-STEP"/>
					</xsl:otherwise>
				</xsl:choose>

				<xsl:choose>
					<xsl:when test="position() = last() and @ACTIVE='1'">
						<td><img src="{$skinPath}/images/steps_separator_aright.gif" /></td>
					</xsl:when>
					<xsl:when test="position() = last()">
						<td><img src="{$skinPath}/images/steps_separator_right.gif" /></td>
					</xsl:when>
					<xsl:when test="@ACTIVE='1'">
						<td><img src="{$skinPath}/images/steps_separator_ar.gif" /></td>
					</xsl:when>
					<xsl:when test="not($nextActive)">
						<td><img src="{$skinPath}/images/steps_separator.gif"/></td>
					</xsl:when>
				</xsl:choose>
				</tr>
			</table>
		</td>
	</xsl:template>

	<xsl:template name="MAIN-PAGE-FOOTER">
		<tr id="TRFooter">
			<td colspan="2">
                <table cellpadding="0" cellspacing="0" border="0" width="100%" class="sb-footer-container">
                    <tr>
                        <td class="sb-footer">
                            <table cellpadding="0" cellspacing="0" border="0" style="width: 100%; height: 100%;">
                                <tr>
                                    <td>
                						<table border="0" cellpadding="0" cellspacing="5" style="height: 100%; padding: 5px 0;">
                							<tr>
                								<td class="sb-footer-text" style="white-space: nowrap;padding-left: 15px;">
                									<xsl:if test="$hideCopyright != 1">
                										&#160;<xsl:value-of select="COPYRIGHT/@TITLE"/>
                									</xsl:if>
                								</td>
                							</tr>
                						</table>
                                    </td>
                                    <td align="right" style="padding-right: 10px;">
                						<table cellpadding="0" cellspacing="0">
                							<tr>
                								<xsl:if test="NAVIGATION/BACKWARD">
                								<td>
                									<table cellpadding="0" cellspacing="0" border="0" type="button" value="Back" style="cursor:pointer;">
                										<xsl:attribute name="onclick">return sbNavigationObject.go('<xsl:value-of select="NAVIGATION/BACKWARD/@ACTION"/>');</xsl:attribute>
                										<tr>
                											<td>
                												<img src="{$skinPath}/images/go_back_l.gif" />
                											</td>
                											<td style="background-image:url({$skinPath}/images/go_bg.gif);padding-left:15px;padding-right:5px;">
                												<img src="{$skinPath}/images/go_back_bullet.gif" />
                											</td>
                											<td align="center" class="sb-go-text" style="padding: 0 15px 0 5px; width:40px; background-image:url({$skinPath}/images/go_bg.gif);">
                												<xsl:value-of select="NAVIGATION/BACKWARD/@TITLE"/>
                											</td>
                											<td>
                												<img src="{$skinPath}/images/go_back_r.gif" />
                											</td>
                										</tr>
                									</table>
                								</td>
                							 	</xsl:if>
                								<xsl:if test="NAVIGATION/PREVIEW">
                									<td>
                										<table cellpadding="0" cellspacing="0" border="0" type="button" value="Preview" style="cursor: pointer;" >
                											<!--<xsl:attribute name="onclick">if(sbApplyChangesObject.isSavingRequired()){sbNavigationObject.setViewParam('preview','show');sbNavigationObject.go('<xsl:value-of select="NAVIGATION/PREVIEW/@ACTION"/>');}else{window.open('<xsl:value-of select="NAVIGATION/PREVIEW/@DIRECT-ACTION"/>','site_<xsl:value-of select="NAVIGATION/PREVIEW/@SITE-ID"/>_preview','title=no,menubar=no,toolbar=no,location=no,status=no,scrollbars=yes,resizable=yes');}</xsl:attribute>-->
                											<xsl:choose>
                												<xsl:when test="NAVIGATION/PUBLISH">
                													<xsl:attribute name="onclick"><xsl:value-of select="NAVIGATION/PREVIEW/@ACTION"/></xsl:attribute>
                												</xsl:when>
                												<xsl:otherwise>
                													<xsl:attribute name="onclick">sbNavigationObject.setViewParam('preview','show');sbNavigationObject.go('<xsl:value-of select="NAVIGATION/PREVIEW/@ACTION"/>');sbNavigationObject.unsetViewParam('preview');</xsl:attribute>
                												</xsl:otherwise>
                											</xsl:choose>
                											<tr>
                												<td style="width:0px;"></td>
                												<td style="background-image:url({$skinPath}/images/go_bg.gif);padding-left:15px;padding-right:5px;">
                													<img src="{$skinPath}/images/go_preview_bullet.gif" />
                												</td>
                												<td align="center" class="sb-go-text" style="padding: 0 15px 0 5px; width:40px; background-image:url({$skinPath}/images/go_bg.gif);">
                													<xsl:value-of select="NAVIGATION/PREVIEW/@TITLE"/>
                												</td>
                												<xsl:if test="not(NAVIGATION/FORWARD) and not(NAVIGATION/PUBLISH)">
                												<td>
                													<img src="{$skinPath}/images/go_next_r.gif" />
                												</td>
                												</xsl:if>
                											</tr>
                										</table>
                									</td>
                							 	</xsl:if>
                								<xsl:if test="NAVIGATION/FORWARD">
                								<td>
                									<table cellpadding="0" cellspacing="0" border="0" value="Forward" style="cursor:pointer;">
                										<xsl:attribute name="onclick">return sbNavigationObject.go('<xsl:value-of select="NAVIGATION/FORWARD/@ACTION"/>');</xsl:attribute>
                										<tr>
                											<td>
                												<img src="{$skinPath}/images/go_start_l.gif" border="0">
                													<xsl:if test="NAVIGATION/PREVIEW|NAVIGATION/BACKWARD">
                														<xsl:attribute name="src"><xsl:value-of select="$skinPath"/>/images/go_next_l.gif</xsl:attribute>
                													</xsl:if>
                												</img>

                											</td>
                											<td background="{$skinPath}/images/go_bg.gif" style="padding-left:15px;padding-right:5px;">
                												<img src="{$skinPath}/images/go_next_bullet.gif"  border="0"/>
                											</td>
                											<td align="center" class="sb-go-text" style="padding: 0 15px 0 5px; width:40px; background-image:url({$skinPath}/images/go_bg.gif);">
                												<xsl:value-of select="NAVIGATION/FORWARD/@TITLE"/>
                											</td>
                											<td><img src="{$skinPath}/images/go_next_r.gif"  border="0"/></td>
                										</tr>
                								 	</table>
                								</td>
                						 		</xsl:if>
                								<xsl:if test="NAVIGATION/PUBLISH">
                								<td>
                									<table cellpadding="0" cellspacing="0" border="0" value="Publish" style="cursor:pointer;">
                										<xsl:attribute name="onclick"><xsl:value-of select="NAVIGATION/PUBLISH/@ACTION"/></xsl:attribute>
                										<tr>
                											<td>
                												<img src="{$skinPath}/images/go_start_l.gif" border="0">
                													<xsl:if test="NAVIGATION/PREVIEW|NAVIGATION/BACKWARD">
                														<xsl:attribute name="src"><xsl:value-of select="$skinPath"/>/images/go_next_l.gif</xsl:attribute>
                													</xsl:if>
                												</img>

                											</td>
                											<td background="{$skinPath}/images/go_bg.gif" style="padding-left:15px;padding-right:5px;">
                												<img src="{$skinPath}/images/go_next_bullet.gif"  border="0"/>
                											</td>
                											<td align="center" class="sb-go-text" style="padding: 0 15px 0 5px; width:40px; background-image:url({$skinPath}/images/go_bg.gif);">
                												<xsl:value-of select="NAVIGATION/PUBLISH/@TITLE"/>
                											</td>
                											<td><img src="{$skinPath}/images/go_next_r.gif"  border="0"/></td>
                										</tr>
                								 	</table>
                								</td>
                							 	</xsl:if>
                							</tr>
                						</table>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
			</td>
		</tr>
	</xsl:template>

	<xsl:template match="ACTION-STATUS" mode="icon">
		<img id="StatusIcon" style="border-width:0px;">
			<xsl:attribute name="src">
				<xsl:value-of select="$skinPath"/>
				<xsl:choose>
					<xsl:when test="@STATUS='3' and MESSAGE">/icons/warning.gif</xsl:when>
					<xsl:when test="@STATUS='2' and MESSAGE">/images/icon_stop.gif</xsl:when>
					<xsl:when test="@STATUS='1' and MESSAGE">/images/icon_info.gif</xsl:when>
					<xsl:otherwise>/images/icon_help.gif</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</img>
	</xsl:template>

	<xsl:template match="ACTION-STATUS[@STATUS='1' or @STATUS='2' or @STATUS='3']/DETAILS/MESSAGE-DETAILED">
		<xsl:text>sb_status.addDetailedMessage('</xsl:text><xsl:value-of select="@NAME"/><xsl:text>',</xsl:text>
		<xsl:choose>
			<xsl:when test="@STATUS = '0'">HELP</xsl:when>
			<xsl:when test="@STATUS = '1'">INFO</xsl:when>
			<xsl:when test="@STATUS = '3'">WARNING</xsl:when>
			<xsl:when test="@STATUS = '2'">ERROR</xsl:when>
			<xsl:otherwise>ERROR</xsl:otherwise>
		</xsl:choose>);
	</xsl:template>

	<xsl:template name="DETAILS-TOOLBAR">
		<div style="margin-bottom: 7px;">
			<table cellspacing="1" border="0" style="width: 720px;" align="center">
				<tr>
					<td>
						<table cellspacing="0" cellpadding="0" border="0" style="border-collapse: collapse;">
							<tr>
								<td valign="middle" class="sb-text" style="padding-right: 5px;">
									<xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/DETAILED-VIEW"/>
								</td>
								<td valign="middle" style="padding-right: 5px;">
									<select class="sb-text" onchange="sb_status.filterDetails(this.value)">
										<option value="0">
											<xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/DETAILED-ALL"/>
										</option>
										<option value="1">
											<xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/DETAILED-INFO"/>
										</option>
										<option value="2">
											<xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/DETAILED-ERR"/>
										</option>
										<option value="3">
											<xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/DETAILED-WARN"/>
										</option>
									</select>
								</td>
							</tr>
						</table>
					</td>
					<td align="right">
						<xsl:call-template name="BUTTON">
							<xsl:with-param name="action">sb_status.clearDetails();</xsl:with-param>
							<xsl:with-param name="title" select="/SITEBUILDER-PAGE/LOCALE/DETAILED-MESSAGES-CLEAR"/>
							<xsl:with-param name="align">right</xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</table>
		</div>
	</xsl:template>

	<xsl:template name="DETAILS-LIST">
		<div style="height: 180px; border-style: solid; border-width: 0px; width: 100%; overflow-y: auto; overflow-x: auto; overflow: auto; float: left;">
			<table cellspacing="1" border="0" style="width: 100%;" align="center" id="StatusDetailedMessages">
				<tr class="sb-gridview-header" align="left" style="height: 24px; white-space: nowrap;">
					<th style="padding-left: 4px; padding-right: 4px; text-align: left; width: 15px;" scope="col" >#</th>
					<th style="padding-left: 4px; padding-right: 4px; text-align: center; width: 25px;" scope="col"><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/DETAILED-STATUS"/></th>
					<th style="padding-left: 4px; padding-right: 4px;" scope="col"><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/DETAILED-MESSAGE"/></th>
				</tr>
				<tr class="0" style="display: none;">
					<td style="padding-left: 4px; padding-right: 4px; text-align: left; width: 15px;" class="sb-gridtext">&#160;</td>
					<td style="padding-left: 4px; padding-right: 4px; text-align: center; width: 25px;" class="sb-gridtext">&#160;</td>
					<td style="padding-left: 4px; padding-right: 4px;" class="sb-gridtext">&#160;</td>
				</tr>
				<tr class="1" style="display: none;">
					<td style="padding-left: 4px; padding-right: 4px; text-align: left; font-wight: bold; width: 15px;" class="sb-gridtext">&#160;</td>
					<td style="padding-left: 4px; padding-right: 4px; text-align: center; width: 25px;" class="sb-gridtext">&#160;</td>
					<td style="padding-left: 4px; padding-right: 4px;" class="sb-gridtext">&#160;</td>
				</tr>
			</table>
		</div>
	</xsl:template>

	<xsl:template name="DETAILS-BOTTOM">
		<div style="padding-top: 7px; width: 100%;">
			<xsl:call-template name="BUTTON">
				<xsl:with-param name="action">sb_status.hideDetails();return false;</xsl:with-param>
				<xsl:with-param name="title" select="/SITEBUILDER-PAGE/LOCALE/DETAILED-MESSAGES-CLOSE"/>
				<xsl:with-param name="align">right</xsl:with-param>
			</xsl:call-template>
		</div>
	</xsl:template>

	<xsl:template match="DETAILS" mode="content">
		<div>
			<xsl:call-template name="DETAILS-TOOLBAR"/>
			<xsl:call-template name="DETAILS-LIST"/>
			<xsl:call-template name="DETAILS-BOTTOM"/>
		</div>
	</xsl:template>

	<xsl:template match="ACTION-STATUS/DETAILS" mode="initAfterBody">
		<xsl:call-template name="MODAL-FORM">
			<xsl:with-param name="formName">StatusDetailed</xsl:with-param>
			<xsl:with-param name="formTitle" select="/SITEBUILDER-PAGE/LOCALE/DETAILED-MESSAGES-TITLE"/>
			<xsl:with-param name="additionalFormStyle">width: 750px; height: 370px; display: none;</xsl:with-param>
			<xsl:with-param name="content" select="current()" />
			<xsl:with-param name="onCloseAction">sb_status.hideDetails();return false;</xsl:with-param>
			<xsl:with-param name="statusShowClickHere">0</xsl:with-param>
		</xsl:call-template>
	</xsl:template>

	<xsl:template match="ACTION-STATUS[@STATUS='2' and MESSAGE]">
		<script language="JavaScript" type="text/javascript">
			<xsl:apply-templates select="MESSAGE" mode="actionStatus"/>
		</script>
	</xsl:template>
	<xsl:template match="MESSAGE" mode="actionStatus">
		alert('<xsl:value-of select="."/>');
	</xsl:template>

	<xsl:template match="PREVIEW" mode="showPreview">try { var w=window.open('<xsl:value-of select="@DIRECT-ACTION"/>&amp;'+Math.random(),'site_<xsl:value-of select="@SITE-ID"/>_preview','title=no,menubar=no,toolbar=no,location=yes,status=yes,scrollbars=yes,resizable=yes'); w.focus(); window.location.href="<xsl:value-of select='/SITEBUILDER-PAGE/VIEW-CONTENT/@CURRENT-STEP'/>";} catch(e) { alert(SbGetLocaleByKey('PREVIEW-POPUP-BLOCKED')); }</xsl:template>

	<xsl:template match="APPLY-CHANGES" mode="initAfterBody">
		<xsl:call-template name="MODAL-FORM">
			<xsl:with-param name="formName">SbApplyChanges</xsl:with-param>
			<xsl:with-param name="formTitle" select="@TITLE"/>
			<xsl:with-param name="closeHint" select="@CLOSE-HINT"/>
			<xsl:with-param name="additionalFormStyle">width:300px; height:145px; display:none;</xsl:with-param>
			<xsl:with-param name="content" select="current()"/>
			<xsl:with-param name="onCloseAction">sbApplyChangesObject.hide();</xsl:with-param>
			<xsl:with-param name="showStatus">0</xsl:with-param>
		</xsl:call-template>
		<script type="text/javascript" language="javascript" src="/js/apply_changes.js?{$version}.{$build}"/>
		<script type="text/javascript" language="javascript">
			<xsl:comment>
				sbApplyChangesObject = new SB_ApplyChanges('SbApplyChanges');
			//</xsl:comment>
		</script>
	</xsl:template>

	<xsl:template match="APPLY-CHANGES" mode="content">
		<table width="80%" cellspacing="0" cellpadding="0" border="0" align="center">
			<tr>
				<td colspan="3" style="padding-bottom:10px; padding-left:10px;">
					<table cellpadding="0" cellspacing="0" border="0">
						<tr>
							<td><img src="{$skinPath}/images/applychanges.gif" border="0"/></td>
							<td class="sb-text" style="padding-left:30px;"><xsl:value-of select="@QUESTION"/></td>
						</tr>
					</table>

				</td>
			</tr>
			<tr>
				<td align="center" width="33%" style="padding-right:15px;">
					<xsl:call-template name="BUTTON">
						<xsl:with-param name="action">return sbApplyChangesObject.yes();</xsl:with-param>
						<xsl:with-param name="title" select="@YES"/>
					</xsl:call-template>
				</td>
				<td align="center" width="34%">
					<xsl:call-template name="BUTTON">
						<xsl:with-param name="action">return sbApplyChangesObject.no();</xsl:with-param>
						<xsl:with-param name="title" select="@NO"/>
					</xsl:call-template>
				</td>
				<td align="center" width="33%" style="padding-left:15px;">
					<xsl:call-template name="BUTTON">
						<xsl:with-param name="action">sbApplyChangesObject.cancel();</xsl:with-param>
						<xsl:with-param name="title" select="@CANCEL"/>
					</xsl:call-template>
				</td>
			</tr>
		</table>

		<!-- abelyaev@: for Modal forms debugging
		<div id="SbLogs" style="width:100%; height:100%; overflow:auto; vertical-align:top; border:solid 1px #000000">Logs:</div>
		<script type="text/javascript" language="javascript">
			<xsl:comment>
				SbInitLogging();
			//</xsl:comment>
		</script>
		-->
	</xsl:template>

	<xsl:template match="LOGOUT-DIALOG" mode="initAfterBody">
		<xsl:call-template name="MODAL-FORM">
			<xsl:with-param name="formName">SbLogoutDialog</xsl:with-param>
			<xsl:with-param name="formTitle" select="@TITLE"/>
			<xsl:with-param name="closeHint" select="@CLOSE-HINT"/>
			<xsl:with-param name="additionalFormStyle">width:320px; height:145px; display:none;</xsl:with-param>
			<xsl:with-param name="content" select="current()"/>
			<xsl:with-param name="onCloseAction">document.getElementById('SbLogoutDialog').hide();</xsl:with-param>
			<xsl:with-param name="showStatus">0</xsl:with-param>
		</xsl:call-template>
	</xsl:template>

	<xsl:template match="LOGOUT-DIALOG" mode="content">
		<table width="80%" cellspacing="0" cellpadding="0" border="0" align="center">
			<tr>
				<td align="left" colspan="3" style="vertical-align: middle; padding-bottom:10px; padding-left:0px;">
					<img src="{$skinPath}/images/applychanges.gif" style="display: inline; vertical-align: middle; border-width:0px;"/>
					<span class="sb-text" style="padding-left:10px; vertical-align: middle;"><xsl:value-of select="@QUESTION"/></span>
				</td>
			</tr>
			<tr>
				<td align="center" width="33%" style="padding-right:15px;">
					<xsl:call-template name="BUTTON">
						<xsl:with-param name="action">doNavigate('/Admin/Logout');</xsl:with-param>
						<xsl:with-param name="title" select="@YES"/>
					</xsl:call-template>
				</td>
				<td align="center" width="34%">
					<xsl:if test="@CHANGE">
							<xsl:call-template name="BUTTON">
								<xsl:with-param name="action">doNavigate('/Admin/Logout?localLogout');</xsl:with-param>
								<xsl:with-param name="title" select="@CHANGE"/>
							</xsl:call-template>
					</xsl:if>
				</td>
				<td align="center" width="33%" style="padding-left:15px;">
					<xsl:call-template name="BUTTON">
						<xsl:with-param name="action">document.getElementById('SbLogoutDialog').hide();</xsl:with-param>
						<xsl:with-param name="title" select="@NO"/>
					</xsl:call-template>
				</td>
			</tr>
		</table>
	</xsl:template>

</xsl:stylesheet>