<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:strip-space elements="*"/>
	<xsl:output method="html" indent="yes" encoding="utf-8"/>

	<xsl:template match="AREAMAP-PROVIDER">
		<script src='/modules/AreaMap/js/providers.js?{$version}.{$build}' type='text/javascript'></script>
		
		<xsl:apply-templates select="PROVIDERS-LIST"/>
		<xsl:apply-templates select="PROVIDER-FORMS-LIST"/>
		<div class="form-separator"><span></span></div>
		<xsl:call-template name="BLOCK-MODULE-BUTTONS">
			<xsl:with-param name="isRequiredFieldsExists">yes</xsl:with-param>
		</xsl:call-template>
	</xsl:template>

	<xsl:template match="AREAMAP-PROVIDER/PROVIDERS-LIST">
		<fieldset>
			<legend><xsl:value-of select="@TITLE"/></legend>
			<div class="fieldset-block">
				<table cellpadding="0" cellspacing="0" border="0" class="control-input-title">
					<xsl:apply-templates select="SERVICE-PROVIDER"/>
				</table>
			</div>
		</fieldset>
	</xsl:template>

	<xsl:template match="AREAMAP-PROVIDER/PROVIDERS-LIST/SERVICE-PROVIDER">
		<tr>
			<td class="input-block">
				<xsl:call-template name="RADIO" mode="control">
					<xsl:with-param name="checked" select="@CHECKED"/>
					<xsl:with-param name="id">areaMapProvider_<xsl:value-of select="@NAME"/></xsl:with-param>
					<xsl:with-param name="name">areaMapProvider</xsl:with-param>
					<xsl:with-param name="onclick">refreshAreaMapProvidersForm(this); return true;</xsl:with-param>
					<xsl:with-param name="value" select="@NAME"/>
				</xsl:call-template>
			</td>
			<td class="title-block">
				<xsl:call-template name="LABEL" mode="label">
					<xsl:with-param name="id">areaMapProvider_<xsl:value-of select="@NAME"/></xsl:with-param>
					<xsl:with-param name="title" select="."></xsl:with-param>
				</xsl:call-template>
			</td>
		</tr>
	</xsl:template>

	<xsl:template match="AREAMAP-PROVIDER/PROVIDER-FORMS-LIST">
		<xsl:apply-templates select="SERVICE-PROVIDER"/>
		<input type="hidden" name="areaMapView">
			<xsl:attribute name="value"><xsl:value-of select="../@VIEW"/></xsl:attribute>
		</input>
		<script type="text/javascript" language="javascript">
			<xsl:comment>
				self.sbEditorObject.addOnSubmitEvent(onSubmitAreaMapProvidersForm);
			//</xsl:comment>
		</script>
	</xsl:template>

	<xsl:template name="INIT-AREAMAP-PROVIDER-FORM">
		<xsl:attribute name="style">width: 100%; display: <xsl:choose>
				<xsl:when test="../../PROVIDERS-LIST/SERVICE-PROVIDER[@NAME=current()/@NAME]/@CHECKED = 1">block</xsl:when>
				<xsl:otherwise>none</xsl:otherwise>
			</xsl:choose>;</xsl:attribute>
		<xsl:attribute name="id">areaMapProviderForm_<xsl:value-of select="@NAME"/></xsl:attribute>
	</xsl:template>

	<xsl:template match="AREAMAP-PROVIDER/PROVIDER-FORMS-LIST/SERVICE-PROVIDER[@NAME='google']">
		<div>
			<xsl:call-template name="INIT-AREAMAP-PROVIDER-FORM"/>
			<fieldset>
				<legend><xsl:value-of select="@TITLE"/></legend>
				<div class="fieldset-block">
					<a target="_blank">
						<xsl:attribute name="href">
							<xsl:value-of select="SIGNUP/@URL"/>
						</xsl:attribute>
						<xsl:value-of select="SIGNUP"/>
					</a>
					<div style="width: 0; height: 10px;"><span></span></div>
					<table cellpadding="0" cellspacing="0" border="0" class="control-title-input">
						<tr>
							<td class="title-block">
								<xsl:apply-templates select="CONTROL[@NAME='google_key']" mode="label"/>
							</td>
							<td class="input-block">
								<xsl:apply-templates select="CONTROL[@NAME='google_key']" mode="control">
									<xsl:with-param name="size">60</xsl:with-param>
								</xsl:apply-templates>
							</td>
						</tr>
					</table>
				</div>
			</fieldset>
		</div>
	</xsl:template>

	<xsl:template match="AREAMAP-PROVIDER/PROVIDER-FORMS-LIST/SERVICE-PROVIDER[@NAME='msmp']">
		<div>
			<xsl:call-template name="INIT-AREAMAP-PROVIDER-FORM"/>
			<xsl:apply-templates select="AREAMAP-LOGIN"/>
		</div>
	</xsl:template>

	<xsl:template match="AREAMAP-GOOGLE-LOCATION">
		<input type="hidden" name="areaMapView">
			<xsl:attribute name="value"><xsl:value-of select="@VIEW"/></xsl:attribute>
		</input>
		<script src="http://maps.google.com/maps?file=api&#38;v=2&#38;key={MAP/@API-KEY}" type="text/javascript"></script>
		<script src="http://www.google.com/uds/api?file=uds.js&#38;v=1.0&#38;key={MAP/@API-KEY}" type="text/javascript"></script>
		<script src='/modules/AreaMap/js/GoogleMap.js?{$version}.{$build}' type='text/javascript'></script>
		<table border="0" cellpadding="0" cellspacing="0" style="width: 100%;">
			<tr>
				<td>
					<xsl:call-template name="INPUT" mode="control">
						<xsl:with-param name="id">ModuleDesigner_GoogleLocationControl_SearchAddress</xsl:with-param>
						<xsl:with-param name="name">searchAddress</xsl:with-param>
						<xsl:with-param name="onkeypress">javascript: return onSearchFieldChanged(event);</xsl:with-param>
						<xsl:with-param name="size">60</xsl:with-param>
					</xsl:call-template>
				</td>
				<td style="padding-left: 5px">
					<xsl:call-template name="BUTTON">
						<xsl:with-param name="action">javascript:ShowAddress();</xsl:with-param>
						<xsl:with-param name="title" select="SEARCH-TITLE"/>
					</xsl:call-template>
				</td>
			</tr>
			<tr>
				<td valign="top" colspan="2" style="padding: 5px 10px 5px 10px;">
					<div id="ModuleDesigner_GoogleLocationControl_GoogleMap" style="width:100%;height:300px;"></div>
					<!--
					<span id="ModuleDesigner_labelError" class="sb-label-error"></span>
					-->
					<input type="hidden" name="googleLocationContainer" id="ModuleDesigner_GoogleLocationControl_FieldsContainerId"/>
				</td>
			</tr>
			<tr>
				<td valign="top" colspan="2" style="padding: 5px 10px 5px 10px;">
					<div class="form-separator"></div>
					<xsl:call-template name="BLOCK-MODULE-BUTTONS"/>
				</td>
			</tr>
		</table>
		<script type="text/javascript" language="javascript">
			<xsl:comment>
				<xsl:apply-templates select="MARKES-LIST"/>
				<xsl:apply-templates select="MAP"/>
			//</xsl:comment>
		</script>
	</xsl:template>

	<xsl:template match="AREAMAP-GOOGLE-LOCATION/MAP">
		try {
			SHOW_MARKERS = 10;
			SHOW_ZOOM = true;
			SHOW_TYPE = true;
			FINDE_MARKERS = 20;
			MarkerContainerId = 'ModuleDesigner_GoogleLocationControl_FieldsContainerId';
		} catch(e){}
		try {
			selectedIcon.image = "/modules/AreaMap/images/selectedIcon.png";
			selectedIcon.shadow = "/modules/AreaMap/images/selectedIconShadow.png";
			unselectedIcon.image = "/modules/AreaMap/images/unselectedIcon.png";
			unselectedIcon.shadow = "/modules/AreaMap/images/unselectedIconShadow.png";

			Inits['ModuleDesigner_GoogleLocationControl_GoogleMap'] = new Init(new GLatLng(<xsl:value-of select="@CENTER-LAT"/>, <xsl:value-of select="@CENTER-LNG"/>), <xsl:value-of select="@ZOOM"/>, '<xsl:value-of select="@TYPE"/>', '<xsl:value-of select="@API-KEY"/>');
		} catch(e){}
		self.sbEditorObject.addOnSubmitEvent(SaveMarkers);
		self.sbEditorObject.addOnLoadEvent(function () {Load('ModuleDesigner_GoogleLocationControl_GoogleMap', 'SearchTableID', 'ModuleDesigner_GoogleLocationControl_SearchAddress', 'ModuleDesigner_labelError')} );
		addEvent(self, 'unload', GUnload);
		function onSearchFieldChanged(event) {
			if (document.all) event = self.event;
			if (event.keyCode == 13) {
				stopEvent(event);
				ShowAddress();
				return false;
			}
			return true;
		}
	</xsl:template>

	<xsl:template match="AREAMAP-GOOGLE-LOCATION/MARKES-LIST">
		try {
			var marker = null;
			<xsl:apply-templates select="MARKER"/>
		} catch(e){}
	</xsl:template>

	<xsl:template match="AREAMAP-GOOGLE-LOCATION/MARKES-LIST/MARKER">
		marker = new GMarker(new GLatLng(<xsl:value-of select="@POINT-LAT"/>, <xsl:value-of select="@POINT-LNG"/>), {draggable: true});
		marker['id'] = '<xsl:value-of select="@MARKER-ID"/>';
		marker['mapId'] = 'ModuleDesigner_GoogleLocationControl_GoogleMap';
		Markers['<xsl:value-of select="@MARKER-ID"/>'] = new Marker(marker, '<xsl:value-of select="@TITLE"/>', true, '<xsl:value-of select="@ADDRESS"/>');
	</xsl:template>

	<xsl:template match="AREAMAP-VIEW">
		<input type="hidden" name="areaMapView">
			<xsl:attribute name="value"><xsl:value-of select="@VIEW"/></xsl:attribute>
		</input>
		<script src='/modules/AreaMap/js/validator.js?{$version}.{$build}' type='text/javascript'></script>
		<fieldset>
			<legend><xsl:value-of select="@TITLE"/></legend>
			<div class="fieldset-block">
				<table width="100%" border="0" style="height: 100%" cellpadding="5" cellspacing="0">
					<tr>
						<td width="300" align="center" valign="top">
							<img width="296" height="227" src="">
								<xsl:attribute name="src">
									<xsl:value-of select="LOCATION/@IMAGE"/>
								</xsl:attribute>
							</img>
						</td>
						<td valign="top">
							<table width="100%" style="height: 100%" border="0" cellpadding="0" cellspacing="0">
								<tr>
									<td style="padding-left: 5px; padding-right: 5px;" height="10">
										<xsl:call-template name="INPUT" mode="control">
											<xsl:with-param name="id">mmp_location</xsl:with-param>
											<xsl:with-param name="name">mmp_location</xsl:with-param>
											<xsl:with-param name="size">60</xsl:with-param>
										</xsl:call-template>
									</td>
									<td style="width: 30%;" align="center">
										<xsl:call-template name="BUTTON-CONTROL">
											<xsl:with-param name="title"><xsl:value-of select="LOCATION/@TITLE"/></xsl:with-param>
											<xsl:with-param name="action">javascript: document.forms[0].action='<xsl:value-of select='@ACTION'/>';return validateViewForm();</xsl:with-param>
										</xsl:call-template>
									</td>
								</tr>
								<tr>
									<td colspan="2" valign="top" style="padding-left: 5px; padding-top: 5px;">
										<div style="height: 207px; overflow: auto;">
											<xsl:for-each select="LINKS-LIST/ITEM">
												<a href="">
													<xsl:attribute name="href">
														<xsl:value-of select="@URL"/>
													</xsl:attribute>
													<xsl:value-of select="."/>
												</a><br/>
											</xsl:for-each>
										</div>
									</td>
								</tr>
							</table>
						</td>
					</tr>
					<tr>
						<td colspan="2" >
							<div class="form-separator"></div>
							<xsl:call-template name="OK-CANCEL-BUTTONS">
								<xsl:with-param name="okAction">javascript: document.forms[0].action='<xsl:value-of select='@ACTION'/>'; e = document.getElementById('mmp_action'); if(e) { e.value='save'; document.forms[0].submit();}</xsl:with-param>
								<xsl:with-param name="cancelAction">javascript: document.forms[0].action='<xsl:value-of select='@ACTION'/>'; e = document.getElementById('mmp_action'); if(e) { e.value='cancel'; document.forms[0].submit();}</xsl:with-param>
							</xsl:call-template>
						</td>
					</tr>
				</table>
			</div>
		</fieldset>
		<input type="hidden" name="mmp_action" id="mmp_action" value="view"/>
		<input type="hidden" name="mmp_activeId">
			<xsl:attribute name="value">
				<xsl:value-of select="LINKS-LIST/@ACTIVE-ID"/>
			</xsl:attribute>
		</input>
		<input type="hidden" name="mmp_image">
			<xsl:attribute name="value">
				<xsl:value-of select="LOCATION/@IMAGE"/>
			</xsl:attribute>
		</input>
	</xsl:template>

	<xsl:template match="AREAMAP-LOGIN">
		<script src='/modules/AreaMap/js/validator.js?{$version}.{$build}' type='text/javascript'></script>
<!--		<form name="loginToMMP" id="loginToMMP" method="post" action="/Wizard/Edit/Modules/AreaMap">
-->		<table width="100%" border="0" cellpadding="0" cellspacing="0">
			<tr><td>
			<fieldset>
				<legend><xsl:value-of select="@TITLE"/></legend>

				<div style="width: 0; height: 5px;"><span></span></div>

				<xsl:value-of select="@DESCRIPTION"/>

				<div style="width: 0; height: 5px;"><span></span></div>

				<a target="_blank">
					<xsl:attribute name="href">
						<xsl:value-of select="LINK-TO-MS/@HREF"/>
					</xsl:attribute>
					<xsl:value-of select="LINK-TO-MS/@TITLE"/>
				</a>

				<div style="width: 0; height: 5px;"><span></span></div>

				<table cellpadding="0" cellspacing="0" border="0" class="control-title-input">
					<tr>
						<td class="title-block">
							<xsl:apply-templates select="CONTROL[@NAME='mmp_login']" mode="label">
								<xsl:with-param name="require">true</xsl:with-param>
							</xsl:apply-templates>
						</td>
						<td class="input-block">
							<xsl:apply-templates select="CONTROL[@NAME='mmp_login']" mode="control">
								<xsl:with-param name="require">true</xsl:with-param>
							</xsl:apply-templates>
						</td>
					</tr>
					<tr>
						<td class="title-block">
							<xsl:apply-templates select="CONTROL[@NAME='mmp_password']" mode="label">
								<xsl:with-param name="require">true</xsl:with-param>
							</xsl:apply-templates>
						</td>
						<td class="input-block">
							<xsl:apply-templates select="CONTROL[@NAME='mmp_password']" mode="control">
								<xsl:with-param name="require">true</xsl:with-param>
							</xsl:apply-templates>
						</td>
					</tr>
				</table>

				<div style="width: 0; height: 5px;"><span></span></div>

				<div align="right">
					<xsl:call-template name="BUTTON-CONTROL">
						<xsl:with-param name="title" select="CONTROL[@TYPE='BUTTON']/@TITLE"/>
						<xsl:with-param name="action">javascript: var e = document.getElementById('mmp_action'); e.value="tryLoginToMsMap"; self.sbEditorObject.submit();</xsl:with-param>
						<xsl:with-param name="style">width: 100px;</xsl:with-param>
					</xsl:call-template>
				</div>
			</fieldset>
			</td></tr>
		</table>
		<input type="hidden" name="mmp_action" id="mmp_action" value="save"/>
	</xsl:template>

</xsl:stylesheet>