<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:output method="html" indent="yes" encoding="utf-8" doctype-public="-//W3C//DTD HTML 4.0 Transitional//EN"/>
	<xsl:strip-space elements="*"/>

	<xsl:template match="SITEBUILDER-PAGE">
		<xsl:apply-templates select="STATUS" mode="admin"/>
		<xsl:apply-templates select="VIEW-CONTENT"/>
	</xsl:template>

	<xsl:template match="VIEW-CONTENT">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="CONFIRMATION-STEP">
		<script src='/modules/Fotolia/js/confirmationStepManager.js?{$version}.{$build}' type='text/javascript'></script>
		<script type="text/javascript" language="javascript">
			self.parent.fotoliaPurchaseImageFormManager.changeFormSize(
				450,
				400 + <xsl:value-of select="IMAGE/@HEIGHT"/>
			);
			InitConfirmationStepManager();
		</script>
		<table id="fotoliaConfirmationStepContainer" border="0" cellpadding="0" cellspacing="0" style="width: 100%; height: 100%; border-collapse: collapse;">
			<tr id="fotoliaPurchaseErrorContainer" style="display: none;">
				<td style="padding: 0px 0px 10px 0px">
					<table border="0" cellpadding="0" cellspacing="0" class="sb-statusbar-admin-error sb-statusbar-admin" style="width: 100%; margin: 0;">
						<tr>
							<td>
								<table border="0" cellpadding="0" cellspacing="0">
									<tr valign="top">
										<td style="text-valign:middle; padding-left: 5px;">
											<img src="{$skinPath}/icons/error.png" style="border-width:0px;" alt="{/SITEBUILDER-PAGE/LOCALE/ERROR}">
											</img>
										</td>
										<td style="padding-left: 5px; padding-right: 5px; white-space: nowrap;">
											<b><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/ERROR"/>:</b>
										</td>
										<td id="fotoliaPurchaseErrorTextContainer" width="100%" class="sb-statusbar-admin-text" style="padding-left: 5px;">
											<span></span>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
				</td>
			</tr>
			<xsl:apply-templates select="USER-INFO" mode="confirmationStep"/>
			<tr>
				<td valign="top">
					<fieldset>
						<legend><xsl:value-of select="@TITLE"/></legend>
						<div class="fieldset-block">
							<table border="0" cellpadding="0" cellspacing="0" style="width: 100%; height: 100%;  border-collapse: collapse;">
								<tr>
									<td style="padding: 5px 0px 0px 0px">
										<xsl:value-of select="CONFIRMATION-TEXT"/>
									</td>
								</tr>
								<tr>
									<td style="padding: 10px 0px 0px 0px">
										<table width="100%" border="0" cellpadding="0" cellspacing="0">
											<tr>
												<td width="1px">
													<xsl:apply-templates select="IMAGE"/>
												</td>
												<td valign="top" style="padding: 0px 0px 0px 10px">
													<xsl:value-of select="TITLE"/><br/>&#0169;&#160;<xsl:value-of select="CREATOR-NAME"/>&#160;#<xsl:value-of select="ID"/>
												</td>
											</tr>
										</table>
									</td>
								</tr>
								<tr>
									<td style="padding: 10px 0px 0px 0px">
										<table cellpadding="0" cellspacing="0" border="0" class="control-title-near-input">
											<tr>
												<td class="title-block" style="width: 115px;">
													<xsl:apply-templates select="CONTROL[@NAME='license']" mode="label"/>
												</td>
												<td class="description-block">
													<xsl:apply-templates select="CONTROL[@NAME='license']" mode="status"/>
												</td>
											</tr>
											<tr>
												<td class="title-block">
													<xsl:apply-templates select="CONTROL[@NAME='resolution']" mode="label"/>
												</td>
												<td class="description-block">
													<xsl:apply-templates select="CONTROL[@NAME='resolution']" mode="status"/>
												</td>
											</tr>
											<tr>
												<td class="title-block">
													<xsl:apply-templates select="CONTROL[@NAME='price']" mode="label"/>
												</td>
												<td class="description-block">
													<b><xsl:apply-templates select="CONTROL[@NAME='price']" mode="status"/></b>
												</td>
											</tr>
										</table>
									</td>
								</tr>
							</table>
						</div>
					</fieldset>
				</td>
			</tr>
			<tr height="1px">
				<td style="padding: 2px 0px 5px 0px">
					<div style="height: 1px; background-color: #ccc;"><span></span></div>
				</td>
			</tr>
			<tr>
				<td>
					<table width="100%" border="0" cellpadding="0" cellspacing="0">
						<tr>
							<td>
								<xsl:apply-templates select="BACK-LINK"/>
							</td>
							<td align="right">
								<xsl:apply-templates select="CONTROL[@TYPE='BUTTON']">
									<xsl:with-param name="action">
										self.parent.fotoliaPurchaseImageFormManager.processPurchase(self.fotoliaConfirmationStepManager);
									</xsl:with-param>
								</xsl:apply-templates>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template match="CONFIRMATION-STEP-PROGRESS">
		<table id="fotoliaConfirmationStepProgressContainer" border="0" cellpadding="0" cellspacing="5" style="width: 100%; height: 100%; border-width: 0px; border-collapse: collapse; cursor: wait; display: none;">
			<tr>
				<td valign="top">
					<xsl:value-of select="TEXT"/><br/><br/>
					<xsl:apply-templates select="PROGRESS-BAR"/>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template match="CONFIRMATION-STEP-DONE">
		<table id="fotoliaConfirmationStepDoneContainer" border="0" cellpadding="5" cellspacing="0" style="width: 100%; border-width: 0px; border-collapse: collapse; display: none;">
			<tr>
				<td valign="top">
					<img width="46" heigth="46" src="{$skinPath}/images/publish_success.gif" border="0"/>
				</td>
				<td valign="top">
					<table cellpadding="0" style="width: 100%; border-width: 0px;">
						<tr>
							<td valign="top">
								<xsl:value-of select="TEXT"/>
							</td>
						</tr>
						<tr>
							<td valign="top" style="padding: 10px 0px 0px 0px">
								<xsl:value-of select="DESCRIPTION"/>
							</td>
						</tr>
					</table>
				</td>
			</tr>
			<tr height="1px">
				<td colspan="2" style="padding: 10px 0px 10px 0px">
					<div style="height: 1px; background-color: #ccc;"><span></span></div>
				</td>
			</tr>
			<tr>
				<td colspan="2" align="center" style="padding: 10px 0px 0px 0px">
					<xsl:apply-templates select="CONTROL[@TYPE='BUTTON']">
						<xsl:with-param name="action">
							self.fotoliaConfirmationStepManager.closeForm();
						</xsl:with-param>
					</xsl:apply-templates>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template match="USER-INFO" mode="confirmationStep">
		<tr height="1px">
			<td>
				<xsl:apply-templates select="current()"/>
			</td>
		</tr>
	</xsl:template>

	<xsl:template match="CONFIRMATION-STEP/IMAGE">
		<img src="{.}" width="{@WIDTH}" height="{@HEIGHT}"/>
	</xsl:template>

	<xsl:template match="CONFIRMATION-STEP/BACK-LINK">
		<xsl:call-template name="BUTTON-CONTROL">
			<xsl:with-param name="title">&#0060;&#0060; <xsl:value-of select="."/></xsl:with-param>
			<xsl:with-param name="action">
				self.parent.fotoliaPurchaseImageFormManager.openSelectLicenseStep();
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>

</xsl:stylesheet>