<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:strip-space elements="*"/>
	<xsl:output method="html" indent="yes" encoding="utf-8"/>

	<xsl:template match="IMAGES-UPLOAD" />

	<xsl:template match="IMAGES-UPLOAD" mode="initAfterBody">

		<div style="width:0;height:0;display:none" id="FileUploaderContainer">
		    <applet id="FileUploader" name="FileUploader" archive="/applet/MIU.jar"
					code="com.swsoft.sitebuilder.miu.applet.FileUploadApplet.class" 
					style="width:0;height:0" MAYSCRIPT="MAYSCRIPT">
				<param name="finishCallbackFunc" value="UploadFinished" />
			</applet>
		</div>

		<xsl:call-template name="MODAL-FORM">
			<xsl:with-param name="formName">MultipleUploadDialogId</xsl:with-param>
			<xsl:with-param name="formTitle" select="/SITEBUILDER-PAGE/LOCALE/FORM-TITLE"/>
			<xsl:with-param name="additionalFormStyle">width: 90%;height: 90%;</xsl:with-param>
			<xsl:with-param name="content" select="current()" />
			<xsl:with-param name="onCloseAction">sbNavigationObject.go();</xsl:with-param>
		</xsl:call-template>

		<xsl:apply-templates select="//UPLOAD-MODAL-DIALOG" />
	</xsl:template>	

	<xsl:template match="UPLOAD-MODAL-DIALOG" mode="initAfterBody">
		<xsl:call-template name="MODAL-FORM">
			<xsl:with-param name="formName">StatusUploadDialogId</xsl:with-param>
			<xsl:with-param name="formTitle" select="/SITEBUILDER-PAGE/LOCALE/UPLOAD-PROGRESS-TITLE"/>
			<xsl:with-param name="additionalFormStyle">width:440px; height:250px; visibility: hidden;</xsl:with-param>
			<xsl:with-param name="content" select="current()"/>
			<xsl:with-param name="showStatus">0</xsl:with-param>
			<xsl:with-param name="onCloseAction">sbNavigationObject.go('/Wizard/Edit/Modules/ImageGallery');</xsl:with-param>
		</xsl:call-template>
	</xsl:template>

	<xsl:template  match="UPLOAD-MODAL-DIALOG"  mode="content">
		<table style="width:100%;height:80%">
			<tr>
				<td style="width:70px; vertical-align:top">
					<img id="ProgressImageId" src="{$skinPath}/icons/AddImage.png" alt="upload" />
					<img id="ErrorImageId" src="{$skinPath}/icons/errorIcon.gif" alt="error" style="display:none" />
				</td>
			
				<td style="vertical-align:top;align:left;width:99%;height:100%">
						<table>
							<tr>
								<td class="sb-text"  style="vertical-align:top">
									<!-- Images uploaded -->
									<xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/IMAGES-UPLOADED" />:&#160;<span id="UploadetFileCountId">0</span>
									&#160;<xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/IMAGES-UPLOADED-OF" />&#160;
									<span id="FromFileCountId">0</span>
								</td>
							</tr>
							<tr id="PanelPBId">
								<td>
									<xsl:call-template name="PROGRESS-BAR">
										<xsl:with-param name="innerDivStyle">background-color: #F7F7F7;border: 1px solid #CCCCCC;margin: 8px;padding: 8px;text-align: left;display:block; width:300px; text-align:left;</xsl:with-param>
									</xsl:call-template>
								</td>
							</tr>
							<tr><td class="sb-text"><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/IMAGES-LEFT" />: <span id="FileLeftCountId">0</span></td></tr>
							<tr><td class="sb-text" id="PanelFileNameId"><span><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/UPLOADING" />:&#160;<span id="FileNameId"></span></span></td></tr>
						</table>
						<div id="PanelErrorsId">
							<table>
								<tr><td>
									<span id="ErrorLabelId" class='sb-label-error'></span>
								</td></tr>
							</table>
						</div>
				</td>
			</tr>
		</table>

		<div id="PanelProgressButtonsId">
			<table width="100%">
				<tr>
					<td width="99%">&#160;</td>
					<td>
						<xsl:call-template name="CANCEL-BUTTON">
							<xsl:with-param name="action">CancelUploadFiles();</xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</table>
		</div>
		
		<div id="PanelErrorButonsId">
			<table width="100%">
				<tr>
					<td width="99%">&#160;</td>
					<td>
						<xsl:call-template name="BUTTON">
							<xsl:with-param name='id' select="'retryButtonId'" />
							<xsl:with-param name='title' select="/SITEBUILDER-PAGE/LOCALE/RETRY-TITLE" />
							<xsl:with-param name='action'>RetryUpload();</xsl:with-param>
						</xsl:call-template>
					</td>
					<td>
						<xsl:call-template name="BUTTON">
							<xsl:with-param name='action'>sbNavigationObject.go('/Wizard/Edit/Modules/ImageGallery');</xsl:with-param>
							<xsl:with-param name='title' select="/SITEBUILDER-PAGE/LOCALE/OK-TITLE" />
						</xsl:call-template>
					</td>
				</tr>
			</table>
		</div>
	</xsl:template>	

	<xsl:template match="IMAGES-UPLOAD" mode="content">
		<xsl:apply-templates select="//APPLET" />
		<table>
			<tr>
				<td style="width:99%">
					<a href="#" onclick="javascript:sbNavigationObject.go('/Wizard/Edit/Modules/ImageGallery/ImageUpload')">
						<xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/MISSING-MUI-MESSAGE" />
					</a>
				</td>
				<td>
				    <xsl:call-template name="BUTTON-CONTROL">
				    	<xsl:with-param name="id">ButtonUploadId</xsl:with-param>
				    	<xsl:with-param name="title" select="/SITEBUILDER-PAGE/LOCALE/UPLOAD" />
				    	<xsl:with-param name="style">display: none;</xsl:with-param>
				    	<xsl:with-param name="action">StartImageUploading();</xsl:with-param>
				    </xsl:call-template>
				</td>
				<td>
					<xsl:call-template name="BUTTON-CONTROL">
						<xsl:with-param name="title" select="/SITEBUILDER-PAGE/LOCALE/CANCEL-TITLE" />
						<xsl:with-param name="id">ButtonCancelId</xsl:with-param>
						<xsl:with-param name="action">sbNavigationObject.go('/Wizard/Edit/Modules/ImageGallery');</xsl:with-param>
					</xsl:call-template>
				</td>
			</tr>
		</table>
	</xsl:template>	
	
	<xsl:template match="APPLET">
		<script type="text/javascript" src="/modules/ImageGallery/js/applet.js?{$version}.{$build}"></script>
		<script type="text/javascript" src="/modules/ImageGallery/js/JamPrototypes.js?{$version}.{$build}"></script>
		<table style="width:100%;height:95%">
			<tr>
				<td>
					<table style="width:100%;height:100%">
						<tr class="sb-edit-panel-block">
							<!-- Left filesystem tree -->
							<td class="sb-edit-panel-block-border" style="width:25%;height:100%;vertical-align:top;">
								<div style="width:100%;height:100%;display:none" id="FSBrowserContainer">
							    <applet id="FSBrowser" name="FSBrowser"
							            code="com.swsoft.sitebuilder.miu.applet.FSBrowseApplet.class"
							            archive="/applet/MIU.jar"
										style="height:100%;width:100%" align="left"  MAYSCRIPT="MAYSCRIPT">
										<param name="failFunc" value="appletFailureCallback" />
								</applet>
								</div>
							</td>
							
							<td class="sb-edit-panel-block-border" style="width:75%;">
								<table class="sb-table-design" cellspacing="0" cellpadding="5"
										border="0"
										height="100%"
										style="border-width:0px;width:100%;border-collapse:collapse;">
									<!-- navigation dropdown -->
<!--									<tr> <td>&#160;</td></tr> -->
									<!-- whole buttons row under dropdown -->
									<tr style="height:1%">
										<td>
											<table class="sb-table-design" cellspacing="0" cellpadding="0"
													border="0" style="border-width:0px;height:100%;width:100%;border-collapse:collapse;">
												<tr>
													<td style="width:30%;white-space:nowrap;text-align:left;">
													    <table>
														    <tr>
															    <td>
																    <xsl:call-template name="BUTTON-CONTROL">
																    	<xsl:with-param name="id">ButtonSelectAllId</xsl:with-param>
																    	<xsl:with-param name="title" select="/SITEBUILDER-PAGE/LOCALE/SELECT-ALL" />
																    	<xsl:with-param name="style">display: none;</xsl:with-param>
																    	<xsl:with-param name="action">
																    	JamShellListX.onSelectAll();
																    	return false;
															    	 	</xsl:with-param>
																    </xsl:call-template>
															    </td>
															    <td>
																    <xsl:call-template name="BUTTON-CONTROL">
																    	<xsl:with-param name="id">ButtonUnSelectId</xsl:with-param>
																    	<xsl:with-param name="title" select="/SITEBUILDER-PAGE/LOCALE/SELECT-NONE" />
																    	<xsl:with-param name="style">display: none;</xsl:with-param>
																    	<xsl:with-param name="action">
																	    	JamShellListX.onSelectNone();
																	    	return false;
				    													</xsl:with-param>
																    </xsl:call-template>
															    </td>
														    </tr>
												    	</table>
													</td>
													<!-- selected: <N>images -->
													<td style="text-align:center;">
														<span class="sb-label"><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/SELECTED" />:&#160;</span>
														<span id="selectedImagesCountId" class="sb-text" style="font-weight:bold;"></span>
														<span class="sb-text" style="font-weight:bold;">&#160;<xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/IMAGES-S" /></span>
													</td>
													
													<td style="width:30%;white-space:nowrap;text-align:right;">
														<span class="sb-text">
															<xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/CLICK-TO-SELECT" />
<!--															<br />
															<xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/DOUBLECLICK-FOR-PREVIEW" />-->
														</span>
													</td>
												</tr>
											</table>
										</td>
									</tr>
									<!-- //button row -->

									<!-- preview area -->
									<tr>
										<td>
										<div style="width:100%;height:100%;display:none" id="ImagePreviewAreaContainer">
										    <applet id="ImagePreviewArea" name="ImagePreviewArea"
									                code="com.swsoft.sitebuilder.miu.applet.ImagePreviewApplet.class"
					            				    archive="/applet/MIU.jar"
									                style="width:100%;height:100%" MAYSCRIPT="MAYSCRIPT">
									            <param name="selectItemCallbackFunc" value="handleItemSelectionEvent" />
												<param name="selectionChangedCallbackFunc" value="SetSelectedCount" />
												<param name="suiteReadyCallbackFunc" value="initializeView" />
										    </applet>

											</div>										
										</td>
									</tr>
									<!-- /preview area -->

									<!-- category selection -->
									<tr style="height:1%">
										<td style="white-space:nowrap;">
											<table cellpadding="0" cellspacing="0" border="0" width="100%">
												<tr>
													<td nowrap="true" style="text-align: left; width: 1%">
														<span class="sb-text" style="font-weight:bold;">
														<xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/UPLOAD-TO-CATEGORY" />:&#160;</span>
														<select name="categoryDropdown" id="CategoryListId"  class="sb-text">
															<xsl:attribute name="onchange">document.getElementById('NewCategoryId').style.display = (this.value == 'new') ? 'block' : 'none'</xsl:attribute>
															<xsl:for-each select="//CATEGORIES/CATEGORY">
																<option>
																	<xsl:attribute name="value"><xsl:value-of select='@ID' /></xsl:attribute> 
																	<xsl:value-of select="." />
																</option>
															</xsl:for-each>
															<option value="new"><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/CREATE-NEW-CATEGORY" /></option>
															<option value="0" selected="selected"><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/NO-CATEGORY" /></option>
														</select>
													</td>
													<td>
														<input type="text" id="NewCategoryId" class="sb-control-input-input" style="width:100px"/>
													</td>
													<td align="right">
														<span class="sb-text" style="font-weight:bold"><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/RESIZE" />&#160;</span>
														<select id="ResizeResolutionId">
															<option value="1024|768">1024x768</option>
															<option value="800|600">800x600</option>
															<option value="640|480">640x480</option>
															<option value="-1|-1" selected="selected"><xsl:value-of select="/SITEBUILDER-PAGE/LOCALE/DO-NOT-RESIZE" /></option>
														</select>
													</td>
													
												</tr>
											</table>
										</td>
									</tr>
									<!-- /category selection -->
								</table>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>

<script type="text/javascript">
function appletFailureCallback() {
	sbNavigationObject.go('/Wizard/Edit/Modules/ImageGallery/ImageUpload')
}

function handleItemSelectionEvent(i,j) { }

function initializeView() {
	$('ButtonSelectAllId').show();
	$('ButtonUnSelectId').show();
	$('ButtonUploadId').show();

	ControlsInit();
	SetSelectedCount();
}

function resetOverflowProperty() {
		P = function(e) { 
			return (e &amp;&amp; (e.style.overflow = 'hidden')); 
		}
		try {
			//$$ is from prototype, as well as each
			P($$('div#edit')[0]);
			P($$('div.scroll-table-block')[0]);
			$$('div.scroll-table-block *').each(P); 
		}
		catch (e) { }
}

function showApplets() {
		$("FileUploaderContainer").style.display = "block";
		$("FSBrowserContainer").style.display = "block";
		$("ImagePreviewAreaContainer").style.display = "block";
}

function StartImageUploading() {
	if(IsCategory()) {
		StartUpload();
	} 
	else { 
		alert(SbGetLocaleByKey('EMPTY-CATEGORY-MESSAGE'));
		return false;
	}
}

var BaseUrl = unescape('<xsl:value-of select="//APPLET/URL" />');

var MakePostBack = function() {
	url = baseUrl + '/Wizard/Edit/Modules/ImageGallery';
	sbNavigationObject.go(url);
}

var JamShellListX = new JamShellListXObject($('ImagePreviewArea'));
var JamShellTreeX = new JamShellTreeXObject($('FSBrowser'));
var FileUploader = new FileUploaderObject($('FileUploader'));
var JamShellLinkX =  new Object();
var JamShellComboX = new Object();

var JamSelectImages = $('selectedImagesCountId');

var ButtonUploadId = 'ButtonUploadId';
var ButtonCancelId = 'ButtonCancelId';
var MultipleUploadDialogId = 'MultipleUploadDialogId';
var StatusUploadDialogId = 'StatusUploadDialogId';
var ResizeResolutionId = 'ResizeResolutionId';
var NewCategoryId = 'NewCategoryId';
var CategoryListId = 'CategoryListId';
var ButtonSelectAllId = 'ButtonSelectAllId';
var ButtonUnSelectId = 'ButtonUnSelectId';
var ProgressBarId = 'sbProgressBar';
var UploadetFileCountId = 'UploadetFileCountId';
var FromFileCountId = 'FromFileCountId';
var FileLeftCountId = 'FileLeftCountId';
var FileNameId = 'FileNameId';
var ErrorImageId = 'ErrorImageId';
var ProgressImageId = 'ProgressImageId';
var PanelErrorsId = 'PanelErrorsId';
var PanelPBId = 'PanelPBId';
var PanelFileNameId = 'PanelFileNameId';
var ErrorLabelId = 'ErrorLabelId';
var PanelProgressButtonsId = 'PanelProgressButtonsId';
var PanelErrorButonsId = 'PanelErrorButonsId';

RegisterOnloadAction("resetOverflowProperty()");
RegisterOnloadAction("showApplets()");
</script>

	</xsl:template>
	
</xsl:stylesheet>
